<?php

/**
 * Parse the sip profiles
 *
 * @author Miguel Palmer <mp@beronet.com>
 */
class profileParser {

	protected $parsedFile;
	protected $path = "/usr/conf/profile/";

	public function __construct($file, $filepath = null) {
	//In der variable $file steckt der Type und der Profile drinnen,
	//der Type ist ein Unterodrner vom profile
		if ($filepath === null) {
			$type_profile = explode("-", $file, 2);
			if (is_file($this->path . $type_profile[0] . "/" . $type_profile[1]))
				$this->parsedFile = @parse_ini_file($this->path . $type_profile[0] . "/" . $type_profile[1], true);
			else
				return NULL;
		}else{
			$this->parsedFile = @parse_ini_file($filepath, true);
		}
	}

	public function getUserSettings() {
		$userSettings = explode(",", $this->parsedFile[general]['user-settings']);
		return $userSettings;
	}

	public function getFixedSettings() {
		return $this->parsedFile['fixed-settings'];
	}

	public function getHelpText() {
		$helpText = $this->parsedFile['general']['help'];
		return $helpText;
	}

	public function getFieldHelp($field) {
		$fieldHelp = $this->parsedFile['general']['help-' . $field];
		return $fieldHelp;
	}

	public function getVersion() {
		$version = $this->parsedFile['general']['Version'];
		return $version;
	}

	public function getType() {
		$type = $this->parsedFile['general']['Type'];
		return $type;
	}

	public function getName() {
		$name = $this->parsedFile['general']['Name'];
		return $name;
	}

}
