<?php
/**
 * @file
 * Validiert die eingegebene Login Datein
 */
session_start();
chdir("..");

include "./includes/variables.php";
include_once("/usr/www/include/SQLite2ToSQLite3.php");
include "./misc/database.php";
include "password_func.php";
include '/usr/fallback/beroConf.php';
require_once '/usr/local/www/berogui/includes/Helper/Helper.php';

$ba = new beroAri();
require_once("./includes/lang.php");

# pages to redirect
$redir_index = "/app/berogui/index.php";
$redir_login = "/app/berogui/includes/login.php";

# get redirection URL
if (isset($_GET['destination'])) {
	$reopen = '&destination=' . htmlspecialchars($_GET['destination'], ENT_QUOTES);
}

# check if user and password are set
if ((strlen(trim($_POST['user'])) == 0) || (strlen((trim($_POST['password']))) == 0)) {
	header('Location:' . $redir_login . '?reason=cred_empty' . ((!empty($reopen)) ? $reopen : ''));
	exit();
}

# extract username and password
$user = htmlentities($_POST['user'], ENT_QUOTES);
$password = $_POST['password'];

$loginTimestamp = $ba->get('loginTime');

if (get_blocked() && ($loginTimestamp + blocked_time()) > time()) {
	header('Location:' . $redir_login . '?reason=blocked&time=' . blocked_time() . ((!empty($reopen)) ? $reopen : ''));
	exit();
}

# check if user is in database
$result = $ba->select('SELECT * FROM users where user=\'' . sqlite_escape_string($user) . '\'');
if (!($row = $ba->fetch_array($result))) {
	header('Location:' . $redir_login . '?reason=cred_user' . ((!empty($reopen)) ? $reopen : ''));
	exit();
}

# count login attempts
if (!tep_validate_password($password, $row['password'])) {
	count_login_attempts();
}

$loginCounter = $ba->get('loginCounter');

if (!tep_validate_password($password, $row['password']) && $loginCounter >= 3 && $loginCounter % 3 == 0) {
	header('Location:' . $redir_login . '?reason=blocked&time=' . blocked_time() . ((!empty($reopen)) ? $reopen : ''));
	exit();
} else if (!tep_validate_password($password, $row['password'])) {
	header('Location:' . $redir_login . '?reason=cred_pass' . ((!empty($reopen)) ? $reopen : ''));
	exit();
}

function get_blocked() {
	global $ba;
	$loginCounter = $ba->get('loginCounter');
	if ($loginCounter >= 3 && $loginCounter % 3 == 0) {
		return true;
	}
	return false;
}

function blocked_time() {
	global $ba;
	$loginCounter = $ba->get('loginCounter');
	if ($loginCounter >= 9 && $loginCounter % 3 == 0) {
		return 60;
	} else if ($loginCounter >= 6 && $loginCounter % 3 == 0) {
		return 30;
	} else if ($loginCounter >= 3 && $loginCounter % 3 == 0) {
		return 10;
	}
}

function count_login_attempts() {
	global $ba;
	$loginCounter = $ba->get('loginCounter');
	if ($loginCounter === false) {
		$loginCounter = 1;
	} else {
		$loginCounter ++;
	}
	$ba->set('loginCounter', $loginCounter);
	if ($loginCounter % 3 == 0) {
		$ba->set('loginTime', time());
	}
	return $loginCounter;
}

# set session-parameters
$_SESSION['beroari_username'] = $row['user'];
$_SESSION['beroari_group'] = $row['group_'];
$_SESSION['beroari_time'] = time();
$ba->set('loginCounter', 0);

# check if group is 'users'
if ($row['group_'] == 'users') {
	header('Location:' . $redir_index . '?m=State');
	exit();
}

# open root db, check if ari.db has to be created or if we can read from it
$bc = new beroConf('root');

if ($bc->get('root', 'is-sbc-vm') == 1) {
	header('Location:' . (isset($_GET['destination']) ? base64_decode($_GET['destination']) : $redir_index));
}
else {
	// Datenbank Überprüfung ob ISDN/Analog Daten gespeichert sind (wenn nicht, werden die Line Interfaces gelesen).
	$query_isdn = $ba->select("select lif, type from isdn group by lif");
	$query_analog = $ba->select("select lif, type from analog group by lif");
	$query_gsm = $ba->select("select lif, type from gsm group by lif");
	$query_lte = $ba->select("select lif, type from lte group by lif");
	$query_cas = $ba->select("select lif, type from cas group by lif");

	if ((sqlite_num_rows($query_isdn) == 0) && (sqlite_num_rows($query_analog) == 0) && (sqlite_num_rows($query_gsm) == 0) && (sqlite_num_rows($query_cas) == 0) && (sqlite_num_rows($query_lte) == 0)) {

		$ba = new beroAri();
		$ba->add_modules_db();
		$ba->enable_portswitch();

		if ($ba->is_error()) {
			echo '<script>alert(' . $ba->error() . ');</script>';
		}
	}

	$lif = Helper::getLif();
	$isdn = FALSE;
	for ($i = 0; $i < Helper::getLifCount(); $i++) {
		if (in_array($lif[$i], array("bf4S0", "bf2S0", "bf1S0", "bf1E1", "bf2E1", "bf2S02FXS", "bf1t1e1", "bf2t1e1", "bf4t1e1"))) {
			$isdn = TRUE;
		}
	}

	// open berogui
	if ($isdn && Helper::check($ba) && ($ba->get('national_code') == "" || $ba->get('international_code') == "")) {
		header('Location: ../index.php?m=Miscellaneous');
	} else {
		header('Location:' . (isset($_GET['destination']) ? base64_decode($_GET['destination']) : $redir_index));
	}
}
?>
