<?php
/**
 * @file
 * Generiert für jedes Feld des Config String, das nicht als additional config string definiert ist, das entsprechende HTML Element.
 */

/*			[IMPORTANT]
 *
 *	To avoid SQL injection vulnerability, include / require
 *	this file only after the GET variable has been sanitized
 *	via the Helper class 
 *
 */

/*
 *	TODO: set the GET variable as an argument to the functions instead to be a global variable
 *
 */
function get_sip_post_options() {
        return array(
                        'codecs'           	=> array_map('strtolower', get_codecs_list()),
                        'from_sip_dest_setting' => get_from_sip_dest_setting_options(),
                        'from_sip_src_setting'  => get_from_sip_src_setting_options(),
                        'number_format'         => array_keys(get_isdn2sip_numformat_options()),
                        'prefix_setting'        => array_keys(get_prefix_setting_options()),
                        'privacy_header'        => array_keys(get_privacy_header_options()),
                        'qvalue'                => array_keys(get_qvalue_options()),
                        's2s_nat_opener'        => array_keys(get_s2s_nat_opener_options()),
                        'sip_from_setting'      => array('', 'manual', '${new_source}', '${oad}', '${oad2}', '${isdn_uuname}', '${isdn_display}', '${qsigname}', '${account_username}', '${account_base_number_auto}', '${from_display}'),
                        'srtp_crypto_suites'    => get_srtp_crypto_suites_options(),
												's2s_rtp_handling_method' => array_keys(get_s2s_rtp_handling_method_options()),
                   );
}

function get_pstn_post_options($type) {
	$options = array();
	switch ($type) {
		case 'analog':
			$options = array('caller_id_pstn' => get_caller_id_pstn_list());
		case 'isdn':
			$options = array('callee_id_pstn' => get_callee_id_pstn_list(), 'caller_id_pstn' => get_caller_id_pstn_list(), 'from_pstn_src_setting_isdn' => get_from_pstn_src_setting_list('isdn')); 
			break;
		default:
			break;
	}
	return $options;
}

function ec($ba, $table = "isdn", $config='') {
		if (isset($_GET['gr'])) {
		    $query = $ba->select("select config from " . $table . " where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
		    while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		    }
		}
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "ec" && $key[1] == 0)
                    return "<input type='hidden' name='ec' value='0'>"
					. "<input type='checkbox' id='ec' name='ec' value='1'>";
            }
        }
    return "<input type='hidden' name='ec'  value='0'>"
		. "<input type='checkbox' name='ec' id='ec' value='1' checked>";
}

/* FUNCTION NOT USED .... CAM BE REMOVED ? */
function eao($config='') {
		if (isset($_GET['gr'])) {
		    $ba = new beroAri();
		    $query = $ba->select("select config from isdn where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
		    while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		    }
		}
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "eao" && $key[1] == 1)
                    return "<input type='hidden' name='eao'  value='0'>"
					. "<input type='checkbox' id='eao' name='eao' value='1' checked>";
            }
        }
    return "<input type='hidden' name='eao'  value='0'>"
		. "<input type='checkbox' name='eao' id='eao' value='1'>";
}
/* */

/* FUNCTION NOT UNSUSED ... CAN BE REMOVED ? */
function ignorep8($config='') {
		if (isset($_GET['gr'])) {
		    $ba = new beroAri();
		    $query = $ba->select("select config from isdn where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
		    while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		    }
		}
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "ignorep8" && $key[1] == 0)
                    return "<input type='hidden' name='ignorep8' value='0'>"
					. "<input type='checkbox' id='ignorep8' name='ignorep8' value='1'>";
            }
        }
    return "<input type='hidden' name='ignorep8' value='0'>"
		. "<input type='checkbox' name='ignorep8' id='ignorep8' value='1' checked>";
}
/* */

/* FUNCTION NOT USED ... CAN BE REMOVED ? */
function gen_ring_eao($config='') {
		if (isset($_GET['gr'])) {
			$ba = new beroAri();
			$query = $ba->select("select config from isdn where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
			while ($entry = $ba->fetch_array($query)) {
			    $config = $entry['config'];
			}
		}
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "gen_ring_eao" && $key[1] == 1)
                    return "<input type='hidden' name='gen_ring_eao'  value='0'>"
					. "<input type='checkbox' id='gen_ring_eao' name='gen_ring_eao' value='1' checked>";
            }
        }
    return "<input type='hidden' name='gen_ring_eao'  value='0'>"
		. "<input type='checkbox' name='gen_ring_eao' id='gen_ring_eao' value='1'>";
}
/* */

function cd($ba, $config='') {
	if (isset($_GET['gr'])){
		$query = $ba->select("select config from isdn where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
		while ($entry = $ba->fetch_array($query)) {
		    $config = $entry['config'];
		}
	}
	if ($config != "") {
		$configs = explode(',', $config);
		foreach ($configs as $value) {
			$key = explode('=', $value, 2);
			if ($key[0] == "cd" && $key[1] == 0) {
				return "<input type='hidden' name='cd'  value='0'> <input type='checkbox' id='cd' name='cd' value='1'>";
			}
		}
	}
	return "<input type='hidden' name='cd'  value='0'> <input type='checkbox' name='cd' id='cd' value='1' checked>";
}

function ec_tail($ba, $table = "isdn",$config='') {
		if (isset($_GET['gr'])) {
		    $query = $ba->select("select config from " . $table . " where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
		    while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		    }
		}
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "ectl")
                    return "<input type='text' class='form-control input-sm' name='ectl' id='ectl' digits=true min=0 max=15 value='" . stripslashes($key[1]) . "' size='7'>";
            }
        }
    return "<input type='text' class='form-control input-sm' name='ectl' id='ectl' digits=true min=0 max=15 value='15' size='7'>";

}

/* FUNCTION NOT USED ... CAN BE REMOVED ? */
function featurecodes($config='') {
	if (isset($_GET['gr'])) {
	    $ba = new beroAri();
	    $query = $ba->select("select config from isdn where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
	    while ($entry = $ba->fetch_array($query)) {
		$config = $entry['config'];
	    }
	}
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "featurecodes")
                    return "<input type='text' class='form-control input-sm' name='featurecodes' id='featurecodes' value='" . stripslashes($key[1]) . "' size='15'>";
            }
        }
    return "<input type='text' class='form-control input-sm' name='featurecodes' id='featurecodes' value='' size='15'>";

}

function clir_on_oad($ba, $table, $config='') {
		if (isset($_GET['gr'])) {
		    $query = $ba->select("select config from " . $table . " where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
		    while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		    }
		}
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "clir_on_oad")
                    return "<input type='text' class='form-control input-sm' name='clir_on_oad' id='clir_on_oad' value='" . stripslashes($key[1]) . "' size='7'>";
            }
        }
    return "<input type='text' class='form-control input-sm' name='clir_on_oad' id='clir_on_oad' size='7'>";

}

function ie_on_sip($ba, $config = "") {
        if (isset($_GET['id'])) {
            $query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
            while ($entry = $ba->fetch_array($query)) {
                $config = $entry['config'];
            }
        }
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "ie_on_sip" && $key[1] == 1)
                    return "<input type='hidden' name='ie_on_sip'  value='0'>"
					. "<input type='checkbox' name='ie_on_sip' id='ie_on_sip' value='1' checked>";
            }
        }
    return "<input type='hidden' name='ie_on_sip'  value='0'>"
		. "<input type='checkbox' name='ie_on_sip' id='ie_on_sip' value='1' >";
}

function dnssrv($ba, $config = "") {
        if (isset($_GET['id'])) {
            $query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
            while ($entry = $ba->fetch_array($query)) {
                $config = $entry['config'];
            }
        }
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "dnssrv" && $key[1] == 1)
                    return "<input type='hidden' name='dnssrv'  value='0'>"
					. "<input type='checkbox' name='dnssrv' id='dnssrv' value='1' checked>";
            }
        }
    return "<input type='hidden' name='dnssrv'  value='0'>"
		. "<input type='checkbox' name='dnssrv' id='dnssrv' value='1' >";
}

/* FUNCTION NOT USED ... CAN BE REMOVED ? */
function allow_sip_183_without_sdp($config = "") {
        if (isset($_GET['id'])) {
            $ba = new beroAri();
            $query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
            while ($entry = $ba->fetch_array($query)) {
                $config = $entry['config'];
            }
        }
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "allow_sip_183_without_sdp" && $key[1] == 0)
                    return "<input type='hidden' name='allow_sip_183_without_sdp'  value='0'>"
					. "<input type='checkbox' name='allow_sip_183_without_sdp' id='allow_sip_183_without_sdp' value='1'>";
            }
        }
    return "<input type='hidden' name='allow_sip_183_without_sdp'  value='0'>"
		. "<input type='checkbox' name='allow_sip_183_without_sdp' id='allow_sip_183_without_sdp' value='1' checked>";

}

function wait_for_cancel($ba, $config = "") {
        if (isset($_GET['id'])) {
            $query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
            while ($entry = $ba->fetch_array($query)) {
                $config = $entry['config'];
            }
        }
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "wait_for_cancel" && $key[1] == 1)
                    return "<input type='hidden' name='wait_for_cancel' value='0'>"
					. "<input type='checkbox' name='wait_for_cancel' id='wait_for_cancel' value='1' checked>";
            }
        }
    return "<input type='hidden' name='wait_for_cancel' value='0'>"
		. "<input type='checkbox' name='wait_for_cancel' id='wait_for_cancel' value='1'>";
}

/* FUNCTION NOT USED ... CAN BE REMOVED ? */
function ea($config = "") {
        if (isset($_GET['id'])) {
            $ba = new beroAri();
            $query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
            while ($entry = $ba->fetch_array($query)) {
                $config = $entry['config'];
            }
        }
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "ea" && $key[1] == 0)
                    return "<input type='hidden' name='ea' value='0'>"
					. "<input type='checkbox' name='ea' id='ea' value='1'>";
            }
        }
    return "<input type='hidden' name='ea' value='0'>"
		. "<input type='checkbox' name='ea' id='ea' value='1' checked>";
}

function t38($ba, $config = "") {

	if (isset($_GET['id'])) {
		$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
		while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		}
	}
	if ($config != "") {
		$configs = explode(',', $config);
		foreach ($configs as $value) {
			$key = explode('=', $value, 2);
			if ($key[0] == "t38" && $key[1] == 1)
				return "<input type='hidden' name='t38' value='0'> <input type='checkbox' name='t38' id='t38' value='1' checked>";
		}
	}
    return "<input type='hidden' name='t38' value='0'> <input type='checkbox' name='t38' id='t38' value='1'>";
}

function dtmfmode($ba, $config = "", $s2s = 0) {
	$default = "rfc2833";
	
	if ($s2s == 1) {
		$options = array("info", "rfc2833", "rfc2833:info", "info:rfc2833");
	}
	else {
		$options = array("info", "inband", "rfc2833");
	}
	if (isset($_GET['id'])) {
		$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
		while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		}
	}
	if ($config != "") {
		$configs = explode(',', $config);
		foreach ($configs as $value) {
			$key = explode('=', $value, 2);
			if ($key[0] == "dtmfmode")
				$default = $key[1];
		}
	}
	$sel = "<select class='form-control input-sm' name='dtmfmode' id='dtmfmode'>";
	foreach ($options as $name) {
		($name == $default) ? $sel.= "<option value='" . $name . "' selected>" . $name . "</option>" : $sel.= "<option value='" . $name . "'>" . $name . "</option>";
	}
	$sel.="</select>";
	return $sel;
}

function failover_timeout($ba, $config = "") {
    $sel = "<select class='form-control input-sm' name='failover_timeout' id='failover_timeout'>";
    for ($i = 0; $i <= 60; $i++) {
        if ($i == 0)
            $sel.="<option value='$i' selected>$i</option>";
        else
            $sel.="<option value='$i'>$i</option>";
    }
    $sel .="</select>";
        if (isset($_GET['id'])) {
            $query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
            while ($entry = $ba->fetch_array($query)) {
                $config = $entry['config'];
            }
        }
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "failover_timeout") {
                    $sel = "<select class='form-control input-sm' name='failover_timeout' id='failover_timeout'>";
                    for ($i = 0; $i <= 60; $i++) {
                        if ($i == $key[1])
                            $sel.="<option value='$i' selected>$i</option>";
                        else
                            $sel.="<option value='$i'>$i</option>";
                    }
                    $sel.="</select>";
                    return $sel;
                }
            }
        }
    return $sel;
}

function failover_proxy($ba, $config = "") {
    $select = "<select class='form-control input-sm' name='failover_proxy' id='failover_proxy'>";
    if (!isset($_GET['id']) || $config == "") {
        $select.="<option value=''>&nbsp;</option>";
        $query = $ba->select("SELECT name from sip");
        while ($entry = $ba->fetch_array($query)) {
            $select.="<option value='" . $entry['name'] . "'>" . $entry['name'] . "</option>";
        }
    } else {
        if (isset($_GET['id'])) {
            $query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
            while ($entry = $ba->fetch_array($query)) {
                $config = $entry['config'];
            }
        }
        $failover_proxy = "";
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "failover_proxy") {
                    $failover_proxy = $key[1];
                }
            }
        }
        $select.="<option value=''>&nbsp;</option>";
        $query = $ba->select("SELECT id, name from sip");
        while ($entry = $ba->fetch_array($query)) {
            if ($entry['id'] != $_GET['id']) {
                if ($entry['name'] == $failover_proxy) {
                    $select.="<option value='" . $entry['name'] . "' selected>" . $entry['name'] . "</option>";
                } else {
                    $select.="<option value='" . $entry['name'] . "'>" . $entry['name'] . "</option>";
                }
            }
        }
    }
    $select.="</select>";
    return $select;
}

function s2i_cpt($ba, $config = "") {

    $query = $ba->select("SELECT name from callprogress where direction='SIP-ISDN'");                                                
    if ($entry = $ba->fetch_array($query)) {                                                                                         
        $select = "<select class='form-control input-sm' name='s2i_cpt' id='s2i_cpt'>";                                              
                                                                                                                                     
        if (!isset($_GET['id']) || $config == "") {                                                                                  
            $select.="<option value=''>&nbsp;</option>";                                                                             
            $query = $ba->select("SELECT name from callprogress where direction='SIP-ISDN'");                                        
            while ($entry = $ba->fetch_array($query)) {                                                                              
                $select.="<option value='" . $entry['name'] . "'>" . $entry['name'] . "</option>";                                   
            }                                                                                                                        
        } else {                                                                                                                     
            if (isset($_GET['id'])) {                                                                                                
                $query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");                 
                while ($entry = $ba->fetch_array($query)) {                                                                          
                    $config = $entry['config'];                                                                                      
                }                                                                                                                    
            }                                                                                                                        
            $s2i_cpt = "";                                                                                                           
            if ($config != "") {                                                                                                     
                $configs = explode(',', $config);                                                                                    
                foreach ($configs as $value) {                                                                                       
                    $key = explode('=', $value, 2);                                                                                  
                    if ($key[0] == "s2i_cpt") {                                                                                      
                        $s2i_cpt = $key[1];                                                                                          
                    }                                                                                                                
                }                                                                                                                    
            }                                                                                                                        
            $select.="<option value=''>&nbsp;</option>";                                                                             
            $query = $ba->select("SELECT name from callprogress where direction='SIP-ISDN'");                                        
             while ($entry = $ba->fetch_array($query)) {                                                                             
                if ($entry['name'] == $s2i_cpt) {                                                                                    
                    $select.="<option value='" . $entry['name'] . "' selected>" . $entry['name'] . "</option>";                      
                } else {                                                                                                             
                    $select.="<option value='" . $entry['name'] . "'>" . $entry['name'] . "</option>";                               
                }                                                                                                                    
            }                                                                                                                        
        }                                                                                                                            
        $select.="</select>";                                                                                                        
        return $select;                                                                                                              
    } else {                                                                                                                         
        $select = "<select class='form-control input-sm' name='s2i_cpt' id='s2i_cpt' disabled>                                       
        <option>".DIALPLAN_CALL_PROGRESS_TABLE_DISABLED_S2I."</option></select>";                                                                     
        return $select;                                                                                                              
    }                                                                                                                                
}  

function i2s_cpt($ba, $config = "") {

    $query = $ba->select("SELECT name from callprogress where direction='ISDN-SIP'");                                                
    if ($entry = $ba->fetch_array($query)) {                                                                                         
                                                                                                                                     
        $select = "<select class='form-control input-sm' name='i2s_cpt' id='i2s_cpt'>";                                              
        if (!isset($_GET['id']) || $config == "") {                                                                                  
            $select.="<option value=''>&nbsp;</option>";                                                                             
            $query = $ba->select("SELECT name from callprogress where direction='ISDN-SIP'");                                        
            while ($entry = $ba->fetch_array($query)) {                                                                              
                $select.="<option value='" . $entry['name'] . "'>" . $entry['name'] . "</option>";                                   
            }                                                                                                                        
        } else {                                                                                                                     
            if (isset($_GET['id'])) {                                                                                                
                $query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");                 
                while ($entry = $ba->fetch_array($query)) {                                                                          
                    $config = $entry['config'];                                                                                      
                }                                                                                                                    
            }                                                                                                                        
            $i2s_cpt = "";                                                                                                           
            if ($config != "") {                                                                                                     
                $configs = explode(',', $config);                                                                                    
                foreach ($configs as $value) {                                                                                       
                    $key = explode('=', $value, 2);                                                                                  
                    if ($key[0] == "i2s_cpt") {                                                                                      
                        $i2s_cpt = $key[1];                                                                                          
                    }                                                                                                                
                 }                                                                                                                   
            }                                                                                                                        
            $select.="<option value=''>&nbsp;</option>";                                                                             
            $query = $ba->select("SELECT name from callprogress where direction='ISDN-SIP'");                                        
            while ($entry = $ba->fetch_array($query)) {                                                                              
                if ($entry['name'] == $i2s_cpt) {                                                                                    
                     $select.="<option value='" . $entry['name'] . "' selected>" . $entry['name'] . "</option>";                     
                } else {                                                                                                             
                     $select.="<option value='" . $entry['name'] . "'>" . $entry['name'] . "</option>";                              
                }                                                                                                                    
            }                                                                                                                        
        }                                                                                                                            
        $select.="</select>";                                                                                                        
        return $select;                                                                                                              
    } else {                                                                                                                         
        $select="<select class='form-control input-sm' name='i2s_cpt' id='i2s_cpt' disabled>                                          
        <option>".DIALPLAN_CALL_PROGRESS_TABLE_DISABLED_I2S."</option></select>";                                                                             
        return $select;                                                                                                              
    }                                                                                                                                
}    

function caller_id_mapping_sip($ba, $name, $config = "") {

	$options = array ("new_source", "oad", "oad2", "isdn_uuname", "isdn_display", "qsigname", "account_username", "account_base_number_auto", "from_display");

	$pai_select="";
	$ns_select=" selected";
	
	$sel = "<select class='form-control input-sm' name='$name' id='$name' onchange='manageManualSelect(this, this.id +\"_manual\");'>";
	
	if ($name == "sip_from_user_setting") {
		$sel.="<option value='\${new_source}' selected>new_source</option>" ;
	}
	else if ($name == "sip_from_display_setting") {
		$sel.="<option value='' selected>none</option>";
	}
	else if ($name == "sip_ppi_user_setting") {
		$sel.="<option value='' selected>none</option>";
	}
	else if ($name == "sip_contact_user_setting") {
		$sel.="<option value='\${new_source}'>new_source</option>";
		$cont_select=" selected";
		$ns_select="";
	}
	else if ($name == "sip_pai_user_setting") {
		$sel.="<option value='\${new_source}'>new_source</option>";
		$pai_select=" selected";
		$ns_select="";
	}
	else {
		$sel.="<option value='\${new_source}'>new_source</option>";
	}
	
	$sel.="	<option value='\${oad}'>oad</option>";
	($name == "sip_p_asserted_identity_setting") ? $sel.="<option value='\${oad2}' selected>oad2</option> " : $sel.="<option value='\${oad2}'>oad2</option>";
	if ($name == "sip_from_user_setting" || $name == "sip_from_display_setting" || $name == "sip_ppi_user_setting" || $name == "sip_pai_user_setting"|| $name == "sip_contact_user_setting"){
		$sel.="	<option value='\${isdn_uuname}'>isdn_uuname</option>";
		$sel.="	<option value='\${isdn_display}'>isdn_display</option>";
	}
	
	
	$sel.=" <option value='\${qsigname}'>qsigname</option>
				<option value='\${account_username}'" . $cont_select . ">account_username</option>
				<option value='\${account_base_number_auto}' " . $pai_select . ">account_base_number_auto</option>
				<option value=''>none</option>
				<option value='manual'>manual</option>
			</select><br>
			<input type='text' class='form-control input-sm' name='" . $name . "_manual' id='" . $name . "_manual' style='display:none;'>";

	if (isset($_GET['id'])) {
		$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
		while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		}
	}
	
	$flag=0;
	if ($config != "") {
		$configs = explode(',', $config);
		
		foreach ($configs as $value) {
			$key = explode('=', $value, 2);
			if ($key[0] == $name) {

				$flag = 1;

				$sel = "<select class='form-control input-sm' name='$name' id='$name' onchange='manageManualSelect(this, this.id +\"_manual\");'>";
							
				($key[1] == "\${new_source}") ? $sel.="<option value='\${new_source}'" . $ns_select . ">new_source</option>" : $sel.="<option value='\${new_source}'>new_source</option>";

				
				foreach ($options as $option) {
					if ($key[1] == "\${" . $option . "}") {
						${$option . "_selected"} = " selected";
						$flag = 2;
						break;
					}
				}
				if ($flag == 2) {
					break;
				}
				if ($key[1] == "") {
					$none_selected=" selected";
					break;
				}
				$manual_selected=" selected";
				$manual_value=$key[1];
				break;
			}
		}
	}
	
	//if not in config string use following defaults
	if ($flag == 0) {
		if ($name == "sip_from_user_setting") {
			$new_source_selected = " selected";
		}
		else if ($name == "sip_from_display_setting") {
			$none_selected = " selected";
		}
		if ($name == "sip_from_user_setting") {
			$new_source_selected = " selected";
		}
		else if ($name == "sip_from_display_setting") {
			$none_selected = " selected";
		}
		else if ($name == "sip_pai_user_setting") {
			$account_base_number_auto_selected = " selected";
		}
		else if ($name == "sip_ppi_user_setting") {
			$none_selected = " selected";
		}
		else if ($name == "sip_contact_user_setting") {
			$account_username_selected = " selected";
		}
	}

	$sel = "<select class='form-control input-sm' name='" . $name . "' id='" . $name . "' " .
		"onchange='if (this.selectedIndex== this.options.length-1) document.getElementById(\"" . $name . "_manual\").style.display=\"\"; " .
		"else document.getElementById(\"" . $name . "_manual\").style.display=\"none\";'>";
	
	foreach ($options as $option) {
		$sel.="<option value='\${" . $option . "}' " . ${$option . "_selected"} . ">" . $option . "</option>\n" ;
	}
 	$sel.= "<option value='' " . $none_selected . ">none</option>\n";
 	$sel.= "<option value='manual' " . $manual_selected . ">manual</option>\n";
	
	$sel.="</select><br>\n";
	if (strlen ($manual_value)) {
		$sel.="<input type='text' class='form-control input-sm' name='" . $name . "_manual' id='" . $name . "_manual' value='" . $manual_value . "'>";
	}
	else {
		$sel.= "<input type='text' class='form-control input-sm' name='" . $name . "_manual' id='" . $name . "_manual' style='display:none;'>";
	}
	return $sel;
}

function sip_input_text($ba, $name, $config = "", $default = "", $regex = "[0-9]+"){
	$value = $default;
	if (isset($_GET['id'])) {
		$value = '';
		$query = $ba->select("SELECT config FROM sip WHERE id='" . sqlite_escape_string($_GET['id']) . "'");
		while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		}
	}
	if ($config != "" && preg_match("/$name=($regex)/", $config, $matched)) {
		$value = $matched[1];
	}
	return "<input type='text' class='form-control input-sm' name='$name' id='$name' value='$value'>";
}

function get_isdn2sip_numformat_options() {
	return array("VAZ_00" => "00 (int) (nat) (num)", "VAZ_PLUS" => "+ (int) (nat) (num)", "VAZ_EMPTY" => "(int) (nat) (num)", "VAZ_UNKNOWN" => "unknown");
}

function isdn2sip_destination_numformat($ba, $config = "", $default = "VAZ_UNKNOWN") {

	$options = get_isdn2sip_numformat_options();

		if (isset($_GET['id'])) {
			$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
			while ($entry = $ba->fetch_array($query)) {
				$config = $entry['config'];
			}
		}
		if ($config != "") {
			$configs = explode(',', $config);
			foreach ($configs as $value) {
				$key = explode('=', $value, 2);
				if ($key[0] == "isdn2sip_destination_numformat")
					$default = $key[1];
			}
		}
	$sel = "<select name='isdn2sip_destination_numformat' class='form-control input-sm' id='isdn2sip_destination_numformat'>";
	foreach ($options as $name => $value) {
		($name == $default) ? $sel.= "<option value='" . $name . "' selected>" . $value . "</option>" : $sel.= "<option value='" . $name . "'>" . $value . "</option>";
	}
	$sel.="</select>";
	return $sel;
}

function isdn2sip_source_numformat($ba, $config = "", $default = "VAZ_UNKNOWN") {

	$options = get_isdn2sip_numformat_options();

		if (isset($_GET['id'])) {
			$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
			while ($entry = $ba->fetch_array($query)) {
				$config = $entry['config'];
			}
		}
		if ($config != "") {
			$configs = explode(',', $config);
			foreach ($configs as $value) {
				$key = explode('=', $value, 2);
				if ($key[0] == "isdn2sip_source_numformat")
					$default = $key[1];
			}
		}
	$sel = "<select name='isdn2sip_source_numformat' class='form-control input-sm' id='isdn2sip_source_numformat'>";
	foreach ($options as $name => $value) {
		($name == $default) ? $sel.= "<option value='" . $name . "' selected>" . $value . "</option>" : $sel.= "<option value='" . $name . "'>" . $value . "</option>";
	}
	$sel.="</select>";
	return $sel;
}

function get_privacy_header_options() {
	return array("auto" => "auto", "off" => "off", "id" => "id", "none" => "none");
}

function use_privacy_header($ba, $config = "") {
	$default="auto";
	$options = get_privacy_header_options();
		if (isset($_GET['id'])) {
			$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
			while ($entry = $ba->fetch_array($query)) {
				$config = $entry['config'];
			}
		}
		if ($config != "") {
			$configs = explode(',', $config);
			foreach ($configs as $value) {
				$key = explode('=', $value, 2);
				if ($key[0] == "use_privacy_header")
					$default = $key[1];
			}
		}
	$sel = "<select name='use_privacy_header' class='form-control input-sm' id='use_privacy_header'>";
	foreach ($options as $name => $value) {
		($name == $default) ? $sel.= "<option value='" . $name . "' selected>" . $value . "</option>" : $sel.= "<option value='" . $name . "'>" . $value . "</option>";
	}
	$sel.="</select>";
	return $sel;
}

function get_prefix_setting_options() {
	return array("replace" => "replace \"+\" by \"prefix\"", "prepend" => "prepend prefix", "none" => "none");
}

function sip2dialplan_dad_prefix_setting($ba, $config = "") {
	$options = get_prefix_setting_options();
		if (isset($_GET['id'])) {
			$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
			while ($entry = $ba->fetch_array($query)) {
				$config = $entry['config'];
			}
		}
		if ($config != "") {
			$configs = explode(',', $config);
			foreach ($configs as $value) {
				$key = explode('=', $value, 2);
				if ($key[0] == "sip2dialplan_dad_prefix_setting")
					$default = $key[1];
			}
		}
	$sel = "<select name='sip2dialplan_dad_prefix_setting' class='form-control input-sm' id='sip2dialplan_dad_prefix_setting' class='sip2dialplan_dad_prefix_setting'>";
	foreach ($options as $name => $value) {
		($name == $default) ? $sel.= "<option value='" . $name . "' selected>" . $value . "</option>" : $sel.= "<option value='" . $name . "'>" . $value . "</option>";
	}
	$sel.="</select>";
	return $sel;
}

function sip2dialplan_oad_prefix_setting($ba, $config = "") {
	$options = get_prefix_setting_options();
	if (isset($_GET['id'])) {
		$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
		while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		}
	}
	if ($config != "") {
		$configs = explode(',', $config);
		foreach ($configs as $value) {
			$key = explode('=', $value, 2);
			if ($key[0] == "sip2dialplan_oad_prefix_setting") $default = $key[1];
		}
	}
	$sel = "<select name='sip2dialplan_oad_prefix_setting' class='form-control input-sm' id='sip2dialplan_oad_prefix_setting' class='sip2dialplan_oad_prefix_setting'>";
	foreach ($options as $name => $value) {
		($name == $default) ? $sel.= "<option value='" . $name . "' selected>" . $value . "</option>" : $sel.= "<option value='" . $name . "'>" . $value . "</option>";
	}
	$sel.="</select>";
	return $sel;
}

function srtp_mode($ba, $config = "", $sip2sip_dialplan_rule = 0) {

	if ($sip2sip_dialplan_rule == 1) {
		$options = array("off", "optional", "mandatory", "off:optional", "off:mandatory", "optional:off", "optional:mandatory", "mandatory:off" , "mandatory:optional",);
	}
	else {
		$options = array("off", "optional", "mandatory");
	}
	
	if (isset($_GET['id'])) {
		$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
		while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		}
	}
	if ($config != "") {
		$configs = explode(',', $config);
		foreach ($configs as $value) {
			$key = explode('=', $value, 2);
			if ($key[0] == "srtp_mode") $default = $key[1];
		}
	}
	$sel = "<select name='srtp_mode' class='form-control input-sm' id='srtp_mode'>";
	foreach ($options as $name) {
		($name == $default) ? $sel.= "<option value='" . $name . "' selected>" . $name . "</option>" : $sel.= "<option value='" . $name . "'>" . $name . "</option>";
	}
	$sel.="</select>";

	return $sel;
}

function get_srtp_crypto_suites_options() {
	return array("AES_CM_128_HMAC_SHA1_80" => "AES_CM_80", "AES_CM_128_HMAC_SHA1_32" => "AES_CM_32", "F8_128_HMAC_SHA1_80" => "F8_80");
}

function srtp_crypto_suites($ba, $config = "") {
	$options = get_srtp_crypto_suites_options();
	$default = array_keys($options); 
		if (isset($_GET['id'])) {
			$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
			while ($entry = $ba->fetch_array($query)) {
				$config = $entry['config'];
			}
		}
		if ($config != "") {
			$configs = explode(',', $config);
			foreach ($configs as $value) {
				$key = explode('=', $value, 2);
				if ($key[0] == "srtp_crypto_suites")
					$default = explode(':', $key[1]);
			}
		}
	$sel = "<select name='srtp_crypto_suites[]' class='form-control input-sm' id='srtp_crypto_suites' multiple='true'>";
	foreach ($options as $name=>$value) {
		in_array($name, $default) ? $sel.= "<option value='" . $name . "' selected>" . $value . "</option>" : $sel.= "<option value='" . $name . "'>" . $value . "</option>";
	}
	$sel.="</select>";
	return $sel;
}


function called_party_number_sip($ba, $name, $config = "") {
    $sel = "<select name='$name' class='form-control input-sm' id='$name' onchange='manageManualSelect(this, this.id +\"_manual\");'>";

    $sel.="<option value='\${new_destination}'>new_destination</option>
        <option value='\${dad}'>dad</option>
	<option value='\${account_username}'>account_username</option>
	<option value='manual'>manual</option>
	</select><br>
	<input type='text' class='form-control input-sm' name='" . $name . "_manual' id='" . $name . "_manual' style='display:none;'>";
        if (isset($_GET['id'])) {
            $query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
            while ($entry = $ba->fetch_array($query)) {
                $config = $entry['config'];
            }
        }
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == $name) {
    		    $sel = "<select name='$name' class='form-control input-sm' id='$name' onchange='manageManualSelect(this, this.id +\"_manual\");'>";

                    ($key[1] == "\${new_destination}") ? $sel.="<option value='\${new_destination}' selected>new_destination</option>" : $sel.="<option value='\${new_destination}'>new_destination</option>";
                    ($key[1] == "\${dad}") ? $sel.="<option value='\${dad}' selected>dad</option>" : $sel.="<option value='\${dad}'>dad</option>";
                    ($key[1] == "\${account_username}") ? $sel.="<option value='\${account_username}' selected>account_username</option>" : $sel.="<option value='\${account_username}'>account_username</option>";
                    ($key[1] != "\${new_destination}" && $key[1] != "\${account_username}" && $key[1] != "\${dad}") ? $sel.="<option value='manual' selected>manual</option>" : $sel.="<option value='manual'>manual</option>";
                    $sel.="</select><br>";
                    ($key[1] != "\${new_destination}" && $key[1] != "\${account_username}" && $key[1] != "\${dad}") ? $sel.="<input type='text' class='form-control input-sm' name='" . $name . "_manual' id='" . $name . "_manual' value='" . $key['1'] . "'>" : $sel.="<input type='text' class='form-control input-sm' name='" . $name . "_manual' id='" . $name . "_manual' style='display:none;'>";
                    return $sel;
                }
            }
        }
    return $sel;
}

function get_from_sip_src_setting_options() {
	return array("auto", "from_user", "from_display", "pai_all", "pai_user", "pai_display", "ppi_all", "ppi_user", "ppi_display", "rpi_all", "rpi_user", "rpi_display", "manual");
}

function from_sip_src_setting($ba, $config = "", $unslash = 0) {
	$options = get_from_sip_src_setting_options();

	if (isset($_GET['id'])) {
		$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
		while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		}
	}
	if ($config != "") {
		$configs = explode(',', $config);
		foreach ($configs as $value) {
			$key = explode('=', $value, 2);
			if ($key[0] == 'from_sip_src_setting') {
				if ($unslash) {
					$active_value = stripslashes ($key[1]);
				}
				else {
					$active_value = $key[1];
				}
				break;
			}
		}
	}
	if (strlen ($active_value) == 0) {
		$active_value="auto";
	}
	
	$sel = "<select name='from_sip_src_setting' class='form-control input-sm' id='from_sip_src_setting' onchange='manageManualSelect(this, this.id +\"_manual\");'>";

	$predefined_value_set = 0;
	foreach ($options as $name) {
		if ($name == $active_value) {
			$sel.= "<option value='" . $name . "' selected>" . $name . "</option>";
			$predefined_value_set  = 1;
		}
		else {
			if ($name == "manual" && $predefined_value_set == 0) {
				$sel.= "<option value='" . $name . "' selected>" . $name . "</option>";
			}
			else {
				$sel.= "<option value='" . $name . "'>" . $name . "</option>";
			}
			
		}
	}
	$sel.="</select>";
	
	if ($predefined_value_set) {
		$sel.="<input type='text' class='form-control input-sm' name='from_sip_src_setting_manual' id='from_sip_src_setting_manual' style='display:none;'>";
	}
	else {
		$sel.="<input type='text' class='form-control input-sm' name='from_sip_src_setting_manual' id='from_sip_src_setting_manual' value='" . $active_value . "''>";
	}
	
	return $sel;
}

function get_from_sip_dest_setting_options() {
	return array("auto", "to_user", "to_display", "pcpi_user", "pcpi_display", "pai_user", "pai_display", "ppi_user", "ppi_display", "request_url_user", "manual");
}

function from_sip_dest_setting($ba, $config = "", $unslash = 0) {
	$options = get_from_sip_dest_setting_options();

	if (isset($_GET['id'])) {
		$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
		while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		}
	}
	if ($config != "") {
		$configs = explode(',', $config);
		foreach ($configs as $value) {
			$key = explode('=', $value, 2);
			if ($key[0] == 'from_sip_dest_setting') {
				if ($unslash) {
					$active_value = stripslashes ($key[1]);
				}
				else {
					$active_value = $key[1];
				}
				break;
			}
		}
	}
	if (strlen ($active_value) == 0) {
		$active_value="auto";
	}
	
	$sel = "<select name='from_sip_dest_setting' class='form-control input-sm' id='from_sip_dest_setting' onchange='manageManualSelect(this, this.id +\"_manual\");'>";

	$predefined_value_set = 0;
	foreach ($options as $name) {
		if ($name == $active_value) {
			$sel.= "<option value='" . $name . "' selected>" . $name . "</option>";
			$predefined_value_set  = 1;
		}
		else {
			if ($name == "manual" && $predefined_value_set == 0) {
				$sel.= "<option value='" . $name . "' selected>" . $name . "</option>";
			}
			else {
				$sel.= "<option value='" . $name . "'>" . $name . "</option>";
			}
			
		}
	}
	$sel.="</select>";
	
	if ($predefined_value_set) {
		$sel.="<input type='text' class='form-control input-sm' name='from_sip_dest_setting_manual' id='from_sip_dest_setting_manual' style='display:none;'>";
	}
	else {
		$sel.="<input type='text' class='form-control input-sm' name='from_sip_dest_setting_manual' id='from_sip_dest_setting_manual' value='" . $active_value . "''>";
	}
	
	return $sel;
}

function get_caller_id_pstn_list() {
	return array(	'', '${new_source}', '${new_source_auto}', '${from_user}', '${from_display}', '${pai_all}', '${pai_user}', '${pai_display}', '${ppi_all}',
			'${ppi_user}', '${ppi_display}', '${rpi_all}', '${rpi_user}', '${rpi_display}', 'manual');
}

function caller_id_mapping_pstn($ba, $name, $table = 'isdn', $fromD = '', $toD = '',$config='') {
    $sel = "<select name='$name' class='form-control input-sm' id='$name' onchange='manageManualSelect(this, this.id +\"_manual\");'>";

    ($name == "analog_oad_setting") ? $sel.="<option value='\${new_source}' selected>new_source</option>" : $sel.="<option value='\${new_source}'>new_source</option>";
    ($name == "isdn_oad_setting") ? $sel.="<option value='\${new_source_auto}' selected>new_source_auto</option>" : $sel.="<option value='\${new_source_auto}'>new_source_auto</option>";
    $sel.="	<option value='\${from_user}'>from_user</option>
				<option value='\${from_display}'>from_display</option>
				<option value='\${pai_all}'>pai_all</option>
				<option value='\${pai_user}'>pai_user</option>
				<option value='\${pai_display}'>pai_display</option>
				<option value='\${ppi_all}'>ppi_all</option>
				<option value='\${ppi_user}'>ppi_user</option>
				<option value='\${ppi_display}'>ppi_display</option>
				<option value='\${rpi_all}'>rpi_all</option>
				<option value='\${rpi_user}'>rpi_user</option>
				<option value='\${rpi_display}'>rpi_display</option>";
    ($name == "isdn_oad2_setting" || $name == "isdn_qsigname_setting" || $name == "isdn_redirected_nr_setting" || $name == "analog_display_setting") ? $sel.="<option value='' selected>none</option>" : $sel.="<option value=''>none</option>";
    $sel.="<option value='manual'>manual</option>";
    $sel.="</select><br>";
    $sel.="<input type='text' class='form-control input-sm' name='" . $name . "_manual' id='" . $name . "_manual' style='display:none;'>";
	if (isset($_GET['gr'])){
		$query = $ba->select("select config from " . $table . " where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
		while ($entry = $ba->fetch_array($query)) {
		    $config = $entry['config'];
		}
	}
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == $name) {
    			$sel = "<select name='$name' class='form-control input-sm' id='$name' onchange='manageManualSelect(this, this.id +\"_manual\");'>";

                    ($key[1] == "\${new_source}") ? $sel.="<option value='\${new_source}' selected>new_source</option>" : $sel.="<option value='\${new_source}'>new_source</option>";
                    ($key[1] == "\${new_source_auto}") ? $sel.="<option value='\${new_source_auto}' selected>new_source_auto</option>" : $sel.="<option value='\${new_source_auto}'>new_source_auto</option>";
                    ($key[1] == "\${from_user}") ? $sel.="<option value='\${from_user}' selected>from_user</option>" : $sel.="<option value='\${from_user}'>from_user</option>";
                    ($key[1] == "\${from_display}") ? $sel.="<option value='\${from_display}' selected>from_display</option>" : $sel.="<option value='\${from_display}'>from_display</option>";
                    ($key[1] == "\${pai_all}") ? $sel.="<option value='\${pai_all}' selected>pai_all</option>" : $sel.="<option value='\${pai_all}'>pai_all</option>";
                    ($key[1] == "\${pai_user}") ? $sel.="<option value='\${pai_user}' selected>pai_user</option>" : $sel.="<option value='\${pai_user}'>pai_user</option>";
                    ($key[1] == "\${pai_display}") ? $sel.="<option value='\${pai_display}' selected>pai_display</option>" : $sel.="<option value='\${pai_display}'>pai_display</option>";
                    ($key[1] == "\${ppi_all}") ? $sel.="<option value='\${ppi_all}' selected>ppi_all</option>" : $sel.="<option value='\${ppi_all}'>ppi_all</option>";
                    ($key[1] == "\${ppi_user}") ? $sel.="<option value='\${ppi_user}' selected>ppi_user</option>" : $sel.="<option value='\${ppi_user}'>ppi_user</option>";
                    ($key[1] == "\${ppi_display}") ? $sel.="<option value='\${ppi_display}' selected>ppi_display</option>" : $sel.="<option value='\${ppi_display}'>ppi_display</option>";
                    ($key[1] == "\${rpi_all}") ? $sel.="<option value='\${rpi_all}' selected>rpi_all</option>" : $sel.="<option value='\${rpi_all}'>rpi_all</option>";
                    ($key[1] == "\${rpi_user}") ? $sel.="<option value='\${rpi_user}' selected>rpi_user</option>" : $sel.="<option value='\${rpi_user}'>rpi_user</option>";
                    ($key[1] == "\${rpi_display}") ? $sel.="<option value='\${rpi_display}' selected>rpi_display</option>" : $sel.="<option value='\${rpi_display}'>rpi_display</option>";
                    ($key[1] == "") ? $sel.="<option value='' selected>none</option>" : $sel.="<option value=''>none</option>";
                    ($key[1] != "\${from_user}" && $key[1] != "\${from_display}" && $key[1] != "\${new_source}" && $key[1] != "\${new_source_auto}" && $key[1] != "\${pai_all}" && $key[1] != "\${pai_user}" && $key[1] != "\${pai_display}" && $key[1] != "\${ppi_all}" && $key[1] != "\${ppi_user}" && $key[1] != "\${ppi_display}" && $key[1] != "\${rpi_all}" && $key[1] != "\${rpi_user}" && $key[1] != "\${rpi_display}" && $key[1] != "") ? $sel.="<option value='manual' selected>manual</option>" : $sel.="<option value='manual'>manual</option>";
                    $sel.="</select><br>";
                    ($key[1] != "\${from_user}" && $key[1] != "\${from_display}" && $key[1] != "\${new_source}" && $key[1] != "\${new_source_auto}" && $key[1] != "\${pai_all}" && $key[1] != "\${pai_user}" && $key[1] != "\${pai_display}" && $key[1] != "\${ppi_all}" && $key[1] != "\${ppi_user}" && $key[1] != "\${ppi_display}" && $key[1] != "\${rpi_all}" && $key[1] != "\${rpi_user}" && $key[1] != "\${rpi_display}" && $key[1] != "") ? $sel.="<input type='text' class='form-control input-sm' name='" . $name . "_manual' id='" . $name . "_manual' value='" . $key['1'] . "'>" : $sel.="<input type='text' class='form-control input-sm' name='" . $name . "_manual' id='" . $name . "_manual' style='display:none;'>";
                    return $sel;
                }
            }
        }
    return $sel;
}

function get_callee_id_pstn_list() {
	return array('${new_destination_auto}', '${new_destination}', '${to_user}', '${to_display}', '${request_uri_user}');
}

function callee_id_mapping_pstn($ba, $name, $table = 'isdn', $config='') {
	$options = get_callee_id_pstn_list();
	if (isset($_GET['gr'])) {
		$query = $ba->select("select config from " . $table . " where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
		while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		}
	}
	$value = NULL;
	if ($config != "") {
		$configs = explode(',', $config);
		foreach ($configs as $configOp) {
			$key = explode('=', $configOp, 2);
			if ($key[0] == $name) {
				$value = $key[1];
			}
		}
	}
	$sel = "<select name='$name' class='form-control input-sm' id='$name' onchange='manageManualSelect(this, this.id +\"_manual\");'>";

    $sel .= ($value == "\${new_destination_auto}") ? "<option value='\${new_destination_auto}' selected>new_destination_auto</option>" : 
		"<option value='\${new_destination_auto}'>new_destination_auto</option>"; 
	$sel .=  ($value == "\${new_destination}") ? "<option value='\${new_destination}' selected>new_destination</option>" : 
		"<option value='\${new_destination}'>new_destination</option>";
	$sel .=  ($value == "\${to_user}") ? "<option value='\${to_user}' selected>to_user</option>" : 
		"<option value='\${to_user}'>to_user</option>";
	$sel .=  ($value == "\${to_display}") ? "<option value='\${to_display}' selected>to_display</option>" : ""
		. "<option value='\${to_display}'>to_display</option>";
	$sel .=  ($value == "\${request_uri_user}") ? "<option value='\${request_uri_user}' selected>request_uri_user</option>" : 
		"<option value='\${request_uri_user}'>request_uri_user</option>";
	$sel .=  (!is_null($value) && !in_array($value, $options)) ? "<option value='manual' selected>manual</option>" : 
		"<option value='manual'>manual</option>";
    $sel .= "</select><br>";
	$manualValue = (!is_null($value) && !in_array($value, $options)) ? $value : "";
	$manualDisplay = (!is_null($value) && !in_array($value, $options)) ? "" : "display:none;";
    $sel .= "<input type='text' class='form-control input-sm' name='" . $name . "_manual' id='" . $name . "_manual' style='$manualDisplay' value='$manualValue'>";
	
    return $sel;
}

function get_from_pstn_src_setting_list($type) {
	// ISDN
	if (strtolower($type) === 'isdn') {
		return array('auto', 'oad', 'oad2', 'qsigname', 'redirected_nr', 'actdivq1', 'actdivq2');
	}
	// Analog
	return array('clip', 'cnip');
}

function from_pstn_src_setting($ba, $table, $fromD = "", $toD = "",$config="") {
    $sel = "<select name='from_pstn_src_setting_" . $table . "' class='form-control input-sm' id='from_pstn_src_setting_" . $table . "'>";
    if ($table == "isdn") {
        $sel.="<option value='auto' selected>auto</option>";
        $sel.="<option value='oad'>oad</option>
				<option value='oad2'>oad2</option>
				<option value='qsigname'>qsigname</option>
				<option value='redirected_nr'>redirected_nr</option>
				<option value='actdivq1'>actdivq1</option>
				<option value='actdivq2'>actdivq2</option>";
				
    } elseif ($table == "analog")
        $sel.="<option value='clip' selected>clip</option>
				<option value='cnip'>cnip</option>";
    $sel.="</select>";
	    if (isset($_GET['gr'])){
		$query = $ba->select("select config from " . $table . " where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
		while ($entry = $ba->fetch_array($query)) {
		    $config = $entry['config'];
		}
	    }
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "from_pstn_src_setting") {
                    $sel = "<select name='from_pstn_src_setting_" . $table . "' class='form-control input-sm' id='from_pstn_src_setting_" . $table . "'>";
                    if ($table == "isdn") {
                        ($key[1] == "auto") ? $sel.="<option value='auto' selected>auto</option>" : $sel.="<option value='auto'>auto</option>";
                        ($key[1] == "oad") ? $sel.="<option value='oad' selected>oad</option>" : $sel.="<option value='oad'>oad</option>";
                        ($key[1] == "oad2") ? $sel.="<option value='oad2' selected>oad2</option>" : $sel.="<option value='oad2'>oad2</option>";
                        ($key[1] == "qsigname") ? $sel.="<option value='qsigname' selected>qsigname</option>" : $sel.="<option value='qsigname'>qsigname</option>";
                        ($key[1] == "redirected_nr") ? $sel.="<option value='redirected_nr' selected>redirected_nr</option>" : $sel.="<option value='redirected_nr'>redirected_nr</option>";
                        ($key[1] == "actdivq1") ? $sel.="<option value='actdivq1' selected>actdivq1</option>" : $sel.="<option value='actdivq1'>actdivq1</option>";
                        ($key[1] == "actdivq2") ? $sel.="<option value='actdivq2' selected>actdivq2</option>" : $sel.="<option value='actdivq2'>actdivq2</option>";
                    } elseif ($table == "analog") {
                        ($key[1] == "clip") ? $sel.="<option value='clip' selected>clip</option>" : $sel.="<option value='clip'>clip</option>";
                        ($key[1] == "cnip") ? $sel.="<option value='cnip' selected>cnip</option>" : $sel.="<option value='cnip'>cnip</option>";
                    }
                    $sel.="</select>";
                    return $sel;
                }
            }
        }
    
    return $sel;

}

// ++++++++CODECS+++++++++++++
function ges_codecs($ba, $config = "") {
    $select = "<select multiple name='codecs[]' class='form-control input-sm' id='sel' size='5'>";
    $select .= "<option value='pcma'>pcma</option>";

    $select .= "</select>";
    if (isset($_GET['id'])) {
        $query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
        while ($entry = $ba->fetch_array($query)) {
            $config = $entry['config'];
        }
    }
    if ($config != "") {
        $configs = explode(',', $config);
        foreach ($configs as $value) {
            $key = explode('=', $value, 2);
            if ($key[0] == "codecs") {
                $cod = explode(':', $key[1]);
                $select = "<select multiple name='codecs[]' class='form-control input-sm' id='sel' size='5'>";
                foreach ($cod as $codec) {
                    $select .= "<option value='" . $codec . "'>" . $codec . "</option>";
                }
                $select .= "</select>";
                $control = true;
		return $select;
            }
	    
        }
	
    } 
    return $select;        
}

function get_codecs_list() {
	return array("pcma", "pcmu", "g729", "g723", "g726-32", "CLEARMODE");
}

function new_codecs($ba, $config = "") {
	$all_codecs = array_merge(array_diff(get_codecs_list(), array("pcma")));
        $select = "<select multiple name='new_codecs[]' class='form-control input-sm' id='sel1' size='5'>";
        for ($i = 0; $i < count($all_codecs); $i++) {
            $select .= "<option value='" . $all_codecs[$i] . "'>" . $all_codecs[$i] . "</option>";
        }
        $select .= "</select>";

    if (isset($_GET['id'])) {
        $query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
        while ($entry = $ba->fetch_array($query)) {
            $config = $entry['config'];
        }
    }

    if ($config != "") {
	$all_codecs = get_codecs_list();
        $new_codecs = $all_codecs;
        $configs = explode(',', $config);
        foreach ($configs as $value) {
            $key = explode('=', $value, 2);
            if ($key[0] == "codecs") {
                $new_codecs = array();
                $cod = explode(':', $key[1]);
                for ($i = 0; $i < count($all_codecs); $i++) {
                    $b = true;
                    for ($j = 0; $j < count($cod); $j++) {
                        if ($cod[$j] == $all_codecs[$i])
                            $b = false;
                    }

                    if ($b == true) {
                        $new_count = count($new_codecs);
                        $new_codecs[$new_count] = $all_codecs[$i];
                    }
                }
		$select = "<select multiple name='new_codecs[]' class='form-control input-sm' id='sel1' size='5'>";
		for ($i = 0; $i < count($new_codecs); $i++) {
		    $select .= "<option value='" . $new_codecs[$i] . "'>" . $new_codecs[$i] . "</option>";
		}
		$select .= "</select>";
		return $select;
            }
        }
    } 
    return $select;
}

function codecs($ba, $config = "") {

    return "
				<div class='col-lg-6'>" . DIALPLAN_ALLOWED_CODECS_DIS . "</div>
				<div class='col-lg-6'>" . DIALPLAN_AVAILABLE_CODECS_DIS . "</div>
			
				<div class='col-lg-2'>
					<div class='row'  data-toggle='tooltip' data-html='true' data-placement='auto bottom' data-trigger='hover' title='" . CODECS_UP . "'>
						<button type='button' class='btn btn-default' id='upB' onclick='up()'>Up</button>
					</div>
					<div class='row'  data-toggle='tooltip' data-html='true' data-placement='auto bottom' data-trigger='hover' title='" . CODECS_DOWN . "'>
						<button type='button' class='btn btn-default' id='downB' onclick='down()'>Down</button>
					</div>
				</div>
				<div class='col-lg-4'>
					" . ges_codecs($ba, $config) . "
				</div>
				<div class='col-lg-2'>
					<div class='row'  data-toggle='tooltip' data-html='true' data-placement='auto bottom' data-trigger='hover' title='" . CODECS_ADD . "'>
						<button type='button' class='btn btn-default' id='addB' onclick='move(\"sel1\",\"sel\")'><- Add</button>
					</div>
					<div class='row'  data-toggle='tooltip' data-html='true' data-placement='auto bottom' data-trigger='hover' title='" . CODECS_REMOVE . "'>
						<button type='button' class='btn btn-default' id='removeB' onclick='move(\"sel\",\"sel1\")'>Del -></button>
					</div>
				</div>
				<div class='col-lg-4'>
					" . new_codecs($ba, $config) . "
				</div>";
}

function tons($ba, $name, $config = "", $port_type = '') 
{
    $sel = "<select class='form-control input-sm$port_type' name='" . $name . "' id='" . $name . "'>
	<option value='0'" . (($name == "oton" || $name == "dton") ? "" : " selected") . " >unknown</option>
	<option value='1'>international</option>
	<option value='2'>national</option>
	<option value='3'>local (network-specific)</option>
	<option value='4'" . (($name != "oton" && $name != "dton") ? "" : " selected") . " >subscriber</option>
	<option value='5'>alphanumeric</option>
	<option value='6'>abbreviated</option>
	</select>";

    if (isset($_GET['gr'])) {
        $query = $ba->select("select config from isdn where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
        while ($entry = $ba->fetch_array($query)) {
            $config = $entry['config'];
        }
    }
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == $name) {
                    $sel = "<select name='" . $name . "' class='form-control input-sm$port_type' id='" . $name . "'>";
                    ($key[1] == 0) ? $sel.="<option value='0' selected>unknown</option>" : $sel.="<option value='0'>unknown</option>";
                    ($key[1] == 1) ? $sel.="<option value='1' selected>international</option>" : $sel.="<option value='1'>international</option>";
                    ($key[1] == 2) ? $sel.="<option value='2' selected>national</option>" : $sel.="<option value='2'>national</option>";
                    ($key[1] == 3) ? $sel.="<option value='3' selected>local (network-specific)</option>" : $sel.="<option value='3'>local (network-specific)</option>";
                    ($key[1] == 4) ? $sel.="<option value='4' selected>subscriber</option>" : $sel.="<option value='4'>subscriber</option>";
                    ($key[1] == 5) ? $sel.="<option value='5' selected>alphanumeric</option>" : $sel.="<option value='5'>alphanumeric</option>";
                    ($key[1] == 6) ? $sel.="<option value='6' selected>abbreviated</option>" : $sel.="<option value='6'>abbreviated</option>";
                    $sel.="</select>";
                    return $sel;
                }
            }
        }
    return $sel;
}

/* FUNCTION NOT USED ... CAN BE REMOVED ? */
function prefixes($name, $default,$config = "") {
    if (isset($_GET['gr'])) {
        $ba = new beroAri();
        $query = $ba->select("select config from isdn where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
        while ($entry = $ba->fetch_array($query)) {
            $config = $entry['config'];
        }
    }
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == $name)
                    return "<input type='text' class='form-control input-sm' name='" . $name . "' id='" . $name . "' value='" . stripslashes($key[1]) . "' size='7'>";
            }
        }
    return "<input type='text' class='form-control input-sm' name='" . $name . "' id='" . $name . "' value='" . $default . "' size='7'>";
}

function screen($ba, $config = "") {
    if (isset($_GET['gr'])) {
        $query = $ba->select("select config from isdn where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
        while ($entry = $ba->fetch_array($query)) {
            $config = $entry['config'];
        }
    }
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "screen" && $key[1] == 1)
                    return "<input type='hidden' name='screen' value='0'>"
					. "<input type='checkbox' id='screen' name='screen' value='1' checked>";
            }
        }
    
    return "<input type='hidden' name='screen' value='0'>"
		. "<input type='checkbox' id='screen' name='screen' value='1'>";
}

function pres($ba, $config = "") {
    if (isset($_GET['gr'])) {
        $query = $ba->select("select config from isdn where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
        while ($entry = $ba->fetch_array($query)) {
            $config = $entry['config'];
        }
    }
        if ($config != "") {
            $configs = explode(',', $config);
            foreach ($configs as $value) {
                $key = explode('=', $value, 2);
                if ($key[0] == "pres" && $key[1] == 1)
                    return "<input type='hidden' name='pres' value='0'>"
					. "<input type='checkbox' name='pres' id='pres' value='1' checked>";
            }
        }
    
    return "<input type='hidden' name='pres' value='0'>"
		. "<input type='checkbox' name='pres' id='pres' value='1'>";
}

function bearer_cap($ba, $config = "") {
	$options = array("SPEECH", "AUDIO_3_1K", "AUDIO_7K", "VIDEO", "DIGITAL_UNRESTRICTED", "DIGITAL_RESTRICTED", "DIGITAL_UNRESTRICTED_TONES");
	if (isset($_GET['gr'])) {
		$query = $ba->select("select config from isdn where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
		while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		}
	}
		if ($config != "") {
			$configs = explode(',', $config);
			foreach ($configs as $value) {
				$key = explode('=', $value, 2);
				if ($key[0] == "bearer_cap")
					$default = $key[1];
			}
		}
	
	$sel = "<select name='bearer_cap' class='form-control input-sm' id='bearer_cap'>";
	foreach ($options as $name) {
		($name == $default) ? $sel.= "<option value='" . $name . "' selected>" . $name . "</option>" : $sel.= "<option value='" . $name . "'>" . $name . "</option>";
	}
	$sel.="</select>";
	return $sel;
}

function get_s2s_nat_opener_options() {
	return array("0" => "off", "1" => "silence", "2" => "dtmf");
}

function s2s_nat_opener($ba, $config = "") {

	$options = get_s2s_nat_opener_options();
	if (isset($_GET['id'])) {
		$ba = new beroAri();
		$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
		while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		}
	}
	if ($config != "") {
		$configs = explode(',', $config);
		foreach ($configs as $value) {
			$key = explode('=', $value, 2);
			if ($key[0] == "s2s_nat_opener") {
				$default = $key[1];
				break;
			}
		}
	}
	$sel = "<select name='s2s_nat_opener' class='form-control input-sm' id='s2s_nat_opener' class='s2s_nat_opener'>";
	foreach ($options as $name => $value) {
		($name == $default) ? $sel.= "<option value='" . $name . "' selected>" . $value . "</option>" : $sel.= "<option value='" . $name . "'>" . $value . "</option>";
	}
	$sel.="</select>";
	return $sel;
}

function get_qvalue_options() {
	return array(	"-1"  => "off", "0.0" => "0.0", "0.1" => "0.1", "0.2" => "0.2", "0.3" => "0.3", "0.4" => "0.4", "0.5" => "0.5",
	 		"0.6" => "0.6", "0.7" => "0.7", "0.8" => "0.8", "0.9" => "0.9", "1.0" => "1.0" );
}

function qvalue($ba, $config = "") {
	$options = get_qvalue_options();
	if (isset($_GET['id'])) {
		$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
		while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		}
	}
	
	if ($config != "") {
		$configs = explode(',', $config);
		foreach ($configs as $value) {
			$key = explode('=', $value, 2);
			if ($key[0] == "qvalue") {
				$default = $key[1];
				break;
			}
		}
	}

	$sel = "<select name='qvalue' class='form-control input-sm' id='qvalue' class='qvalue'>";
	foreach ($options as $name => $value) {
		($name == $default) ? $sel.= "<option value='" . $name . "' selected>" . $value . "</option>" : $sel.= "<option value='" . $name . "'>" . $value . "</option>";
	}
	$sel.="</select>";
	return $sel;
}


function get_s2s_rtp_handling_method_options() {
	return array ("0"  => "Transparent first, then transcoding", "1" => "Transcoding first, then transparent ", "2" => "Transparent only", "3" => "Transcoding only" );
}


function s2s_rtp_handling_method($ba, $config = "") {
	$options = get_s2s_rtp_handling_method_options();
	if (isset($_GET['id'])) {
		$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
		while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		}
	}
	
	if ($config != "") {
		$configs = explode(',', $config);
		foreach ($configs as $value) {
			$key = explode('=', $value, 2);
			if ($key[0] == "s2s_rtp_handling_method") {
				$default = $key[1];
				break;
			}
		}
	}

	$sel = "<select name='s2s_rtp_handling_method' class='form-control input-sm' id='s2s_rtp_handling_method' class='s2s_rtp_handling_method'>";
	foreach ($options as $name => $value) {
		($name == $default) ? $sel.= "<option value='" . $name . "' selected>" . $value . "</option>" : $sel.= "<option value='" . $name . "'>" . $value . "</option>";
	}
	$sel.="</select>";
	return $sel;
}


function gsm_clir($type = "lte", $config = "") {
	$options = array(GSM_CLIR_VALUE_DEFAULT, GSM_CLIR_VALUE_SUPPRESS, GSM_CLIR_VALUE_SHOW);
	
	if (isset($_GET['gr'])) {
		$ba = new beroAri();
		$query = $ba->select("select config from $type where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
		while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		}
	}
		if ($config != "") {
			$configs = explode(',', $config);
			foreach ($configs as $value) {
				$key = explode('=', $value, 2);
				if ($key[0] == "gsm_clir")
					$default = $key[1];
			}
		}
	
	$sel = "<select name='gsm_clir' class='form-control input-sm' id='gsm_clir'>";
	$i=0;
	foreach ($options as $name) {
		($i == $default) ? $sel.= "<option value='" . $i. "' selected>" . $name . "</option>" : $sel.= "<option value='" . $i . "'>" . $name . "</option>";
		$i++;
	}

	$sel.="</select>";
	return $sel;
}

?>


