<?php

if (!defined('_BEROARI_CLASS')) {
	define('_BEROARI_CLASS', true);
	require_once('/usr/local/www/berogui/includes/Helper/Helper.php');
	include_once('/usr/www/include/SQLite2ToSQLite3.php');

	/**
	 * Implementiert die Funktionen für den Umgang mit der Datenbank
	 * @author Florian Kraatz <fk@beronet.com>
	 */
	class beroAri {

		private $db;
		private $err;
		private $fxo_counter;

		function __construct($path = '') {

			$dbfile = (($path != '') ? $path : '/usr/conf/ari.db');

			if (is_file($dbfile) && filesize($dbfile)) {
				$this->db = sqlite_open($dbfile);
			} else {
				$this->db = sqlite_open($dbfile, 0666, $sqlerror);
				$this->create_database();
			}



			if ($this->db == null) {
				$this->err = 'Opening ' . $dbfile . ' failed: ' . sqlite_error_string(sqlite_last_error($this->db));
			} else {
				$res = $this->exec_query("SELECT count(*) FROM sqlite_master WHERE type='table' AND name='key_val' or name='users' or name='sip';");
				if (@sqlite_fetch_single($res) != 3) {
					exec('/bin/rm /usr/conf/ari.db');
					$this->db = sqlite_open($dbfile, 0666, $sqlerror);
					$this->create_database();
				}
			}

			$this->fxo_counter = $this->get_fxo_counter();
		}

		function __destruct() {
			if (is_object($this->db)) {
				sqlite_close($this->db);
			}
		}

		private function _add_module_isdn($name, $lino, $portcount, $clock, $cr_cid_len) {

			$type = (($name == 'E1') ? 'P' : 'B') . 'RI';

			for ($i = 0; $i < $portcount; $i++) {
				$ret[] = 'INSERT INTO isdn (type, lif, config, port_type, clock, crlen, cidlen) ' .
					'VALUES (\'bf' . $portcount . $name . '\',\'' . $lino . '\',\'\',\'' . $type . '\',\'' . $clock[$i] . '\',\'' . $cr_cid_len . '\',\'' . $cr_cid_len . '\');';
			}

			return($ret);
		}

		private function _add_module_tel($type, $lino, $portcount) {

			switch ($type) {
				case 'FXS':
				case 'FXO':
					$table = 'analog';
					$ret[] = 'UPDATE key_val SET value="all" where key="master";';
					break;
				case 'GSM':
					$ret[] = 'UPDATE key_val SET value="all" where key="master";';
					$table = 'gsm';
					break;
				case 'LTE':
					$ret[] = 'UPDATE key_val SET value="all" where key="master";';
					$table = 'lte';
					break;
				default:
					return(array(NULL));
			}

			for ($i = 0; $i < $portcount; $i++) {
				$ret[] = 'INSERT INTO ' . $table . ' (type, lif, config, port_type) ' .
					'VALUES (\'bf' . $portcount . $type . '\',\'' . $lino . '\',\'\',\'' . $type . '\');';
			}

			return($ret);
		}

		private function _add_module_t1($lino, $portcount) {

			for ($i = 0; $i < $portcount; $i++) {
				sqlite_query($this->db, 'INSERT INTO cas (type, lif) VALUES (\'bf' . $portcount . 't1e1\',\'' . $lino . '\');');
				$port = sqlite_last_insert_rowid($this->db);

				$ret[] = 'INSERT INTO isdn (type, lif, port_type,ccs,crlen,cidlen) ' .
					'VALUES (\'bf' . $portcount . 't1e1\',\'' . $lino . '\',\'PRI\',1,2,2);';
			}

			return($ret);
		}

		private function _add_module_s0fxs($lino, $portcount_s0, $portcount_fxs, $clock,$cr_cid_len) {

			for ($i = 0; $i < $portcount_s0; $i++) {
				$ret[] = 'INSERT INTO isdn (type, lif, config, port_type, clock, crlen, cidlen) ' .
					'VALUES (\'bf2S02FXS\',\'' . $lino . '\',\'\',\'BRI\',\'' . $clock[$i] . '\',\'' . $cr_cid_len . '\',\'' . $cr_cid_len . '\');';
			}

			for ($i = 0; $i < $portcount_fxs; $i++) {
				$ret[] = 'INSERT INTO analog (type, lif, config, port_type) ' .
					'VALUES (\'bf2S02FXS\',\'' . $lino . '\',\'\',\'FXS\');';
			}

			return($ret);
		}

		function add_module_db($lino, $clock) {

			$li = array('index' => $lino, 'name' => Helper::getLifName($lino));
			$ret = array();

			switch ($li['name']) {
				case 'bf1S0':
					$ret = array_merge($ret, $this->_add_module_isdn('S0', $li['index'], 1, array($clock), 1));
					break;
				case 'bf2S0':
					$ret = array_merge($ret, $this->_add_module_isdn('S0', $li['index'], 2, array($clock, 0), 1));
					break;
				case 'bf4S0':
					$ret = array_merge($ret, $this->_add_module_isdn('S0', $li['index'], 4, array($clock, 0, 0, 0), 1));
					break;
				case 'bf1E1':
					$ret = array_merge($ret, $this->_add_module_isdn('E1', $li['index'], 1, array($clock), 2));
					break;
				case 'bf2E1':
					$ret = array_merge($ret, $this->_add_module_isdn('E1', $li['index'], 2, array($clock, 0), 2));
					break;
				case 'bf1GSM':
					$ret = array_merge($ret, $this->_add_module_tel('GSM', $li['index'], 1, 1));
					break;
				case 'bf2GSM':
					$ret = array_merge($ret, $this->_add_module_tel('GSM', $li['index'], 2, 1));
					break;
				case 'bf1LTE':
					$ret = array_merge($ret, $this->_add_module_tel('LTE', $li['index'], 1, 1));
					break;
				case 'bf2LTE':
					$ret = array_merge($ret, $this->_add_module_tel('LTE', $li['index'], 2, 1));
					break;
				case 'bf1FXS':
					$ret = array_merge($ret, $this->_add_module_tel('FXS', $li['index'], 1));
					break;
				case 'bf2FXS':
					$ret = array_merge($ret, $this->_add_module_tel('FXS', $li['index'], 2));
					break;
				case 'bf4FXS':
					$ret = array_merge($ret, $this->_add_module_tel('FXS', $li['index'], 4));
					break;
				case 'bf8FXS':
					$ret = array_merge($ret, $this->_add_module_tel('FXS', $li['index'], 8));
					break;
				case 'bf2FXO':
					$ret = array_merge($ret, $this->_add_module_tel('FXO', $li['index'], 2));
					break;
				case 'bf4FXO':
					$ret = array_merge($ret, $this->_add_module_tel('FXO', $li['index'], 4));
					break;
				case 'bf2S02FXS':
					$ret = array_merge($ret, $this->_add_module_s0fxs($li['index'], 2, 2, array($clock, 0), 1));
					break;
				case 'bf1t1e1':
					$ret = array_merge($ret, $this->_add_module_t1($li['index'], 1));
					break;
				case 'bf2t1e1':
					$ret = array_merge($ret, $this->_add_module_t1($li['index'], 2));
					break;
				case 'bf4t1e1':
					$ret = array_merge($ret, $this->_add_module_t1($li['index'], 4));
					break;
			}

			return($ret);
		}

		function get_fxo_counter() {
			$result = @sqlite_query($this->db, "select distinct lif from analog where port_type='FXO'");
			if ($result) {
				return sqlite_num_rows($result);
			} else {
				return 0;
			}
		}

		function get_count_port($lino) {
			$li = Helper::getLifName($lino);

			// special case 2S02FXS
			if ($li == 'bf2S02FXS') {
				return(4);
			}

			// in all other cases we can extract from name
			preg_match('/bf(?<port_count>[0-9]*)/', $li, $matches);
			return($matches['port_count']);
		}

		function add_modules_db() {

			$liCount = Helper::getLifCount();

			for ($i = 0; $i < $liCount; $i++) {
				$queries_li[$i] = $this->add_module_db($i, (($i == 0) ? 1 : 0));
			}

			for ($i = 0; $i < $liCount; $i++) {
				if (!empty($queries_li[$i])) {
					foreach ($queries_li[$i] as $query) {
						sqlite_query($this->db, $query);
					}
					unset($queries_li[$i]);
				}
			}
		}

		function enable_portswitch() {

			$q = sqlite_query($this->db, 'SELECT type, lif FROM isdn union SELECT type, lif FROM analog union SELECT type, lif FROM gsm '
				. 'union SELECT type, lif FROM lte order by lif');

			while ($ent = sqlite_fetch_array($q)) {
				$li[$ent['lif']] = $ent['lif'];
				$type[$ent['lif']] = $ent['type'];
			}
			unset($q);

			$revision = Helper::getRevision();
			$type = Helper::getType();

			if ((in_array($type[0], array('bf4S0', 'bf2S02FXS', 'bf4FXS', 'bf4FXO'))) && !isset($type[1]) && (strpos($revision, '1.8') == FALSE) && ($type < 30)) {
				sqlite_query($this->db, 'SELECT type, lif FROM isdn GROUP BY type, lif ORDER BY lif');
				sqlite_query($this->db, 'INSERT into key_val VALUES(\'portswitch\',1)');
			}
		}

		private function _import_sql($filename) {
			if (!file_exists($filename)) {
				return(false);
			}
			foreach (file($filename) as $line) {
				if (($line[0] == '#') || (strlen($line) <= 1)) {
					continue;
				}
				sqlite_query($this->db, $line);
			}
			return(true);
		}

		function create_database() {
			// import 
			$this->_import_sql('/usr/local/conf/db/database_init_general.sql');

			// sbc-vm
			if ($is_sbc_vm = @file_exists('/etc/beroNet/sbc.conf')) {
				$this->_import_sql('/usr/local/conf/db/database_init_cloudsbc.sql');
			}
			// sbc
			else {
				$this->_import_sql('/usr/local/conf/db/database_init_sbc.sql');
				$this->add_modules_db();
			}

			## Hardware factory reset occured ##
			if (file_exists('/usr/conf/need_red_activate')) {
				foreach (array(22, 80, 443) as $port) {
					$this->insert_("INSERT INTO acl (protocol, dest_port, address, netmask) VALUES ('tcp', '$port', '0.0.0.0', '0')");
				}
			}
			##
			include_once ('/usr/local/php/include/restore.Class.php');
			$restore = new restoreConfig(1, $this);
			$restore->isgwcauses();
			
			if ($is_sbc_vm) {
				## this system leads to exit the __construct method. So we put it at the end
				Helper::system(1, '/bin/bash /usr/local/beroNet/sbin/setup_berogui.sh ari');
			}
			else {
				$this->enable_portswitch();
			}
		}

		private function _generic_query($sql) {
			if (defined('PHP_VERSION_ID')) {
				if (($res = sqlite_query($this->db, $sql)) == false) {
					$this->err = 'query(' . $sql . ') failed: ' . sqlite_error_string(sqlite_last_error($this->db));
					return(false);
				}
			}
			else {
				if (($res = @sqlite_query($this->db, $sql)) == false) {
					$this->err = 'query(' . $sql . ') failed: ' . sqlite_error_string(sqlite_last_error($this->db));
					return(false);
				}
			}

			return($res);
		}

		function update($sql) {
			return($this->_generic_query($sql));
		}

		function delete($sql) {
			return($this->_generic_query($sql));
		}

		function insert_($sql) {
			return($this->_generic_query($sql));
		}

		function select($sql) {
			return($this->_generic_query($sql));
		}

		function exec_query($sql) {
			return($this->_generic_query($sql));
		}

		function set($key, $value = '') {
			$sql = 'UPDATE key_val SET value = \'' . sqlite_escape_string($value) . '\' WHERE key = \'' . $key . '\'';
			if (($ok = sqlite_exec($this->db, $sql)) == false) {
				return false;
			}

			if (sqlite_changes($this->db) == 1) {
				return true;
			}

			$sql = 'INSERT INTO key_val (key, value) VALUES (\'' . $key . '\', \'' . $value . '\')';

			return((sqlite_exec($this->db, $sql) == false) ? false : true);
		}

		function get($key) {
			$sql = 'SELECT value FROM key_val WHERE key = \'' . $key . '\';';
			$res = sqlite_query($this->db, $sql);
			if (($res == false) || (($row = $this->fetch_array($res)) == false)) {
				return false;
			}

			return $row[0];
		}

		function stripslashes_deep($value) {
			if (is_array($value)) {
				return array_map(array($this, 'stripslashes_deep'), $value);
			}
			else if (defined('PHP_VERSION_ID') && preg_match('/\\\\1$/', $value)) {
				return $value;
			}
			return stripslashes($value);
		}

		function htmlentities_deep($value) {
			return(is_array($value) ? array_map(array($this, 'htmlentities_deep'), $value) : htmlentities($value, ENT_NOQUOTES));
		}

		function fetch_array($data, $array_type = null) {
			$entry = is_null($array_type) ? sqlite_fetch_array($data) : sqlite_fetch_array($data, $array_type);
			$entry = $this->stripslashes_deep($entry);
			return($this->htmlentities_deep($entry));
		}

		function rowid() {
			return(sqlite_last_insert_rowid($this->db));
		}

		function column_type($data) {
			return(sqlite_fetch_column_types($data, $this->db));
		}

		function is_error() {
			return($this->err ? true : false);
		}

		function error() {
			return($this->err ? $this->err : 'No error.');
		}

		public function insertTable($table, $id, $data) {
			$sql = "INSERT INTO $table ";
			if (is_null($id)) {
				$sql .= "('". implode("','", array_map('sqlite_escape_string', array_keys($data))) ."') VALUES ('". implode("','", array_map('sqlite_escape_string', $data)) ."');";
			}
			else {
				$sql .= "('id', '". implode("','", array_map('sqlite_escape_string', array_keys($data))) ."') VALUES ('$id', '". implode("','", array_map('sqlite_escape_string', $data)) ."');";
			}
			return ($this->_generic_query($sql));
		}

		public function updateTable($table, $id, $data) {
			// convert data to string
			$last_value = end($data);
			$last_key = key($data);
			unset($data[$last_key]);

			$sql = "";
			foreach ($data as $key => $value) {
				$sql .= "$key='". sqlite_escape_string($value) ."', ";
			}
			$sql .= "$last_key='". sqlite_escape_string($last_value) ."'";

			// set sql string
			$sql = "UPDATE $table SET $sql WHERE id='$id'";

			return $this->_generic_query($sql);
		}

		public function removeExperimentalOptions($what) {
			$exp_options = $this->get('experimental_options');
			$this->set('experimental_options', preg_replace("/$what,?/", '', $exp_options));
		}
	}

} // END DEFINE _BEROARI_CLASS
