<?php
/**
 * Zeigt alle Einträge von der Tabelle acl der Datenbank an
 * 
 * @author Miguel Palmer <mp@beronet.com>
 */
class Acl {

	/**
	 *
	 * @var beroConf Instance root db
	 */
	private 	$bc;

	private		$m_attr,
			$q_attr,
			$start_attr,
			$order_attr,
			$sort_attr;

	private		$post_attr,
			$post_checked = 0;

	private		$isRequestRejected = 0,
			$reasonRejected = array();

	function __construct($m, $get = array(), $post = array(), $session = array()) {
		// load beroConf
		require_once('/usr/fallback/beroConf.php');
		$this->bc = new beroConf('root');

		// assign main GET variable		
		$this->m_attr = $m;

		// check GET variable
		$this->q_attr 		= isset($get['q']) 	? Helper::sanitizeGet($get['q']		, 'q'	 ) : 0;
		$this->start_attr 	= isset($get['start']) 	? Helper::sanitizeGet($get['start']	, 'start') : 0;
		$this->order_attr 	= isset($get['order'])	? Helper::sanitizeGet($get['order']	, 'order') : 0;
		$this->sort_attr 	= isset($get['sort']) 	? Helper::sanitizeGet($get['sort']	, 'sort' ) : 0;

		// get error from modal or submit execution
		$isError = false;
		if (isset($get['error'])) {
			$this->isRequestRejected = 1;
			$this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
			unset($get['error'], $get['request'], $get['checkor'], $get['key']);
		}

		// check POST variable
		if (isset($post['save'])) {
			// clean
			unset($post['m'], $post['save']);

			$list_post = array('allowlan' => 'bool', 'allowberonet' => 'bool');

			$this->post_checked = 1;
			$this->post_attr = Helper::sanitizePost($post, $list_post, $this->post_checked, $this->reasonRejected);

			$this->isRequestRejected = !$this->post_checked;
		}
	}

	function allowLan() {
		$excludelan = $this->bc->get("root", "excludelan");
		($excludelan == 1) ? $checked = "" : $checked = "checked";
		return $checked;
	}

	function allowBeronet () {
		$excludeberonet = $this->bc->get("root", "excludeberonet");
		($excludeberonet == 1) ? $checked = "" : $checked = "checked";
		return $checked;
	}

	private function _save($ba) {
		if ($this->post_attr['allowlan'] == "1") {
			$query = $ba->select('SELECT * FROM acl');
			$record_count = sqlite_num_rows($query);
			
			if ($record_count == "0") {
				print "<script>window.alert('" . ACL_MESSAGE_DISABLE_ALLOWLAN_NO_RULES_DIS . "');</script>";
				return "";
			}
		}

		$this->bc->set("root", "excludelan", $this->post_attr['allowlan']);
		$this->bc->set("root", "excludeberonet", $this->post_attr['allowberonet']);
		return Helper::activate(1, true, $this->m_attr, ACTIVATE);
	}

	/**
	 * Die einträge der ACL Tabelle werden formatiert angezeigt
	 * 
	 * @return string HTML Inhalt
	 */

	function display() {

		include "./includes/functions.php";
		//Das Objekt funktions wird erzeugt um später die Navigationsleiste zu erzeugen.
		$functions = new functions();

		// args (already sanitized into the index.php file)
		$m = $this->m_attr;
		$q = $this->q_attr;
		$start = $this->start_attr;
		$order = $this->order_attr;
		$sort = $this->sort_attr;

		$ba = new beroAri();

		$span = 15;
		$query = $ba->select('SELECT * FROM acl');
		$record_count = sqlite_num_rows($query);
		$test = $record_count / $span;
		$test = (int) $test;
		if ($record_count == 0) {
			$next_add = 0;
		} else {
			$next_add = ($test * $span);
		}

		$start = $start == '' ? 0 : $start;
		$order = $order;
		$sort = $sort;
		$name = "ACL_TITLE_DIS";
		include('./includes/header.php');

		if ($this->post_checked) {
			$ret .= $this->_save($ba);
		} else if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

		$acl_table = $this->dynamic_table($ba);
		ob_start();
		?>
		<script>
			function del(table, option) {
				conf = confirm('<?php echo ACL_DELETE_MESS1_DIS ?>? ');
				if (conf == false) {
					return false;
				} else {
					window.location = './misc/delete.php?m=<?php echo $m ?>&id=' + option + '&table=' + table;
				}
			}
		</script>
		<div class='modal fade bs-example-modal-lg' id='acl-popup' tabindex='-1' role='dialog' aria-labelledby='myModalLabel' aria-hidden='true'>
			<div class='modal-dialog modal-lg'>
				<div class='modal-content'>
					<div class='modal-header'>
						<button type='button' class='close' data-dismiss='modal' aria-label='Close'><span aria-hidden='true'>&times;</span></button>
						<h4 class='modal-title' id='myModalLabel'><?php echo ACL_TITLE_DIS ?></h4>
					</div>
					<div class='modal-body'>
					</div>
				</div>
			</div>
		</div>
		<br>
		<div id='container'>
			<?php echo $acl_table ?>
		</div>
		<br>
		<div class='text-center'>
			<a href='modules/Acl/acl_popup.php?start=<?php echo $next_add ?>' role='button' data-remote='false' data-toggle='modal' data-target='#acl-popup' class='btn btn-default'>
				<?php echo BUTTON_ADD ?>
			</a>
		</div>
		<script type="text/javascript">
			$('#acl-popup').on('show.bs.modal', function (e) {
				var link = $(e.relatedTarget);
				$('.modal-body').load(link.attr('href'));
			});
		</script>
		<?php
		//Erzeugung der Navigationsleiste.
		$query = $ba->select('SELECT * FROM acl');
		$record_count = sqlite_num_rows($query);
		$url_opts = array();
		$url_opts['sort'] = $sort;
		$url_opts['order'] = $order;
		?>
		<div class='text-center'>
			<?php echo $functions->displayNavigationBlock($m, $q, $url_opts, $start, $span, $record_count) ?>
		</div>
		<?php
		if ($this->bc->get('root', 'is-sbc-vm') == 1) {
			return $ret . ob_get_clean();
		}
		?>
		<br>
		<br>
		<form action='' class='allow form-horizontal' method='POST'>
			<input type=hidden name=m value='<?php echo $m ?>'>
			<div class="form-group">
				<label for='allowlan' class='col-sm-7 control-label'><?php echo ($this->bc->get('root', 'is-vpn-running') == 1 ? ACL_ALLOW_LANVPN_DIS : ACL_ALLOW_LAN_DIS); ?></label>
				<div class='col-sm-4 form-checkbox'>
					<input type='hidden' name='allowlan' value='1'>
					<input type='checkbox' name='allowlan' id='allowcheck' value='0' <?php echo $this->allowLan() ?>>
					<div id='warning_allowlan' class="text-danger"></div>
				</div>
			</div>
			
			<div class="form-group">
				<label for='allowberonet' class='col-sm-7 control-label'><?php echo ACL_ALLOW_BERONET_DIS ?></label>
				<div class='col-sm-4 form-checkbox'>
					<input type='hidden' name='allowberonet' value='1'>
					<input type='checkbox' name='allowberonet' id='allowberonet' value='0' <?php echo $this->allowBeronet() ?>>
				</div>
			</div>
			
				<div class="text-center">
					<button type='submit' name='save' class='btn btn-default'><?php echo BUTTON_SAVE ?></button>
				</div>
			<br>
		</form>
		<script type="text/javascript">
			$('#allowcheck').change(function () {
				if ($('#allowcheck').is(':checked') == false)
					$('#warning_allowlan').html('<?php echo ACL_MESSAGE_DIS ?>');
				else
					$('#warning_allowlan').html('');
			});
		</script>
		<?php
		$ret .= ob_get_clean();

		//Rückgabe: Inhalt der HTML-Seite
		return $ret;
	}

	/**
	 * Liefert den HTML Code für die Tabelle
	 * 
	 * @return string HTLM code für die Tabelle
	 */

	function dynamic_table($ba) {
		//ein neues Datenbankobjekt wird erzeugt.
		$bc = $this->bc;
		
		require_once("./includes/lang.php");
		$start = $this->start_attr;

		//Das Header der Tabelle sind die Spaltennamen von acl
		$columns = $ba->column_type('acl');
		$i = 0;

		if ($bc->get('root', 'lan-mode') == 'lan-wan') {
			$columnsToShow = array("protocol", "dest_port", "address", "netmask", "stack", "action");
			$colName = array("protocol" => ACL_PROTOCOL_DIS, "dest_port" => ACL_DEST_PORT_DIS, "address" => ACL_ADDRESS_DIS, "netmask" => ACL_NETMASK_DIS, "stack" => "Stack", "action" => ACL_ACTION_DIS);
		}
		else {
			$columnsToShow = array("protocol", "dest_port", "address", "netmask", "action");
			$colName = array("protocol" => ACL_PROTOCOL_DIS, "dest_port" => ACL_DEST_PORT_DIS, "address" => ACL_ADDRESS_DIS, "netmask" => ACL_NETMASK_DIS, "action" => ACL_ACTION_DIS);
		}
		
		foreach ($columns as $column => $type) {
			if (in_array($column, $columnsToShow))
				$cols .= "<th>" . $colName[$column] . "</th>";
		}

		/* Die Einträge werden von der Tabelle acl gelesen, formatiert und in einer
		  Tabelle geschrieben, zusätzlich werden 2 Knöpfe eingebaut: modify und delete */
		$page = (($start / 15) + 1);
		if (!$start)
			$start = 0;
		$id = 0;
		$ports = array(-1 => "SIP", 
			-2 => "SIP-TLS", 
			80 => "HTTP", 
			443 => "HTTPS", 
			54322 => "Telnet", 
			22 => "SSH", 
			161 => "SNMP", 
			162 => "SNMP-Trap", 
			65001 => "bfdetect", 
			"all" => "All");
		$protocol = array("" => "All", "udp" => "UDP", "tcp" => "TCP");
		$stack = array("" => "ANY", "LAN" => "LAN", "WAN" => "WAN");
		$action = array("" => "ACCEPT", "ACCEPT" => "ACCEPT", "DROP" => "DROP");
		for ($j = 1; $j <= $page; $j++) {
			$query = $ba->select('SELECT * FROM acl ORDER BY action desc,id asc limit 15 offset ' . $start);
			$rows = '';
			while ($entry = $ba->fetch_array($query)) {
				$rows .= "<tr>";
				for ($i = 0; $i < (count($columnsToShow)); $i++) {
					$col_name = $columnsToShow[$i];
					if ($col_name == "dest_port" && (array_key_exists($entry[$col_name], $ports)))
						$entry[$col_name] = $ports[$entry[$col_name]];
					elseif (($col_name == "protocol" && (array_key_exists($entry[$col_name], $protocol))))
						$entry[$col_name] = $protocol[$entry[$col_name]];
					elseif (($col_name == "stack" && (array_key_exists($entry[$col_name], $stack))))
						$entry[$col_name] = $stack[$entry[$col_name]];
					elseif (($col_name == "action" && (array_key_exists($entry[$col_name], $action))))
						$entry[$col_name] = $action[$entry[$col_name]];
						
					$rows .= "<td>" . $entry[$col_name] . "</td>";
				}
				$id = $entry['id'];
				$rows .= "<td class='buttons'>
				<a href='modules/Acl/acl_popup.php?id=" . $id . "' data-remote='false' data-toggle='modal' data-target='#acl-popup' class='popup_download'>
					<img src='./includes/images/modify.png'>
				</a>&nbsp;
				<a class='popup_download' onclick=\"del('acl','" . $id . "');\">
            	    <img src='./includes/images/delete.png'>
				</a>
				</td></tr>";
			}
		}

		$table = "<table class='table table-striped table-bordered' id='table' style='max-width:600px; margin:auto;'>"
			. "<tr>" 
			. $cols 
			. "<th></th>"
			. "</tr>"
			. $rows 
			. "</table>";
		//Rückgabe: Erzeugte Tabelle mit den Einträgen der Tabelle acl der Datenbank
		return $table;
	}

}
?>
