<?php
/**
 * @file
 * Modal form für ISDN Portgruppen
 */
require_once ("/usr/local/www/berogui/includes/Helper/Helper.php");

$load_popup = 1;
$invalid = array();

/* [CHECKING GET VARIABLE] */
$list_get = array(	'gr' 	=> 'group-name'	, 
			'opt'	=> 'opt'	);

$_GET = Helper::sanitizeGet($_GET, $list_get, $load_popup, $invalid);

/* [CHECKING POST] */
unset($_POST);

/* [DISPLAYING POPUP] */
if (!$load_popup) {
	echo "<script>window.location='../../index.php?m=Analog&opt={$_GET['opt']}&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
	exit(1);
}

chdir("../..");

include "./includes/variables.php";
include_once("/usr/www/include/SQLite2ToSQLite3.php");
include "./misc/database.php";
include("./misc/config_parameter.php");
$ba = new beroAri();
require_once ('./includes/lang.php');
require_once "./includes/isgwtelnet.php";
require_once "./includes/Helper/HelperPstn.php";
require_once('/usr/local/www/berogui/includes/session.php');

$group = '"general"';
$query_comp = $ba->select("SELECT * FROM analog");
while ($entry = $ba->fetch_array($query_comp)) {
	if ($entry['gr'] != $_GET['gr'])
		$group .= ',' . '"' . $entry['gr'] . '"';
}

$simple_class = $ba->get('gui_mode') == 'simple' ? 'simple' : '';

// add two boolean to display credentials tones only for FXO in advanced mode
$is_fxo = $_GET['opt'] == "FXO";
$is_advanced = strlen($simple_class) == 0;

$java_validate = '';
if ($is_fxo && $is_advanced) {
	foreach (array('description', 'dial', 'busy', 'ring', 'congestion', 'acp_detect', 'acp_event') as $key) {
		$java_validate .= "\t\t\t'data[$key]': {checkManual:true},\n";
	}
}

?>
<script type="text/javascript">
	$('#checkall').click(function(event) {
		if (this.checked){
			$('.aport').each(function() { 
				this.checked = true;               
			});
		} else {
			$('.aport').each(function() { 
				this.checked = false;               
			});
		}
	});
	var validator = $("#analog").validate({
        	rules: {
            		clip: {
                		required: function (element) {
                    			return "FXO" == "<?php echo $_GET['opt']; ?>";
                		},
				digits: true,
            		},
			cnip: {
				alphanumeric: true,
			},
			dialtone_digits: {
				digits: true,
			},
			ectl: {
				digits: true,
				range: [0, 15]
			},
            		group: {
                		required: true,
                		checkDigChar: true,
                		compareName: [<?php echo $group; ?>]
            		},
			overlap_dial_timeout: {
				digits: true,
			},
			overlap_dial_timeout_empty_dad: {
				digits: true,
			},
            		'ports[]': {
                		atLeastOnePort: true,
            		},
			clir_on_oad: {
				digits: true
			},
			addit_options: {
				checkManual: true
			},
<?php echo $java_validate; ?>
        	},
    	});

    function required() {
        if ("FXO" == "<?php echo $_GET['opt']; ?>") {
            addAsterisk("clip");
        } else {
            deleteAsterisk("clip");
        }
    }

    function overlapdial_show(val) {
        if (val) {
            $(".odt_empty_dad_tr").css("display","none");
            $(".odt_tr").css("display", "none");
        } else {
            $(".odt_empty_dad_tr").css("display","");
            $(".odt_tr").css("display", "");
        }
    }

    $(document).ready(function () {
        $('[data-toggle="tooltip"]').tooltip({placement: 'auto bottom', html: true, trigger: 'hover', container: 'body'});
        required();
        overlapdial_show(document.getElementById('overlap_dialing').checked);
        $('input[name="group"]').focus();
    });
	
	$('#analog-tab a').on('hide.bs.tab', function (e) {
			var valid = true;
			var tab=e.target.getAttribute('href');
			$(tab).find("input").each(function() {
				if (!validator.element(this) && valid) {
					valid = false;
				}
			});
			$(tab).find("select").each(function() {
				if (!validator.element(this) && valid) {
					valid = false;
				}
			});
			if (!valid)
				e.preventDefault();
		});
</script>
<?php

function fxo_call_ending_signal($ba, $gr) {
	if ($gr != "") {
		$query = $ba->select("select fxo_call_ending_signal from analog where gr='" . sqlite_escape_string($gr) . "'");
		while ($entry = $ba->fetch_array($query)) {
			$ret = "<fieldset>";
			$res = explode(",", $entry['fxo_call_ending_signal']);
			if (in_array("unobtainable", $res))
				$ret .= PSTN_UNOBTAINABLE_TONE_DIS . "<input type='checkbox' value='unobtainable' name='fxo_call_ending_signal[]' checked><br>";
			else
				$ret .= PSTN_UNOBTAINABLE_TONE_DIS . "<input type='checkbox' value='unobtainable' name='fxo_call_ending_signal[]'><br>";
			if (in_array("busy", $res))
				$ret .= PSTN_BUSY_TONE_DIS . "<span style='margin-left:42px;'><input type='checkbox' value='busy' name='fxo_call_ending_signal[]' checked></span>";
			else
				$ret .= PSTN_BUSY_TONE_DIS . "<span style='margin-left:42px;'><input type='checkbox' value='busy' name='fxo_call_ending_signal[]'></span>";
			$ret .= "</fieldset>";
		}
		return $ret;
	}else {
		return "<fieldset>" . PSTN_UNOBTAINABLE_TONE_DIS . "<input type='checkbox' value='unobtainable' name='fxo_call_ending_signal[]' checked><br>" . PSTN_BUSY_TONE_DIS .
			"<span style='margin-left:42px;'><input type='checkbox' value='busy' name='fxo_call_ending_signal[]'></span></fieldset>";
	}
}

function buildTones($ba, $group, $options, &$tones_custom = null, $tab = "") {
	$credentials = '';
	return 	"$tab<div class='form-group tones'>\n"
				.	"$tab\t<label for='tones' class='col-sm-3 control-label'>". PSTN_TONES_DIS ."</label>\n"
				. "$tab\t<div class='col-sm-8'>\n"
				. HelperPstn::tones($ba, $group, 'analog', $options, $credentials, $tones_custom)
				. "$tab\t</div>\n"
				. "$tab</div>\n"
				. $credentials;
}

$count_ports = 0;
$config_values = array("from_pstn_src_setting", "analog_display_setting", "analog_oad_setting", "clir_on_oad", "ec", "ectl",);

$tabs = ($is_fxo && $is_advanced ? "<li role='presentation'><a href='#tones' aria-controls='tones' role='tab' data-toggle='tab'>". PSTN_TONES_DIS ."</a></li>\n" : '')
			.	($is_advanced ? "<li role='presentation'><a href='#config-string' aria-controls='config-string' role='tab' data-toggle='tab'>More</a></li>\n" : '');

$tones = array();
$tones_custom = array();
if ($is_fxo && $is_advanced) {
	$tones['fxs'] = '';
	$tones['fxo'] = "\t<div role='tabpanel' class='tab-pane' id='tones' style='padding-top:20px;'>\n"
								. buildTones($ba, $_GET['gr'], array('id' => 'idtones', 'is_fxo' => true), $tones_custom, "\t\t")
								. "\t</div>\n";
	ob_start();
	?>
	<script>
		function showDeleteButton(listCustom) {
			if (listCustom.indexOf($('#idtones').val()) >= 0) {
				$('#id_btndelete').show();
			}
			else {
				$('#id_btndelete').hide();
			}
		}
		$(document).ready(function() {
			$('#idtones').data('oldval', $('#idtones').val());
			showDeleteButton(['<?php echo implode("','", $tones_custom); ?>']);
		});
		$('#idtones').change(function() {
			var tones = this.value;
			var old = $(this).data('oldval');
			$(this).data('oldval', tones);

			var self = this;
			$(this).attr('disabled', true);
			$.ajax({
				cache: false,
				data: {
					action: 'switch',
					oldtones: old,
					tones: tones,
				},
				error: function() {
				},
				success: function(res) {
					var data = JSON.parse(res);
					var disabled = tones.substring(1, 7) != 'custom';
					Object.keys(data).forEach(function(key) {
						$('#'+ key).attr('disabled', disabled);
						$('#'+ key).val(data[key]);
					});
					$(self).attr('disabled', false);
				},
				timeout: 30000,
				type: "post",
				url: "modules/Analog/analog_ajax.php",
			});
		});
		$('#id_btndelete').click(function() {
			if (confirm("<?php echo ANALOG_TONES_DELETE_CUSTOM_BTN; ?>")) {
				var tones = $('#idtones').val();
				$.ajax({
					cache: false,
					data: {
						action: 'delete',
						tones: tones,
					},
					error: function() {
					},
					success: function(res) {
						var data = JSON.parse(res);
						Object.keys(data).forEach(function(key) {
							if (key == 'options') {
								$('#idtones').find('option').remove();
								var options = data[key].split('/');
								options.forEach(function(entry) {
									$('#idtones').append('<option value="['+entry+']">['+entry+']</options>');
								});
								$('#idtones').val('[de]');
							}
							else if (key == 'created') {
								$('#idtones').val('[de]');
								showDeleteButton(data[key].split('/'));
							} 
							else {
								$('#'+ key).attr('disabled', true);
								$('#'+ key).val(data[key]);
							}
						});
						$(self).attr('disabled', false);
						$('#idtones').data('oldval', '[de]');
					},
					timeout: 30000,
					type: "post",
					url: "modules/Analog/analog_ajax.php",
				});
			}
		});
	</script>
	<?php
	$javascript = ob_get_clean();
}
else {
	$tones['fxo'] = '';
	$tones['fxs'] = buildTones($ba, $_GET['gr'], array('is_fxo' => false), $tones_custom, "\t\t");
	$javascript = '';
}

echo $javascript;
?>
<div>
	<!-- Nav tabs -->
	<ul class='nav nav-tabs' role='tablist' id='analog-tab'>
		<li role='presentation' class='active'><a href='#settings' aria-controls='settings' role='tab' data-toggle='tab'>Settings</a></li>
<?php echo $tabs; ?>
	</ul>
	<form name='analog' id='analog' action='modules/Analog/analog_submit.php?opt=<?php echo $_GET['opt']; ?>' method='POST' class='form-horizontal' accept-charset='ISO-8859-1'>
		<!-- you have to make these ones end as well -->
		<div class='tab-content'>
			<div role='tabpanel' class='tab-pane active' id='settings' style='padding-top:15px;'>
				<div class='form-group group' data-toggle='tooltip' title='<?php echo ANALOG_GROUP_NAME; ?>'>
					<label for='group' class='col-sm-3 control-label'><?php echo PSTN_NAME_DIS; ?></label>
					<div class='col-sm-8'>
						<input name='group' id='group' class='form-control input-sm' type='text' value='<?php echo $_GET['gr']; ?>'>
					</div>
				</div>
				<div class='form-group ports[]'>
					<label for='ports[]' class='col-sm-3 control-label'><?php echo PSTN_PORTS_DIS; ?></label>
					<div class='col-sm-8'>
						<div class='left'>
							<div> <?php echo HelperPstn::title($ba, $_GET['gr'], 0); ?></div>
							<div> <?php echo HelperPstn::ports($ba, $_GET['gr'], 0, 'analog', $count_ports); ?></div>
						</div>
						<div class='left' style='margin-left:50px;'>
							<div> <?php echo HelperPstn::title($ba, $_GET['gr'], 1); ?></div>
							<div> <?php echo HelperPstn::ports($ba, $_GET['gr'], 1, 'analog', $count_ports); ?></div>
						</div>
						<?php if (Helper::getType() == 30) { ?>
						<div class='left' style='margin-left:50px;'>
							<div> <?php echo HelperPstn::title($ba, $_GET['gr'], 2); ?></div>
							<div> <?php echo HelperPstn::ports($ba, $_GET['gr'], 2, "analog", $count_ports); ?></div>
						</div>
						<?php } ?>
						<?php if ($count_ports >= 8) { ?>
						<div class='left' style='margin-left:50px;'>
							<div> <b><?php echo DIALPLAN_CHECK_ALL_DIS; ?> </b><input type='checkbox' id='checkall'></div>
						</div>
						<?php } ?>
					</div>
				</div>
				<!--careful with the names, they don't match in Helper -->
				<div class='form-group odt_empty_dad_tr <?php echo $simple_class; ?>'>
					<label for='odt_empty_dad' class='col-sm-3 control-label'><?php echo PSTN_OVERLAPDIAL_TIMEOUT_EMPTY_DAD_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'overlap_dial_timeout_empty_dad', 'analog', '15'); ?></div>
					</div>
				</div>
				<div class='form-group odt_tr <?php echo $simple_class; ?>'>
					<label for='odt_empty' class='col-sm-3 control-label'><?php echo PSTN_ODT_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'overlap_dial_timeout', 'analog', '3'); ?></div>
					</div>
				</div>
				<div class='form-group overlap_dialing <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_OVERLAPDIALING; ?>'>
					<label for='overlap_dialing' class='col-sm-3 control-label'><?php echo PSTN_OVERLAP_DIALING_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::checkbox($ba, $_GET['gr'], 'overlap_dialing', 'analog', "onchange='overlapdial_show(this.checked)'"); ?></div>
					</div>
				</div>
	<?php echo $tones['fxs']; ?>
				<div class='form-group clip' data-toggle='tooltip' title='<?php echo ANALOG_CLIP; ?>'>
					<label for='clip' class='col-sm-3 control-label'><?php echo PSTN_CLIP_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'clip', 'analog'); ?></div>
					</div>
				</div>
				<div class='form-group cnip <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ANALOG_CNIP; ?>'>
					<label for='cnip' class='col-sm-3 control-label'><?php echo PSTN_CNIP_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'cnip', 'analog'); ?></div>
					</div>
				</div>
				<div class='form-group chansel <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo PSTN_CHANSEL; ?>'>
					<label for='chansel' class='col-sm-3 control-label'><?php echo PSTN_CHANSEL_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'chansel', 'analog', array('standard' => 'standard', 'random' => 'random', 'roundrobin' => 'roundrobin')); ?></div>
					</div>
				</div>
				<div class='form-group chansel_dir <?php echo $simple_class; ?>'>
					<label for='chansel_dir' class='col-sm-3 control-label'><?php echo PSTN_CHANSEL_DIR_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'chansel_dir', 'analog', array('ascending' => 'ascending', 'descending' => 'descending')); ?></div>
					</div>
				</div>
				<div class='form-group dialtone_digits <?php echo $simple_class; ?>'>
					<label for='dialtone_digits' class='col-sm-3 control-label'><?php echo PSTN_DIALTONE_DIGITS_DIR_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'dialtone_digits', 'analog', '0'); ?></div>
					</div>
				</div>
				<?php
				if ($is_fxo) {
					?>
					<div class='form-group fxo_connect <?php echo $simple_class; ?>'>
						<label for='fxo_connect' class='col-sm-3 control-label'><?php echo PSTN_CONNECT_DIS; ?></label>
						<div class='col-sm-8'>
							<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'fxo_connect', 'analog', array('instant' => 'instant', 'polarity' => 'polarity')); ?></div>
						</div>
					</div>
					<div class='form-group fxo_wait_for_oad <?php echo $simple_class; ?>'>
						<label for='fxo_wait_for_oad' class='col-sm-3 control-label'><?php echo PSTN_WAIT_FOR_OAD_DIS; ?></label>
						<div class='col-sm-8'>
							<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'fxo_wait_for_oad', 'analog', array('wait' => 'wait', 'dontwait' => 'dontwait')); ?></div>
						</div>
					</div>
					<div class='form-group fxo_dialtone_passthrough <?php echo $simple_class; ?>'>
						<label for='fxo_dialtone_passthrough' class='col-sm-3 control-label'><?php echo PSTN_DIALTONE_PASSTHROUGH_DIS; ?></label>
						<div class='col-sm-8'>
							<div> <?php echo HelperPstn::checkbox($ba, $_GET['gr'], 'fxo_dialtone_passthrough', 'analog'); ?></div>
						</div>
					</div>
					<div class='form-group fxo_call_ending_signal <?php echo $simple_class; ?>'>
						<label for='fxo_call_ending_signal' class='col-sm-3 control-label'><?php echo PSTN_ANALOG_CALL_ENDING_SIGNAL_DIS; ?></label>
						<div class='col-sm-8'>
							<div> <?php echo fxo_call_ending_signal($ba, $_GET['gr']); ?></div>
						</div>
					</div>
					<div class='form-group fxo_cid_detection_mode <?php echo $simple_class; ?>'>
						<label for='fxo_cid_detection_mode' class='col-sm-3 control-label'><?php echo PSTN_ANALOG_CID_DETECTION_MODE_DIS; ?></label>
						<div class='col-sm-8'>
							<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'fxo_cid_detection_mode', 'analog', array('Bellcore' => 'Bellcore', 'ETSI-DTMF' => 'ETSI-DTMF', 'ETSI-DTMF-AR' => 'ETSI-DTMF-AFTER-RINGING')); ?></div>
						</div>
					</div>
					<div class='form-group fxo_verify_ringing<?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo PSTN_VERIFY_RINGING_TOOLTIP; ?>'>
						<label for='fxo_verify_ringing' class='col-sm-3 control-label'><?php echo PSTN_VERIFY_RINGING_LABEL; ?></label>
						<div class='col-sm-8'>
							<div> <?php echo HelperPstn::checkbox($ba, $_GET['gr'], 'fxo_verify_ringing', 'analog'); ?></div>
						</div>
					</div>
					<?php
				}
				?>
				<?php if (!$is_fxo) {
					?>
					<div class='form-group message_waiting_method <?php echo $simple_class; ?>'>
						<label for='message_waiting_method' class='col-sm-3 control-label'><?php echo PSTN_MWI_DIS; ?></label>
						<div class='col-sm-8'>
							<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'message_waiting_method', 'analog', array('stutter' => 'stutter', 'fsk' => 'fsk', 'off' => 'off')); ?></div>
						</div>
					</div>
					<?php
				}
				?>
			</div>
<?php echo $tones['fxo']; ?>
			<div role='tabpanel' class='tab-pane' id='config-string' style='padding-top:20px;'>
				<div class="row ec ec_tail clir_on_oad <?php echo $simple_class; ?>">
					<p class="lead text-center"><?php echo DIALPLAN_CONFIGURATION_DIS; ?></p>
				</div>
				<div class='form-group analog <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo EC; ?>'>
					<label for='analog' class='col-sm-3 control-label'><?php echo DIALPLAN_EC_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo ec($ba, 'analog'); ?>
					</div>
				</div>
				<div class='form-group analog <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo EC_TAIL; ?>'>
					<label for='analog' class='col-sm-3 control-label'><?php echo DIALPLAN_EC_TAIL_LENGTH_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo ec_tail($ba, 'analog'); ?>
					</div>
				</div>
				<div class='form-group analog <?php echo $simple_class; ?>'>
					<label for='analog' class='col-sm-3 control-label'><?php echo DIALPLAN_CLIR_ON_CLIP_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo clir_on_oad($ba, 'analog'); ?>
					</div>
				</div>

				<?php
				if (!$is_fxo) {
					?>
					<div class='form-group analog <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo FROM_PSTN_SRC_SETTING; ?>'>
						<label for='analog' class='col-sm-3 control-label'><?php echo DIALPLAN_FROM_PSTN_SRC_SETTING_DIS; ?></label>
						<div class='col-sm-8'>
							<div> <?php echo from_pstn_src_setting($ba, 'analog'); ?></div>
						</div>
					</div>
					<?php
				}
				?>

				<?php
				if ($is_fxo) {
					?>
				<div class="row analog_oad_setting analog_display_setting <?php echo $simple_class; ?>">
					<p class="lead text-center"><?php echo DIALPLAN_CALLER_ID_MAPPING_DIS; ?></p>
				</div>
				<div class='form-group analog_oad_setting <?php echo $simple_class; ?>'>
					<label for='analog_oad_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_ANALOG_CLIP_SETTING_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo caller_id_mapping_pstn($ba, 'analog_oad_setting', 'analog'); ?>
					</div>
				</div>
				<div class='form-group analog_display_setting <?php echo $simple_class; ?>'>
					<label for='analog_display_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_ANALOG_CNIP_SETTING_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo caller_id_mapping_pstn($ba, 'analog_display_setting', 'analog'); ?>
					</div>
				</div>
					<?php
				}
				?>

				<div class="row failover_proxy failover_timeout <?php echo $simple_class; ?>">
					<p class="lead text-center"><?php echo DIALPLAN_OTHER_DIS; ?></p>
				</div>
				<div class='form-group addit_options <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ADDIT_OPTIONS; ?>'>
					<label for='addit_options' class='col-sm-3 control-label'><?php echo DIALPLAN_ADDITIONAL_CONFIG_DIS; ?></label>
					<div class='col-sm-8'>
						<textarea name='addit_options' id='addit_options' class='form-control' rows='5'></textarea>
					</div>
				</div>
				<div class='form-group addit_options <?php echo $simple_class; ?>'>
					<label for='extra_tooltip' class='col-sm-3 control-label'><?php echo DIALPLAN_ADDITIONAL_CONFIG_DOC_DIS; ?></label>
					<div class='col-sm-8'>
						<p id='extra_tooltip' class='form-control-static' style='height: 170px; overflow: auto; border: 1px solid #A31D26; resize:both;'></p>
					</div>
				</div>
				<div class="clearfix"></div>
			</div>
		<div class='text-center'><i><?php echo REQUIRED_FIELDS; ?></i></div>
</div>
		<?php
		if (isset($_GET['gr'])) {
			HelperPstn::showdefmc($config_values, 'a', 'analog');
		} else {
			HelperPstn::show_confadd($config_values, 'a');
		}
		?>
		<br/>
		<input type='hidden' name='gr_upd' value='<?php echo $_GET['gr']; ?>'>
			   <div class='text-center'>
			<input name='submit' class='btn btn-default' type='submit' value='<?php echo BUTTON_SAVE; ?>' >
		</div>
	</form>
</div>

