<?php
header('Content-Type: text/html; charset=ISO-8859-1');
$berogui = '/usr/local/www/berogui';
include ($berogui.'/includes/Helper/Helper.php');

$exec_ajax = 1;
$invalid = array();

/* [CHECKING GET REQUEST] */
$list_get = array('opt' => 'opt');

$_GET = Helper::sanitizeGet($_GET, $list_get, $exec_ajax, $invalid);

/* [CHECKING SESSION] */
$newTarget = '/app/berogui/index.php?m=Analog&opt='.strtolower($_GET['opt']);
require_once($berogui.'/includes/session.php');
unset($newTarget);

/* [CHECKING POST REQUEST] */
include ($berogui.'/includes/Helper/HelperPstn.php');
include ($berogui.'/misc/config_parameter.php');

unset($_POST['submit']);

$general_post = HelperPstn::getPostParameters('general');
$analog_post = HelperPstn::getPostParameters('analog', get_pstn_post_options('analog'));

$data = array();
$tones_custom = null;
$has_custom_tones = false;
if (preg_match('/^\[(custom[0-9]+)\]$/', $_POST['tones'], $matched)) {
	$has_custom_tones = true;
	$tones_custom = $matched[1];
	$credentials_post = array();
	foreach (HelperPstn::getTonesCredentials() as $key => $param) {
		$credentials_post[$key] = $param['validator'];
	}
	$data = Helper::sanitizePost($_POST['data'], $credentials_post, $exec_ajax, $invalid);
	unset($_POST['data']);
}

$_POST = Helper::sanitizePost($_POST, array_merge($analog_post['post'], $general_post['post']), $exec_ajax, $invalid, array_merge($analog_post['options'], $general_post['options']));

/* [EXECUTING AJAX_REQUEST] */
if (!$exec_ajax) {
	echo "<script>window.location='../../index.php?m=Analog&opt={$_GET['opt']}&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
	exit(1);
}

// Analog-Einträge speichern
chdir("../..");

    include "./includes/variables.php";
    include_once("/usr/www/include/SQLite2ToSQLite3.php");
    include "./misc/database.php";
    require_once "./includes/isgwtelnet.php";
    $ba = new beroAri();

    function parameters($config = "") {
		$default = Helper::getDefaultConfig();
		
        foreach ($_POST as $key => $value) {
            $_POST[$key] = str_replace("'", "\"", $_POST[$key]);
        }
		
		$config_array = array('ec', 'ectl', 'clir_on_oad');
		foreach ($config_array as $option){
			if (isset($_POST[$option]) && $_POST[$option] != $default[$option] ) 
				$config.=',' . $option . '=' . $_POST[$option];
		}
		
        //ANALOG_OAD_SETTING
        if (isset($_POST['analog_oad_setting']) && $_POST['analog_oad_setting'] != 'manual' && $_POST['analog_oad_setting'] != $default['analog_oad_setting'])
            $config.=",analog_oad_setting=" . $_POST['analog_oad_setting'];
        else if (isset($_POST['analog_oad_setting']) && $_POST['analog_oad_setting'] == 'manual')
            $config.=",analog_oad_setting=" . $_POST['analog_oad_setting_manual'];

        //ANALOG_DISPLAY_SETTING
        if (isset($_POST['analog_display_setting']) && $_POST['analog_display_setting'] != 'manual' && $_POST['analog_display_setting'] != $default['analog_display_setting'])
            $config.=",analog_display_setting=" . $_POST['analog_display_setting'];
        else if (isset($_POST['analog_display_setting']) && $_POST['analog_display_setting'] == 'manual')
            $config.=",analog_display_setting=" . $_POST['analog_display_setting_manual'];

        //PSTN_SRC_SETTING
        if (isset($_POST['from_pstn_src_setting_analog']) && $_POST['from_pstn_src_setting_analog'] != $default['from_pstn_src_setting'])
            $config.=",from_pstn_src_setting=" . $_POST['from_pstn_src_setting_analog'];

        //Additional config string hinzufügen.
        if ($_POST['addit_options'] != "")
            $config.="," . str_replace(array("\r\n", "\n", "\r"), ",", $_POST['addit_options']);

        return $config;
    }

    if ($ba->is_error()) {
        die($ba->error());
    }
    if (strtolower($_POST['group']) == "general") {
        echo "<script>alert('Invalid Group Name');  window.history.back();</script>";
        return;
    }
    $query_comp = $ba->select("SELECT gr FROM analog");
    while ($entry = $ba->fetch_array($query_comp)) {
        if ($_POST['gr_upd'] != $entry['gr']) {
            if ($_POST['group'] == $entry['gr']) {
                echo "<script>alert('Invalid Group Name');  window.history.back();</script>";
                return;
            }
        }
    }
    //UPDATE
    if ($_POST['gr_upd'] != "")
        $query_new = $ba->update('UPDATE analog SET gr=\'NULL\', config=\'\' WHERE gr=\'' . sqlite_escape_string ($_POST['gr_upd']) . '\'');
    $gr = $_POST['group'];
    $ports = $_POST['ports'];
    $overlap_dial_timeout_empty_dad = $_POST['overlap_dial_timeout_empty_dad']; 	
    $overlap_dial_timeout = $_POST['overlap_dial_timeout'];		
    if (isset($_POST['overlap_dialing'])) {
        $overlap_dialing = $_POST['overlap_dialing'];
    } else {
        $overlap_dialing = "0";
    }
    $tones = $_POST['tones'];
    $connect = $_POST['fxo_connect'];
    $wait_for_oad = $_POST['fxo_wait_for_oad'];
    $clip = $_POST['clip'];
    $cnip = $_POST['cnip'];
    $chansel = $_POST['chansel'];
    $chansel_dir = $_POST['chansel_dir'];
    $dialtone_digits = $_POST['dialtone_digits'];
    $fxo_verify_ringing = $_POST['fxo_verify_ringing'];

    $message_waiting_method = $_POST['message_waiting_method'];

    $analog_call_ending_signal = $_POST['fxo_call_ending_signal'];
    $fxo_cid_detection_mode = $_POST['fxo_cid_detection_mode'];
    if ($analog_call_ending_signal) {
        foreach ($analog_call_ending_signal as $value) {
            $fxo_call_ending_signal.="," . $value;
        };
    }
    $fxo_call_ending_signal = substr($fxo_call_ending_signal, 1, strlen($fxo_call_ending_signal) - 1);
    if (isset($_POST['fxo_dialtone_passthrough']))
        $dialtone_passthrough = $_POST['fxo_dialtone_passthrough'];
    else
        $dialtone_passthrough = 0;



	$port = "";
	$config = parameters();
	
	for ($i = 0; $i < count($ports); $i++) {
		$port = $ports[$i];

		$query_new = $ba->update('UPDATE analog SET gr=\'' . sqlite_escape_string($gr) . '\', '
				. 'config=\'' . sqlite_escape_string($config) . '\', clip=\'' . sqlite_escape_string($clip) . '\', '
				. 'cnip=\'' . sqlite_escape_string($cnip) . '\', overlap_dial_timeout_empty_dad=\'' . sqlite_escape_string($overlap_dial_timeout_empty_dad) . '\', '
				. 'overlap_dial_timeout=\'' . sqlite_escape_string($overlap_dial_timeout) . '\', '
				. 'tones=\'' . sqlite_escape_string($tones) . '\', fxo_connect=\'' . sqlite_escape_string($connect) . '\', '
				. 'fxo_wait_for_oad=\'' . sqlite_escape_string($wait_for_oad) . '\', fxo_dialtone_passthrough=\'' . sqlite_escape_string($dialtone_passthrough) . '\', '
				. 'fxo_call_ending_signal=\'' . sqlite_escape_string($fxo_call_ending_signal) . '\', '
				. 'fxo_cid_detection_mode=\'' . sqlite_escape_string($fxo_cid_detection_mode) . '\', '
				. 'message_waiting_method=\'' . sqlite_escape_string($message_waiting_method) . '\', '
				. 'overlap_dialing=\'' . sqlite_escape_string($overlap_dialing) . '\', chansel=\'' . sqlite_escape_string($chansel) . '\', '
				. 'chansel_dir=\'' . sqlite_escape_string($chansel_dir) . '\','
				. 'dialtone_digits=\'' . sqlite_escape_string($dialtone_digits) . '\','
				. 'fxo_verify_ringing=\''.sqlite_escape_string ($fxo_verify_ringing).'\' '
				. 'WHERE port=\'' . sqlite_escape_string ($port) . '\'');
	}

	//UPDATE Dialplan after modify
	if (!$ba->is_error() && $_POST['gr_upd'] != "") {
		$query = $ba->update('UPDATE dialplan SET fromId=\'g:' . sqlite_escape_string($gr) . '\' where fromDirection=\'analog\' and fromId=\'g:' . sqlite_escape_string ($_POST['gr_upd']) . '\'');
		$query = $ba->update('UPDATE dialplan SET toId=\'g:' . sqlite_escape_string($gr) . '\' where toDirection=\'analog\' and toId=\'g:' . sqlite_escape_string ($_POST['gr_upd']) . '\'');
	}

// update tones config file
if (!$ba->is_error()) {
	if ($has_custom_tones) {
		$has_entry = false;
		$tones = sqlite_escape_string($tones_custom);
		$query = $ba->select("SELECT * FROM tones_custom WHERE name='$tones'");
		while ($entry = $ba->fetch_array($query)) {
			$has_entry = true;
			break;
		}
		// has custom tones -> update table
		if ($has_entry) {
			$str = "UPDATE tones_custom SET ";
			foreach ($data as $key => $value) {
				$str .= sqlite_escape_string($key) ."='". sqlite_escape_string($value) ."',";
			}
			$str = substr($str, 0, -1) ." WHERE name='$tones'";
			$ba->update($str);
		}
		// has custom tones -> insert table
		else {
			$str = "INSERT INTO tones_custom (name,".implode(',',array_map('sqlite_escape_string', array_keys($data))).") VALUES ('$tones','".implode("','",array_map('sqlite_escape_string',array_values($data)))."')";
			$ba->insert_($str);
		}
	}
}

    Helper::activate(2);
	//Redirection
    if (!$ba->is_error()) {
        echo "<script>window.location='../../index.php?m=Analog&opt=" . strtolower($_GET['opt']) . "'</script>";
    } else {
        echo "<script>alert('" . $ba->error() . "');</script>";
    }

?>
