<?php
/**
 * Erstellen und Herunterladen eines Backups.
 * Konfiguration anhand eines Backups wiederherstellen.
 * 
 * @author Miguel Palmer <mp@beronet.com>
 */
class BackupRestore {

        function __construct($m, $get = array(), $post = array(), $session = array()) {
	}

	/**
	 * Erstellt die Backup and Restore Seite
	 * @return string HTML Inhalt
	 */
	function display() {

		$name = "BACKUP_RESTORE_TITLE_DIS";
		include('./includes/header.php');
		ob_start();
		?>
		<script>
			function checkUploadedFile (fileName) {
				// check if file has a .xml extension
				if (fileName.slice(-4) === '.xml') {
					return confirm('<?php echo BACKUP_RESTORE_CONFIRM_MESSAGE_DIS ?>');
				}
				var baseName = fileName.replace(/.*\//, '');
				baseName = baseName.replace(/.*\\/, '');
				var allowedFiles = ['hardware.conf', 'isgw.analog', 'isgw.cas', 'isgw.causes', 'isgw.conf', 'isgw.cpt', 'isgw.dialplan','isgw.gsm', 'isgw.lte', 'isgw.isdn', 'isgw.sip', 'isgw.tdm', 'misc.conf', 'network.acl'];
				for (i = 0; i < allowedFiles.length; i++) {
					if (baseName == allowedFiles[i]) {
						return confirm('<?php echo BACKUP_RESTORE_CONFIRM_MESSAGE_DIS ?>');
					}
				}
				alert('<?php echo BACKUP_RESTORE_ALERT_MESSAGE_CONFIG_FILE; ?>');
				return false;
			}
		</script>
		<br>
		<div class="panel panel-default" style="max-width:600px; margin:auto;">
			<div class="panel-heading text-center lead">
				<?php echo BACKUP_RESTORE_DOWNLOAD_DIS ?>
			</div>
			<div class="panel-body text-center">
				<form name="download" action="misc/files_download.php" method="GET">
					<button type="submit" class="btn btn-default" data-toggle="tooltip" title="<?php echo BACK_RES_DOWNLOAD ?>" >
						<?php echo BACKUP_RESTORE_DOWNLOAD_LINK_DIS ?>
					</button>
				</form>
			</div>
		</div>
		<br>
		<br>
		<div class="panel panel-default" style="max-width:600px; margin:auto;">
			<div class="panel-heading text-center lead">
				<?php echo BACKUP_RESTORE_RESTORE_DIS ?>
			</div>
			<div class="panel-body text-center">
				<form name="upload"  action="misc/upload.php" method="POST" ENCTYPE="multipart/form-data">
					<div class="row">
						<div class="col-lg-2 col-lg-offset-2">
							<input type="file" id="iduploadfile" name="uploadfile" data-toggle="tooltip" title="<?php echo BACK_RES_FILE ?>" required>
						</div>
					</div>
					<br>
					<div class="row text-center">
						<input type="submit" class="btn btn-default" data-toggle="tooltip" title="<?php echo BACK_RES_UPLOAD ?>" value="<?php echo BUTTON_UPLOAD ?>"
								onclick="var fileName = $('#iduploadfile').val(); if (fileName.length > 0) { return checkUploadedFile(fileName); }">
						&nbsp;&nbsp;
						<input type="reset" class="btn btn-default" value="<?php echo BUTTON_RESET ?>" data-toggle="tooltip" title="<?php echo BACK_RES_RESET ?>">
					</div>
				</form>
			</div>
		</div>
		<?php
		$ret .= ob_get_clean();

		return $ret;
	}

}
?>
