<?php
/**
 * @file
 * Modal form für Wählplanregeln
 */
require_once("/usr/local/www/berogui/includes/Helper/Helper.php");

$load_popup = 1;
$invalid = array();

/* [CHECKING GET REQUEST] */
$list_get = array('id' => 'id', 'isdnid' => 'id', 'copy' => 'id', 'start' => 'start', 'dir' => 'direction', 'search' => 'search');

$options_get = array('dir' => array('sip', 'cas', 'analog', 'gsm', 'lte', 'isdn'));

$_GET = Helper::sanitizeGet($_GET, $list_get, $load_popup, $invalid, $options_get);

/* [CHECKING POST REQUEST] */
unset($_POST);

/* [DISPLAYING POPUP] */
if (!$load_popup) {
	echo "<script>window.location='../../index.php?m=Dialplan&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
        exit(1);
}

chdir("../..");
include './includes/variables.php';
require_once ('./includes/isgwtelnet.php');
include_once("/usr/www/include/SQLite2ToSQLite3.php");
include './misc/database.php';
$ba = new beroAri();
require_once ('./includes/lang.php');
require_once('/usr/local/www/berogui/includes/session.php');

$is_sbc_vm = $ba->get('is_sbc_vm') == 1 ? 1 : 0;

//check mode and make it explicit
$bool_simple_mode = ($ba->get('gui_mode') == 'simple');
if ($bool_simple_mode) {
	$simple_class = 'simple';
} else {
	$advanced_class = 'advanced';
}
?>

<script type="text/javascript" src="misc/script/dialplan_popup.js">
</script>
<script>
// validate signup form on keyup and submit
    $("#dialplan").validate({
        rules: {
	    dest: {
		checkManual: true
	    },
	    newDest: {
		checkManual: true
	    },
	    src: {
		checkManual: true
	    },
	    newSrc: {
		checkManual: true
	    },
            manualsipfrom: {
                required: "#manualsipfrom:visible",
		checkManual: true
            },
            manualisdnfrom: {
                required: "#manualisdnfrom:visible",
		checkManual: true
            },
            manualanalogfrom: {
                required: "#manualanalogfrom:visible",
		checkManual: true
            },
            manualcasfrom: {
                required: "#manualcasfrom:visible",
		checkManual: true
            },
            manualgsmfrom: {
                required: "#manualgsmfrom:visible",
		checkManual: true
            },
            manualltefrom: {
                required: "#manualltefrom:visible",
		checkManual: true
            },
            manualsip: {
                required: "#manualsip:visible",
		checkManual: true
            },
            manualgsm: {
                required: "#manualgsm:visible",
		checkManual: true
            },
            manualisdn: {
                required: "#manualisdn:visible",
		checkManual: true
            },
            manualanalog: {
                required: "#manualanalog:visible",
		checkManual: true
            },
            manualcas: {
                required: "#manualcas:visible",
		checkManual: true
            },
            comment: "specChar"
        }
    });

    $(document).ready(function () {
        required();
        hide_elements("<?php echo DIALPLAN_FROM_ID_DIS; ?>", "<?php echo DIALPLAN_MATCH_TYPE_DIS; ?>");
        $('[data-toggle="tooltip"]').tooltip({placement: 'auto bottom', html: true, trigger: 'hover', container: 'body'});

<?php	if ($bool_simple_mode) { ?>
	$('#dialplan').submit(function () {
		var alertMessSrc = true;
		var alertMessDst = true;
		var regexOnlyDigits = /^\d+$/;

		if (!($('#dialplan').validate({}).form())) {
			return false;
		}

		var saveNewSrc = $('[name="newSrc"]').val();
		var saveNewDst = $('[name="newDest"]').val(); 

		if (saveNewSrc == '' || regexOnlyDigits.test(saveNewSrc)) {
			alertMessSrc = false;
	       		$('[name="newSrc"]').val(saveNewSrc + "\\1");
		}

            	if (saveNewDst == '' || regexOnlyDigits.test(saveNewDst)) {
			alertMessDst = false;
               		$('[name="newDest"]').val(saveNewDst + "\\1");
		}

		if (alertMessSrc || alertMessDst) {
			alert('<?php echo DIALPLAN_CHANGE_TO_ADVANCED_RULES_DIS ?>');
	       		$('[name="newSrc"]').val(saveNewSrc);
               		$('[name="newDest"]').val(saveNewDst);
			return false;
		}

		return true;
        });
<?php 	} ?>
    });
</script>

<?php
function fromSip($ba, $frId, $fromDirection) {
	$query = $ba->select("SELECT name from sip");
	$ret = "<fieldset id='FromSipBox' data-toggle='tooltip' title='" . DIALPLAN_FROM_SIP . "'>";
	$ret .= "<select id='match_type' class='form-control' name='matchType' onchange='hide_elements(\"" . DIALPLAN_FROM_ID_DIS . "\",\"" . DIALPLAN_MATCH_TYPE_DIS . "\");'>";
	if (sqlite_num_rows($query) > 0) {
		(substr_count($frId, "p:") == 1) ? $ret .= "<option value='p:' selected>IP Address</option>" : $ret .= "<option value='p:'>IP Address</option>";
		(substr_count($frId, "d:") == 1) ? $ret .= "<option value='d:' selected>From user</option>" : $ret .= "<option value='d:'>From user</option>";
		;
		(substr_count($frId, "t:") == 1) ? $ret .= "<option value='t:' selected>To user</option>" : $ret .= "<option value='t:'>To user</option>";
		(substr_count($frId, "a:") == 1 || $frId == "") ? $ret .= "<option value='a:' selected>Default SIP account</option>" : $ret .= "<option value='a:'>Default SIP account</option>";
		($frId == ".*") ? $ret .= "<option value='any' selected>Any</option>" : $ret .= "<option value='any'>Any</option>";
		($frId != "" && substr_count($frId, "p:") != 1 && substr_count($frId, "d:") != 1 && substr_count($frId, "t:") != 1 && substr_count($frId, "a:") != 1 && $frId != ".*") ? $ret .= "<option value='manual' selected>Manual Address</option>" : $ret .= "<option value='manual'>Manual Address</option>";
		;
	} else {
		$ret .= "<option value='any'>Any</option>";
		$ret .= "<option value='manual' selected>Manual Address</option>";
	}

	$ret .= "</select><br>";
	$ret .= "<select class='form-control' id='from_sip' name='fromIdSip' onchange='hide_elements(\"" . DIALPLAN_FROM_ID_DIS . "\",\"" . DIALPLAN_MATCH_TYPE_DIS . "\");'>";
	while ($entry = $ba->fetch_array($query)) {
		if (("p:" . $entry['name'] == $frId) || ("d:" . $entry['name'] == $frId) || ("t:" . $entry['name'] == $frId) || ("a:" . $entry['name'] == $frId)) {
			$ret .= "<option value='" . $entry['name'] . "' selected>" . $entry['name'] . "</option>";
		} else {
			$ret .= "<option value='" . $entry['name'] . "'>" . $entry['name'] . "</option>";
		}
	}
	$ret .= "</select>";
//check if manual
	if (substr_count($frId, "p:") == 0 && substr_count($frId, "d:") == 0 && substr_count($frId, "t:") == 0 && substr_count($frId, "a:") == 0 && $fromDirection == 'sip') {
		$ret .= "<input type='text' class='form-control' name='manualsipfrom' id='manualsipfrom' value='" . stripslashes($frId) . "'>";
	} else {
		$ret .= "<input type='text' class='form-control' name='manualsipfrom' id='manualsipfrom'>";
	}
	$ret .= "</fieldset>";
	return $ret;
}

function fromPstn($ba, $frId, $table, $name, $col) {
	global $is_sbc_vm;
	if ($is_sbc_vm) {
		return '';
	}
	$b = false;
	$ret = "<fieldset id='From" . $name . "Box'>";
	$query = $ba->select("SELECT distinct gr from " . $table . " WHERE gr!='NULL'");
	$manual = true;
	$ret .= "<select class='form-control' name='fromId" . $name . "' id='from_" . strtolower($name) . "' onchange='hide_elements(\"" . DIALPLAN_FROM_ID_DIS . "\",\"" . DIALPLAN_MATCH_TYPE_DIS . "\");'>";
	while ($entry = $ba->fetch_array($query)) {
		if ((substr_count($frId, "g:") == 1) && ("g:" . $entry['gr'] == $frId)) {
			$ret .= "<option value='g:" . $entry['gr'] . "' selected>g:" . $entry['gr'] . "</option>";
			$b = true;
			$manual = false;
		}
		if (!$b)
			$ret .= "<option value='g:" . $entry['gr'] . "'>g:" . $entry['gr'] . "</option>";
		$b = false;
	}

	$query = $ba->select("SELECT " . $col . " from " . $table . " WHERE gr!='NULL'");
	while ($entry = $ba->fetch_array($query)) {
		if ((substr_count($frId, "g:") == 0) && ($entry[$col] == $frId)) {
			$ret .= "<option value='" . $entry[$col] . "' selected>" . $entry[$col] . "</option>";
			$b = true;
			$manual = false;
		}
		if (!$b)
			$ret .= "<option value='" . $entry[$col] . "'>" . $entry[$col] . "</option>";
		$b = false;
	}

	if (($frId != "") && ($manual == true))
		$ret .= "<option value='manual' selected>Manual Address</option>";
	else
		$ret .= "<option value='manual'>Manual Address</option>";
	$ret .= "</select><br>";
	if (($frId != "") && ($manual == true))
		$ret .= "<input type='text' class='form-control' name='manual" . strtolower($name) . "from' id='manual" . strtolower($name) . "from' value='" . stripslashes($frId) . "'>";
	else
		$ret .= "<input type='text' class='form-control' name='manual" . strtolower($name) . "from' id='manual" . strtolower($name) . "from'>";

	$ret .= "</fieldset>";
	return $ret;
}

function toPstn($ba, $toId, $table, $name, $col) {
	global $is_sbc_vm;
	if ($is_sbc_vm) {
		return '';
	}
	$manual = true;
	$ret = "<fieldset id='to" . $name . "Box'>";
	$query = $ba->select("SELECT distinct gr from " . $table . " WHERE gr!='NULL'");
	$ret .= "<select class='form-control' name='to" . $name . "' id='to_" . strtolower($name) . "' onchange='hide_elements(\"" . DIALPLAN_FROM_ID_DIS . "\",\"" . DIALPLAN_MATCH_TYPE_DIS . "\");'>";
	while ($entry = $ba->fetch_array($query)) {
		if ((substr_count($toId, "g:") == 1) && ("g:" . $entry['gr'] == $toId)) {
			$ret .= "<option value='g:" . $entry['gr'] . "' selected>g:" . $entry['gr'] . "</option>";
			$manual = false;
		} else {
			$ret .= "<option value='g:" . $entry['gr'] . "'>g:" . $entry['gr'] . "</option>";
		}
	}
	$query = $ba->select("SELECT " . $col . " from " . $table . " WHERE gr!='NULL'");
	while ($entry = $ba->fetch_array($query)) {
		if ((substr_count($toId, "g:") == 0) && ($entry[$col] == $toId)) {
			$ret .= "<option value='" . $entry[$col] . "' selected>" . $entry[$col] . "</option>";
			$manual = false;
		} else {
			$ret .= "<option value='" . $entry[$col] . "'>" . $entry[$col] . "</option>";
		}
	}
	if (($toId != "") && ($manual == true))
		$ret .= "<option value='manual'  selected>Manual Address</option>";
	else
		$ret .= "<option value='manual'>Manual Address</option>";
	$ret .= "</select><br>";
	if (($toId != "") && ($manual == true))
		$ret .= "<input type='text' class='form-control' name='manual" . strtolower($name) . "' id='manual" . strtolower($name) . "' value='" . stripslashes($toId) . "'>";
	else
		$ret .= "<input type='text' class='form-control' name='manual" . strtolower($name) . "' id='manual" . strtolower($name) . "'>";
	$ret .= "</fieldset>";
	return $ret;
}

function toSip($ba, $toId, $toDirection) {
	$ret = "<fieldset id='toSipBox' data-toggle='tooltip' title='" . DIALPLAN_TO_SIP . "'>";
	$query = $ba->select("SELECT name from sip");
	$ret .= "<select id='to_sip' class='form-control' name='toSip' onchange='hide_elements(\"" . DIALPLAN_FROM_ID_DIS . "\",\"" . DIALPLAN_MATCH_TYPE_DIS . "\");'>";
	$manual = true;
	while ($entry = $ba->fetch_array($query)) {
		if ((substr_count($toId, "p:") == 1) && ("p:" . $entry['name'] == $toId)) {
			$manual = false;
			$ret .= "<option value='p:" . $entry['name'] . "' selected>p:" . $entry['name'] . "</option>";
		} else {
			$ret .= "<option value='p:" . $entry['name'] . "'>p:" . $entry['name'] . "</option>";
		}
	}
//check if manual
	if ($manual === true && $toDirection == 'sip') {
		$ret .= "<option value='manual' selected>" . DIALPLAN_MANUAL_ADDRESS_DIS . "</option>";
		$ret .= "</select><br>";
		$ret .= "<input type='text' class='form-control' name='manualsip' id='manualsip' value='" . stripslashes($toId) . "'>";
	} else {
		$ret .= "<option value='manual'>" . DIALPLAN_MANUAL_ADDRESS_DIS . "</option>";
		$ret .= "</select><br>";
		$ret .= "<input type='text' class='form-control' name='manualsip' id='manualsip'>";
	}
	$ret .= "</fieldset>";
	return $ret;
}

function direction($ba, $direction, $technologie) {
	global $is_sbc_vm;
	$query = array(
		'analog'=> 0,
		'isdn'	=> 0,
		'gsm'		=> 0,
		'lte'		=> 0,
		'cas'		=> 0,
	);
	if (!$is_sbc_vm) {
		$query = array(
			'analog'=> $ba->select("SELECT distinct gr from analog WHERE gr!='NULL'"),
			'isdn'	=> $ba->select("SELECT distinct gr from isdn WHERE gr!='NULL'"),
			'gsm'		=> $ba->select("SELECT distinct gr from gsm WHERE gr!='NULL'"),
			'lte'		=> $ba->select("SELECT distinct gr from lte WHERE gr!='NULL'"),
			'cas'		=> $ba->select("SELECT distinct gr from cas_channels WHERE gr!='NULL'"),
		);
	}
	switch ($technologie) {
		case "sip":
			$selected_sip = "selected";
			break;
		case "isdn":
			$selected_isdn = "selected";
			break;
		case "analog":
			$selected_analog = "selected";
			break;
		case "gsm":
			$selected_gsm = "selected";
			break;
		case "lte":
			$selected_lte = "selected";
			break;
		case "cas":
			$selected_cas = "selected";
			break;
		default:
			$selected_sip = "selected";
			break;
	}
	$ret = "<select  id='" . $direction . "Direction' class='form-control' name='" . $direction . "Direction' onchange='hide_elements(\"" . DIALPLAN_FROM_ID_DIS . "\",\"" . DIALPLAN_MATCH_TYPE_DIS . "\");' data-toggle='tooltip' title='" . DIALPLAN_DIRECTION . "'>" .
		"<option value='sip' " . $selected_sip . ">SIP</option>";
	if (sqlite_num_rows($query['isdn']) > 0)
		$ret .= "<option value='isdn' " . $selected_isdn . ">ISDN</option>";
	if (sqlite_num_rows($query['analog']) > 0)
		$ret .= "<option value='analog' " . $selected_analog . ">ANALOG</option>";
	if (sqlite_num_rows($query['gsm']) > 0)
		$ret .= "<option value='gsm' " . $selected_gsm . ">GSM</option>";
	if (sqlite_num_rows($query['lte']) > 0)
		$ret .= "<option value='lte' " . $selected_lte . ">LTE</option>";
	if (sqlite_num_rows($query['cas']) > 0)
		$ret .= "<option value='cas' " . $selected_cas . ">CAS</option>";
	$ret .= "</select>";

	return $ret;
}

function hol_daten($ba) {
	if (isset($_GET['isdnid'])) {

		$q = $ba->select("select * from dialplan where isdnid='" . sqlite_escape_string($_GET['isdnid']) . "'");
		$en = $ba->fetch_array($q);
//$q1 = $ba->select("select toId from dialplan where isdnid='".$_GET['isdnid']."' and direction='sip-isdn'");
//$en1=$ba->fetch_array($q1);

		$e[0]['fromDirection'] = $en['fromDirection'];
		$e[0]['toDirection'] = $en['toDirection'];
		$e[0]['fromId'] = $en['fromId'];
		/* echo "fromId:".$en['fromId']."<br>";
		  echo "toId:".$en1['toId']."<br>"; */

		$e[0]['toId'] = $en['toId'];
		$e[0]['dest'] = $en['dest'];
		$newDest = str_replace($_GET['isdnid'], '', $en['newDest']);
		$e[0]['newDest'] = $newDest;
		$e[0]['src'] = $en['src'];
		$e[0]['newSrc'] = $en['newSrc'];
		$e[0]['config'] = $en['config'];
		$e[0]['comment'] = $en['comment'];
		$e[0]['posid'] = $en['posId'];
		return $e;
	} elseif (isset($_GET['id'])) {
		$q = $ba->select("select * from dialplan where id='" . sqlite_escape_string($_GET['id']) . "'");
		$e = $ba->stripslashes_deep(sqlite_fetch_all($q));
		return $e;
	} elseif (isset($_GET['copy'])) {
		$q = $ba->select("select * from dialplan where id='" . sqlite_escape_string($_GET['copy']) . "'");
		$e = $ba->stripslashes_deep(sqlite_fetch_all($q));
		return $e;
	}
}

$e = hol_daten($ba);
$activChecked = "checked";
if (isset($e[0]['activ']) && $e[0]['activ'] == 0) {
	$activChecked = "";
}

//set allowed destination, source and new options for simple mode
$regex = '^\d*\\\\1$|^\d+[^\\\\]$';
$dest_source_simple_options = array('(.*)' => DIALPLAN_REMOVE_ZERO, '.(.*)' => DIALPLAN_REMOVE_ONE, '..(.*)' => DIALPLAN_REMOVE_TWO, '...(.*)' => DIALPLAN_REMOVE_THREE, '....(.*)' => DIALPLAN_REMOVE_FOUR);
$new_dest_source_simple_options = array('\\1' => '');

$dest = (isset($_GET['id']) || isset($_GET['copy'])) ? $e[0]['dest'] : "(.*)";
$newDest = (isset($_GET['id']) || isset($_GET['copy'])) ? $e[0]['newDest'] : "\\1";
$enable_dest = array_key_exists(trim($dest), $dest_source_simple_options) && preg_match('/'. $regex .'/m', trim($newDest));

$src = (isset($_GET['id']) || isset($_GET['copy'])) ? $e[0]['src'] : "(.*)";
$newSrc = (isset($_GET['id']) || isset($_GET['copy'])) ? $e[0]['newSrc'] : "\\1";
$enable_src = array_key_exists(trim($src), $dest_source_simple_options) && preg_match('/'. $regex .'/m', trim($newSrc));

$disable_fieldset = ($simple_class == 'simple' && (!($enable_dest) || !($enable_src)));
?>
<form name='dialplan' id='dialplan' action='modules/Dialplan/dialplan_submit.php' method='POST' onsubmit='return (is_submit("<?php echo $simple_class; ?>"));' class='form-horizontal'>
	<?php echo ($disable_fieldset ? "<div style='text-align: center; color: red; margin-bottom: 5px;'>". DIALPLAN_CHANGE_TO_ADVANCED_MESSAGE_DIS ."</div>\n" : '') ?>
	<fieldset id='dialplan_fieldset' <?php echo ($disable_fieldset ? 'disabled' : '') ?>>
		<input type=hidden name=start value='<?php echo $page; ?>'/>
		<input type=hidden name=dir value='<?php echo $dir; ?>'/>
		<input type=hidden name=search value='<?php echo $search; ?>'/>
		<div class="form-group">
			<div class='fromDirection'>
				<label for='fromDirection' class='col-sm-3 control-label'><?php echo DIALPLAN_FROM_DIRECTION_DIS; ?></label>
				<div class='col-sm-3'>
					<?php echo direction($ba, 'from', $e[0]['fromDirection']); ?>
				</div>
			</div>
			<div class='toDirection'>
				<label for='toDirection' class='col-sm-3 control-label'><?php echo DIALPLAN_TO_DIRECTION_DIS; ?></label>
				<div class='col-sm-3'>
					<?php echo direction($ba, 'to', $e[0]['toDirection']); ?>
				</div>
			</div>
		</div>
		<div class="form-group">
			<div class='fromId'>
				<label for='fromId' class='col-sm-3 control-label' id='from_txt'>
					<?php echo DIALPLAN_MATCH_TYPE_DIS; ?><br><br><?php echo DIALPLAN_FROM_ID_DIS; ?>
				</label>
				<div class='col-sm-3'>
					<?php
					echo fromSip($ba, $e[0]['fromId'], $e[0]['fromDirection']) . fromPstn($ba, $e[0]['fromId'], 'isdn', 'Isdn', 'port') .
					fromPstn($ba, $e[0]['fromId'], 'analog', 'Analog', 'port') . fromPstn($ba, $e[0]['fromId'], 'gsm', 'Gsm', 'port') .
					fromPstn($ba, $e[0]['fromId'], 'cas_channels', 'Cas', 'channel') . fromPstn($ba, $e[0]['fromId'], 'lte', 'Lte', 'port');
					?>
				</div>
			</div>
			<div class='toId'>
				<label for='toId' class='col-sm-3 control-label'><?php echo DIALPLAN_TO_ID_DIS; ?></label>
				<div class='col-sm-3'>
					<?php
					echo toSip($ba, $e[0]['toId'], $e[0]['toDirection']) . toPstn($ba, $e[0]['toId'], 'isdn', 'Isdn', 'port') .
					toPstn($ba, $e[0]['toId'], 'analog', 'Analog', 'port') . toPstn($ba, $e[0]['toId'], 'gsm', 'Gsm', 'port') .
					toPstn($ba, $e[0]['toId'], 'cas_channels', 'Cas', 'channel') . toPstn($ba, $e[0]['toId'], 'lte', 'Lte', 'port');
					?>
				</div>
			</div>
		</div>
		<div class="form-group">
			<div class='dest <?php echo $simple_class; ?>'>
				<label for='dest' class='col-sm-3 control-label'>
					<?php echo DIALPLAN_DESTINATION_DIS; ?>
				</label>
				<div class='col-sm-3'>
					<input type='text' class='form-control' name='dest' value='<?php echo $dest; ?>' data-toggle='tooltip' title='<?php echo DIALPLAN_DESTINATION; ?>'>
				</div>
			</div>
			<div class='dest  <?php echo $advanced_class; ?>'>
				<label for='dest' class='col-sm-3 control-label'>
					<?php echo DIALPLAN_DESTINATION_REMOVE_DIS; ?>
				</label>
				<div class='col-sm-3'>
					<select class='form-control' name='dest' data-toggle="tooltip" title='<?php echo DIALPLAN_DESTINATION; ?>'>
						<?php foreach ($dest_source_simple_options as $option => $text) { ?>
							<option value="<?php echo $option ?>" <?php echo (trim($dest) == $option) ? 'selected' : ''; ?> ><?php echo $text ?></option>
						<?php } ?>
					</select>
				</div>
			</div>
			<div class='newDest <?php echo $simple_class; ?>'>
				<label for='newDest' class='col-sm-3 control-label'><?php echo DIALPLAN_NEW_DESTINATION_DIS; ?></label>
				<div class='col-sm-3'>
					<input type='text' class='form-control' name='newDest' value='<?php echo $newDest; ?>' data-toggle='tooltip' title='<?php echo DIALPLAN_NEW_DESTINATION; ?>'>
				</div>
			</div>
			<div class='newDest <?php echo $advanced_class; ?>'>
				<label for='newDest' class='col-sm-3 control-label'><?php echo DIALPLAN_PREPEND_NEW_DESTINATION_DIS; ?></label>
				<div class='col-sm-3'>
					<input type='text' class='form-control' name='newDest' value='<?php echo array_key_exists(trim($newDest), $new_dest_source_simple_options) ? '' : (preg_match('/\\d+\\\1/', trim($newDest), $out) == 1 ? str_replace('\1', '', trim($newDest)) : trim($newDest)); ?>' data-toggle='tooltip' title='<?php echo DIALPLAN_NEW_DESTINATION; ?>'>
				</div>
			</div>
		</div>
		<div class="form-group">
			<div class='src  <?php echo $simple_class; ?>'>
				<label for='src' class='col-sm-3 control-label'><?php echo DIALPLAN_SOURCE_DIS; ?></label>
				<div class='col-sm-3'>
					<input type='text' class='form-control' name='src' value='<?php echo $src; ?>' data-toggle='tooltip' title='<?php echo DIALPLAN_SOURCE; ?>'>
				</div>
			</div>
			<div class='src  <?php echo $advanced_class; ?>'>
				<label for='src' class='col-sm-3 control-label'><?php echo DIALPLAN_SOURCE_REMOVE_DIS; ?></label>
				<div class='col-sm-3'>
					<select class='form-control' name='src' data-toggle="tooltip" title='<?php echo DIALPLAN_SOURCE; ?>'>
						<?php foreach ($dest_source_simple_options as $option => $text) { ?>
							<option value="<?php echo $option ?>" <?php echo (trim($src) == $option) ? 'selected' : ''; ?> ><?php echo $text ?></option>
						<?php } ?>
					</select>
				</div>
			</div>
			<div class='newSrc <?php echo $simple_class; ?>'>
				<label for='newSrc' class='col-sm-3 control-label'><?php echo DIALPLAN_NEW_SOURCE_DIS; ?></label>
				<div class='col-sm-3'>
					<input type='text' class='form-control' name='newSrc' value='<?php echo $newSrc; ?>' data-toggle='tooltip' title='<?php echo DIALPLAN_NEW_SOURCE; ?>'>
				</div>
			</div>
			<div class='newSrc <?php echo $advanced_class; ?>'>
				<label for='newSrc' class='col-sm-3 control-label'><?php echo DIALPLAN_PREPEND_NEW_SOURCE_DIS; ?></label>
				<div class='col-sm-3'>
					<input type='text' class='form-control' name='newSrc' value='<?php echo array_key_exists(trim($newSrc), $new_dest_source_simple_options) ? '' : (preg_match('/\\d+\\\1/', trim($newSrc), $out) == 1 ? str_replace('\1', '', trim($newSrc)) : trim($newSrc)); ?>' data-toggle='tooltip' title='<?php echo DIALPLAN_NEW_SOURCE; ?>'>
				</div>
			</div>
		</div>
		<div class="form-group <?php echo $simple_class; ?>">
			<div class='comment'>
				<label for='comment' class='col-sm-3 control-label'><?php echo DIALPLAN_COMMENTS_DIS; ?></label>
				<div class='col-sm-9'>
					<textarea name='comment' class='form-control' id='comment' cols='50' rows='4' wrap='physical' onKeyDown='limitText(this);'
							  onKeyUp='limitText(this);'><?php echo $e[0]['comment'] ?></textarea>
				</div>
			</div>
		</div>
		<div class="form-group <?php echo $simple_class; ?> activation">
			<div class='activ'>
				<label for='activ' class='col-sm-3 control-label'><?php echo DIALPLAN_ACTIV_DIS; ?></label>
				<div class='col-sm-3 form-checkbox'>
					<input type='checkbox' name='activ' value='1' <?php echo $activChecked; ?>>
				</div>
			</div>
		</div>
		<?php if (!isset($_GET['id'])) { ?>
		<div class="form-group">
			<div class='reverse'>
				<label for='reverse' class='col-sm-3 control-label'><?php echo DIALPLAN_REVERSE_RULE_DIS; ?></label>
				<div class='col-sm-3 form-checkbox'>
					<input type='hidden' name='reverse' value='0'>
					<input type='checkbox' name='reverse' value='1'>
				</div>
			</div>
		</div>
		<div class="form-group">
			<div class='first'>
				<label for='first' class='col-sm-3 control-label'><?php echo DIALPLAN_FIRST_POSITION_DIS; ?></label>
				<div class='col-sm-3 form-checkbox'>
					<input type='checkbox' name='first' value='1'>
				</div>
			</div>
		</div>
		<?php } ?>

		<?php if (isset($_GET['id'])) { ?>
		<input name='id_upd' type='hidden' value='<?php echo $_GET['id']; ?>'>
			   <input name='config' type='hidden' value='<?php echo $e[0]['config']; ?>'>
			   <?php } ?>
			   <div class='text-center'><i><?php echo REQUIRED_FIELDS; ?></i></div>

		<?php if (isset($_GET['copy'])) { ?>
		<input name='config' type='hidden' value='<?php echo $e[0]['config']; ?>'>
			   <?php } ?>

			   <?php if ($_GET['isdnid'] != "") { ?>
			   <input name='isdnid' type='hidden' value='<?php echo $_GET['isdnid']; ?>'>
			   <?php } ?>


			   <br>
		<div class='text-center'>
			<input name='submit' id='submitbtn' class='btn btn-default' type='submit' value='<?php echo BUTTON_SAVE; ?>' data-toggle='tooltip' title='<?php echo DIALPLAN_SAVE; ?>'>
		</div>
	</fieldset>
</form>
