<?php
/**
 * @file
 * Modal form für den Config String
 */
require_once('/usr/local/www/berogui/includes/Helper/Helper.php');

$load_more = 1;
$invalid = array();

/* [CHECKING GET REQUEST] */
$list_get = array('from' => 'select', 'to' => 'select', 'dialplanid' => 'id', 'isdnid' => 'id', 'start' => 'int>=0', 'dir' => 'direction', 'search' => 'int>=0'); 

$list_techno = array('sip', 'isdn', 'analog', 'gsm', 'lte', 'cas');
$list_get_options = array('from' => $list_techno, 'to' => $list_techno);

$_GET = Helper::sanitizeGet($_GET, $list_get, $load_more, $invalid, $list_get_options);

$page =$_GET['start'];
$dir = $_GET['dir'];
$search = $_GET['search'];

/* [CHECKING POST REQUEST] */
unset($_POST);

/* [LOADING POPUP] */
if (!$load_more) {
        echo "<script>window.location='../../index.php?m=Dialplan&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
	exit(1);
}

chdir("../..");
include './includes/variables.php';
require_once ('./includes/isgwtelnet.php');
include_once("/usr/www/include/SQLite2ToSQLite3.php");
include './misc/database.php';
$ba = new beroAri();
require_once ('./includes/lang.php');
require_once('/usr/local/www/berogui/includes/session.php');
include './misc/config_parameter.php';

//Config Felder, die nicht in dem Extra Config Feld reinkommen.
$config_values=array("t38", "dtmfmode", "codecs", "ec", "ectl", "dton", "oton", "screen", "pres", "bearer_cap", "cd", "ie_on_sip", "wait_for_cancel", 
	"from_sip_src_setting", "from_sip_dest_setting", "from_pstn_src_setting", "isdn_oad_setting", "isdn_oad2_setting", "isdn_qsigname_setting","isdn_redirected_nr_setting",
	"isdn_dad_setting", "analog_oad_setting","analog_display_setting", "sip_from_user_setting","sip_from_display_setting","s2i_cpt","i2s_cpt",
	"sip_to_user_setting","sip_national_code","sip_international_code", "isdn2sip_destination_numformat", "isdn2sip_source_numformat", "dialplan_international_prefix",
	"sip2dialplan_dad_prefix_setting", "sip2dialplan_oad_prefix_setting","srtp_mode","srtp_crypto_suites","s2s_nat_opener","s2s_rtp_handling_method","use_privacy_header","sip_pai_user_setting","sip_ppi_user_setting","sip_contact_user_setting","gsm_clir");

?>


<script type="text/javascript" src="misc/script/more.js"></script>


<script type="text/javascript">
function showdef(){
	//Configuration für neue Parameter
	var conf=new Object();
	var config;
	<?php
	$e=hol_daten($ba);
	echo "config='".trim($e[0]['config'])."';";
	echo "from='".trim($e[0]['fromDirection'])."';";
	echo "to='".trim($e[0]['toDirection'])."';";
	$conf=showconf($ba, $e);
	if ($conf!=NULL){
		foreach ($conf as $key => $value){
			echo "conf[\"".trim($key)."\"]=new Object();";
			foreach ($conf[$key] as $key1 => $value1){
				echo "conf[\"".trim($key)."\"][\"".trim($key1)."\"]=\"".trim($value1)."\";";
			}
		}
	}
	?>
	showdef_(conf,config,from,to)
;}

var validator = $("#config").validate({
        rules: {
            'srtp_crypto_suites[]': {
                required: {
                    depends: function() {
                        return (($("#srtp_mode").val() === "mandatory" || $("#srtp_mode").val() === "optional") && !$("#srtp_mode").is(":disabled"));
                    }
                }
            },           
                dialplan_international_prefix: {
                        checkPhoneNumber: true,
                },
                from_sip_dest_setting_manual: {
                        checkManual: "#from_sip_dest_setting_manual:visible",
                },
                from_sip_src_setting_manual: {
                        checkManual: "#from_sip_src_setting_manual:visible",
                },
                sip_contact_user_setting_manual: {
                        checkManual: "#sip_contact_user_setting_manual:visible",
                },
                sip_from_user_setting_manual: {
                    checkManual: "#sip_from_user_setting_manual:visible",
                },
                sip_from_display_setting_manual: {
                    checkManual: "#sip_from_display_setting_manual:visible",
                },
                sip_international_code: {
                        checkPhoneNumber: true,
                },
                sip_national_code: {
                        digits: true,
                },
                sip_pai_user_setting_manual: {
                    checkManual: "#sip_pai_user_setting_manual:visible",
                },
                sip_ppi_user_setting_manual: {
                    checkManual: "#sip_ppi_user_setting_manual:visible",
                },
                sip_to_user_setting_manual: {
                        checkManual: "#sip_to_user_setting_manual:visible",
                },
                addit_options: {
                        checkManual: true
                }   
        },
        highlight: function (element) {
            $(element).closest('.form-group').addClass('has-error');
        },
        unhighlight: function (element) {
            $(element).closest('.form-group').removeClass('has-error');
        }
    });
    
$( '#srtp_mode' ).change(function() {
    srtp();
    required();
});
function required() {
        if (($("#srtp_mode").val() === "mandatory" || $("#srtp_mode").val() === "optional") && !$("#srtp_mode").is(":disabled")) {
            addAsterisk("srtp_crypto_suites[]");
        } else {
            deleteAsterisk("srtp_crypto_suites[]");
        }
    }
	
	$( document ).ready(function() {
			hide_elements("<?php echo $_GET['from'] . '-' . $_GET['to']; ?>"); 
			disable(); 
			showdef();
			$('[data-toggle="tooltip"]').tooltip({placement : 'auto bottom', html : true, trigger : 'hover', container: 'body'});
		});
		
	$('#more-tab a').on('hide.bs.tab', function (e) {
			var valid = true;
			var tab=e.target.getAttribute('href');
			$(tab).find("input").each(function() {
				if (!validator.element(this) && valid) {
					valid = false;
				}
			});
			$(tab).find("select").each(function() {
				if (!validator.element(this) && valid) {
					valid = false;
				}
			});
			if (!valid)
				e.preventDefault();
		});
		
	
</script>

<?php
$e=hol_daten($ba);
$config=trim($e[0]['config']);

function pstnConfig($table,$letter,$lines,$e,$fromto,$ba){
	$conf=array();
	foreach ($lines as $line){
			if (stripos($line,'[')===0){
				preg_match("/\[(?<bez>.)\]\[(?<name>.+)\] (?<desc>.+) '(?<def>.*)'/",$line,$res);
				if ($res['bez']==$letter || $res['bez']=="p" || $res['bez'] == "*")
				$conf[$res['name']]=$res['def'];
			}

		}
		if (substr_count($e[0]['fromId'],"g:")==1){
			$query=$ba->select("SELECT config from $table WHERE gr='".substr($e[0][$fromto.'Id'], 2)."'");
			$config=sqlite_fetch_single($query);
			$configs=explode(',',$config);
			foreach ($configs as $value){
				$key=explode('=',$value,2);
				if ($key[0]!="") $conf[$key[0]]=$key[1];
			}
		}else{
			$query=$ba->select("SELECT config from $table WHERE port='".$e[0][$fromto.'Id']."'");
			$config=sqlite_fetch_single($query);
			$configs=explode(',',$config);
			foreach ($configs as $value){
				$key=explode('=',$value,2);
				if ($key[0]!="") $conf[$key[0]]=$key[1];
			}
		}
		return $conf;
}

function sipConfig($lines,$e,$fromto,$ba){
	$conf=array();
	foreach ($lines as $line){
			if (stripos($line,'[')===0){
				preg_match("/\[(?<bez>.)\]\[(?<name>.+)\] (?<desc>.+) '(?<def>.*)'/",$line,$res);
				if ($res['bez']=="s" || $res['bez'] == "*")
				$conf[$res['name']]=$res['def'];
			}

		}
		if (substr_count($e[0]['fromId'],"p:")==1 || substr_count($e[0]['fromId'],"d:")==1 || substr_count($e[0]['fromId'],"t:")==1 || substr_count($e[0]['fromId'],"a:")==1){
			$query=$ba->select("SELECT config from sip WHERE name='".substr($e[0][$fromto.'Id'], 2)."'");
			$config=sqlite_fetch_single($query);
			$configs=explode(',',$config);
			foreach ($configs as $value){
				$key=explode('=',$value,2);
				if ($key[0]!="") $conf[$key[0]]=$key[1];
			}
		}else{
			$query=$ba->select("SELECT config from sip WHERE name='".$e[0][$fromto.'Id']."'");
			$config=sqlite_fetch_single($query);
			$configs=explode(',',$config);
			foreach ($configs as $value){
				$key=explode('=',$value,2);
				if ($key[0]!="") $conf[$key[0]]=$key[1];
			}
		}
		return $conf;
}


function showconf($ba, $e){
	$isgw = new isgwtelnet();
	$result=$isgw->isgw_login();
	//$conf ist die Variable fürs Hash
	$conf=null;
	if ($result!=false){
	$dialplanc=$isgw->isgw_dialplanconfig();
	$lines=  explode("\n",$dialplanc);

	//ISDN Configuration FROM
	switch ($e[0]['fromDirection']){
		case "isdn":
			$conf['from']= pstnConfig('isdn', 'i', $lines, $e,"from",$ba);
			break;
		case "analog":
			$conf['from']= pstnConfig('analog', 'a', $lines, $e,"from",$ba);
			break;
		case "cas":
			$conf['from']= pstnConfig('cas_channels', 'c', $lines,$e,"from",$ba);
			break;
		case "gsm":
			$conf['from']= pstnConfig('gsm', 'g', $lines, $e,"from",$ba);
			break;
		case "lte":
			$conf['from']= pstnConfig('lte', 'l', $lines, $e,"from",$ba);
			break;
		case "sip":
			$conf['from']= sipConfig($lines, $e,"from",$ba);
			break;
	}
	switch ($e[0]['toDirection']){
		case "isdn":
			$conf['to']=  pstnConfig('isdn', 'i', $lines, $e,"to",$ba);
			break;
		case "analog":
			$conf['to']=  pstnConfig('analog', 'a', $lines, $e,"to",$ba);
			break;
		case "cas":
			$conf['to']=  pstnConfig('cas_channels', 'c', $lines, $e,"to",$ba);
			break;
		case "gsm":
			$conf['to']=  pstnConfig('gsm', 'g', $lines, $e,"to",$ba);
			break;
		case "lte":
			$conf['to']=  pstnConfig('lte', 'l', $lines, $e,"to",$ba);
			break;
		case "sip":
			$conf['to']= sipConfig($lines, $e,"to",$ba);
			break;
	}
	
	//Dialplan config
	if ($e[0]['config']!=""){
		$configs=explode(',',$e[0]['config']);
		foreach ($configs as $value){
			$key=explode('=',$value,2);
			if (($key[0]!="")) {
				if (array_key_exists($key[0],$conf['from'])) $conf['from'][$key[0]]=$key[1];
				elseif (array_key_exists($key[0],$conf['to'])) $conf['to'][$key[0]]=$key[1];
				else $conf['from'][$key[0]]=$key[1];
			}
		}
	}
//Wenn ISGW nicht gestartet ist
}else{
	//ISDN Configuration FROM
	switch ($e[0]['fromDirection']){
		case "isdn":
			$conf['from']= pstnConfig('isdn', 'i', array(), $e,"from",$ba);
			break;
		case "analog":
			$conf['from']= pstnConfig('analog', 'a', array(), $e,"from",$ba);
			break;
		case "cas":
			$conf['from']= pstnConfig('cas_channels', 'c', array(), $e,"from",$ba);
			break;
		case "gsm":
			$conf['from']= pstnConfig('gsm', 'g', array(), $e,"from",$ba);
			break;
		case "lte":
			$conf['from']= pstnConfig('lte', 'l', array(), $e,"from",$ba);
			break;
		case "sip":
			$conf['from']= sipConfig(array(), $e,"from",$ba);
			break;
	}
	switch ($e[0]['toDirection']){
		case "isdn":
			$conf['to']=  pstnConfig('isdn', 'i', array(), $e,"to",$ba);
			break;
		case "analog":
			$conf['to']=  pstnConfig('analog', 'a', array(), $e,"to",$ba);
			break;
		case "cas":
			$conf['to']=  pstnConfig('cas_channels', 'c', array(), $e,"to",$ba);
			break;
		case "gsm":
			$conf['to']=  pstnConfig('gsm', 'g', array(), $e,"to",$ba);
			break;
		case "lte":
			$conf['to']=  pstnConfig('lte', 'l', array(), $e,"to",$ba);
			break;
		case "sip":
			$conf['to']= sipConfig(array(), $e,"to",$ba);
			break;
	}

	if ($e[0]['config']!=""){
		$configs=explode(',',$e[0]['config']);
		foreach ($configs as $value){
			$key=explode('=',$value,2);
			if (($key[0]!="")) {
				if (array_key_exists($key[0],$conf['from'])) $conf['from'][$key[0]]=$key[1];
				elseif (array_key_exists($key[0],$conf['to'])) $conf['to'][$key[0]]=$key[1];
				else $conf['from'][$key[0]]=$key[1];
			}
		}
	}
}
return $conf;
}

function showdefmc($ba, $e){
	global $config_values;
	$isgw = new isgwtelnet();
	$result=$isgw->isgw_login();
	if ($result!=false){
		$dialplanc=$isgw->isgw_dialplanconfig();
		$lines=explode("\n",$dialplanc);
		foreach ($lines as $line){
			if (stripos($line,'[')===0){
				preg_match("/\[(?<bez>.+)\]\[(?<name>.+)\][\s]*(?<desc>.+)[\s]*\<(?<val>.*)\>[\s]*'(?<def>.*)'/",$line,$res);
				if (!in_array($res['name'],$config_values)){
					echo "<script>
						$('#extra_tooltip').html($('#extra_tooltip').html()+'<p>".DIALPLAN_OPTION_DIS."<b>&nbsp;".$res['name']."</b><br>".DIALPLAN_VALUES_DIS."<b>&nbsp;&lt;".$res['val']."&gt;</b><br>Default:<b>&nbsp;".$res['def']."</b><br><i>".htmlspecialchars ($res['desc'],ENT_QUOTES)."</i></p><br>');
					</script>";
				}
			}
		}

		$conf=showconf($ba, $e);
		if ($e[0]['config']!=""){
			$configs=explode(',',$e[0]['config']);
				foreach ($configs as $value){
				$key=explode('=',$value,2);
				if (($key[0]!="") && !in_array($key[0],$config_values)){
					echo "<script>
						if ($('#addit_options').html()=='')
							$('#addit_options').html('".trim($key[0])."=".trim($key[1])."');
						else
							$('#addit_options').html($('#addit_options').html()+'\\n".trim($key[0])."=".trim($key[1])."');</script>";
				}elseif (($key[0]!="") && ($key[1]=='') && !in_array($key[0],$config_values)){
					echo "<script>
						if ($('#addit_options').html()=='')
							$('#addit_options').html('".trim($key[0])."=');
						else
							$('#addit_options').html($('#addit_options').html()+'\\n".trim($key[0])."=');</script>";
				}
			}
		}
	}
}



function hol_daten($ba){
	if  (isset($_GET['dialplanid'])){
		$q=$ba->select("select * from dialplan where id='".sqlite_escape_string($_GET['dialplanid'])."'");
		$e=sqlite_fetch_all($q);
		return $e;

	}
}
?>
<!-- Tab buttons ISDN, SIP, ANALOG, ADITIONAL CONFIG -->
<ul class='nav nav-tabs' role='tablist' id='more-tab'>	    
	<?php if ($e[0]['toDirection'] == "sip" || $e[0]['fromDirection'] == "sip" || ($e[0]['toDirection'] == "isdn" && $e[0]['fromDirection'] == "isdn")) { ?>
		<li role='presentation'><a href='#config_sip' aria-controls='SIP config string' role='tab' data-toggle='tab'>SIP</a></li>
	<?php
	}
	if ($e[0]['toDirection'] == "isdn" || $e[0]['fromDirection'] == "isdn") {
		?>
		<li role='presentation'><a href='#config_isdn' aria-controls='ISDN config string' role='tab' data-toggle='tab'>ISDN</a></li>
	<?php
	}
	if ($e[0]['toDirection'] == "analog" || $e[0]['fromDirection'] == "analog") {
		?>
		<li role='presentation'><a href='#config_analog' aria-controls='Analog config string' role='tab' data-toggle='tab'>Analog</a></li>
	<?php
	}
	if ($e[0]['toDirection'] == "gsm" || $e[0]['fromDirection'] == "gsm") {
		?>
		<li role='presentation'><a href='#config_gsm' aria-controls='GSM config string' role='tab' data-toggle='tab'>GSM</a></li>
	<?php
		}
	if ($e[0]['toDirection'] == "lte" || $e[0]['fromDirection'] == "lte") {
		?>
		<li role='presentation'><a href='#config_gsm' aria-controls='GSM config string' role='tab' data-toggle='tab'>LTE</a></li>
	<?php
	}
	if ($e[0]['toDirection'] == "analog") {
		if ((substr_count($e[0]['toId'], "g:") == 1)) {
			$q = $ba->select("select distinct port_type from analog where gr='" . substr($e[0]['toId'], 2) . "'");
			$portTypeTo = sqlite_fetch_single($q);
		} else {
			$q = $ba->select("select port_type from analog where port='" . $e[0]['toId'] . "'");
			$portTypeTo = sqlite_fetch_single($q);
		}
	}
	if ($e[0]['fromDirection'] == "analog") {
		if ((substr_count($e[0]['fromId'], "g:") == 1)) {
			$q = $ba->select("select distinct port_type from analog where gr='" . substr($e[0]['fromId'], 2) . "'");
			$portTypeFrom = sqlite_fetch_single($q);
		} else {
			$q = $ba->select("select port_type from analog where port='" . $e[0]['fromId'] . "'");
			$portTypeFrom = sqlite_fetch_single($q);
		}
	}


//Wenn eine Richtung der Direction FXS ist, wird das Dialplan Source Setting nicht angezeigt
	($portTypeFrom != "FXS" && $portTypeTo != "FXS") ? $showDialSrc = "" : $showDialSrc = "style='display:none'";

//Wenn eine Richtung der Direction FXO ist, wird das Caller ID Mapping nicht angezeigt
	($portTypeFrom != "FXO" && $portTypeTo != "FXO") ? $showCallerMapp = "" : $showCallerMapp = "style='display:none'";
	?>
	<li role='presentation' class='active'><a href='#config-string' aria-controls='config-string' role='tab' data-toggle='tab'>More</a></li>
</ul>

<div>
	<form action='modules/Dialplan/more_submit.php' id='config' method='POST' class='form-horizontal'>
		<div class='tab-content'>
			<div role='tabpanel' class='tab-pane active' id='config-string' style='padding-top:20px;'>
				<div class="row addit_options addit_options">
					<p class="lead text-center"><?php echo DIALPLAN_CONFIGURATION_DIS; ?></p>
				</div>
				<div class='form-group addit_options'  data-toggle='tooltip' title='<?php echo ADDIT_OPTIONS; ?>'>
					<label for='addit_options' class='col-sm-3 control-label'><?php echo DIALPLAN_ADDITIONAL_CONFIG_DIS; ?></label>
					<div class='col-sm-8'>
						<textarea name='addit_options' id='addit_options' class='form-control' rows='5'></textarea>
					</div>
				</div>
				<div class='form-group addit_options'>
					<label for='extra_tooltip' class='col-sm-3 control-label'><?php echo DIALPLAN_ADDITIONAL_CONFIG_DOC_DIS; ?></label>
					<div class='col-sm-8'>
						<p id='extra_tooltip' class='form-control-static' style='height: 170px; overflow: auto; border: 1px solid #A31D26; resize:both;'></p>
					</div>
				</div>
				<div class="clearfix"></div>
			</div>
			<?php if ($e[0]['toDirection'] == "analog" || $e[0]['fromDirection'] == "analog") { ?>
				<div role='tabpanel' class='tab-pane' id='config_analog' style='padding-top:20px;'>
					<p class="lead text-center"><?php echo DIALPLAN_CONFIGURATION_DIS; ?></p>
					<div class="row">
						<div class="col-lg-offset-10 col-lg-2 "><strong><?php echo DIALPLAN_DEFAULT_DIS; ?></strong></div>
					</div>
					<?php if ($e[0]['fromDirection'] != "isdn" && $e[0]['toDirection'] != "isdn") { ?>
						<div class='form-group ec' data-toggle='tooltip' title='<?php echo EC; ?>'>
							<label for='ec' class='col-sm-3 control-label'><?php echo DIALPLAN_EC_DIS; ?></label>
							<div class='col-sm-7 form-checkbox'>
								<?php echo ec($ba, 'analog', $config); ?>
							</div>
							<div class='col-sm-1 form-checkbox'>
								<input type='checkbox' value='1' name='def_ec' id='def_ec' checked 
									   onclick='if (def_ec.checked) $("#ec").prop("disabled", true); else $("#ec").prop("disabled", false);'>
							</div>
						</div>
						<div class='form-group analog' data-toggle='tooltip' title='<?php echo EC_TAIL; ?>'>
							<label for='ec_tail' class='col-sm-3 control-label'><?php echo DIALPLAN_EC_TAIL_LENGTH_DIS; ?></label>
							<div class='col-sm-7'>
								<?php echo ec_tail($ba, 'analog', $config); ?>
							</div>
							<div class='col-sm-1'>
								<input type='checkbox form-checkbox' value='1' name='def_ectl' id='def_ectl' checked  
									   onclick='if (def_ectl.checked) ectl.disabled = true; else ectl.disabled = false;'>
							</div>
						</div>
					<?php } ?>

					<div class='form-group analog' data-toggle='tooltip' title='<?php echo FROM_PSTN_SRC_SETTING; ?>' <?php echo $showDialSrc; ?>>
						<label for='analog' class='col-sm-3 control-label'><?php echo DIALPLAN_FROM_PSTN_SRC_SETTING_DIS; ?></label>
						<div class='col-sm-7'>
							<?php echo from_pstn_src_setting($ba, 'analog', $e[0]['fromDirection'], $e[0]['toDirection'], $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_from_pstn_src_setting_analog' id='def_from_pstn_src_setting_analog' checked 
								   onclick='if (def_from_pstn_src_setting_analog.checked) from_pstn_src_setting_analog.disabled = true; 
									   else from_pstn_src_setting_analog.disabled = false;'>

						</div>
					</div>
					<div class="row analog_oad_setting analog_display_setting" <?php echo $showCallerMapp; ?>>
						<p class="lead text-center"><?php echo DIALPLAN_CALLER_ID_MAPPING_DIS; ?></p>
					</div>
					<div class='form-group analog_oad_setting' <?php echo $showCallerMapp; ?>>
						<label for='analog_oad_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_ANALOG_CLIP_SETTING_DIS; ?></label>
						<div class='col-sm-7'>
							<?php echo caller_id_mapping_pstn($ba, 'analog_oad_setting', 'analog', $e[0]['fromDirection'], $e[0]['toDirection'], $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_analog_oad_setting' id='def_analog_oad_setting' checked 
								   onclick='if (def_analog_oad_setting.checked) analog_oad_setting.disabled = true; else analog_oad_setting.disabled = false;'>

						</div>
					</div>
					<div class='form-group analog_display_setting' <?php echo $showCallerMapp; ?>>
						<label for='analog_display_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_ANALOG_CNIP_SETTING_DIS; ?></label>
						<div class='col-sm-7'>
							<?php echo caller_id_mapping_pstn($ba, 'analog_display_setting', 'analog', '', '', $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_analog_display_setting' id='def_analog_display_setting' checked 
								   onclick='if (def_analog_display_setting.checked) analog_display_setting.disabled = true; 
									   else analog_display_setting.disabled = false;'>

						</div>
					</div>
				</div>
			<?php } ?>
			
			<?php if ($e[0]['toDirection'] == "gsm" || $e[0]['fromDirection'] == "gsm" || $e[0]['toDirection'] == "lte" || $e[0]['fromDirection'] == "lte") { ?>
				<div role='tabpanel' class='tab-pane' id='config_gsm' style='padding-top:20px;'>
					<p class="lead text-center"><?php echo DIALPLAN_CONFIGURATION_DIS; ?></p>
					<div class="row">
						<div class="col-lg-offset-10 col-lg-2 "><strong><?php echo DIALPLAN_DEFAULT_DIS; ?></strong></div>
					</div>
					
					<div class='form-group gsm_clir' data-toggle='tooltip' title='<?php echo GSM_CLIR_TOOLTIP; ?>'>
						<label for='gsm_clir' class='col-sm-3 control-label'><?php if ($e[0]['toDirection'] == "lte" || $e[0]['fromDirection'] == "lte") { echo LTE_CLIR_LABEL; } else { echo GSM_CLIR_LABEL; } ?></label>
						<div class='col-sm-7'>
							<?php ($e[0]['toDirection'] == "gsm" || $e[0]['fromDirection'] == "gsm" ) ? $type = "gsm"  : $type = "lte"; echo gsm_clir($type, $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_gsm_clir' id='def_gsm_clir' checked 
								   onclick='if (def_gsm_clir.checked) gsm_clir.disabled = true; else gsm_clir.disabled = false;'>
						</div>
					</div>
	
				</div>
		<?php } ?>
			
			<?php if ($e[0]['toDirection'] == "isdn" || $e[0]['fromDirection'] == "isdn") { ?>
				<div role='tabpanel' class='tab-pane' id='config_isdn' style='padding-top:20px;'>
					<p class="lead text-center"><?php echo DIALPLAN_CONFIGURATION_DIS; ?></p>
					<div class="row">
						<div class="col-lg-offset-10 col-lg-2 "><strong><?php echo DIALPLAN_DEFAULT_DIS; ?></strong></div>
					</div>
					<div class='form-group isdn' data-toggle='tooltip' title='<?php echo EC; ?>'>
						<!-- is name ec or analog? and afterwards, idem -->
						<label for='ec' class='col-sm-3 control-label'><?php echo DIALPLAN_EC_DIS; ?></label>
						<div class='col-sm-7 form-checkbox'>
							<?php echo ec($ba, 'isdn', $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_ec' id='def_ec' checked 
								   onclick='if (def_ec.checked) $("#ec").prop("disabled", true); else $("#ec").prop("disabled", false);'>
						</div>
					</div>
					<div class='form-group isdn' data-toggle='tooltip' title='<?php echo EC_TAIL; ?>'>
						<label for='ec_tail' class='col-sm-3 control-label'><?php echo DIALPLAN_EC_TAIL_LENGTH_DIS; ?></label>
						<div class='col-sm-7'>
							<?php echo ec_tail($ba, 'isdn', $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_ectl' id='def_ectl' checked  
								   onclick='if (def_ectl.checked) ectl.disabled = true; else ectl.disabled = false;'/>
						</div>
					</div>
					<div class='form-group dton' data-toggle='tooltip' title='<?php echo DTON; ?>'>
						<label for='dton' class='col-sm-3 control-label'><?php echo DIALPLAN_DTON_DIS; ?></label>
						<div class='col-sm-7'>
							<?php echo tons($ba, 'dton', $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_dton' id='def_dton' checked  
								   onclick='if (def_dton.checked) dton.disabled = true; else dton.disabled = false;'>
						</div>
					</div>
					<div class='form-group oton' data-toggle='tooltip' title='<?php echo OTON; ?>'>
						<label for='oton' class='col-sm-3 control-label'><?php echo DIALPLAN_OTON_DIS; ?></label>
						<div class='col-sm-7'>
							<?php echo tons($ba, 'oton', $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_oton' id='def_oton' checked  
								   onclick='if (def_oton.checked) oton.disabled = true; else oton.disabled = false;'>
						</div>
					</div>
					<div class='form-group screen' data-toggle='tooltip' title='<?php echo SCREENING; ?>'>
						<label for='screen' class='col-sm-3 control-label'><?php echo DIALPLAN_SCREENING_DIS; ?></label>
						<div class='col-sm-7 form-checkbox'>
							<?php echo screen($ba, $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_screen' id='def_screen' checked 
								   onclick='if (def_screen.checked) $("#screen").prop("disabled", true); else $("#screen").prop("disabled", false);'>
						</div>
					</div>
					<div class='form-group pres' data-toggle='tooltip' title='<?php echo PRES; ?>'>
						<label for='pres' class='col-sm-3 control-label'><?php echo DIALPLAN_PRESENTATION_DIS; ?></label>
						<div class='col-sm-7 form-checkbox'>
							<?php echo pres($ba, $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_pres' id='def_pres' checked 
								   onchange='if (def_pres.checked) $("#pres").prop("disabled", true); else $("#pres").prop("disabled", false);'/>

						</div>
					</div>
					<div class='form-group bearer_cap' data-toggle='tooltip' title='<?php echo BEARER; ?>'>
						<label for='bearer_cap' class='col-sm-3 control-label'><?php echo DIALPLAN_BEARER_DIS; ?></label>
						<div class='col-sm-7'>
							<?php echo bearer_cap($ba, $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_bearer_cap' id='def_bearer_cap' checked 
								   onclick='if (def_bearer_cap.checked) bearer_cap.disabled = true; else bearer_cap.disabled = false;'>
						</div>
					</div>
					<div class='form-group cd' data-toggle='tooltip' title='<?php echo CD; ?>'>
						<label for='cd' class='col-sm-3 control-label'><?php echo DIALPLAN_CALL_DEFLECTION_DIS; ?></label>
						<div class='col-sm-7 form-checkbox'>
							<?php echo cd($ba, $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_cd' id='def_cd' checked 
								   onclick='if (def_cd.checked) $("#cd").prop("disabled", true); else $("#cd").prop("disabled", false);'>
						</div>
					</div>
					<div class='form-group from_pstn_src_setting' data-toggle='tooltip' title='<?php echo FROM_PSTN_SRC_SETTING; ?>'>
						<label for='from_pstn_src_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_FROM_PSTN_SRC_SETTING_DIS; ?></label>
						<div class='col-sm-7'>
							<?php echo from_pstn_src_setting($ba, 'isdn', $e[0]['fromDirection'], $e[0]['toDirection'], $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_from_pstn_src_setting_isdn' id='def_from_pstn_src_setting_isdn' checked 
								   onclick='if (def_from_pstn_src_setting_isdn.checked) from_pstn_src_setting_isdn.disabled = true;
									   else from_pstn_src_setting_isdn.disabled = false;'>
						</div>
					</div>

					<div class="row isdn_oad_setting isdn_oad2_setting isdn_qsigname_setting isdn_redirected_nr_setting">
						<p class="lead text-center"><?php echo DIALPLAN_CALLER_ID_MAPPING_DIS; ?></p>
					</div>
					<div class='form-group isdn_oad_setting' data-toggle='tooltip' title='<?php echo ISDN_OAD_SETTING; ?>'>
						<label for='isdn_oad_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_ISDN_OAD_SETTING_DIS; ?></label>
						<div class='col-sm-7'>
							<?php echo caller_id_mapping_pstn($ba, 'isdn_oad_setting', 'isdn', $e[0]['fromDirection'], $e[0]['toDirection'], $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_isdn_oad_setting' id='def_isdn_oad_setting' checked 
								   onclick='if (def_isdn_oad_setting.checked) isdn_oad_setting.disabled = true; 
									   else isdn_oad_setting.disabled = false;'>
						</div>
					</div>
					<div class='form-group isdn_oad2_setting' data-toggle='tooltip' title='<?php echo ISDN_OAD2_SETTING; ?>'>
						<label for='isdn_oad2_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_ISDN_OAD2_SETTING_DIS; ?></label>
						<div class='col-sm-7'>
							<?php echo caller_id_mapping_pstn($ba, 'isdn_oad2_setting', 'isdn', '', '', $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_isdn_oad2_setting' id='def_isdn_oad2_setting' checked 
								   onclick='if (def_isdn_oad2_setting.checked) isdn_oad2_setting.disabled = true; 
									   else isdn_oad2_setting.disabled = false;'/>
						</div>
					</div>
					<div class='form-group isdn_qsigname_setting' data-toggle='tooltip' title='<?php echo ISDN_QSIGNAME_SETTING; ?>'>
						<label for='isdn_qsigname_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_ISDN_QSIGNAME_SETTING_DIS; ?></label>
						<div class='col-sm-7'>
							<?php echo caller_id_mapping_pstn($ba, 'isdn_qsigname_setting', 'isdn', '', '', $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_isdn_qsigname_setting' id='def_isdn_qsigname_setting' checked 
								   onclick='if (def_isdn_qsigname_setting.checked) isdn_qsigname_setting.disabled = true; 
									   else isdn_qsigname_setting.disabled = false;'/>
						</div>
					</div>
					<div class='form-group isdn_redirected_nr_setting' data-toggle='tooltip' 
						 title='<?php echo ISDN_REDIRECTED_NR_SETTING; ?>'>
						<label for='isdn_redirected_nr_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_ISDN_REDIRECTED_NR_SETTING_DIS; ?></label>
						<div class='col-sm-7'>
							<?php echo caller_id_mapping_pstn($ba, 'isdn_redirected_nr_setting', 'isdn', '', '', $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_isdn_redirected_nr_setting' id='def_isdn_redirected_nr_setting' 
								   checked onclick='if (def_isdn_redirected_nr_setting.checked) isdn_redirected_nr_setting.disabled = true; 
									   else isdn_redirected_nr_setting.disabled = false;'/>
						</div>
					</div>
					<div class='form-group isdn_dad_setting' data-toggle='tooltip' title='<?php echo ISDN_DAD_SETTING; ?>'>
						<label for='isdn_dad_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_ISDN_DAD_SETTING_DIS; ?></label>
						<div class='col-sm-7'>
							<?php echo callee_id_mapping_pstn($ba, 'isdn_dad_setting', 'isdn', $config); ?>
						</div>
						<div class='col-sm-1 form-checkbox'>
							<input type='checkbox' value='1' name='def_isdn_dad_setting' id='def_isdn_dad_setting' checked
								   onclick='if (def_isdn_dad_setting.checked) isdn_dad_setting.disabled = true;
									   else isdn_dad_setting.disabled = false;'>
						</div>
					</div>
				</div>
		<?php } ?>
			
		<?php if ($e[0]['toDirection'] == "sip" || $e[0]['fromDirection'] == "sip" || ($e[0]['toDirection'] == "isdn" && $e[0]['fromDirection'] == "isdn")) { ?>
			<div role='tabpanel' class='tab-pane' id='config_sip' style='padding-top:20px;'>
				<div class="row">
					<div class="col-lg-offset-10 col-lg-2 "><strong><?php echo DIALPLAN_DEFAULT_DIS; ?></strong></div>
				</div>
				<div class="row t38 dtmfmode srtp_mode codecs">
					<p class="lead text-center"><?php echo DIALPLAN_MEDIA_OPTIONS_DIS; ?></p>
				</div>
				<div class='form-group t38' data-toggle='tooltip' title='<?php echo T38; ?>'>
					<label for='t38' class='col-sm-3 control-label'><?php echo DIALPLAN_T38_SUPPORT_DIS; ?></label>
					<div class='col-sm-7 form-checkbox'>
					<?php echo t38($ba, $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_t38' id='def_t38' checked 
							   onclick='if (def_t38.checked) $("#t38").prop("disabled", true); else $("#t38").prop("disabled", false);'>
					</div>
				</div>
				<div class='form-group dtmfmode' data-toggle='tooltip' title='<?php echo DTMFMODE; ?>'>
					<label for='dtmfmode' class='col-sm-3 control-label'><?php echo DIALPLAN_DTMF_MODE_DIS; ?></label>
					<div class='col-sm-7'>
					<?php if ($e[0]['toDirection'] == "sip" && $e[0]['fromDirection'] == "sip") {echo dtmfmode($ba, $config,1);} else echo dtmfmode($ba, $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' name='def_dtmfmode' id='def_dtmfmode' checked 
							   onclick='if (def_dtmfmode.checked) dtmfmode.disabled = true; else dtmfmode.disabled = false;'>
					</div>
				</div>
				<div class='form-group srtp_mode' data-toggle='tooltip' title='<?php echo SRTP_MODE; ?>'>
					<label for='srtp_mode' class='col-sm-3 control-label'><?php echo DIALPLAN_SRTP_MODE_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo srtp_mode($ba, $config, ($e[0]['toDirection'] == "sip" && $e[0]['fromDirection'] == "sip") ? 1 : 0); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_srtp_mode' id='def_srtp_mode' checked 
							   onclick='if (def_srtp_mode.checked) $("#srtp_mode").prop("disabled",true); else $("#srtp_mode").prop("disabled",false);'>
					</div>
				</div>
				<div class='form-group srtp_crypto_suites'>
					<label for='srtp_crypto_suites[]' class='col-sm-3 control-label'><?php echo DIALPLAN_SRTP_CRYPTO_SUITES_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo srtp_crypto_suites($ba, $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_srtp_crypto_suites' id='def_srtp_crypto_suites' checked 
							   onclick='if (def_srtp_crypto_suites.checked) $("#srtp_crypto_suites").prop("disabled",true); 
								   else $("#srtp_crypto_suites").prop("disabled",false);'/>
					</div>
				</div>
				<div class='form-group codecs'>
					<label for='codecs' class='col-sm-3 control-label'><?php echo DIALPLAN_CODECS_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo codecs($ba, $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_codecs' id='def_codecs' data-toggle='tooltip' title='<?php echo CODECS_DEF; ?>' checked
							   onclick='if (def_codecs.checked){
                                       $("#sel").prop("disabled", true);
                                       $("#sel1").prop("disabled", true);
                                       $("#upB").prop("disabled", true);
                                       $("#downB").prop("disabled", true);
                                       $("#addB").prop("disabled", true);
                                       $("#removeB").prop("disabled", true);
                                    } else{
                                       $("#sel").prop("disabled", false);
                                       $("#sel1").prop("disabled", false);
                                       $("#upB").prop("disabled", false);
                                       $("#downB").prop("disabled", false);
                                       $("#addB").prop("disabled", false);
                                       $("#removeB").prop("disabled", false);
                                    }'>

					</div>
				</div>
				
				<div class="clearfix"></div>
				<div class="row wait_for_cancel s2i_cpt i2s_cpt ">
					<p class="lead text-center"><?php echo DIALPLAN_STATE_OPTIONS_DIS; ?></p>
				</div>
				<div class='form-group wait_for_cancel ' data-toggle='tooltip' title='<?php echo WAIT_FOR_CANCEL; ?>'>
					<label for='wait_for_cancel' class='col-sm-3 control-label'><?php echo DIALPLAN_WAIT_FOR_CANCEL_DIS; ?></label>
					<div class='col-sm-7 form-checkbox'>
					<?php echo wait_for_cancel($ba, $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_wait_for_cancel' id='def_wait_for_cancel' checked 
							   onclick='if (def_wait_for_cancel.checked) $("#wait_for_cancel").prop("disabled", true); 
							   else $("#wait_for_cancel").prop("disabled", false);'>
					</div>
				</div>
				<div class='form-group s2i_cpt ' data-toggle='tooltip' title='<?php echo CALL_PROGRESS_TABLE; ?>'>
					<label for='s2i_cpt' class='col-sm-3 control-label'><?php echo DIALPLAN_CALL_PROGRESS_TABLE_S2I_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo s2i_cpt($ba, $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_s2i_cpt' id='def_s2i_cpt' checked 
							   onclick='if (def_s2i_cpt.checked) s2i_cpt.disabled = true; else s2i_cpt.disabled = false;'>
					</div>
				</div>
				<div class='form-group i2s_cpt ' data-toggle='tooltip' title='<?php echo CALL_PROGRESS_TABLE; ?>'>
					<label for='i2s_cpt' class='col-sm-3 control-label'><?php echo DIALPLAN_CALL_PROGRESS_TABLE_I2S_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo i2s_cpt($ba, $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_i2s_cpt' id='def_i2s_cpt' checked 
							   onclick='if (def_i2s_cpt.checked) i2s_cpt.disabled = true; else i2s_cpt.disabled = false;'>	
					</div>
				</div>
				<div class="clearfix"></div>
				<div class="row ie_on_sip sip_to_user_setting sip_from_display_setting sip_from_user_setting sip_pai_user_setting sip_ppi_user_setting ">
					<p class="lead text-center"><?php echo DIALPLAN_SIP_SETTINGS_DIS; ?></p>
				</div>
				<div class='form-group ie_on_sip ' data-toggle='tooltip' title='<?php echo IE_ON_SIP; ?>'>
					<label for='ie_on_sip' class='col-sm-3 control-label'><?php echo DIALPLAN_IE_ON_SIP_DIS; ?></label>
					<div class='col-sm-7 form-checkbox'>
					<?php echo ie_on_sip($ba, $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_ie_on_sip' id='def_ie_on_sip' checked 
							   onclick='if (def_ie_on_sip.checked) $("#ie_on_sip").prop("disabled", true); else $("#ie_on_sip").prop("disabled", false);'>
					</div>
				</div>
				<div class='form-group sip_to_user_setting ' data-toggle='tooltip' title='<?php echo SIP_TO_USER_SETTING; ?>'>
					<label for='sip_to_user_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_TO_USER_SETTING_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo called_party_number_sip($ba, 'sip_to_user_setting', $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_sip_to_user_setting' id='def_sip_to_user_setting' checked 
							   onclick='if (def_sip_to_user_setting.checked) sip_to_user_setting.disabled = true; else sip_to_user_setting.disabled = false;'>
					</div>
				</div>
				<div class='form-group sip_from_user_setting ' data-toggle='tooltip' title='<?php echo SIP_FROM_USER_SETTING; ?>'>
					<label for='sip_from_user_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_FROM_USER_SETTING_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo caller_id_mapping_sip($ba, 'sip_from_user_setting', $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_sip_from_user_setting' id='def_sip_from_user_setting' checked 
							   onclick='if (def_sip_from_user_setting.checked) sip_from_user_setting.disabled=true; else sip_from_user_setting.disabled=false;'>
					</div>
				</div>
				
				<div class='form-group sip_from_display_setting ' data-toggle='tooltip' title='<?php echo SIP_FROM_DISPLAY_SETTING; ?>'>
					<label for='sip_from_display_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_FROM_DISPLAY_SETTING_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo caller_id_mapping_sip($ba, 'sip_from_display_setting', $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_sip_from_display_setting' id='def_sip_from_display_setting' checked 
							   onclick='if (def_sip_from_display_setting.checked) sip_from_display_setting.disabled=true; 
							   else sip_from_display_setting.disabled=false;'/>
					</div>
				</div>
				
				<div class='form-group sip_pai_user_setting ' data-toggle='tooltip' title='<?php echo SIP_PAI_USER_SETTING; ?>'>
					<label for='sip_pai_user_setting ' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_PAI_USER_SETTING_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo caller_id_mapping_sip($ba, 'sip_pai_user_setting', $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_sip_pai_user_setting' id='def_sip_pai_user_setting' checked 
							   onclick='if (def_sip_pai_user_setting.checked) sip_pai_user_setting.disabled=true;
							   else sip_pai_user_setting.disabled=false;'/>
					</div>
				</div>
				
				<div class='form-group sip_ppi_user_setting ' data-toggle='tooltip' title='<?php echo SIP_PPI_USER_SETTING; ?>'>
					<label for='sip_ppi_user_setting ' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_PPI_USER_SETTING_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo caller_id_mapping_sip($ba, 'sip_ppi_user_setting', $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_sip_ppi_user_setting' id='def_sip_ppi_user_setting' checked 
							   onclick='if (def_sip_ppi_user_setting.checked) sip_ppi_user_setting.disabled=true;
							   else sip_ppi_user_setting.disabled=false;'/>
					</div>
				</div>
				
				<div class='form-group sip_contact_user_setting ' data-toggle='tooltip' title='<?php echo SIP_CONTACT_USER_SETTING; ?>'>
					<label for='sip_contact_user_setting ' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_CONTACT_USER_SETTING_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo caller_id_mapping_sip($ba, 'sip_contact_user_setting', $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_sip_contact_user_setting' id='def_sip_contact_user_setting' checked 
							   onclick='if (def_sip_contact_user_setting.checked) sip_contact_user_setting.disabled=true;
							   else sip_contact_user_setting.disabled=false;'/>
					</div>
				</div>
				<div class="clearfix"></div>
				
				<div class="row sip_national_code sip_international_code dialplan_international_prefix 
					 isdn2sip_destination_numformat isdn2sip_source_numformat sip2dialplan_dad_prefix_setting
					 sip2dialplan_oad_prefix_setting ">
					<p class="lead text-center"><?php echo DIALPLAN_PROVIDER_SETTINGS_DIS; ?></p>
				</div>
				<div class='form-group sip_national_code ' data-toggle='tooltip' title='<?php echo SIP_NATIONAL_CODE_SETTING; ?>'>
					<label for='sip_national_code' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_NATIONAL_CODE_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo sip_input_text($ba, 'sip_national_code', $config, '', '[0-9]+'); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_sip_national_code' id='def_sip_national_code' checked 
							   onclick='if (def_sip_national_code.checked) sip_national_code.disabled=true; else sip_national_code.disabled=false;'>
					</div>
				</div>
				<div class='form-group sip_international_code ' data-toggle='tooltip' title='<?php echo SIP_INTERNATIONAL_CODE_SETTING; ?>'>
					<label for='sip_international_code' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_INTERNATIONAL_CODE_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo sip_input_text($ba, 'sip_international_code', $config, '', '[+0-9]+'); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_sip_international_code' id='def_sip_international_code' checked 
							   onclick='if (def_sip_international_code.checked) sip_international_code.disabled=true; else sip_international_code.disabled=false;'>
					</div>
				</div>
				<div class='form-group dialplan_international_prefix '>
					<label for='dialplan_international_prefix' class='col-sm-3 control-label'><?php echo DIALPLAN_DIALPLAN_INTERNATIONAL_PREFIX_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo sip_input_text($ba, 'dialplan_international_prefix', $config, '00', '[+0-9]+'); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_dialplan_international_prefix' id='def_dialplan_international_prefix' checked 
							   onclick='if (def_dialplan_international_prefix.checked) dialplan_international_prefix.disabled=true; 
							   else dialplan_international_prefix.disabled=false;'>
					</div>
				</div>
				<div class="clearfix"></div>
				<div class="row isdn2sip_destination_numformat isdn2sip_source_numformat ">
					<div class="text-center">
						<h5><?php echo DIALPLAN_PSTN_TO_SIP_DIS; ?></h5>
					</div>
				</div>
				<div class='form-group isdn2sip_destination_numformat ' data-toggle='tooltip' title='<?php echo ISDN2SIP_DESTINATION_NUMFORMAT; ?>'>
					<label for='isdn2sip_destination_numformat' class='col-sm-3 control-label'><?php echo DIALPLAN_ISDN2SIP_DESTINATION_NUMFORMAT_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo isdn2sip_destination_numformat($ba, $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_isdn2sip_destination_numformat' id='def_isdn2sip_destination_numformat' checked 
							   onclick='if (def_isdn2sip_destination_numformat.checked) isdn2sip_destination_numformat.disabled=true; 
							   else isdn2sip_destination_numformat.disabled=false;'>
					</div>
				</div>
				<div class='form-group isdn2sip_source_numformat ' data-toggle='tooltip' title='<?php echo ISDN2SIP_SOURCE_NUMFORMAT; ?>'>
					<label for='isdn2sip_source_numformat' class='col-sm-3 control-label'><?php echo DIALPLAN_ISDN2SIP_SOURCE_NUMFORMAT_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo isdn2sip_source_numformat($ba, $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_isdn2sip_source_numformat' id='def_isdn2sip_source_numformat' checked 
							   onclick='if (def_isdn2sip_source_numformat.checked) isdn2sip_source_numformat.disabled=true; 
							   else isdn2sip_source_numformat.disabled=false;'>
					</div>
				</div>
					<div class='form-group use_privacy_header ' data-toggle='tooltip' title='<?php echo USE_PRIVACY_HEADER_TOOLTIP; ?>'>
					<label for='use_privacy_header' class='col-sm-3 control-label'><?php echo DIALPLAN_USE_PRIVACY_HEADER_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo use_privacy_header($ba, $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_use_privacy_header' id='def_use_privacy_header' checked 
							   onclick='if (def_use_privacy_header.checked) use_privacy_header.disabled=true; 
							   else use_privacy_header.disabled=false;'>
					</div>
				</div>
				
				
				<div class="clearfix"></div>
				<div class="row sip2dialplan_dad_prefix_setting sip2dialplan_oad_prefix_setting ">
					<div class="text-center">
						<h5><?php echo DIALPLAN_SIP_TO_PSTN_DIS; ?></h5>
					</div>
				</div>
				<div class='form-group sip2dialplan_dad_prefix_setting '>
					<label for='sip2dialplan_dad_prefix_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP2DIALPLAN_DAD_PREFIX_SETTING_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo sip2dialplan_dad_prefix_setting($ba, $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_sip2dialplan_dad_prefix_setting' id='def_sip2dialplan_dad_prefix_setting' checked 
							   onclick='if (def_sip2dialplan_dad_prefix_setting.checked) $("#sip2dialplan_dad_prefix_setting").prop("disabled",true); 
							   else $("#sip2dialplan_dad_prefix_setting").prop("disabled",false);'>
					</div>
				</div>
				<div class='form-group sip2dialplan_oad_prefix_setting '>
					<label for='sip2dialplan_oad_prefix_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP2DIALPLAN_OAD_PREFIX_SETTING_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo sip2dialplan_oad_prefix_setting($ba, $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_sip2dialplan_oad_prefix_setting' id='def_sip2dialplan_oad_prefix_setting' checked 
							   onclick='if (def_sip2dialplan_oad_prefix_setting.checked) $("#sip2dialplan_oad_prefix_setting").prop("disabled",true); 
							   else $("#sip2dialplan_oad_prefix_setting").prop("disabled",false);'/>
					</div>
				</div>
				<div class="clearfix"></div>
				<div class="row from_sip_src_setting ">
					<p class="lead text-center"><?php echo DIALPLAN_OPTIONS_DIS; ?></p>
				</div>
				<div class='form-group from_sip_src_setting ' data-toggle='tooltip' title='<?php echo FROM_SIP_SRC_SETTING; ?>'>
					<label for='failover_timeout' class='col-sm-3 control-label'><?php echo DIALPLAN_FROM_SIP_SRC_SETTING_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo from_sip_src_setting($ba, $config, 1); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_from_sip_src_setting' id='def_from_sip_src_setting' checked 
							   onclick='if (def_from_sip_src_setting.checked) from_sip_src_setting.disabled=true; else from_sip_src_setting.disabled=false;'/>
					</div>
				</div>
				<div class='form-group from_sip_dest_setting ' data-toggle='tooltip' title='<?php echo FROM_SIP_DEST_SETTING; ?>'>
					<label for='failover_timeout' class='col-sm-3 control-label'><?php echo DIALPLAN_FROM_SIP_DEST_SETTING_DIS; ?></label>
					<div class='col-sm-7'>
					<?php echo from_sip_dest_setting($ba, $config, 1); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_from_sip_dest_setting' id='def_from_sip_dest_setting' checked 
							   onclick='if (def_from_sip_dest_setting.checked) from_sip_dest_setting.disabled=true; else from_sip_dest_setting.disabled=false;'/>
					</div>
				</div>
				<div class="clearfix"></div>
<?php
if ($e[0]['toDirection'] == "sip" && $e[0]['fromDirection'] == "sip") {
?>
				
				<div class='form-group s2s_nat_opener ' data-toggle='tooltip' title='<?php echo SIP_NAT_OPENER_TOOLTIP; ?>'>
					<label for='s2s_nat_opener' class='col-sm-3 control-label'><?php echo SIP_NAT_OPENER_HEADER; ?></label>
					<div class='col-sm-7'>
						<?php echo s2s_nat_opener($ba, $config); ?>
					</div>
					<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_s2s_nat_opener' id='def_s2s_nat_opener' checked
						onclick='if (def_s2s_nat_opener.checked) s2s_nat_opener.disabled=true; else s2s_nat_opener.disabled=false;'/>
					</div>
				</div>
				<div class="clearfix"></div>
				
				<div class='form-group s2s_rtp_handling_method <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo S2S_RTP_HANDLING_METHOD_LABEL ?>'>
					<label for='s2s_rtp_handling_method' class='col-sm-3 control-label'><?php echo S2S_RTP_HANDLING_METHOD_LABEL; ?></label>
					<div class='col-sm-7'>
					<?php echo s2s_rtp_handling_method($ba, $config); ?>
					</div>
						<div class='col-sm-1 form-checkbox'>
						<input type='checkbox' value='1' name='def_s2s_rtp_handling_method' id='def_s2s_rtp_handling_method' checked
							   onclick='if (def_s2s_rtp_handling_method.checked) s2s_rtp_handling_method.disabled=true; else s2s_rtp_handling_method.disabled=false;'/>
					</div>
				</div>
				<div class="clearfix"></div>
				
<?php }
?>

			</div>
		<?php } ?>
		</div>
		<br/> 
		<input name='page' type='hidden' value='<?php echo $page; ?>'>
		<input name='dir' type='hidden' value='<?php echo $dir; ?>'>
		<input name='search' type='hidden' value='<?php echo $search; ?>'>
		<input name='id_upd' type='hidden' value='<?php echo $_GET['dialplanid']; ?>'>
		<input name='from' type='hidden' value='<?php echo $e[0]['fromDirection']; ?>'>
		<input name='to' type='hidden' value='<?php echo $e[0]['toDirection']; ?>'>
 
  <?php if ($_GET['isdnid']!=""){ ?>
  <input name='isdnid' type='hidden' value='<?php echo $_GET['isdnid']; ?>'>
		<?php } ?>

		<div id='buttons' class='text-center'><input name='submit' class='btn btn-default' type='submit' value='<?php echo BUTTON_SAVE; ?>' onclick='selectall();' data-toggle='tooltip' title='<?php echo DIALPLAN_SAVE; ?>'>
		</div>
		</form>
</div>
<?php	showdefmc($ba, $e); ?>


