<?php
/**
 * Dialplan debug popup
 */
chdir("../..");
include './includes/variables.php';
require_once ('./includes/isgwtelnet.php');
include_once("/usr/www/include/SQLite2ToSQLite3.php");

/*
	Checking:	
		- without POST request
		- all GET inputs are used into isset() function -> sanitizing not necessary
 */

/**
 * @return string HTML Inhalt
 */
function show_file($version_file = "/usr/local/VERSION") {
	include "./misc/database.php";
	$ba = new beroAri();
	require_once("./includes/lang.php");

	/* update year footer */
	// default value
	$year = "2019";

	//update year 
	$import_year = file_get_contents($version_file);
	preg_match("/YEAR=([0-9]*)/", $import_year, $output_year);

	if (isset($output_year[1])) {
	        $year = $output_year[1];
	}
	else {
	        // get year from server
	        exec("/bin/cat /usr/conf/misc.conf | /bin/grep ntphost | /usr/bin/cut -d '=' -f 2", $ntphost);
	        if (isset($ntphost[0]) && strlen($ntphost[0]) > 0) {
	                exec("/bin/ping -c 1 $ntphost[0]", $output, $retval);
	                $dns_works = (($retval == 0) ? 1 : 0);

	                if ($dns_works) {
	                        system("/usr/local/bin/rdate -ns $ntphost[0]");
	                        $year = date('Y');
	                }
	        }
	}


	$ret = '<!DOCTYPE html>
	<html lang="en">
	<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="icon" href="../../includes/images/favicon.ico" type="image/x-icon" />
	<link rel="stylesheet" type="text/css" href="../../includes/css/bootstrap.min.css" />
	<link rel="stylesheet" type="text/css" href="../../includes/css/template_css.css" />
	<script type="text/javascript" language="javascript" src="../../includes/js/jquery-1.7.2.min.js"></script>';
	if ((!isset($_GET['stop']) && !isset($_GET['stopped'])) || isset($_GET['start']))
		$ret.="<script type=\"text/javascript\" language=\"javascript\">
				setInterval(function() {
				$('#content').load('./dialplan_debug.php?reload_ajax=Reload','');
				}, 10000);
				</script>";
	$ret.="<title>" . DIALPLAN_DEBUG_POPUP_TITLE_DIS . "</title>
	</head>
	<body>";

	$ret.= "<div class='container boxed'>
<div id=\"header\" style='padding-bottom:15px;'>
        <div id=\"logo\"> <a href=\"http://www.beronet.com\" target=\"_blank\" onfocus=\"if (this.blur()) { this.blur(); }\">
        <img src=\"../../includes/images/beroNet.jpg\" alt=\"beroNet\" class=\"png\">
        </a>        
</div><p><font size='3'>" . DIALPLAN_DEBUG_TITLE_DIS . "</font></p></div>";
	if ((isset($_GET['stop']) || isset($_GET['stopped'])) && !isset($_GET['start'])) {
		$ret.="<p>" . DIALPLAN_DEBUG_POPUP_STATE_OFF_DIS . "</p>";
	} else {
		$ret.="<p>" . DIALPLAN_DEBUG_POPUP_STATE_ON_DIS . "</p>";
	}
	$ret.="<form action='' method='GET'>
	<input type='submit' name='reload' class='btn btn-default' value='" . BUTTON_RELOAD . "'/>&nbsp;
	<input type='submit' name='clear' class='btn btn-default' value='" . BUTTON_CLEAR . "'/>&nbsp;";

	if ((isset($_GET['stop']) || isset($_GET['stopped'])) && !isset($_GET['start'])) {
		$ret.="<input type='hidden' name='stopped' value='1'>";
		$ret.="<input type='submit' name='start' class='btn btn-default' value='" . BUTTON_START . "'><br/><br/><table style='text-align:left;'><tr><td>";
	} else {
		$ret.="<input type='submit' name='stop' class='btn btn-default' value='" . BUTTON_STOP . "'><br/><br/><table style='text-align:left;'><tr><td>";
	}
	if (isset($_GET['clear']) && is_file("/tmp/dialplan_debug.log")) {
		file_put_contents("/tmp/dialplan_debug.log", "");
	}
	$ret.="<div id='content'>" . content() . "</div>";
	$ret.= "</td></tr></table></form>"
		. "<div class='clearfix'></div>
<div class='row text-muted footer'>

    <!-- copyright text -->
    <div class='col-lg-6'>
        Copyright &copy; $year beroNet GmbH, Germany
    </div>
</div>
	</body>
	</html>";

	return $ret;
}

if (isset($_GET['stop'])) {
	$isgw = new isgwtelnet();
	$result = $isgw->isgw_login();
	$res = $isgw->isgw_verbose(0);
	echo show_file();
} elseif (isset($_GET['reload'])) {
	echo show_file();
} elseif (isset($_GET['reload_ajax'])) {
	echo content();
} elseif (isset($_GET['clear']) && is_file("/tmp/dialplan_debug.log")) {
	file_put_contents("/tmp/dialplan_debug.log", "");
	echo show_file();
} elseif (!is_file("/tmp/dialplan_debug.log") || isset($_GET['start'])) {
	$isgw = new isgwtelnet();
	$result = $isgw->isgw_login();
	$res = $isgw->isgw_verbose(1);
	echo show_file();
}

function content() {
	$ret = "";
	if (is_file("/tmp/dialplan_debug.log")) {
		$zeilen = file("/tmp/dialplan_debug.log");
		$zeilen = array_reverse($zeilen);
		$i = 0;
		foreach ($zeilen as $zeile) {
			if ($i != count($zeilen)) {
			
				$info = htmlspecialchars($zeile);
				$info = str_replace ("&lt;br&gt;", "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", $info);
				if (strstr ($info, "|REQUEST"))  {
					$direction = "<font color='#000000'>==>&nbsp;</font>";
				}
				else if (strstr ($info, "|INDICATION"))  {
					$direction = "<font color='#FF0000'><==&nbsp;</font>";
				}
				else {
					$direction = "<font color='#888888'>===&nbsp;</font>";
				}
				
				if (strpos($zeile, "S") === 0) {
					$ret.= $direction . "<font color='#FF9900'>" . $info . "</font><br/>";
				}
				elseif (strpos($zeile, "I") === 0) {
					$ret.= $direction . "<font color='black'>" . $info . "</font><br/>";
				}
				elseif (strpos($zeile, "A") === 0) {
					$ret.= $direction . "<font color='black'>" . $info . "</font><br/>";
				}
				elseif (strpos($zeile, "D") === 0) {
					$ret.= $direction . "<font color='red'>" . $info . "</font><br/>";
				}
				else {
					$ret.= $direction . "<font color='#C0C0C0'>" . $info . "</font><br/>";
				}
			}
			else {
				$pid = $zeile;
			}
			$i++;
		}
	}
	return $ret;
}

?>
