<?php
include('/usr/fallback/beroConf.php');
include('/usr/local/php/include/fulltrace.Class.php');
include_once('/usr/www/include/SQLite2ToSQLite3.php');
require_once('/usr/local/www/berogui/includes/Helper/HelperHtml.php');

/**
 * Implements the debug funtions of the gateway
 * @author Florian Kraatz <fk@beronet.com>
 * @author Miguel Palmer <mp@beronet.com>
 */
class FulltraceGui {

	private	$_ba,
					$_bc,
					$_ft;

	private $m_attr;

	private	$action = 'default';

	private $isRequestRejected = 0,
					$reasonRejected = array();

	/**
	* Constructor
	*/
	function __construct($m, $get = array(), $post = array(), $session = array()) {
		// load classes
		$this->_ba = new beroAri();
		$this->_bc = new beroConf('root');
		$this->_ft = new fulltrace();

		// set main GET variable
		$this->m_attr = $m;

		// get values from submit
		if (isset($get['error'])) {
			$this->isRequestRejected = 1;
			$this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
			unset($get['error'], $get['request'], $get['checkor'], $get['key']);
		}
		else if (isset($get['action'])) {
			$list_get = array('action' => 'select');
			$list_options = array(
				'action' => array('start', 'stop', 'default')
			);

			$is_safe = 1;
			$get = Helper::sanitizeGet($get, $list_get, $is_safe, $this->reasonRejected, $list_options);
			if ($is_safe) {
				$this->action = $get['action'];
			}
			else {
				$this->isRequestRejected = 1;
			}
			unset($get['action']);
		}
	}

	private function _show_trace_run() {
		ob_start();
		?>
		<br/>
		<form method="POST" class="form-horizontal" action='modules/FulltraceGui/fulltracegui_submit.php'>
			<p class="text-center lead" ><?php echo FULL_TRACE_TABLE_HEADER_DIS; ?></p>
			<div class='form-group text-center'><?php echo FULL_TRACE_NOTICE_DIS; ?></div>
			<div class='form-group text-center' id="fulltrace" style='margin-top:15px;'>
				<img src="includes/images/punkt_gruen.gif" style="margin-right: 15px;">
				<input type="submit" class="btn btn-default" id="cancel_trace" name="trace" title="<?php echo DEBUG_CANCEL_TRACE; ?>" data-toggle="tooltip" value="<?php echo DEBUG_CANCEL_BUTTON_TEXT; ?>"/>
				<input type="submit" class="btn btn-default" id="stop_trace" name="trace" title="<?php echo DEBUG_STOP_TRACE; ?>" data-toggle="tooltip" value="<?php echo DEBUG_STOP_DOWNLOAD_BUTTON; ?>" />
			</div>
		</form><br/>
		<?php
		$ret .= ob_get_clean();

		// we don't display file-download during trace if we're not 'advanced'
		if (((strlen($this->_ba->get('gui_mode')) == 0) ? 'easy' : $this->_ba->get('gui_mode')) != 'advanced') {
			return($ret);
		}
		ob_start();
		?>
			<div class='text-center'>
				<input type='button' class='btn btn-default' id='expand-singledl-file' title='' data-toggle='tooltip' value="<?php echo DEBUG_EXPAND_BUTTON; ?>"/>
			</div>
			<div class='text-center' style='display:none;' id='showSingleDl'>
				<p class="text-center lead" ><?php echo FULL_TRACE_SINGLE_TABLE_HEADER_DIS; ?></p>
				<div class='text-center' id='contentSingleDl' style='margin-top:15px;'></div>
			</div>
			<script>
				$('#expand-singledl-file').click(function() {
					// show title with the waiting gif
					$('#expand-singledl-file').hide();
					$('#contentSingleDl').html("<img src='./includes/images/waitlogo1.gif'>");
					$('#showSingleDl').show();
					// start the ajax request
					setInterval(refreshSingleDownload, 1000);
				});
			</script>
		<?php
		return $ret . ob_get_clean() . $this->_ajaxRefreshSingleDownload();
	}

	function table() {
		require_once('/usr/local/www/berogui/includes/Helper/HelperPstn.php');	
		require_once('/usr/local/www/berogui/includes/Helper/HelperHtml.php');

		$form = array(
			'action'=> 'modules/FulltraceGui/fulltracegui_submit.php',
			'id'		=> 'fulltrace_form',
			'style' => 'margin-top:10px;',
			'title' => 'FULL_TRACE_TABLE_HEADER_DIS', 
		);

		$parameters = array(
			'mode' => array(
				'class'	=> array(
					'label' => 'col-sm-4 control-label',
				),
				'db-key'		=> 'fulltrace_type',
				'default'		=> 0,
				'display'		=> 'fieldSelect',
				'options'		=> array(
					'select'=> array(
						0 => 'FULL_TRACE_TYPE_BASIC',
						1 => 'FULL_TRACE_TYPE_ADVANCED',
					),
				),
				'title'			=> 'FULL_TRACE_TYPE_DIS',
				'tooltip'		=> '',
			),
			'options'	=> array(
				'class'	=> array(
					'label' => 'col-sm-4 control-label',
				),
				'db-key'		=> 'ft_advanced_options',
				'default'		=> '',
				'display'		=> 'fieldText',
				'div-id'		=> 'id_options',
				'div-style'	=> 'display:none;',
				'options'		=> null,
				'title'			=> 'FULL_TRACE_TYPE_OPTPARAMETER_DIS',
				'tooltip'		=> 'FULL_TRACE_TYPE_OPTPARAMETER_TT',
			),
		);

		$analog_script = '';
		if (!($this->_ba->get('is_sbc_vm') == 1) && HelperPstn::hasAnalog($this->_ba)) {
			$parameters['analog-ports-select'] = array(
				'class'	=> array(
					'label' => 'col-sm-4 control-label',
				),
				'db-key'		=> 'analog_ports_select',
				'default'		=> 0,
				'display'		=> 'fieldSelect',
				'options'		=> array(
					'select'	=> array(
						0	=> 'FULL_TRACE_ANALOGPORTS_SELECT_NONE',
						1 => 'FULL_TRACE_ANALOGPORTS_SELECT_UPTO4PORTS',
					),
				),
				'title'			=> 'FULL_TRACE_ANALOGPORTS_SELECT_DIS',
				'tooltip'		=> '',
			);
			$ports = array();
			for ($i=0; $i<Helper::getLifCount(); $i++) {
				$query = $this->_ba->select("SELECT DISTINCT type,port_type FROM analog WHERE lif='". sqlite_escape_string($i) ."'");
				while ($entry = $this->_ba->fetch_array($query)) {
					$ports[$i]['type'] = $entry['type'];
					$query_port = $this->_ba->select("SELECT port FROM analog WHERE lif='". sqlite_escape_string($i) ."' AND port_type='". sqlite_escape_string($entry['port_type']) ."'");
					while ($entry_port = $this->_ba->fetch_array($query_port)) {
						$ports[$i]['ports'][] = $entry_port['port'];
					}
				}
			}
			$parameters['analog-ports'] = array(
				'class'	=> array(
					'label' => 'col-sm-4 control-label',
				),
				'db-key'		=> 'analog_ports',
				'default'		=> $ports,
				'display'		=> 'fieldPorts',
				'div-id'		=> 'id_analog_ports',
				'div-style'	=> 'display:none;margin-left:-55px;',
				'options'		=> null,
				'title'			=> '',
				'tooltip'		=> '',
			);
			ob_start();
			?>
			<script>
				$('#id_analog_ports_select').change(function() {
					if (this.value == 1) {
						$('#id_analog_ports').show();
					}
					else {
						$('#id_analog_ports').hide();
					}
				});
				$('#id_start').click(function(e) {
					if (getTotalPortsChecked() > 4) {
						e.preventDefault();
						$('#invalid').html('<?php echo FULL_TRACE_SELECTED_PORTS_ERROR; ?>');
					}
				});
				$('#fulltrace_form').change(function() {
					$('#invalid').html('');
				});
				function getTotalPortsChecked() {
					var total = 0;
					$("input[name='data[analog_ports][]']").each(function(index) {
						if($(this).is(':checked')) {
							total++;
						}
					});
					return total;
				}
			</script>
			<?php
			$analog_script = ob_get_clean();
		}

		$content = "\t\t\t<div class='text-center' id='invalid' style='color:red;font-size:13px;margin-bottom:15px;'></div>\n";
		foreach ($parameters as $key => $parameter) {
			$function = $parameter['display'];
			$content .= HelperHtml::$function($parameter['db-key'], $parameter['default'], $parameter, "\t\t\t");
		}
		$content .= HelperHtml::buttons('start', 'BUTTON_START', array('name' => 'trace'), "$tab\t\t");

		ob_start();
		?>
		<script>
			$('#id_fulltrace_type').change(function() {
				if (this.value == 1) {
					$('#id_options').show();
				}
				else {
					$('#id_options').hide();
				}
			});
		</script>
		<?php
		$content .= ob_get_clean() . $analog_script;

		return "\n". HelperHtml::form($content, $form, "\t\t");
	}

	function display() {

		$name = 'FULL_TRACE_TITLE_DIS';
		include('./includes/header.php');
		require_once('./includes/isgwtelnet.php');
		
		if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

		if ($this->_ba->get('trace') == 1) {
			$ret .= $this->_show_trace_run();
		}
		else {
			$ret .= $this->table()
						. $this->_show_download_files();
		}
		return $ret;
	}

	private function _show_download_files() {
		$content = $ret = '';
		foreach (require('/usr/local/www/berogui/modules/FulltraceGui/fulltracegui_parameters.php') as $key => $file) {
			if ($key == 'DebugFiles' && $this->_bc->get('root', 'trace-state') == 'STOPPING') {
				$is_exists = true;
				$restore = $file['btns']['dld'];
				$restore['id'] = 'restoreDownload';
				$file['btns']['dld'] = array(
					'disabled'=> true,
					'id'			=> 'restoreDownload',
					'onclick' => '',
					'title' 	=> 'FULL_TRACE_LOADING_BTN_TOOLTIP',
					'value' 	=> 'FULL_TRACE_LOADING_BTN_DIS',
				);
				$content .= HelperHtml::fieldButtonsInline($file['label'], $file['btns'], $file['options'], "\t\t\t")
									.	$this->_ajaxDownload($restore);
			}
			else if (file_exists($file['name'])) {
				$file['options']['image'] = date("d M Y H:i", filectime($file['name']));
				$content .= HelperHtml::fieldButtonsInline($file['label'], $file['btns'], $file['options'], "\t\t\t");
			}
		}
		if (strlen($content)) {
			$ret .= "<hr>\n". HelperHtml::form($content, array('style' => 'margin-top:20px;', 'title' => 'FULL_TRACE_DOWNLOADS_DIS'), "\t\t");
		}
		return $ret;
	}

	private function _ajaxDownload($restore) {
		$restore_btn = "\n";
		$destination = base64_encode("/app/berogui/index.php?m=FulltraceGui");
		foreach (array('onclick', 'title', 'value') as $key) {
			$restore_btn .= "\t\t\t\t\t\t\t\t$('#{$restore['id']}').attr('$key', \"". (defined($restore[$key]) ? constant($restore[$key]) : $restore[$key]) ."\");\n";
		}
		ob_start();
?>
		<script>
			var intervalId = setInterval(downloadDebugFiles, 1000);
			function downloadDebugFiles() {
				$.ajax({
					data: {
						action: 'download',
					},
					error: function(res) {
						if (res.status == 400) {
							$('#ajaxErrors').html('<?php echo AJAX_ERRORS_BAD_REQUEST; ?>');
						}
						else if (res.status == 408) {
							window.location.href = './includes/login.php?reason=sess_expd&destination=<?php echo $destination; ?>';
						}
					},
					success: function(res) {
						var state = JSON.parse(res);
						if (typeof state.completed !== 'undefined') {
							if (state.completed == '1') {
								clearInterval(intervalId);
								window.location.href = 'modules/FulltraceGui/fulltracegui_download.php';
					<?php echo $restore_btn; ?>
								$('#<?php echo $restore['id']; ?>').removeAttr('disabled');
								return;
							}
						}
					},
					timeout: 1000,
					type: 'POST',
					url: 'modules/FulltraceGui/fulltracegui_ajax.php',
				});
			}
		</script>
<?php
		return ob_get_clean();
	}

	private function _ajaxRefreshSingleDownload() {
		// TODO: write a generic function for the ajax error behavior and use it for all ajax requests
		$destination = base64_encode("/app/berogui/index.php?m=FulltraceGui");
		ob_start();
		?>
		<script>
			function refreshSingleDownload() {
				$.ajax({
					data: {
						action: 'refresh-single-file',
					},
					error: function(res) {
						if (res.status == 400) {
							$('#ajaxErrors').html('<?php echo AJAX_ERRORS_BAD_REQUEST; ?>');
						}
						else if (res.status == 408) {
							window.location.href = './includes/login.php?reason=sess_expd&destination=<?php echo $destination; ?>';
						}
					},
					success: function(res) {
						$('#contentSingleDl').html(res);
					},
					timeout: 1000,
					type: 'POST',
					url: 'modules/FulltraceGui/fulltracegui_ajax.php',
				});
			}
		</script>	
		<?php
		return ob_get_clean();
	}
}
?>
