<?php
/**
 * Implementiert die CRUD Operationen für GSM Portgruppen
 * 
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class Gsm {

	private		$m_attr,
			$start_attr;

	private		$isRequestRejected = 0,
			$reasonRejected = array();

	function __construct($m, $get = array(), $post = array(), $session = array()) {
		$this->m_attr = $m;
		
		$this->start_attr = isset($get['start']) ? Helper::sanitizeGet($get['start'], 'start') : 0;

                if (isset($get['error'])) {
			$this->isRequestRejected = true;
			$this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
                	unset($get['error'], $get['request'], $get['checkor'], $get['key']);
                }
	}

	/**
	 * Funktion display erzeugt den Inhalt von der HTML-Seite
	 * @return string HTML Inhalt
	 */
	function display() {

		// args
		$m = $this->m_attr;
		$start = $this->strart_attr; 

                $name="GSM_TITLE_DIS";
		include('./includes/header.php');
		
		if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

		$gsm_table = $this->dynamic_table();
		// build page content
		$ret .= "
			<script>
			function del(table,option,opt){
				conf = confirm('".PSTN_DELETE_MESS1_DIS." '+option+'? ".PSTN_DELETE_MESS2_DIS."');
				if (conf==false)
					return false;
				else
					window.location='./misc/delete.php?m=".$m."&gr='+option+'&table='+table+'&opt='+opt;
			}
			</script>
			<div class='modal fade bs-example-modal-lg' id='gsm-popup' tabindex='-1' role='dialog' aria-labelledby='myModalLabel' aria-hidden='true'>
			  <div class='modal-dialog modal-lg'>
			    <div class='modal-content'>
			      <div class='modal-header'>
				<button type='button' class='close' data-dismiss='modal' aria-label='Close'><span aria-hidden='true'>&times;</span></button>
				<h4 class='modal-title' id='myModalLabel'>" . GSM_TITLE_DIS . "</h4>
			      </div>
			      <div class='modal-body'>
			      </div>
			    </div>
			  </div>
			</div>
			<br>
			<div id='container'>
			" . $gsm_table . "
			</div>
			<br>
			<div class='text-center'>
				<a href='modules/Gsm/gsm_popup.php?start=" . $start . "' role='button' data-remote='false' data-toggle='modal' data-target='#gsm-popup' class='btn btn-default'>
				" . BUTTON_ADD . "
				</a>
			 </div>
			<script>" .
			"$('#gsm-popup').on('show.bs.modal', function(e) {" .
				"var link = $(e.relatedTarget);" .
				"$('.modal-body').load(link.attr('href'));" . 
			"});" .
			"$('#gsm-popup').on('hidden.bs.modal', function(e) {" .
				"$('.modal-body').empty();" . 
			"});" .
			"</script>";


		return $ret;
	}

	/**
	 * Erstellt die HTML Tabelle für die GSM Portgruppen
	 * @return string HTML Tabelle
	 */
	function dynamic_table() {
		//ein neues Datenbankobjekt wird erzeugt.
		$ba = new beroAri();
		require_once("./includes/lang.php");

		$cols .= "<th>".PSTN_GROUP_DIS."</th>";
		$cols .= "<th>".PSTN_PORTS_DIS."</th>";
		/*Die Einträge werden von der Tabelle analog gelesen, formatiert und in einer
		  Tabelle geschrieben, zusätzlich werden 2 Knöpfe eingebaut: modify und delete*/
		$query = $ba->select('SELECT DISTINCT gr FROM gsm WHERE gr!="NULL"');
		$rows = '';
		while ($entry = $ba->fetch_array($query)) {
			$query_port = $ba->select('SELECT port FROM gsm WHERE gr=\''.$entry['gr'].'\' ORDER BY port asc');
			$ports="";
			while ($entryp = $ba->fetch_array($query_port)) {
				if($ports!=""){
					$ports.=",".$entryp['port'];
				}else{
					$ports.=$entryp['port'];
				}
			}
			$rows.="<tr><td>".$entry['gr']."</td><td>".$ports."</td>";
			$rows .= "<td class='buttons'>
				<a href='modules/Gsm/gsm_popup.php?gr=" . $entry['gr'] . "' data-remote='false' data-toggle='modal' data-target='#gsm-popup' class='popup_download'>
					<img src='./includes/images/modify.png' onmouseover=\"Tip('" . MOD_GSM_MODIFY . "')\" onmouseout='UnTip()'>
				</a>&nbsp;
				<a class='popup_download' onclick=\"del('gsm','".$entry['gr']."','".$this->m_attr."');\">
            	    <img src='./includes/images/delete.png' onmouseover=\"Tip('" .
					MOD_GSM_DELETE . "')\" onmouseout='UnTip()'>
				</a>
			</td></tr>";
		}


		$table = "<table class='table table-striped table-bordered' id='table' style='max-width:700px; margin:auto;'><tr>" . $cols . "<th></th></tr>" . $rows . "</table>";
		//Rückgabe: Erzeugte Tabelle mit den Einträgen der Tabelle gsm der Datenbank
		return $table;
	}

}
?>
