<?php
/**
 * @file
 * Modal form für ISDN Portgruppen
 */
require_once("/usr/local/www/berogui/includes/Helper/Helper.php");

$load_popup = 1;
$invalid = array();

/* [CHECKING GET REQUEST] */
$list_get = array('gr' => 'group-name', 'opt' => 'opt');

$_GET = Helper::sanitizeGet($_GET, $list_get, $load_popup, $invalid);

/* [CHECKING POST REQUEST] */
unset($_POST);

/* [DISPLAYING POPUP] */
if (!$load_popup) {
        echo "<script>window.location='../../index.php?m=Isdn&opt={$_GET['opt']}&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
        exit(1);
}

chdir("../..");

include "./includes/variables.php";
include_once("/usr/www/include/SQLite2ToSQLite3.php");
include "./misc/database.php";
include("./misc/config_parameter.php");
$ba = new beroAri();
require_once ('./includes/lang.php');
require_once "./includes/isgwtelnet.php";
require_once "./includes/Helper/HelperPstn.php";
require_once('/usr/local/www/berogui/includes/session.php');

$group = '"general"';
$query_comp = $ba->select("SELECT * FROM isdn");
while ($entry = $ba->fetch_array($query_comp)) {
	if ($entry['gr'] != $_GET['gr'])
		$group .= ',' . '"' . $entry['gr'] . '"';
}
?>


<script type="text/javascript">
	var validator = $("#isdn").validate({
		rules: {
			city_code: {
//disabled, because some contries don't have a city code
// 				required: {
// 					depends: function (element) {
// 						return $("#isdn_oad_setting").prop("selectedIndex") == 1;
// 					}
// 				},
				digits: true
			},
			clir_on_oad: {
				digits: true
			},
			country_code: {
				required: {
					depends: function (element) {
						return $("#isdn_oad_setting").prop("selectedIndex") == 1;
					}
				},
				checkPhoneNumber: true
			},
			dialtone_digits: {
				digits: true,
			},
			ectl: {
				range: [0, 15]
			},
			group: {
				required: true,
				checkDigChar: true,
				compareName: [<?php echo $group; ?>]
			},
			isdn_dad_setting_manual: {
				specChar: "#isdn_dad_setting_manual:visible"
			},
			isdn_oad_setting_manual: {
				checkManual: "#isdn_oad_setting_manual:visible"
			},
			isdn_oad2_setting_manual: {
				checkManual: "#isdn_oad2_setting_manual:visible"
			},
			isdn_qsigname_setting_manual: {
				checkManual: "#isdn_qsigname_setting_manual:visible"
			},
			isdn_redirected_nr_setting_manual: {
				checkManual: "#isdn_redirected_nr_setting_manual:visible"
			},
			local_area_code: {
				digits: true
			},
			odt: {
				digits: true
			},
			odt_empty_dad: {
				digits: true
			},
			'ports[]': {
				atLeastOnePort: true,
			},
			monitored_sip_peer_offtime: {
				digits: true,
			},
			addit_options: {
				checkManual: true
			}
		}
	});

    $("#isdn_oad_setting").change(function () {
        required();
    });

    function required() {
        if ($("#isdn_oad_setting").prop("selectedIndex") == 1) {
            addAsterisk("country_code");
            addAsterisk("city_code");
        } else {
            deleteAsterisk("country_code");
            deleteAsterisk("city_code");
        }
    }

    function ovelapdial_show(val) {
        if (val) {
            $(".odt_empty_dad_tr").hide();
            $(".odt_tr").hide();
        } else {
            $(".odt_empty_dad_tr").show();
            $(".odt_tr").show();
        }
    }


    $(document).ready(function () {
        required();
        ovelapdial_show(document.getElementById('overlap_dialing').checked);
        $('input[name="group"]').focus();
        $('[data-toggle="tooltip"]').tooltip({placement: 'auto bottom', html: true, trigger: 'hover', container: 'body'});
    });

	$('#isdn-tab a').click(function (e) {
        e.preventDefault();
        $(this).tab('show');
    });

	$('#isdn-tab a').on('hide.bs.tab', function (e) {
		var valid = true;
		var tab=e.target.getAttribute('href');
		$(tab).find("input").each(function() {
			if (!validator.element(this) && valid) {
				valid = false;
			}
		});
		$(tab).find("select").each(function() {
			if (!validator.element(this) && valid) {
				valid = false;
			}
		});
		if (!valid)
			e.preventDefault();
	});
</script>

<?php
$config_values = array("ec", "ectl", "dton", "isdn_oad_setting", "from_pstn_src_setting", "oton", "screen", "pres", "isdn_oad2_setting",
	"clir_on_oad", "bearer_cap", "cd", "isdn_qsigname_setting", "isdn_redirected_nr_setting", "isdn_dad_setting");

if ($ba->get('gui_mode') == 'simple')
	$simple_class = 'simple';
?>
<div>

	<!-- Nav tabs -->
	<ul class='nav nav-tabs' role='tablist' id='isdn-tab'>
		<li role='presentation' class='active'><a href='#settings' aria-controls='settings' role='tab' data-toggle='tab'>Settings</a></li>
		<?php	if ($simple_class != 'simple') { ?> <li role='presentation'><a href='#config-string' aria-controls='config-string' role='tab' data-toggle='tab'>More</a></li> <?php } ?>
	</ul>
	<form name='isdn' id='isdn' action='modules/Isdn/isdn_submit.php?opt=<?php echo $_GET['opt']; ?>' method='POST' class='form-horizontal'>
		<div class='tab-content'>
			<div role='tabpanel' class='tab-pane active' id='settings' style='padding-top:15px;'>
				<div class='form-group group' data-toggle='tooltip' title='<?php echo ISDN_GROUP_NAME; ?>'>
					<label for='group' class='col-sm-3 control-label'><?php echo PSTN_NAME_DIS; ?></label>
					<div class='col-sm-8'>
						<input name='group' id='group' class='form-control input-sm' type='text' value='<?php echo $_GET['gr']; ?>'>
					</div>
				</div>
				<div class='form-group ports[]'>
					<label for='ports[]' class='col-sm-3 control-label'><?php echo PSTN_PORTS_DIS; ?></label>
					<div class='col-sm-8'>
						<div class='left'>
							<div> <?php echo HelperPstn::title($ba, $_GET['gr'], 0); ?></div>
							<div> <?php echo HelperPstn::ports($ba, $_GET['gr'], 0, "isdn"); ?></div>
						</div>
						<div class='left' style='margin-left:50px;'>
							<div> <?php echo HelperPstn::title($ba, $_GET['gr'], 1); ?></div>
							<div> <?php echo HelperPstn::ports($ba, $_GET['gr'], 1, "isdn"); ?></div>
						</div>
						<?php if (Helper::getType() == 30) { ?>
						<div class='left' style='margin-left:50px;'>
							<div> <?php echo HelperPstn::title($ba, $_GET['gr'], 2); ?></div>
							<div> <?php echo HelperPstn::ports($ba, $_GET['gr'], 2, "isdn"); ?></div>
						</div>
						<?php } ?>
					</div>
				</div>
				<div class='form-group chansel <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo PSTN_CHANSEL; ?>'>
					<label for='chansel' class='col-sm-3 control-label'><?php echo PSTN_CHANSEL_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'chansel', 'isdn',
							array('standard' => 'standard', 'random' => 'random', 'roundrobin' => 'roundrobin')); ?></div>
					</div>
				</div>
				<div class='form-group chansel_dir <?php echo $simple_class; ?>'>
					<label for='chansel_dir' class='col-sm-3 control-label'><?php echo PSTN_CHANSEL_DIR_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'chansel_dir', 'isdn',
							array('ascending' => 'ascending', 'descending' => 'descending')); ?></div>
					</div>
				</div>
				<div class='form-group tones <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_TONES; ?>'>
					<label for='tones' class='col-sm-3 control-label'><?php echo PSTN_TONES_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::tones($ba, $_GET['gr'], 'isdn'); ?></div>
					</div>
				</div>
				<div class='form-group odt_tr <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_ODT; ?>'>
					<label for='odt' class='col-sm-3 control-label'><?php echo PSTN_ODT_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'odt', 'isdn', '3'); ?></div>
					</div>
				</div>
				<div class='form-group odt_empty_dad_tr <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_ODT_EMPTY_DAD; ?>'>
					<label for='odt_empty_dad' class='col-sm-3 control-label'><?php echo PSTN_OVERLAPDIAL_TIMEOUT_EMPTY_DAD_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'odt_empty_dad', 'isdn', '15'); ?></div>
					</div>
				</div>
				<div class='form-group overlap_dialing <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_OVERLAPDIALING; ?>'>
					<label for='overlap_dialing' class='col-sm-3 control-label'><?php echo PSTN_OVERLAP_DIALING_DIS; ?></label>
					<div class='col-sm-8 form-checkbox'>
						<div> <?php echo HelperPstn::checkbox($ba, $_GET['gr'], 'overlap_dialing', 'isdn',
							"onchange='ovelapdial_show(this.checked)'"); ?></div>
					</div>
				</div>
				<div class='form-group qsig <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_QSIG; ?>'>
					<label for='qsig' class='col-sm-3 control-label'><?php echo PSTN_QSIG_SUPPORT_DIS; ?></label>
					<div class='col-sm-8 form-checkbox'>
						<div> <?php echo HelperPstn::checkbox($ba, $_GET['gr'], 'qsig', 'isdn'); ?></div>
					</div>
				</div>
				<div class='form-group restart_after_link_loss <?php echo $simple_class; ?>'>
					<label for='restart_after_link_loss' class='col-sm-3 control-label'><?php echo PSTN_RESTART_AFTER_LINK_LOSS_DIS; ?></label>
					<div class='col-sm-8 form-checkbox'>
						<div> <?php echo HelperPstn::checkbox($ba, $_GET['gr'], 'restart_after_link_loss', 'isdn'); ?></div>
					</div>
				</div>
				<div class='form-group portpullup <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_PORTPULLUP; ?>'>
					<label for='portpullup' class='col-sm-3 control-label'><?php echo PSTN_PORTPULLUP_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'portpullup', 'isdn',
							array('0' => 'Nothing', '1' => 'Pull Link Up (2s)', '2' => 'Pull Link Up (once)')); ?></div>
					</div>
				</div>
				<div class='form-group country_code <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_COUNTRY_CODE; ?>'>
					<label for='country_code' class='col-sm-3 control-label'><?php echo PSTN_COUNTRY_CODE_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'country_code', 'isdn', $ba->get('international_code')); ?></div>
					</div>
				</div>
				<div class='form-group city_code <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_CITY_CODE; ?>'>
					<label for='city_code' class='col-sm-3 control-label'><?php echo PSTN_CITY_CODE_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'city_code', 'isdn', $ba->get('national_code')); ?></div>
					</div>
				</div>
				<div class='form-group local_area_code <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_LOCAL_AREA_CODE; ?>'>
					<label for='local_area_code' class='col-sm-3 control-label'><?php echo PSTN_LOCAL_AREA_CODE_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'local_area_code', 'isdn'); ?></div>
					</div>
				</div>
				<div class='form-group pcmlaw <?php echo $simple_class; ?>'>
					<label for='pcmlaw' class='col-sm-3 control-label'><?php echo PSTN_PCMLAW_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'pcmlaw', 'isdn',
							array('default' => 'default', 'alaw' => 'alaw', 'ulaw' => 'ulaw')); ?></div>
					</div>
				</div>
				<div class='form-group dialtone_digits <?php echo $simple_class; ?>'>
					<label for='dialtone_digits' class='col-sm-3 control-label'><?php echo PSTN_DIALTONE_DIGITS_DIR_DIS; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'dialtone_digits', 'isdn', '0'); ?></div>
					</div>
				</div>
				
				<div class='form-group portpullup <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo PSTN_MONITORED_SIP_PEER_TOOLTIP; ?>'>
					<label for='monitored_sip_peer' class='col-sm-3 control-label'><?php echo PSTN_MONITORED_SIP_PEER; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::sip_peer_dropdown($ba, $_GET['gr'], 'monitored_sip_peer'); ?></div>
					</div>
				</div>
				
				<div class='form-group monitored_sip_peer_offtime <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo PSTN_MONITORED_SIP_PEER_TOOLTIP; ?>'>
					<label for='monitored_sip_peer_offtime' class='col-sm-3 control-label'><?php echo PSTN_MONITORED_SIP_PEER_OFFTIME; ?></label>
					<div class='col-sm-8'>
						<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'monitored_sip_peer_offtime', 'isdn', '0'); ?></div>
					</div>
				</div>
				
			</div>
			<div role='tabpanel' class='tab-pane' id='config-string' style='padding-top:20px;'>
				<div class="row t38 dtmfmode srtp_mode codecs <?php echo $simple_class; ?>">
					<p class="lead text-center"><?php echo DIALPLAN_CONFIGURATION_DIS; ?></p>
				</div>
				<div class='form-group ec <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo EC; ?>'>
					<label for='ec' class='col-sm-3 control-label'><?php echo DIALPLAN_EC_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo ec($ba); ?>
					</div>
				</div>
				<div class='form-group ec_tail <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo EC_TAIL; ?>'>
					<label for='ec_tail' class='col-sm-3 control-label'><?php echo DIALPLAN_EC_TAIL_LENGTH_DIS; ?></label>
					<div class='col-sm-8 form-checkbox'>
						<?php echo ec_tail($ba); ?>
					</div>
				</div>
				<div class='form-group bearer_cap <?php echo $simple_class; ?>'>
					<label for='bearer_cap' class='col-sm-3 control-label'><?php echo DIALPLAN_BEARER_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo bearer_cap($ba); ?>
					</div>
				</div>
				<div class='form-group cd <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo CD; ?>'>
					<label for='cd' class='col-sm-3 control-label'><?php echo DIALPLAN_CALL_DEFLECTION_DIS; ?></label>
					<div class='col-sm-8 form-checkbox'>
						<?php echo cd($ba); ?>
					</div>
				</div>
				<div class='form-group clir_on_oad_tr <?php echo $simple_class; ?>'>
					<label for='clir_on_oad' class='col-sm-3 control-label'><?php echo DIALPLAN_CLIR_ON_OAD_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo clir_on_oad($ba, 'isdn'); ?>
					</div>
				</div>
				<div class='form-group isdn_qsigname_setting <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_QSIGNAME_SETTING; ?>'>
					<label for='isdn_qsigname_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_ISDN_QSIGNAME_SETTING_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo caller_id_mapping_pstn($ba, 'isdn_qsigname_setting'); ?>
					</div>
				</div>
				<div class='form-group isdn_redirected_nr_setting <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_REDIRECTED_NR_SETTING; ?>'>
					<label for='isdn_redirected_nr_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_ISDN_REDIRECTED_NR_SETTING_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo caller_id_mapping_pstn($ba, 'isdn_redirected_nr_setting'); ?>
					</div>
				</div>
				<div class='form-group from_pstn_src_setting <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo FROM_PSTN_SRC_SETTING; ?>'>
					<label for='from_pstn_src_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_FROM_PSTN_SRC_SETTING_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo from_pstn_src_setting($ba, 'isdn'); ?>
					</div>
				</div>

				<div class="row isdn_dad_setting dton <?php echo $simple_class; ?>">
					<p class="lead text-center"><?php echo ISDN_DAD_SETTING_LABEL; ?></p>
				</div>
				<div class='form-group isdn_dad_setting <?php echo $simple_class; ?>'>
					<label for='isdn_dad_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_ISDN_DAD_SETTING_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo callee_id_mapping_pstn($ba, 'isdn_dad_setting'); ?>
					</div>
				</div>
				<div class='form-group dton <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo DTON; ?>'>
					<label for='dton' class='col-sm-3 control-label'><?php echo DIALPLAN_DTON_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo tons($ba, 'dton'); ?>
					</div>
				</div>
				<div class="row isdn_oad_setting oton isdn_oad2_setting screen pres <?php echo $simple_class; ?>">
					<p class="lead text-center"><?php echo ISDN_OAD_SETTING_LABEL; ?></p>
				</div>
				<div class='form-group isdn_oad_setting <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_OAD_SETTING; ?>'>
					<label for='isdn_oad_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_ISDN_OAD_SETTING_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo caller_id_mapping_pstn($ba, 'isdn_oad_setting'); ?>
					</div>
				</div>
				<div class='form-group oton <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo OTON; ?>'>
					<label for='oton' class='col-sm-3 control-label'><?php echo DIALPLAN_OTON_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo tons($ba, 'oton'); ?>
					</div>
				</div>
				<div class='form-group isdn_oad2_setting <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_OAD2_SETTING; ?>'>
					<label for='isdn_oad2_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_ISDN_OAD2_SETTING_DIS; ?></label>
					<div class='col-sm-8'>
						<?php echo caller_id_mapping_pstn($ba, 'isdn_oad2_setting'); ?>
					</div>   
				</div>
				<div class='form-group screen <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo SCREENING; ?>'>
					<label for='screen' class='col-sm-3 control-label'><?php echo DIALPLAN_SCREENING_DIS; ?></label>
					<div class='col-sm-8 form-checkbox'>
						<?php echo screen($ba); ?>
					</div>
				</div>
				<div class='form-group pres <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo PRES; ?>'>
					<label for='pres' class='col-sm-3 control-label'><?php echo DIALPLAN_PRESENTATION_DIS; ?></label>
					<div class='col-sm-8 form-checkbox'>
						<?php echo pres($ba); ?>
					</div>
				</div>
				<div class="row failover_proxy failover_timeout <?php echo $simple_class; ?>">
					<p class="lead text-center"><?php echo DIALPLAN_OTHER_DIS; ?></p>
				</div>
				<div class='form-group addit_options <?php echo $simple_class; ?>'  data-toggle='tooltip' title='<?php echo ADDIT_OPTIONS; ?>'>
					<label for='addit_options' class='col-sm-3 control-label'><?php echo DIALPLAN_ADDITIONAL_CONFIG_DIS; ?></label>
					<div class='col-sm-8'>
						<textarea name='addit_options' id='addit_options' class='form-control' rows='5'></textarea>
					</div>
				</div>
				<div class='form-group addit_options <?php echo $simple_class; ?>'>
					<label for='extra_tooltip' class='col-sm-3 control-label'><?php echo DIALPLAN_ADDITIONAL_CONFIG_DOC_DIS; ?></label>
					<div class='col-sm-8'>
						<p id='extra_tooltip' class='form-control-static' style='height: 170px; overflow: auto; border: 1px solid #A31D26; resize:both;'></p>
					</div>
				</div>
				<div class="clearfix"></div>
			</div>
		</div>
		<div class='text-center'><i><?php echo REQUIRED_FIELDS; ?></i></div>
		<?php
		if (isset($_GET['gr'])) {
			HelperPstn::showdefmc($config_values, 'i', 'isdn');
		} else {
			HelperPstn::show_confadd($config_values, 'i');
		}
		?>
		<br/>
		<input type='hidden' name='gr_upd' value='<?php echo $_GET['gr']; ?>'>
		<div class='text-center'>
			<input name='submit' class='btn btn-default' type='submit' value='<?php echo BUTTON_SAVE; ?>' >
		</div>
	</form>
</div>


