<?php

/**
 * Implementiert die CRUD Operationen für ISGW Causes
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class IsgwCauses {

	private		$m_attr,
			$q_attr,
			$start_attr,
			$order_attr,
			$sort_attr;

	private		$post_attr,
			$post_checked = 0;

	private 	$isRequestRejected = 0,
			$reasonRejected = array();

        function __construct($m, $get = array(), $post = array(), $session = array()) {

		// set index php page
		$this->m_attr = $m;

		// check GET variable
                $this->q_attr 	  = isset($get['q']) 	 ? Helper::sanitizeGet($get['q']	, 'q'	 ) : 0;
                $this->start_attr = isset($get['start']) ? Helper::sanitizeGet($get['start']	, 'start') : 0;
                $this->order_attr = isset($get['order']) ? Helper::sanitizeGet($get['order']	, 'order') : 0;
                $this->sort_attr  = isset($get['sort'])  ? Helper::sanitizeGet($get['sort']	, 'sort' ) : 0;

		// get error from modal or submit execution
		if (isset($get['error'])) {
                        $this->isRequestRejected = 1;
                        $this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
			unset($get['error'], $get['request'], $get['checkor'], $get['key']);
		}

		// check POST
		if (isset($post['save']) || isset($post['rest'])) {
			unset($post['m']);

			$list_post = array('rest' => 'select', 'save' => 'bool', 'causes' => 'bool'); 

			$list_options_select = array('rest' => array('Load default', 'Standardeinstellungen laden')); // TODO: rework the class to generalize with BUTTON_LOAD_DEF 
		
			$this->post_checked = 1;
			$this->post_attr = Helper::sanitizePost($post, $list_post, $this->post_checked, $this->reasonRejected, $list_options_select);

			$this->isRequestRejected = !$this->post_checked;
		}
	}


    /*
     * Funktion display erzeugt den Inhalt von der HTML-Seite
	* @return string HTML Inhalt
     */

	function display() {

		$ba = new beroAri();
		$is_sbc_vm = $ba->get('is_sbc_vm') == 1;

		$m = $this->m_attr;
		$q = $this->q_attr;
		$start = $this->start_attr;
		$order = $this->order_attr;
		$sort = $this->sort_attr;

		include "./includes/functions.php";
		$functions = new functions();

		$name = "ISGW_CAUSES_TITLE_DIS";
		include('./includes/header.php');

		// Restore default causes
		if ($this->post_checked && isset($this->post_attr['rest'])) {
			if (!is_dir("/usr/conf/backup")) {
				Helper::mkdir($is_sbc_vm, "/usr/conf/backup");
			}
			Helper::copy($is_sbc_vm, "/usr/conf/isgw.causes", "/usr/conf/backup/isgw.causes");
			Helper::unlink($is_sbc_vm, "/usr/conf/isgw.causes");

			include_once('/usr/local/php/include/restore.Class.php');
			$restore = new restoreConfig(0, $ba);
			if (!$restore->isgwcauses()) {
				Helper::copy($is_sbc_vm, "/usr/conf/backup/isgw.causes", "/usr/confisgw.causes");
				$ret .= "<div class='text-center' style='margin-top:5px;color:red;'>". ISGW_CAUSES_ERROR_LOADING_DEFAULT ."</div>\n"; 
			}
			else {
				require_once "/usr/local/www/berogui/includes/isgwtelnet.php";
				$isgw = new isgwtelnet();
				$result = $isgw->isgw_login();
				$isgw->isgw_causesmapreload();
			}
		}
		else if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

        $causes_table = $this->dynamic_table($ba);
        $ret .= "<script>
					function del(table,id){
						conf = confirm('" . ISGW_CAUSES_DELETE_MESSAGE_DIS . "?');
						if (conf==false)
							return false;
						else
							window.location='./misc/delete.php?m=".$this->m_attr."&id='+id+'&table='+table;
					}
				 </script>
				 <div class='modal fade bs-example-modal-lg' id='causes-popup' tabindex='-1' role='dialog' aria-labelledby='myModalLabel' aria-hidden='true'>
				  <div class='modal-dialog modal-lg'>
				    <div class='modal-content'>
				      <div class='modal-header'>
					<button type='button' class='close' data-dismiss='modal' aria-label='Close'><span aria-hidden='true'>&times;</span></button>
					<h4 class='modal-title' id='myModalLabel'>CAUSES MAP</h4>
				      </div>
				      <div class='modal-body'>
				      </div>
				    </div>
				  </div>
				</div>
					<form name='isgw_causes' action='' method='POST' >
					<input type=hidden name=m value='" . $m . "'>
					<br>
					<div class='container table-responsive'>
					" . $causes_table .
                "</div>"
			. "<br>"
			. "<div class='text-center'>"
			. "<a href='modules/IsgwCauses/causes_popup.php' role='button' data-remote='false' data-toggle='modal' data-target='#causes-popup' class='btn btn-default'>"
			.  BUTTON_ADD . "</a>&nbsp;"
			. "<input name='rest' type='submit' class='btn btn-default' value='" . BUTTON_LOAD_DEF . "' onclick='javascript:return confirm(\"". ISGW_CAUSES_CONFIRM_LOAD_DEFAULT ."\");'>"
			. "</div>"
			. "</form>"
			. "<script>
			$('#causes-popup').on('show.bs.modal', function(e) {
				var link = $(e.relatedTarget);
				$('.modal-body').load(link.attr('href'));
			});
		</script>";

        //Erzeugung der Navigationsleiste.
        $query = $ba->select('SELECT * FROM isgw_causes');
        $record_count = sqlite_num_rows($query);
        $url_opts = array();
        $url_opts['sort'] = $sort;
        $url_opts['order'] = $order;
        $ret .= "<div class='text-center'>" . 
			$functions->displayNavigationBlock($m, $q, $url_opts, $start, $span, $record_count) .
			"</div>";

        //Rückgabe: Inhalt der HTML-Seite
        return $ret;
    }

    /**
     * Liefert die HTML Tabelle mit dein ISGW Causes
	 * @return HTML Tabelle
     */

    function dynamic_table($ba) {
        if ($this->post_checked && isset($this->post_attr['save']) && isset($this->post_attr['causes'])) {
            $ba->set("causes_active", $this->post_attr['causes']);
            $table.=Helper::activate(2, true, $this->m_attr, ACTIVATE);
        }

        require_once("./includes/lang.php");

        $columns = $ba->column_type('isgw_causes');
        $i = 0;
        foreach ($columns as $column => $type) {
            if (($column != 'id') && ($column != 'sip_response_message')) {
                $cols_name[$i] = $column;
                if ($column == "direction")
                    $column = ISGW_CAUSES_CALL_DIRECTION_DIS;
                if ($column == "to_cause")
                    $column = ISGW_CAUSES_TO_CAUSE_DIS;
                if ($column == "from_cause")
                    $column = ISGW_CAUSES_FROM_CAUSE_DIS;
                $cols .= "<th>" . $column . "</th>";
                $i++;
            }
        }

        $start = $this->start_attr;
        $page = (($start / 15) + 1);
        if (!$start)
            $start = 0;
        $id = 0;
        for ($j = 1; $j <= $page; $j++) {
            $query = $ba->select('SELECT * FROM isgw_causes ORDER BY id asc limit 15 offset ' . sqlite_escape_string($start));
            $rows = '';
            while ($entry = $ba->fetch_array($query)) {
                $rows .= "<tr>";
                $count = sqlite_num_fields(defined('PHP_VERSION_ID') ? $entry : $query);

                $entry['sip_response_message'] = str_replace("\r\n", "<br>", $entry['sip_response_message']);
                $dir = preg_split("/-/", $entry['direction']);
                if ($entry['sip_response_message'] != "") {
                    $rows .= "<td onmouseover=\"Tip('" . $entry['sip_response_message'] . "')\" onmouseout='UnTip()'>" . $entry['direction'] . "</td>";
                    $rows .= "<td onmouseover=\"Tip('" . $entry['sip_response_message'] . "')\" onmouseout='UnTip()'>" . $entry['from_cause'] . " (" . $dir[0] . ")</td>";
                    $rows .= "<td onmouseover=\"Tip('" . $entry['sip_response_message'] . "')\" onmouseout='UnTip()'>" . $entry['to_cause'] . " (" . $dir[1] . ")</td>";
                } else {
                    $rows .= "<td>" . $entry['direction'] . "</td>";
                    $rows .= "<td>" . $entry['from_cause'] . " (" . $dir[0] . ")</td>";
                    $rows .= "<td>" . $entry['to_cause'] . " (" . $dir[1] . ")</td>";
                }
                $id = $entry['id'];
                $rows .= "<td class='buttons'>
					<a href='modules/IsgwCauses/causes_popup.php?id=" . $entry['id'] . "' data-remote='false' data-toggle='modal' data-target='#causes-popup' class='popup_download'>
					<img src='./includes/images/modify.png' onmouseover=\"Tip('" . MOD_ISGW_CAUSES_MODIFY . "')\" onmouseout='UnTip()'>
				</a>
				&nbsp;
				<a class='popup_download' onclick=\"del('isgw_causes','" . $id . "');\">
            	    <img src='./includes/images/delete.png' onmouseover=\"Tip('" .
                        MOD_ISGW_CAUSES_DELETE . "')\" onmouseout='UnTip()'>
				</a>

				</td></tr>";
            }
        }
        $table = "<table class='table table-striped table-bordered' style='max-width:700px; margin:auto;' id='table'><tr>" . $cols . "<th></th></tr>" . $rows . "</table>";

        return $table;
    }

}

?>
