<?php

/**
 * Implementiert den App-Market und die Installation und Deinstallation von Apps
 * @author Miguel Palmer <mp@beronet.com>
 * @author Florian Kraatz <fk@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class Market {

	/**
	 * @var beroConf 
	 */
	private 	$_ba;

	private 	$m_attr,
			$get_attrs;

	private		$isRequestRejected = 0,
			$reasonRejected = array();

	function __construct ($m, $get = array(), $post = array(), $session = array()) {
		$this->m_attr = $m;
		$this->_ba = new beroAri();

		// the GET inputs are checked during the process
		$this->get_attrs = $get; 

                // get error from modal or submit execution
		if (isset($get['error'])) {
			$this->isRequestRejected = 1;
			$this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
			unset($get['error'], $get['request'], $get['checkor'], $get['key']);
		}
	}

	/**
	 * Lädt eine App hoch
	 * @param string $image_dir
	 * @param boolean $show
	 * @return string HTML Code
	 */
    function upload($image_dir, $show) {
        //Alte Dateien löschen, die sich in dem $image_dir befinden
        if (is_dir($image_dir) && ($dh = opendir($image_dir))) {
            while (($file = readdir($dh)) != false) {
                if ((strlen($file) > 7 && substr_compare($file, ".tar.gz", -7, 7) == 0) || $file == "content.txt") {
                    $file_ = $image_dir . '/' . $file;
                    if (strlen($file_) != 0 && file_exists($file_)) {
						unlink($file_);
					}
				}
            }
        }

        if (substr_compare($_FILES['userfile']['name'], ".tar.gz", -7, 7) == 0) {
            $upload_file = $image_dir . '/' . basename($_FILES['userfile']['name']);
            if ((filesize($_FILES['userfile']['tmp_name']) / 1024) / 1024 > 7.9) {
                $ret.= "<div class='text-center'><h3>Error:</h3><b>" . UPDATE_TOOL_ERROR_SIZE_DIS . "!</b></div>";
            } else {
                if (move_uploaded_file($_FILES['userfile']['tmp_name'], $upload_file)) {
                    $file = basename($_FILES['userfile']['name']);
                    $ret = "<div class='text-center' id='update'><h5>" . UPDATE_TOOL_MESSAGE_INSTALL_DIS . "</h5>"
                            . "<div><h3>" . UPDATE_TOOL_QUESTION_INSTALL_DIS . " <span style='color:red;'>" . $file . "</span>?</h3></div>"
                            . "<div><h5>(" . UPDATE_TOOL_INFO_INSTALL_DIS . ").</h5></div>"
                            . "<div><a href='index.php?m=market'><b>" . UPDATE_TOOL_NO_DIS . "</b></a> "
                            . "<a style='cursor:pointer;' href='#' onclick='link(\"index.php?m=".$this->m_attr."&action=do_install&file=$file\");' ><b>" . UPDATE_TOOL_YES_DIS . "</b></a></div>"
                            . "</div>";
                    $show = false;
                } else {
                    $ret.= '<div class="text-center">' . UPDATE_TOOL_ERROR_FAILED_DIS . '!</div>';
                }
            }
        } else {
            $ret.= '<div class="text-center">' . UPDATE_TOOL_ERROR_FILE_EXTENSION_DIS . '!<br/>' . UPDATE_TOOL_ERROR_FAILED_DIS . '!</div>';
        }
        $result['show'] = $show;
        $result['html'] = $ret;
        return $result;
    }

	/**
	 * Installiert eine hochgeladene App
	 * @param string $image_dir
	 * @return string
	 */
    function install($image_dir) {
        $file = $this->get_attrs['file'];
        if (strlen($file) != 0 && file_exists($image_dir . '/' . $file)) {
            $ret.= '<div id="log"><p><b>Install log:</b></p>';
            $ret.= '<pre>';
            exec("/usr/sbin/userapp_pkg_install.sh " . addcslashes($file, "()") . " ", $retval);
            foreach ($retval as $key => $value)
                $ret.=$value . "<br/>";
            $ret.= '</pre><div><br />';
        }
        return $ret;
    }

	private function _display_app_space () {

		exec('df | grep /home/admin | awk \'{ print $2; }\'', $out_all);
		$all = $out_all[0];
		unset($out_all);

		exec('df | grep /home/admin | awk \'{ print $3; }\'', $out_used);
		$used = $out_used[0];
		unset($out_used);

		$percent_used = round(($used * 100) / $all);

		$ret =	'<table style="border-style: none; border-spacing: 0px; border-collapse: collapse; margin-left: auto; margin-right: auto; max-width: 95%;"' .
			'width=\"95%\">' . "\n" .
			'<tr><th style="border: none;" colspan="100">' . MARKET_INSTALLED_DISKSPACE_TBL_HEAD . '</th></tr>' . "\n" .
			'<tr>' ."\n";

		for ($i = 1; $i <= 100; $i++) {
			$style = 'background-color: ' . (($i <= $percent_used) ? 'red' : 'green') . '; border: none; color: black; font-size: 3px; height: 5px; width: 2px;';
			$ret .= '<td style="' . $style . '">&nbsp;</td>' . "\n";
		}

		$ret .=	'</tr>' . "\n" .
			'<tr>' .
			'<td colspan="25" style="background-color: transparent; border: none; text-align: left;">0%</td>' .
			'<td colspan="50" style="background-color: transparent; border: none; text-align: center;">' .
			$percent_used . '% ' . MARKET_INSTALLED_DISKSPACE_TBL_USED . ' (' . number_format(round($used/1024, 2), 2) . '/' .
			number_format(round($all/1024, 2), 2) . ' MB)' .
			'</td>' .
			'<td colspan="25" style="background-color: transparent; border: none; text-align: right;">100%</td>' .
			'</tr>' . "\n" .
			'</table>' . "\n";

		return($ret);
	}

	private function _display_app_mounts () {

		if (!($dh = @opendir('/apps/'))) {
			return('');
		}

		while ($sub = readdir($dh)) {

			if (($sub == '.') || ($sub == '..')) {
				continue;
			}

			if ($sub_fs = @file('/apps/' . $sub . '/etc/fstab')) {

				foreach ($sub_fs as $line) {
					if ($line[0] == '#') {
						continue;
					}

					$field = explode('\t', $line);

					exec('/bin/mount | grep ' . $field[0], $tmp, $mounted);

					$rows .=	'<tr>' .
							'<td>' . $field[0] . '</td>' .
							'<td>/apps/' . $sub . $field[1] . '</td>' .
							'<td>' . $field[2] . '</td>' .
							'<td>' . ($mounted == 0 ? UPDATE_TOOL_YES_DIS : UPDATE_TOOL_NO_DIS) . '</td>' .
							'</tr>' . "\n";
				}
			}
		}

		if (empty($rows)) {
			return('');
		}

		closedir($dh);

		$ret =	'<br />' . "\n" .
			'<table class="table table-striped table-bordered" width="95%">' . "\n" .
			'<tr style="background-color: rgb(235,223,223);">' .
			'<th colspan="4">' . MARKET_SETTINGS_SHARES_TBL_HEAD. '</th>' .
			'</tr>' . "\n" .
			'<tr style="background-color: rgb(240,240,236);">' .
			'<td><b>' . MARKET_SETTINGS_SHARES_TBL_REMOTE . '</b></td>' .
			'<td><b>' . MARKET_SETTINGS_SHARES_TBL_LOCAL . '</b></td>' .
			'<td><b>' . MARKET_SETTINGS_SHARES_TBL_TYPE . '</b></td>' .
			'<td><b>' . MARKET_SETTINGS_SHARES_TBL_MOUNT . '</b></td>' .
			'</tr>' . "\n" .
			$rows .
			'</table>' . "\n";

		return($ret);
	}

    	private function _display_tabs ($bc) {

		$apps_enabled = $bc->get('root', 'userapp-enabled');
		$apps_installed = Helper::getAppList();

		$ret =	"\n\n" . '<!-- BEGIN TABS //-->' . "\n\n" .
			'<div id="tabs" class="">' . "\n" .
			'<ul>' . "\n" .
			((count($apps_installed)>0) ? '<li><a href="#tabs-1">' . MARKET_TAB1_TITLE_DIS . '</a></li>' . "\n" : '') .
			(($apps_enabled == '1') ? '<li><a href="#tabs-2">' . MARKET_TAB2_TITLE_DIS . '</a></li>' . "\n" : '') .
			'<li><a href="#tabs-3">' . MARKET_TAB3_TITLE_DIS . '</a></li>' . "\n" .
			'</ul>' . "\n" .
			((!empty($apps_installed)) ? $this->_display_tab1() : '') .
			(($apps_enabled == '1') ? $this->_display_tab2() : '') .
			$this->_display_tab3($apps_enabled) .
			'</div>' .
			"\n\n" . '<!-- END TABS //-->' . "\n\n";

		return($ret);
	}

	private function _display_tab1 () {

		$ret =	"\n\n" . '<!-- BEGIN TAB1 //-->' . "\n\n" .
			'<div id="tabs-1">' . "\n" .
			'<table class="table table-striped table-bordered" id="table" style="max-width:400px; margin:auto;">' . "\n";
		$apps=  Helper::getAppList();
		foreach ($apps as $file){
			$ret .= '<tr><td>' . $file . '</td><td><img src="./includes/images/delete.png" onclick="del(\'' . $file . '\');" /></td></tr>' . "\n";
		}

		$ret .= '</table>' . "\n" .
			'<br />' . "\n" .
			$this->_display_app_space() .
			'</div>' . "\n";

		return($ret);
	}

	private function _display_tab2 () {

		$ret =	"\n\n" . '<!-- BEGiN TAB2 //-->' . "\n\n" .
			'<div id="tabs-2">' . "\n" .
			'<div class="apps" style="overflow-x:hidden;"></div>' . "\n" .
			'<br />' . "\n" .
			'<div class="text-center"><input id="get_app" class="btn btn-default" type="button" value="' . BUTTON_GET_APP_LIST . '" /></div>' . "\n" .
			'<br />' . "\n" .
			'<div class="text-center">' . MARKET_OR_DIS . '</div>' . "\n" .
			'<br />' . "\n";

		$image_dir = '/tmp/images';
		@mkdir($image_dir);
		$show = true;
		switch ($_GET['action']) {
		case 'upload':
                	$upload = $this->upload($image_dir, $show);
                	$show = $upload['show'];
                	$ret.=$upload['html'];
                	break;
		case 'do_install':
                	system('ps ax|grep -v grep|grep userapp_pkg_install.sh > /dev/null', $retval);
			if ($retval != 0) {
				$ret .= $this->install($image_dir);
			}
			break;
		}

		if ($show != true) {
			return($ret . '</div>' . "\n");
		}

		if (!is_dir($image_dir) || !($dh = @opendir($image_dir))) {
			$ret.= "<div class='text-center'><h3>Error:</h3><b>" . UPDATE_TOOL_ERROR_READ_DIS . " $image_dir!</b></div>\n";
		} else {
			$ret.=	'<form enctype="multipart/form-data" action="index.php?m='.$this->m_attr.'&action=upload" method="POST">'
				. '<div class="row">'
					. '<div class="col-lg-2 col-lg-offset-2">'
						. '<label for="userfile">' . UPDATE_TOOL_IMAGE_FILE_DIS . '</label>'
					. '</div>'
					. '<div class="col-lg-4">'
						. '<input name="userfile" type="file" onmouseover=\'Tip("' . UPDATE_TOOL_FILE . '")\' onmouseout="UnTip()"/>'
						. '<input type="hidden" name="MAX_FILE_SIZE" value="52428800" />'
					. '</div>'
					. '<div class="col-lg-2">'
						. '<input type="submit" class="btn btn-default" value="' . BUTTON_UPLOAD_FILE . '" onclick="document.getElementById(\'wait_div\').style.display=\'block\';" onmouseover=\'Tip("' . UPDATE_TOOL_UPLOAD . '")\' onmouseout="UnTip()"/>'
					. '</div>'
				. '</div>'
				. '</form>';
		}

		return($ret . '</div>' . "\n");
	}

	private function _display_tab3 ($enabled) {

		$ret =	"\n\n" . '<!-- BEGIN TAB3 //-->' . "\n\n" .
			'<div id="tabs-3">' . "\n" .
			$activate .
			'<form enctype="multipart/form-data" action="modules/Market/market_submit.php" method="POST">' . "\n" .
			'<table class="table table-striped table-bordered" id="table" style="max-width:400px; margin:auto;">' . "\n" .
			'<tr><th colspan="2" class="text-center">' . MARKET_SETTINGS_TABLE_HEADER_DIS . '</th></tr>' . "\n" .
			'<tr>' .
			'<td style="font-weight: bold;">' . MARKET_SETTINGS_ENABLE_DIS . ':</td>' .
			'<td><input type="checkbox" id="userapp-enabled" name="userapp-enabled" value="1" ' . (($enabled == '1') ? 'checked="checked" ' : '') . '/></td>' .
			'</tr>' . "\n" .
			'<tr>' .
			'<td colspan="2" class="text-center">' .
			'<input name="submit" class="btn btn-default" type="submit" value="' . BUTTON_SAVE . '" />' .
			'</td>' .
			'</tr>' . "\n" .
			'</table>' . "\n" .
			'</form>' . "\n" .
			(($enabled == 1) ? $this->_display_app_mounts() : '') .
			'</div>' . "\n";

		return($ret);
	}

    function display() {
        $m = $this->m_attr;

        $name="MARKET_TITLE_DIS";
        include('./includes/header.php');
        require_once("./includes/lang.php");

	if ($this->isRequestRejected) {
		$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
	}

	## check the userappfs version from the updated rootfs
	$userappfs = file_get_contents('/pkginfo/VERSION.userappfs');
	if (preg_match('/PKG_VERSION=([0-9]+)/', $userappfs, $userappfs_vers)) {
		if (defined('PHP_VERSION_ID') && $userappfs_vers[1] == 7) {
			$ret .= "<div class='text-center' style='margin-top: 30px; margin-bottom: 20px;'><font style='color: red;'>". MARKET_WARNING_UPDATE_DIS ."</font></div>\n";
			return $ret;
		}
	}

	$bc = new beroConf('root');

        // build page content
        $ret .= "<br /><br />
			<script>
                        function link(link) {
                            $('#wait_div').fadeIn(2000);
                            $( '#update' ).load( link+' #log',  function() {
                                $('#wait_div').fadeOut(300);
                                getInstalled();
                            });
                        }
				$(function() {
					$( \"#tabs\" ).tabs({active:1});
				});
				</script>";

	$ret .= '<div class="demo" style="width: 100%;">' . "\n" .
		$this->_display_tabs($bc) .
		'</div>' . "\n";

	$ret .= "<script>
			$(\"#get_app\").click(function() {
				document.getElementById(\"wait_div\").style.display=\"block\";
			$.ajax({
				  url: \"modules/Market/market_ajax.php\",
				  type: \"POST\",
				  data: {a : \"get_app\"},
				  cache: false
				}).done(function( html ) {
				  $(\".apps\").html(html);
				  document.getElementById(\"wait_div\").style.display=\"none\";
			});
			});
			function install() {
			var param='';
				$('.installApp').each(function () {
					if (this.checked) {
						if (param=='') {
							param=this.value;
						}else{
							param+=','+this.value;
						}
					}
				});
				document.getElementById(\"wait_div\").style.display=\"block\";
				$.ajax({
				  url: \"modules/Market/market_ajax.php\",
				  type: \"POST\",
				  data: {param : param},
				  cache: false
				}).done(function( html ) {
					$(\"#tabs-1\").html(html);
					$.ajax({
					  url: \"modules/Market/market_ajax.php\",
					  type: \"POST\",
					  data: {menu : \"get\"},
					  cache: false
					}).done(function( html ) {
						window.location.reload();
					});
			});
			}
			function getInstalled() {
				$.ajax({
				  url: \"modules/Market/market_ajax.php\",
				  type: \"POST\",
				  data: {get_installed : \"get\"},
				  cache: false
				}).done(function( html ) {
					$(\"#tabs-1\").html(html);
					$.ajax({
					  url: \"modules/Market/market_ajax.php\",
					  type: \"POST\",
					  data: {menu : \"get\"},
					  cache: false
					}).done(function( html ) {
						$(\"#ajax_apps\").html(html);
					});

			});
			}
			function del(param) {
				conf = confirm('" . MARKET_DELETE_MESS1_DIS . " '+param+'?');
				if (conf == true){
					document.getElementById(\"wait_div\").style.display=\"block\";
					$.ajax({
					  url: \"modules/Market/market_ajax.php\",
					  type: \"POST\",
					  data: {del_param : param},
					  cache: false
					}).done(function( html ) {
						$(\"#tabs-1\").html(html);
						$.ajax({
						  url: \"modules/Market/market_ajax.php\",
						  type: \"POST\",
						  data: {menu : \"get\"},
						  cache: false
						}).done(function( html ) {
							$(\"#ajax_apps\").html(html);
						});

						location.reload();
				});
				}else{
					return false;
				}
			}
			</script>";
        require_once("./includes/lang.php");

        //Rückgabe: Inhalt der HTML-Seite
        return $ret;
    }

}

?>
