<?php

/**
 * Einstellungen die unter keine andere Kategorie passen.
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class Miscellaneous {

	private		$m_attr,
			$reload_attr;

	private		$post_attr,
			$post_checked = 0;

	private		$isRequestRejected = 0,
			$reasonRejected = array();

	/**
	 * Constructor
	 */
	function __construct($m, $get = array(), $post = array()) {
		$this->m_attr = $m;

		$this->reload_attr = isset($get['reload']);

		if ($post['action'] == 'save') {
			// clean post
			unset($post['m'], $post['a'], $post['action'], $post['submit']);

			// check post
			$list_post = array('experimental_options' => 'config-option', 'international_code' => 'international-code', 'national_code' => 'int>=0', 'reject_calls_under_load' => 'bool', 'emergency_numbers' => 'int-piped');

			$this->post_checked = 1;
			$this->post_attr = Helper::sanitizePost($post, $list_post, $this->post_checked, $this->reasonRejected);

			$this->isRequestRejected = !$this->post_checked;
		}
	}

	/**
	 * @return string HTML code
	 */
	function _display_tabs($ba)
	{
		$showTab2 = false;
		$tab2 = $this->_display_tab2($ba, null, $showTab2);
		$html_str =	"<br/>\n<br/>\n"
							.	"<script>\n"
              .	"\t$(function() {\n" 
							.	"\t\t$( '#tabs' ).tabs({active:0})\n"
							.	"\t});\n"
							.	"</script>\n"
							. "<!-- BEGIN TABS //-->\n\n"
							. "<div id='tabs' class=''>\n"
							. "\t<ul>\n"
							.	"\t\t<li><a href='#tabs-1'>". MISCELLANEOUS_TABLE_HEADER_DIS ."</a></li>\n"
							. ($showTab2 ? "\t\t<li><a href='#tabs-2'>". MISCELLANEOUS_ROOTFS_HEADER_DIS. "</a></li>\n" : '')
							. "\t</ul>\n"
							. $this->_display_tab1($ba)
							. $tab2
							.	"\n<!-- END TABS //-->\n"
							. "</div>\n\n";

		return $html_str;
	}

	/**
	 * @return string HTML code
	 */
	function _display_tab1 ($ba)
	{
		$html_str =	"\n\n" . '<!-- BEGIN TAB1 //-->' . "\n\n" .
				'<div id="tabs-1">' . "\n";

		ob_start();
		?>
		<form name='miscellaneous' id='misc-form' class = "form-horizontal" action='' style="margin-top: 15px;" method='POST'>
			<input type=hidden name=m value='<?php echo $this->m_attr ?>'>
			<input type=hidden name=a value='save'>
			<div class='form-group'>
				<label for='experimental_options' class='col-sm-5 control-label'><?php echo MISCELLANEOUS_EXPERIMENTAL_OPTIONS_DIS ?></label>
				<div class='col-sm-4'>
					<input type='text' class='form-control' id='experimental_options' name='experimental_options' 
						   value='<?php echo $ba->get("experimental_options") ?>'>
				</div>
			</div>
			<div class='form-group'>
				<label for='reject_calls_under_load' class='col-sm-5 control-label'><?php echo MISCELLANEOUS_REJECT_CALLS_UNDER_LOAD_DIS ?></label>
				<div class='col-sm-4 form-checkbox'>
					<?php echo $this->reject_calls_under_load($ba) ?>
				</div>
			</div>
			<div class='form-group' data-toggle='tooltip' title='<?php echo ISDN_COUNTRY_CODE; ?>'>
				<label for='international_code' class='col-sm-5 control-label'><?php echo DIALPLAN_SIP_INTERNATIONAL_CODE_DIS ?></label>
				<div class='col-sm-4'>
					<input type='text' class='form-control' id='international_code' name='international_code' value='<?php echo $ba->get("international_code") ?>'>
				</div>
			</div>
			<div class='form-group' data-toggle='tooltip' title='<?php echo ISDN_CITY_CODE; ?>'>
				<label for='national_code' class='col-sm-5 control-label'><?php echo DIALPLAN_SIP_NATIONAL_CODE_DIS ?></label>
				<div class='col-sm-4'>
					<input type='text' class='form-control' id='national_code' name='national_code' value='<?php echo $ba->get("national_code") ?>'>
				</div>
			</div>
			<div class='form-group' data-toggle='tooltip' title='<?php echo MISCELLANEOUS_EMERGENCY_NUMBERS; ?>'>
				<label for='emergency_numbers' class='col-sm-5 control-label'><?php echo SIP_EMERGENCY_NUMBERS ?></label>
				<div class='col-sm-4'>
					<input type='text' class='form-control' id='emergency_numbers' name='emergency_numbers' value='<?php echo $ba->get("emergency_numbers") ?>'>
				</div>
			</div>
			<div class='text-center'>
				<input type='hidden' name='action' value='save'>
				<input name='submit' class='btn btn-default'  type='submit' value='<?php echo BUTTON_SAVE ?>' >
			</div>
		</form>
		<script type='text/javascript'>
			function show_tr_adminPass() {
				if ($('#userapp-enabled').is(':checked'))
					$('#admin-pass').css('display', '');
				else
					$('#admin-pass').css('display', 'none');
			}
			$('#userapp-enabled').change(function () {
				show_tr_adminPass();
			});
			$(document).ready(function () {
				show_tr_adminPass();

				$("#misc-form").validate({
					rules: {
						emergency_numbers: {
							checkIntPiped: true
						},
						experimental_options: {
							checkManual: true
						},
						international_code: {
							required: true,
							checkPhoneNumber: true
						},
						national_code: {
							required: true,
							digits: true
						},
					},
					highlight: function (element) {
						$(element).closest('.form-group').addClass('has-error');
					},
					unhighlight: function (element) {
						$(element).closest('.form-group').removeClass('has-error');
					}
				});
			});
		</script>
		<?php

		$html_str .= 	ob_get_clean() . "\n" .
				'</div>' . "\n";		

		return $html_str; 
	}

	/**
	 * Tab to manage rootfs space.
	 * aka, move php-cgi from mtdblock5 to mtdblock7
	 */
	private function _display_tab2($ba, $bc = null, &$showTab = null) {
		/* [THIS PART SHOULD BE REMOVED IN FUTURE BEROGUI ... aka, $ba and $bc loaded only one time]*/
		if (is_null($bc)) {
			require_once('/usr/fallback/beroConf.php');
			$bc = new beroConf('root');
		}
		/* */
		if (preg_match('/freeing_rootfs=1/', $ba->get('experimental_options')) || strlen($bc->get('root', 'rootfs-notenough-space'))) {
			$showTab = true;
			return($this->_displayManageRootfsFreeing($bc, $ba));
		}
		else if (preg_match('/restoring_rootfs=1/', $ba->get('experimental_options')) || $bc->get('root', 'downgrading-required') == 1) {
			$showTab = true;
			return($this->_displayManageRootfsRestoreOld($bc, $ba));
		}
		return('');
	}

	private function _displayManageRootfsFreeing($bc, $ba, $toMove = 'mvToMtd7', $toCheck = 'checkMtd7') {
		// php-cgi already moved to mtdblock7. other issue (should not happen)
		if (file_exists('/home/admin/bin/php-cgi')) {
			$bc->delete('root', 'rootfs-notenough-space');
			$ba->removeExperimentalOptions('freeing_rootfs=1');
			ob_start();
			?>
			<div id='tabs-2'>
				<p class='text-center lead' style='margin-top:20px'><?php echo MISCELLANEOUS_ROOTFS_SPACE_FREED_DIS; ?></p>
			</div>
			<?php
		}
		// move php-cgi from mtdblock5 to mtdblock7
		else {
			$info_message = strlen($bc->get('root', 'rootfs-notenough-space')) ? MISCELLANEOUS_FREEING_ROOTFS_SPACE_DIS : MISCELLANEOUS_CLEANING_ROOTFS_SPACE_DIS;
			ob_start();
			?>
			<div id='tabs-2'>
				<p class="text-center lead" style='font-size:16px;'><?php echo $info_message; ?></p>
				<div class="text-center">
					<input type='button' id='rootfsbtn' class='btn btn-default' style='margin-top:5px;' value='<?php echo FACTORY_RESET_APPLY; ?>'>
				</div>
	<?php echo $this->_ajaxManageRootfs($toMove, $toCheck, MISCELLANEOUS_ROOTFS_WAITING_MESSAGE, MISCELLANEOUS_ROOTFS_REBOOT_MESSAGE); ?>
				<script>
					$('#rootfsbtn').click(function() {
						manageRootfs('<?php echo $toMove; ?>');
					});
				</script>
			</div>
			<?php
		}
		return(ob_get_clean());
	}

	private function _displayManageRootfsRestoreOld($bc, $ba, $toMove = 'mvToMtd5', $toCheck = 'checkMtd5') {
		// php-cgi already restored to mtdblock5.
		if (!is_link('/usr/bin/php-cgi') && file_exists('/usr/bin/php-cgi')) {
			$bc->delete('root', 'downgrading-required');
			$ba->removeExperimentalOptions('restoring_rootfs=1');
			ob_start();
			?>
			<div id='tabs-2'>
				<p class='text-center lead' style='margin-top:20px'><?php echo MISCELLANEOUS_OLDROOTFS_RESTORED_DIS; ?></p>
			</div>
			<?php
		}
		// move php-cgi from mtdblock7 to mtdblock5
		else {
			ob_start();
			?>
			<div id='tabs-2'>
				<p class="text-center lead" style='font-size:16px;'><?php echo MISCELLANEOUS_RESTORE_OLDROOTFS_DIS; ?></p>
				<div class="text-center">
					<input type='button' id='rootfsbtn' class='btn btn-default' style='margin-top:5px;' value='<?php echo FACTORY_RESET_APPLY; ?>'>
				</div>
	<?php echo $this->_ajaxManageRootfs($toMove, $toCheck, MISCELLANEOUS_ROOTFS_WAITING_MESSAGE, MISCELLANEOUS_ROOTFS_REBOOT_MESSAGE); ?>
				<script>
					$('#rootfsbtn').click(function() {
						manageRootfs('<?php echo $toMove; ?>');
					});
				</script>
			</div>
			<?php
		}
		return(ob_get_clean());
	}

	private function _ajaxManageRootfs($toMove, $toCheck, $waiting, $reboot) {
		ob_start();
		?>
		<script>
			var ajaxCall;
			function manageRootfs(action) {
				$('#ajaxErrors').html('');
				if (action == '<?php echo $toMove; ?>') {
					// display waiting message
					$('#wait_div').html('<p><?php echo $waiting; ?></p><br/><img src="./includes/images/waitlogo1.gif"/>');
					document.getElementById('wait_div').style.display = 'block';
				}
				$.ajax({
					cache: false,
					data: {action:action},
					error: function(response, thrown) {
						var res = JSON.parse(response);
						$('#ajaxErrors').html(res.error);
						$('#ajaxErrors').css('color', 'red');
						document.getElementById('wait_div').style.display = 'none';
					},
					success: function(response) {
						if (action == '<?php echo $toCheck; ?>') {
							var res = JSON.parse(response);
							if (res.state == 'waiting') {
								// do nothing
								return;
							}
							else if (res.state == 'failed') {
								// display error message
								clearInterval(ajaxCall);
								$('#ajaxErrors').html(res.error);
								$('#ajaxErrors').css('color', 'red');
								document.getElementById('wait_div').style.display = 'none';
								return;
							}
							else if (res.mustReboot == '1') {
								// display reboot message
								clearInterval(ajaxCall);
								$('#wait_div').html('<p><?php echo $reboot; ?></p><br/><img src="./includes/images/waitlogo1.gif"/>');
								setInterval(setRequest, 10000);
								return;
							}
							// php-cgi moved and gui accessible. reloading the page
							window.location.reload();
						}
						else if (action == '<?php echo $toMove; ?>') {
							ajaxCall = setInterval(function() {
								manageRootfs('<?php echo $toCheck; ?>');
							}, 10000);
						}
						return;
					},
					timeout: 5000,
					type: 'POST',
					url: 'modules/Miscellaneous/miscellaneous_ajax.php',
				});
			}
		</script>
		<?php
		return(ob_get_clean());
	}

	/**
	 * Funktion display erzeugt den Inhalt von der HTML-Seite
	 * @return string HTML code
	 */
	function display() {

		$name = "MISCELLANEOUS_TITLE_DIS";
		include('./includes/header.php');
		require_once("./includes/lang.php");

		$ba = new beroAri();

		if ($this->reload_attr) {
			$this->reload_sip_license();
		}

		//Save changes
		if ($this->post_checked) {
			$option = 1;
			if (isset($this->post_attr['experimental_options'])) {
				if ($this->post_attr['emergency_numbers'] != $ba->get("emergency_numbers"))
					$option = 2;
				if ($this->post_attr['experimental_options'] != $ba->get("experimental_options"))
					$option = 3;
				$ba->set("experimental_options", sqlite_escape_string($this->post_attr["experimental_options"]));
				$ba->set("international_code", sqlite_escape_string($this->post_attr["international_code"]));
				$ba->set("national_code", sqlite_escape_string($this->post_attr["national_code"]));
				$ba->set("reject_calls_under_load", sqlite_escape_string($this->post_attr['reject_calls_under_load']));
				$ba->set("emergency_numbers", sqlite_escape_string($this->post_attr['emergency_numbers']));
			}

			$ret .= Helper::activate($option, true, $this->m_attr, ACTIVATE);
		}
		else if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

		//Return: Site content
		$ret .= $this -> _display_tabs($ba);
		return $ret;
	}

	/**
	 * Generates the checkbox reject calls under load
	 * @return string
	 */
	function reject_calls_under_load($ba) {
		$option = $ba->get("reject_calls_under_load");
		if ($option == "1") {
			$checked = "checked";
		}
		ob_start();
		?>
		<input type='hidden' name='reject_calls_under_load' value='0'>
		<input type='checkbox' name='reject_calls_under_load' value='1' <?php echo $checked ?>>
		<?php
		return ob_get_clean();
	}
}
?>
