<?php
require_once('/usr/local/www/berogui/includes/Helper/Helper.php');

/* [INTERN FUNCTIONS] */
/**
 * Function checking if php-cgi successfully moved to mtdblock7
 */
function doCheck($ba) {
	require('/usr/fallback/beroConf.php');
	$bc = new beroConf('root');
	$response = array();
	// php-cgi successfully moved
	if (strlen($bc->get('root', 'rootfs-phpcgi-success'))) {
		$response = array('state' => 'success');
		$bc->delete('root', 'downgrading-required');
		$ba->removeExperimentalOptions('freeing_rootfs=1');
		$ba->removeExperimentalOptions('restoring_rootfs=1');
		// check if rootfs-notenough-space warning is displayed
		// if true, reboot in update mode and decrease the PKG_VERSION values
		if (strlen($bc->get('root', 'rootfs-notenough-space'))) {
			$response['mustReboot'] = 1;
			$bc->set('root', 'boot_fwupdate', '1');
			$bc->delete('root', 'rootfs-phpcgi-success');
			$bc->delete('root', 'rootfs-notenough-space');
			Helper::exec(0, '/bin/mount -o remount,rw /');
			foreach (glob('/pkginfo/VERSION.*') as $file) {
				Helper::exec(0, "/bin/sed -i 's/PKG_VERSION=.*/PKG_VERSION=1/g' $file");
			}	
			Helper::exec(0, '/bin/mount -o remount,ro /');
			Helper::exec(0, '/sbin/reboot > /dev/null 2>&1 &');
		}
	}
	// moving php-cgi still in progress
	else {
		$response = array('state' => 'waiting');
		// moving php-cgi failed. probably not enough free space in mtdblock7
		if (($error = $bc->get('root', 'rootfs-phpcgi-failed')) != '') {
			if (preg_match('/^(.*):(.*):([0-9]+)$/', $error, $matched)) {
				$response = array('error' => constant($matched[1]).'<br/>'.constant($matched[2]).'<br/>('.round($matched[3] * 0.001, 1).'MB)', 'state' => 'failed');
			}
			else if (preg_match('/^(.*):(.*)$/', $error, $matched)) {
				$response = array('error' => constant($matched[1]).'<br/>'.constant($matched[2]), 'state' => 'failed');
			}
			else {
				$response = array('error' => constant($error), 'state' => 'failed');
			}
		}
	}
	return(Helper::jsonEncode($response));
}

/**
 * Function to move php-cgi from mtdblock5 (/) to mtdblock7 (/home/admin)
 */
function mvPhpCgi($action) {
	$response = array('state' => 'success');
	Helper::exec(0, "/bin/bash /usr/local/setup/manage_rootfs.sh php$action > /dev/null 2>&1 &");
	return(Helper::jsonEncode($response));
}

/* [MAIN] */
require('/usr/local/www/berogui/misc/database.php');
$ba = new beroAri();

include('/usr/local/www/berogui/includes/lang.php');
switch ($_POST['action']) {
	// mtd5 -> mtd7
	case 'checkMtd7':
		echo(doCheck($ba));
		break;
	case 'mvToMtd7':
		if (file_exists('/home/admin/bin/php-cgi')) {
			$ba->removeExperimentalOptions('freeing_rootfs=1');
			die(Helper::jsonEncode(array('error' => HOMEADMIN_PHPCGI_FILE_EXISTS))); 
		}
		echo(mvPhpCgi('Mtd7'));
		break;
	// mtd7 -> mtd5
	case 'checkMtd5':
		echo(doCheck($ba));
		break;
	case 'mvToMtd5':
		if (!is_link('/usr/bin/php-cgi') && file_exists('/usr/bin/php-cgi')) {
			$ba->removeExperimentalOptions('restoring_rootfs=1');
			die(Helper::jsonEncode(array('error' => ROOTFS_PHPCGI_FILE_EXISTS)));
		}
		echo(mvPhpCgi('Mtd5'));
		break;
	default:
		die(Helper::jsonEncode(array('error' => MISCELLANEOUS_AJAX_UNKNOWN_ACTION)));
}

exit(0);
?>
