<?php
$berogui = '/usr/local/www/berogui'; 
require_once("$berogui/includes/Helper/Helper.php");
require_once("$berogui/includes/Helper/HelperHtml.php");

class NetConf {

	private $_m = null;

	private $_data 				= array(),
					$_parameters 	= array();

	private $_tabs = array(
						'1' => array(
							'display'	=> '_displayNetworkSettingsTab',
							'form'		=> array(
								'action'			=> 'saveNwSettings',
								'has-required'=> true,
								'id'					=> 'id_nwsettings_form',
								'name' 				=> 'nwsettings',
								'style'				=> 'margin-top:15px;',
							),
							'key'			=> 'network-settings',
							'title' 	=> 'NETWORK_TABLE_HEADER_DIS',
						),
						'2'	=> array(
							'display'	=> '_displayAdvancedSettingsTab',
							'form'		=> array(
								'action'			=> 'saveNwAdvanced',
								'has-required'=> true,
								'id'					=> 'id_nwadvanced_form',
								'name' 				=> 'nwadvanced',
								'style'				=> 'margin-top:15px;',
							),
							'key'			=> 'advanced-settings',
							'title' 	=> 'NETWORK_ADVANCED_TABLE_HEADER_DIS',
						),
						'3'	=> array(
							'display'	=> '_displayHttpsSettingsTab',
							'form'		=> array(
								'action'			=> 'saveNwHttps',
								'has-required'=> false,
								'id'					=> 'id_nwhttps_form',
								'name' 				=> 'nwhttps',
								'style'				=> 'margin-top:15px;',
							),
							'key'			=> 'https-settings',
							'title'		=> 'HTTPS_TABLE_HEADER_DIS',
						),
						'4'	=> array(
							'display'	=> '_displayNwtsTab',
							'form'		=> array(
								'action'			=> 'saveNwTs',
								'has-required'=> true,
								'id'					=> 'id_nwts_form',
								'name' 				=> 'nwtsform',
								'style'				=> 'margin-top:15px;',
							),
							'key'			=> 'ntws-settings',
							'title' 	=> 'NWTS_TABLE_HEADER_DIS',
						),
					);

	private $_rejectReason 	= '',
					$_successLevel	= '';	

	private $_isRequestRejected 	= 0,
					$_isRequestSuccessful	= 0;

	private $_isAdvanced		= 0,
					$_isSbcVm 			= 0,
					$_isVpnRunning 	= 0;

	/* [CONSTRUCTOR] */
	function __construct($m, $get = array(), $post = array(), $session = array()) {
		$this->_m = $m;

		if (isset($get['error'])) {
			$this->_isRequestRejected = 1;
			$this->_rejectReason = $get['error'] == 1 ? $get : $get['error'];
		}
		else if (isset($get['success'])) {
			$this->_isRequestSuccessful = 1;
			$this->_successLevel = $get['success'];
		}

		require_once('/usr/fallback/beroConf.php');
		$bc = new beroConf('root');
		if (!$bc->valid()) {
			$this->_isRequestRejected = 1;
			$this->_rejectReason = 1; 
			return;
		}
		$this->_isSbcVm = $bc->get('root', 'is-sbc-vm') == 1 ? 1 : 0;
		$this->_isVpnRunning = $bc->get('root', 'is-vpn-running') == 1 ? 1 : 0;

		$this->_parameters = require('/usr/local/www/berogui/modules/NetConf/netconf_parameters.php');
		if ($this->_isSbcVm) {
			// update parameters values
			$parameters = require('/usr/local/www/berogui/modules/NetConf/netconf_parameters_sbcvm.php');
			$this->_parameters = $parameters['update']($this->_parameters, $this->_isVpnRunning);
			// remove the advanced and https tab
			unset($this->_tabs[2], $this->_tabs[3]);
		}
		foreach ($this->_parameters as $key => $param) {
			if ($param['getData']) {
				$value = $bc->get('root', $param['db-key']);
				$this->_data[$key] = strlen($value) > 0 ? $value : $param['default'];
			}
		}
		// in DHCP mode, get ipaddr / netmask 
		foreach (array('lan' => $this->_data['lanMode'] == 'bonding' ? 'eth0' : 'eth0.10', 'wan' => 'eth0.11') as $iface => $iface_v) {
			if ($this->_data["{$iface}Dhcp"] == 1) {
				$this->_data["{$iface}Ipaddr"] = Helper::getNetworkIpAddr($iface_v);
				$this->_data["{$iface}Netmask"] = Helper::getNetworkMask($iface_v);
			}
		}
		// migration from old configuration: from =< 20.05.X to >= 21.01
		if (is_null($this->_data['gatewayMode'])) {
			$this->_data = $this->_migrateDb($this->_data);
		}
		// an error occured during the switching LAN-Mode ajax request.
		// the page get reloaded with the wanted LAN-Mode
		if (isset($get['mode']) && in_array($get['mode'], array_keys($this->_parameters['lanMode']['options']['select']))) {
			$this->_data['lanMode'] = $get['mode'];
		}
		unset($get, $post);
	}

	/* [PUBLIC METHODS] */
	public function display() {
		$name = "NETWORK_TITLE_DIS";
		include('./includes/header.php');
		include_once('./includes/lang.php');
		$ret .= "\n";

		// get GUI-Mode (should not occur here and should be given as argument / same for the lang)
		if (!$this->_isAdvanced = Helper::getGuiMode(null) == 'advanced') {
			unset($this->_tabs[2]);
		}

		$tabs = "";
		$tabs_menu = "";
		foreach ($this->_tabs as $id => $tab) {
			$tabs_menu .= "\t\t<li><a href='#tabs-$id'>". constant($tab['title'])  ."</a></li>\n";

			$function = $tab['display'];
			$tab['form']['uri'] = 'NetConf/netconf_submit.php';
			$tabs .= $this->$function($id, $tab['form'], "\t");
		}

		$msg = 	($this->_isRequestRejected ? $this->_setError() : '')
					.	($this->_isRequestSuccessful ? $this->_setSuccess() : '');

		$ret .= HelperHtml::buildTabs('tabs', $msg, $tabs_menu, $tabs);

		return $ret;
	}

	public function displayNetworkSettingsJavascript($full = true, $tab = '') {
		return $this->_javascriptNetworkSettings($full);
	}

	public function ifacesConfiguration($mode, $tab = '') {
		return $this->_ifacesConfiguration($mode, $tab);
	}

	/* [PRIVATE METHODS] */
	private function _displayAdvancedSettingsTab($id, $form, $tab = "") {
		$vlan = '';
		$java_validator = array('lanMtu');
		if ($this->_data['lanPorts'] != 2) {
			$java_validator[] = 'vlanId';
			$vlan = $this->_settingsVlan("$tab\t\t");

		}
		// build content
		$content['main-form'] = $this->_settingsAdvanced("$tab\t\t")
													. $vlan
													. HelperHtml::buttons('saveAdvanced', 'BUTTON_SAVE', null, "$tab\t\t");
		// return tab
		return HelperHtml::tab($id, $form, null, $content, array_intersect_key($this->_parameters, array_flip($java_validator)), $tab);
	}

	private function _displayHttpsSettingsTab($id, $form, $tab = "") {
		// build javascript
		ob_start();
		?>
		<script type="text/javascript">
		</script>
		<?php
		$javascript = ob_get_clean() ."\n";
		// build content
		$content['main-form'] = $this->_settingsHttps("$tab\t\t")
													. HelperHtml::buttons('saveHttps', 'BUTTON_SAVE', null, "$tab\t\t");
		// return tab
		return HelperHtml::tab($id, $form, $javascript, $content, null, $tab);
	}

	private function _displayNetworkSettingsTab($id, $form, $tab = "") {
		// init: build both ifacesConfiguration (only on sbc) and get network mode
		$param = array(
			0 => array('single', 'lan-wan'),
			1 => $this->_isVpnRunning ? array('lan-wan') : array('single'),
		);
		$ifaces = array();
		foreach ($param[$this->_isSbcVm] as $mode) {
			$ifaces[$mode] = $this->_ifacesConfiguration($mode, "$tab\t\t\t");
		}
		$is_lan_wan_mode = $this->_data['lanMode'] === 'lan-wan';
		// build javascript
		$javascript = $this->_javascriptNetworkSettings(true);
		// build content
		$content = array('main-form' => '', '2nd-form' => '');
		//// display select mode
		if ($this->_data['lanPorts'] == 2) {
			$content['main-form'] .= $this->_displayParameters(array('lanMode'), "$tab\t\t");
		}
		//// display ifaces configuration, nameserver, hostame
		$param = array(
			0 => array('gatewayMode', 'gatewayManual', 'nameserverMode', 'nameserverManual', 'hostname', 'checkDns'),
			1 => array(),
		);
		$content['main-form'] .= 	HelperHtml::section('id_ifaces', $is_lan_wan_mode ? $ifaces['lan-wan'] : $ifaces['single'], null, "$tab\t\t")
														.	$this->_displayParameters($param[$this->_isSbcVm], "$tab\t\t")
														. ($this->_isSbcVm ? '' : HelperHtml::buttons('saveNwSettings', 'BUTTON_SAVE', null, "$tab\t\t"));
		//// display route table
		if (!$this->_isSbcVm && $this->_isAdvanced) {
			$content['2nd-form'] .= $this->_dynamicTableRoute("$tab\t");
		}
		// return tab
		$param = array(
			0 => array('lanIpaddr', 'lanNetmask', 'wanIpaddr', 'wanNetmask', 'gatewayManual', 'nameserverManual', 'hostname'),
			1 => array(),
		);
		if ($this->_isSbcVm) {
			$form['has-required'] = false;
		}
		return HelperHtml::tab($id, $form, $javascript, $content, array_intersect_key($this->_parameters, array_flip($param[$this->_isSbcVm])), $tab);
	}

	private function _displayNwtsTab($id, $form, $tab = "") {
		// build javascript
		$javascript = $this->_javascriptNwtsTab($form)
								. HelperHtml::validateJavascript($form, array_intersect_key($this->_parameters, array_flip(array('nwts_hostName'))));
		// build content: order the third_column array  as wanted to be shown
		$third_column = array(
			'nwts_hostName'	=> '',
			'nwts_pingHost' => "<div class='col-sm-4 form-checkbox' id='res_pinghost'></div>",
			'nwts_resName'	=> "<div class='col-sm-4 form-checkbox' id='res_resname'></div>",
			'nwts_health'		=> "<div class='col-sm-4 form-checkbox' id='res_health'></div>",
			'nwts_getPubIP'	=> "<div class='col-sm-4 form-checkbox' id='res_pubic'></div>",
		);

		$content = array('main-form' => '');
		foreach (array_keys($third_column) as $param) {
			$parameter = $this->_parameters[$param];
			$parameter['style'] = 'width:1%;';
			$parameter['third-column'] = $third_column[$param];

			$function = $parameter['display'];
			$content['main-form'] .= HelperHtml::$function($param, $this->_data[$param], $parameter, "$tab\t\t");
		}

		$content['main-form'] .=	"$tab\t\t<div id='nwtsWait' class='text-center' style='display:none;'>\n"
														. "$tab\t\t\t<img src='./includes/images/waitlogo1.gif'>\n"
														. "$tab\t\t</div>\n"
														. "$tab\t\t<div id='nwtsButton' class='text-center' style='display:block;'>\n"
														. "$tab\t\t\t<input type='button' id='nwtsTest' class='btn btn-default' value='". BUTTON_TEST ."'>\n"
														. "$tab\t\t</div>\n";
		// return tab
		return HelperHtml::tab($id, $form, $javascript, $content, null, $tab);
	}

	private function _displayParameters($parameters, $tab = "") {
		$html = '';
		if (!empty($parameters)) {
			foreach ($parameters as $param) {
				$parameter = $this->_parameters[$param];
				$function = $parameter['display'];
				$html .= HelperHtml::$function($param, $this->_data[$param], $parameter, $tab);
			}
		}
		return $html;
	}

	private function _dynamicTableRoute($tab = '') {
		// init
		$options = array(
			'action-delete'	=> 'route',
			'btn-add'				=> 'BUTTON_ADD',
			'btn-delete'		=> 'MODAL_ROUTE_DELETE',
			'btn-delete-all'=> 'BUTTON_DELETE',
			'btn-modify'		=> 'MODAL_ROUTE_MODIFY',
			'checkall-id'		=> 'routecheckall',
			'href-id'				=> 'id_route_popup',
			'm'							=> 'NetConf',
			'modal-id'			=> 'routemodal',
			'modal-id-title'=> 'id_routemodal_title',
			'modal-title'		=> 'NETWORK_ROUTE_MODAL_TITLE',
			'msg-delete'		=> 'NETWORK_ROUTE_DELETE_CONFIRM',
			'table-style'		=> 'width:70%;',
			'url-add'				=> 'modules/NetConf/netconf_popup.php?action=addRoute',
			'script-delete'	=> 'netconf_delete.php',
			'url-edit'			=> 'modules/NetConf/netconf_popup.php?action=editRoute',
		);
		// build table
		$header = array(NETWORK_ROUTE_TARGET_DIS, NETWORK_ROUTE_NETMASK_DIS, NETWORK_ROUTE_GATEWAY_DIS);
		$data = array();
		if (strlen($this->_data['routing']) > 0) {
			foreach (array_filter(explode(',', $this->_data['routing'])) as $route) {
				$data[] = explode('/', $route);
			}
		}
		$html = "$tab<hr>\n"
					. "$tab<p class='text-center lead'>". NETWORK_ROUNTING_HEADER_DIS ."</p>\n"
					. HelperHtml::dynamicTable($header, $data, $options, $tab);
		return $html;
	}

	private function _ifaceConfiguration($iface, $tab = "") {
		$param = array("{$iface}Dhcp", "{$iface}Ipaddr", "{$iface}Netmask");
		return $this->_displayParameters($param, $tab);
	}

	private function _ifacesConfiguration($mode, $tab = "") {
		$html = '';
		$lan_tittle = array(
			0 => NETWORK_LAN_SETTING_DIS,
			1 => $this->_isVpnRunning ? NETWORK_LANVPN_SETTINGS_DIS : NETWORK_LAN_SETTING_DIS,
		);
		switch ($mode) {
			// LAN and Ethernet bonding
			case 'bonding':
			case 'single':
				$html .= $this->_ifaceConfiguration($this->_isSbcVm ? 'wan' : 'lan', $tab);
				break;
			case 'lan-wan':
				$html .= 	"$tab\t\t<hr style='width:50%;'>\n"
								.	"$tab\t\t<div class='left' style='width:49%;'>\n"
								. "$tab\t\t<p class='text-center lead'>{$lan_tittle[$this->_isSbcVm]}</p>\n"
								.	$this->_ifaceConfiguration('lan', "$tab\t\t\t")
								. "$tab\t\t</div>\n"
								. "$tab\t\t<div class='right' style='width:49%;'>\n"
								. "$tab\t\t<p class='text-center lead'>". NETWORK_WAN_SETTING_DIS ."</p>\n"
								. $this->_ifaceConfiguration('wan', "$tab\t\t\t")
								. "$tab\t\t</div>\n"
								. "$tab\t\t<div class='clearfix'></div>\n"
								. "$tab\t\t<hr style='width:50%;'>\n";
				break;
			default:
				break;
		}
		return $html;
	}

	private function _migrateDb($data) {
		// set gateway
		if ($data['lanMode'] == 'lan-wan') {
			$data['gatewayMode'] = $data['wanDhcp'] == 0 ? 'manual' : 'eth0.11';
			$data['gatewayManual'] = $data['wanGateway'];
		}	
		else {
			$data['gatewayMode'] = $data['lanDhcp'] == 0 ? 'manual' : 'eth0.10';
			$data['gatewayManual'] = $data['lanGateway'];
		}
		// set default nameserver
		if (strlen($data['nameserverManual']) == 0) {
			$data['nameserverMode'] = $data['lanMode'] == 'lan-wan' ? 'eth0.11' : 'eth0.10';
		}
		else {
			$data['nameserverMode'] = 'manual';
		}
		return $data;
	}

	private function _removeProvidedSelection($isGateway = true) {
		$list = array();
		switch ($this->_data['lanMode']) {
			case 'bonding':
			case 'single':
				$list[] = 'eth0.11';
				if ($this->_data['lanDhcp'] == 0) {
					$list[] = 'eth0.10';
				}	
				else if ($isGateway) {
					$list[] = 'manual';
				}
				break;
			case 'lan-wan':
				if ($this->_data['lanDhcp'] == 0) {
					$list[] = 'eth0.10';
				}
				if ($this->_data['wanDhcp'] == 0) {
					$list[] = 'eth0.11';
				}
				if ($isGateway && $this->_data['lanDhcp'] == 1 && $this->_data['wanDhcp'] == 1) {
					$list[] = 'manual';
				}
				break;
			default:
				return array('eth0.10', 'eth0.11');
		}
		return $list;
	}

	private function _setError() {
		if (is_array($this->_rejectReason)) {
			$error = $this->_rejectReason;
			return Helper::displayErrorMessage($error['request'], $error['checkor'], $error['key']);
		}
		else {
			$error = '';
			switch ($this->_rejectReason['error']) {
				case 1:
					return "<div class='text-center' style='color:red;'>". BEROCONF_ERROR_LOAD ."</div>\n";
				case 2:
					$error = 'HTTPS_INVALID_CERT_ERROR ';
					break;
				case 3:
					$error = 'HTTPS_INVALID_FILE_SIZE';
					break;
				case 4:
					$error = 'HTTPS_INVALID_PRIVKEY_ERROR';
					break;
				case 5:
					$error = 'HTTPS_CERT_PRIVKEY_UNMATCH_ERROR';
				 	break;	
				case 6:
					return "<div class='text-center' style='color:red;'>". NET_CONF_INVALID_GATEWAY_ERROR ."</div>\n";
				default:
					break;
			}
			return "<div class='text-center'><img src='./includes/images/punkt_rot.gif'><font color='black'>". constant($error) ."</font></div>\n";
		}
	}

	private function _setSuccess() {
		switch ($this->_successLevel) {
			case 3:
				return "<div class='text-center' style='color:red;'><strong>". NETWORK_CONFIGURATION_APPLIED_DIS ."</strong></div>\n";
				break;
			case 4:
				return "<div class='text-center'><img src='./includes/images/punkt_gruen.gif'><font color='black'>". HTTPS_CERTIFICATE_UPLOAD_SUCCESS_DIS ."</font></div>\n";
				break;
			default:
				break;
		}
	}

	private function _settingsAdvanced($tab = "") {
		/* Set the array as the wanted displaying order */
		return 	$this->_displayParameters(array('lanMtu', 'beroAvahiEnabled', 'ncsMode'), $tab);
	}

	private function _settingsHttps($tab = "") {
		/* Set the array as the wanted displaying order */
		$html = $this->_displayParameters(array('uploadFile'), "$tab\t");
		if (file_exists("/usr/conf/berofix.pem") && !is_link("/usr/conf/berofix.pem")) {
			$btns[]	= array(
				'javascript' 	=> "window.location.href='misc/files_download.php?option=certificate_https';",
				'value' 			=> 'HTTPS_DOWNLOAD_CERTIFICATE_DIS',
			);
			$btns[] = array(
				'javascript'	=> "if (confirm('". HTTPS_DELETE_CERTIFICATE_MESS_DIS ."?') == true) { window.location.href='misc/deletefile.php?m={$this->_m}&option=certificate_https'; }",
				'value'				=> 'HTTPS_DELETE_CERTIFICATE_DIS',
			);
			$html .= HelperHtml::fieldButtonsInline('HTTPS_CERTIFICATE_DIS', $btns, $tab);
		}
		if (file_exists('/tmp/error_certificate.log')) {
			$html .= $this->_displayParameters(array('errorCert'), $tab);
		}
		$html .= $this->_displayParameters(array('httpsOnly'), "$tab\t");
		return $html;
	}

	private function _settingsVlan($tab = "") {
		if ($this->_data['lanMode'] !== 'single') {
			return '';
		}
		/* Set the array as the wanted displaying order */
		return 	$this->_displayParameters(array('vlanEnable', 'vlanId', 'vlanPrio'), $tab)
					.	$this->_javascriptSettingsVlan();
	}

	/* [JAVASCRIPT CODE] */
	private function _javascriptNetworkSettings($full = true) {
		if ($this->_isSbcVm) {
			ob_start();
			?>
			<script>
				addAsterisk('gatewayMode');
				addAsterisk('nameserverMode');
			</script>
			<?php
			return ob_get_clean() ."\n";
		}
		// build dynamic javascript
		ob_start();
		?>
		<script>
			var lan = ['lanIpaddr', 'lanNetmask'];
			lan.forEach(function(name) { addAsterisk(name); });
			showFieldForm(lan, $('#id_lanDhcp').val() == 0);
			$('#id_lanDhcp').change(function() {
				updateServerModes();
				$('#id_gatewayMode').val($('#id_lanDhcp').val() == 1 ? 'eth0.10' : 'manual').change();
				$('#id_nameserverMode').val($('#id_lanDhcp').val() == 1 ? 'eth0.10' : 'manual').change();
				showFieldForm(lan, $('#id_lanDhcp').val() == 0);
			});
			var wan = ['wanIpaddr', 'wanNetmask'];
			showFieldForm(wan, $('#id_wanDhcp').val() == 0);
			wan.forEach(function(name) { addAsterisk(name); });
			$('#id_wanDhcp').change(function() {
				updateServerModes();
				$('#id_gatewayMode').val($('#id_wanDhcp').val() == 1 ? 'eth0.11' : $('#id_lanDhcp').val() == 1 ? 'eth0.10' : 'manual').change();
				$('#id_nameserverMode').val($('#id_wanDhcp').val() == 1 ? 'eth0.11' : $('#id_lanDhcp').val() == 1 ? 'eth0.10' : 'manual').change();
				showFieldForm(wan, $('#id_wanDhcp').val() == 0);
			});
		</script>
		<?php
		$javascript = ob_get_clean() ."\n";
		if (!$full) {
			return $javascript;
		}
		// build static javascript
		$remove = '';
		foreach (array('gateway' => true, 'nameserver' => false) as $type => $bool) {
			$remove_list = $this->_removeProvidedSelection($boll);
			if (!empty($remove_list)) {
				$remove .= 	"\t\t\t\tvar listRemove = ['". implode("','", $remove_list) ."'];\n"
									.	"\t\t\t\tlistRemove.forEach(function(value) {\n"
									. "\t\t\t\t\t$(\"#id_{$type}Mode option[value='\"+ value +\"']\").remove();\n"
									. "\t\t\t\t});\n";
			}
		}
		ob_start();
		?>
		<script>
			function mustShowManual(param) {
				switch ($('#id_'+ param +'Mode').val()) {
					case "eth0.10":
						return $('#id_lanDhcp').val() == 0;
					case "eth0.11":
						return $('#id_wanDhcp').val() == 0;
					case "manual":
						return true;
					default:
						break;
				}
				return false;
			}
			function updateServerModes(onLoad = false) {
				if (onLoad) {
<?php echo $remove; ?>
					showFieldForm(['gatewayManual'], <?php echo ($this->_data['gatewayMode'] == 'manual' ? 'true' : 'false') ?>);
					requiredAsterisk('gatewayMode', $('#id_gatewayManual').is(':visible'));
					showFieldForm(['nameserverManual'], <?php echo ($this->_data['nameserverMode'] == 'manual' ? 'true' : 'false') ?>);
				}
				else {
					var newOptionsGw = {};
					var newOptionsDns = {};
					if ($('#id_lanDhcp').val() == 1) {
						Object.assign(newOptionsGw, <?php echo Helper::jsonEncode(array_intersect_key($this->_parameters['gatewayMode']['options']['select'], array_flip(array('eth0.10')))); ?>);
						Object.assign(newOptionsDns, <?php echo Helper::jsonEncode(array_intersect_key($this->_parameters['gatewayMode']['options']['select'], array_flip(array('eth0.10')))); ?>);
					}
					if ($('#id_lanMode').val() == 'lan-wan' && $('#id_wanDhcp').val() == 1) {
						Object.assign(newOptionsGw, <?php echo Helper::jsonEncode(array_intersect_key($this->_parameters['gatewayMode']['options']['select'], array_flip(array('eth0.11')))); ?>);
						Object.assign(newOptionsDns, <?php echo Helper::jsonEncode(array_intersect_key($this->_parameters['gatewayMode']['options']['select'], array_flip(array('eth0.11')))); ?>);
					}
					Object.assign(newOptionsGw, <?php echo Helper::jsonEncode(array_intersect_key($this->_parameters['gatewayMode']['options']['select'], array_flip(array('manual')))); ?>);
					Object.assign(newOptionsDns, <?php echo Helper::jsonEncode(array_intersect_key($this->_parameters['gatewayMode']['options']['select'], array_flip(array('manual')))); ?>);
					updateSelectOptions(['id_gatewayMode'], newOptionsGw);
					updateSelectOptions(['id_nameserverMode'], newOptionsDns);
					showFieldForm(['gatewayManual'], mustShowManual('gateway'));
					requiredAsterisk('gatewayMode', $('#id_gatewayManual').is(':visible'));
					showFieldForm(['nameserverManual'], mustShowManual('nameserver'));
				}
			}
			function requiredAsterisk(param, isRequired) {
				if (isRequired) {
					addAsterisk(param);
				}
				else {
					deleteAsterisk(param);
				}
			}
			updateServerModes(true);
			showFieldForm(['lanMtu'], $('#id_lanIpaddr').is(':visible'));
			$('#id_gatewayMode').change(function() {
				showFieldForm(['gatewayManual'], mustShowManual('gateway'));
				requiredAsterisk('gatewayMode', $('#id_gatewayManual').is(':visible'));
			});
			$('#id_nameserverMode').change(function() {
				showFieldForm(['nameserverManual'], mustShowManual('nameserver'));
			});
			$('#id_lanMode').change(function() {
				var mode = $('#id_lanMode').val();
<?php if ($this->_data['vlanId'] != 2) { ?>
				showFieldForm(['vlanEnable'], mode == 'single');
				showFieldForm(['vlanId', 'vlanPrio'], $('#id_vlanEnable').is(':checked'));
<?php } ?>
				$('#id_ifaces').html("<div class='text-center' style='margin-bottom:5px;'><img src='./includes/images/waitlogo1.gif'></div>");
				$.ajax({
					type:"post",
					url:"modules/NetConf/netconf_ajax.php",
					data: {
						mode: mode,
					},
					cache:false,
					success: function (data) {
						$('#id_ifaces').html(data);
						updateServerModes();
						showFieldForm(['lanMtu'], $('#id_lanIpaddr').is(':visible'));
					},
					error: function (textStatus, errorThrown) {
						window.location.href = 'index.php?m=NetConf&mode='+ mode;
					},
					timeout: 1500,
				});
			});
		</script>
		<?php
		$javascript .= ob_get_clean() ."\n";
		return $javascript;
	}

	private function _javascriptNwtsTab($form) {
		ob_start();
		?>
		<script type="text/javascript">
			$(document).ready(function () {
				//if hostname is not validated, disable button
				$('#<?php echo $form['id']; ?> input').bind('keyup blur click', function () {
					if ($('#<?php echo $form['id']; ?>').validate().checkForm()) {
						$('#nwtsTest').removeClass('button_disabled').prop('disabled', false); //enables button
					}
					else {
						$('#nwtsTest').addClass('button_disabled').prop('disabled', true);   //disables button
					}
				});
				$("#nwtsTest").click(function() {
					document.getElementById("nwtsButton").style.display="none";
					document.getElementById("nwtsWait").style.display="block";
					$.ajax({
						type:"post",
						url:"modules/NetConf/ajax_nwts.php",
						data: {
							hostname: $('#id_nwts_hostName').val(),
							pinghost: $('#id_nwts_pingHost').is(':checked'),
							resname: $('#id_nwts_resName').is(':checked'),
							health: $('#id_nwts_health').is(':checked'),
							pubip: $('#id_nwts_getPubIP').is(':checked'),
						},
						cache:false,
						success: function (data) {
							var parts = data.split('|');
							$('#res_pinghost').html(parts[0]);
							$('#res_resname').html(parts[1]);
							$('#res_health').html(parts[2]);
							$('#res_pubic').html(parts[3]);
							document.getElementById("nwtsWait").style.display = "none";
							document.getElementById("nwtsButton").style.display = "block";
						},
						error: function (textStatus, errorThrown) {
							document.getElementById("nwtsWait").style.display = "none";
							document.getElementById("nwtsButton").style.display = "block";
							console.log("Error: " + errorThrown);
						},
						timeout: 30000
					});
					return false;
				});
			});
		</script>
		<?php
		return ob_get_clean() ."\n";
	}

	private function _javascriptSettingsVlan() {
		ob_start();
		?>
		<script>
			showFieldForm(['vlanId', 'vlanPrio'], <?php echo $this->_data['vlanEnable']; ?>);
			$('#id_vlanEnable').click(function() {
				showFieldForm(['vlanId', 'vlanPrio'], $(this).is(':checked'));
			});
		</script>
		<?php
		return ob_get_clean() ."\n";
	}
}
?>
