<?php
$provided_modes = array(
	'eth0.10' => 'NETWORK_PROVIDED_SOURCE_FROMLAN',
	'eth0.11'	=> 'NETWORK_PROVIDED_SOURCE_FROMWAN',
	'manual'	=> 'NETWORK_PROVIDED_SOURCE_MANUAL',
);

$parameters = array(
	// GENERAL
	'gatewayManual'		=> array(
		'cleanOnSubmit'	=> true,
		'db-key'  			=> 'gateway-manual',
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldText',
		'getData'				=> true,
		'miscConf'			=> true,
		'options'				=> null,
		'title'   			=> '',
		'tooltip' 			=> '',
		'validator'			=> 'ip4',
		'validator-java'=> 'verifyIP: true, required: { depends: function(element) { return $("#id_gatewayManual").is(":visible"); } }, matchSubnet: [\'id_gatewayManual\', [\'id_lanIpaddr\', \'id_lanNetmask\'], [\'id_wanIpaddr\', \'id_wanNetmask\']]',
	),
	'gatewayMode' => array(
		'cleanOnSubmit'	=> false,
		'db-key'  			=> 'gateway-mode',
		'default' 			=> null,
		'disabled'			=> false,
		'display' 			=> 'fieldSelect',
		'getData'				=> true,
		'miscConf'			=> 1,
		'options'				=> array(
			'select' => $provided_modes,
		),
		'title'   			=> 'NETWORK_GATEWAY_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'select',
		'validator-java'=> null,
	),
	'hostname'	=> array(
		'cleanOnSubmit'	=> false,
		'db-key' 				=> 'hostname',
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldText',
		'getData'				=> true,
		'miscConf'			=> '',
		'options'				=> null,
		'title'   			=> 'NETWORK_HOSTNAME_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'hostname',
		'validator-java'=> 'checkHostname: true',
	),
	'lanMode'	=> array(
		'cleanOnSubmit'	=> false,
		'db-key' 				=> 'lan-mode',
		'default' 			=> 'single',
		'disabled'			=> false,
		'display' 			=> 'fieldSelect',
		'getData'				=> true,
		'miscConf'			=> 1,
		'options' 			=> array(
			'select' => array(
				'single'	=> 'NETWORK_SETTINGS_LANMODE_SINGLE',
				'lan-wan'	=> 'NETWORK_SETTINGS_LANMODE_LANWAN',
				'bonding'	=> 'NETWORK_SETTINGS_LANMODE_BONDING',
  		),
		),
		'title'   			=> 'NETWORK_LAN_MODE_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'select',
		'validator-java'=> null,
	),
	'nameserverManual'	=> array(
		'cleanOnSubmit'	=> true,
		'db-key' 				=> 'lan-nameserver',
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldText2',
		'getData'				=> true,
		'miscConf'			=> 1,
		'options'				=> null,
		'title'   			=> '',
		'tooltip' 			=> array(
			1 => 'NET_CONF_NAMESERVER',
			2 => 'NET_CONF_SECONDARY_NAMESERVER',
		),
		'validator'			=> 'ip4',
		'validator-java'=> array(
			1 => 'verifyIP: true, required: { depends: function(element) { return $("#id_lanNameserver_1").is(":visible"); } }',
			2 => 'verifyIP: true',
		),
	),
	'nameserverMode' => array(
		'cleanOnSubmit'	=> true,
		'db-key' 				=> 'nameserver-mode',
		'default' 			=> null,
		'disabled'			=> false,
		'display' 			=> 'fieldSelect',
		'getData'				=> true,
		'miscConf'			=> 1,
		'options'				=> array(
			'select' => $provided_modes, 
		),
		'title'   			=> 'NETWORK_DNS_SERVERS_DIS',
		'tooltip'				=> '',
		'validator'			=> 'select',
		'validator-java'=> null,
	),
	'lanPorts' => array(
		'cleanOnSubmit'	=> false,
		'db-key'				=> 'lan-ports',
		'default'				=> 2,
		'disabled'			=> false,
		'display'				=> '',
		'getData'				=> true,
		'miscConf'			=> 1,
		'options'				=> null,
		'title'					=> '',
		'tooltip'				=> '',
		'validator'			=> 'int',
		'validator-java'=> null,
	),
	'checkDns' => array(
		'cleanOnSubmit'	=> false,
		'db-key'				=> 'check-dns',
		'default'				=> false,
		'disabled'			=> false,
		'display'				=> 'fieldCheckbox',
		'getData'				=> true,
		'miscConf'			=> 1,
		'options'				=> null,
		'title'					=> 'NETWORK_ENABLE_DNS_CHECKING_DIS',
		'tooltip'				=> 'NETWORK_ENABLE_DNS_CHECKING_TOOLTIP',
		'validator'			=> 'bool',
		'validator-java'=> null,
	),
	// LAN PARAMETERS
	'lanDhcp'			=> array(
		'cleanOnSubmit'	=> true,
		'db-key'   			=> 'lan-dhcp',
		'default' 			=> 0,
		'disabled'			=> false,
		'display' 			=> 'fieldSelect',
		'getData'				=> true,
		'miscConf'			=> 1,
		'options'				=> array(
			'select'	=> array(
				'0'	=> 'NET_CONF_STATIC',
				'1'	=> 'NET_CONF_DHCP',
			),
		),
		'title'   			=> 'NETWORK_IP_METHOD_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'bool',
		'validator-java'=> null,
	),
	'lanGateway'		=> array(
		'cleanOnSubmit'	=> true,
		'db-key'  			=> 'lan-gateway',
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> null,
		'getData'				=> true,
		'miscConf'			=> 1,
		'options'				=> null,
		'title'   			=> null,
		'tooltip' 			=> null,
		'validator'			=> 'ip4',
		'validator-java'=> null,
	),
	'lanIpaddr'		=> array(
		'cleanOnSubmit'	=> true,
		'db-key' 				=> 'lan-ipaddr',
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldText',
		'getData'				=> true,
		'miscConf'			=> 1,
		'options'				=> null,
		'title'   			=> 'NETWORK_IP_ADDRESS_DIS',
		'tooltip' 			=> 'NET_CONF_IP_ADDRESS',
		'validator'			=> 'ip4',
		'validator-java'=> 'verifyIP: true, required: true',
	),
	'lanNetmask'		=> array(
		'cleanOnSubmit'	=> true,
		'db-key' 				=> 'lan-netmask',
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldText',
		'getData'				=> true,
		'miscConf'			=> 1,
		'options'				=> null,
		'title'   			=> 'NETWORK_NETMASK_DIS',
		'tooltip' 			=> 'NET_CONF_NETMASK',
		'validator'			=> 'ip4',
		'validator-java'=> 'verifyIP: true, required: true',
	),
	// WAN PARAMETERS
	'wanDhcp'		=> array(
		'cleanOnSubmit'	=> true,
		'db-key' 				=> 'wan-dhcp',
		'default' 			=> 1,
		'disabled'			=> false,
		'display' 			=> 'fieldSelect',
		'getData'				=> true,
		'miscConf'			=> 1,
		'options'				=> array(
			'select'	=> array(
				'0'	=> 'NET_CONF_STATIC',
				'1'	=> 'NET_CONF_DHCP',
			),
		),
		'title'   			=> 'NETWORK_IP_METHOD_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'bool',
		'validator-java'=> null,
	),
	'wanGateway'	=> array(
		'cleanOnSubmit'	=> true,
		'db-key'  			=> 'wan-gateway',
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldText',
		'getData'				=> true,
		'miscConf'			=> 1,
		'options'				=> null,
		'title'   			=> null,
		'tooltip' 			=> null,
		'validator'			=> 'ipv4',
		'validator-java'=> null,
	),
	'wanIpaddr'	=> array(
		'cleanOnSubmit'	=> true,
		'db-key' 				=> 'wan-ipaddr',
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldText',
		'getData'				=> true,
		'miscConf'			=> 1,
		'options'				=> null,
		'title'   			=> 'NETWORK_IP_ADDRESS_DIS',
		'tooltip' 			=> 'NET_CONF_IP_ADDRESS',
		'validator'			=> 'ip4',
		'validator-java'=> 'verifyIP: true, required: true',
	),
	'wanNetmask'	=> array(
		'cleanOnSubmit'	=> true,
		'db-key' 				=> 'wan-netmask',
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldText',
		'getData'				=> true,
		'miscConf'			=> 1,
		'options'				=> null,
		'title'   			=> 'NETWORK_NETMASK_DIS',
		'tooltip' 			=> 'NET_CONF_NETMASK',
		'validator'			=> 'ip4',
		'validator-java'=> 'verifyIP: true, required: true',
	),
	// BONDING
	'bondingMode'	=> array(
		'cleanOnSubmit'	=> false,
		'db-key' 				=> 'bonding-mode',
		'default' 			=> '1',
		'disabled'			=> false,
		'display' 			=> null,
		'getData'				=> false,
		'miscConf'			=> 1,
		'options'				=> null,
		'title'   			=> null,
		'tooltip' 			=> null,
		'validator'			=> null,
		'validator-java'=> null,
	),
	'bondingMiimon'	=> array(
		'cleanOnSubmit'	=> false,
		'db-key' 				=> 'bonding-miimon',
		'default' 			=> '100',
		'disabled'			=> false,
		'display' 			=> null,
		'getData'				=> false,
		'miscConf'			=> 1,
		'options'				=> null,
		'title'   			=> null,
		'tooltip' 			=> null,
		'validator'			=> null,
		'validator-java'=> null,
	),
	'bondingUpdelay'	=> array(
		'cleanOnSubmit'	=> false,
		'db-key' 				=> 'bonding-updelay',
		'default' 			=> '200',
		'disabled'			=> false,
		'display' 			=> null,
		'getData'				=> false,
		'miscConf'			=> 1,
		'options'				=> null,
		'title'   			=> null,
		'tooltip' 			=> null,
		'validator'			=> null,
		'validator-java'=> null,
	),
	'bondingDowndelay'	=> array(
		'cleanOnSubmit'	=> false,
		'db-key' 				=> 'bonding-downdelay',
		'default' 			=> '200',
		'disabled'			=> false,
		'display' 			=> null,
		'getData'				=> false,
		'miscConf'			=> 1,
		'options'				=> null,
		'title'   			=> null,
		'tooltip' 			=> null,
		'validator'			=> null,
		'validator-java'=> null,
	),
	// ADVANCED
	'beroAvahiEnabled' => array(
		'cleanOnSubmit'	=> false,
		'db-key' 				=> 'beroAvahi-enabled',
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldCheckbox',
		'getData'				=> true,
		'miscConf'			=> 0,
		'options'				=> null,
		'title'   			=> 'NETWORK_AVAHI_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'bool',
		'validator-java'=> null,
	),
	'lanMtu'			=> array(
		'cleanOnSubmit'	=> false,
		'db-key' 				=> 'lan-mtu',
		'default' 			=> 1500,
		'disabled'			=> false,
		'display' 			=> 'fieldText',
		'getData'				=> true,
		'miscConf'			=> 1,
		'options'				=> array(
			'int-range'	=> array(
				'max'	=> 1500,
				'min'	=> 150,
			),
		),
		'title'   			=> 'NETWORK_MTU_SIZE_DIS',
		'tooltip' 			=> 'NET_CONF_MTU_SIZE',
		'validator'			=> 'int-range',
		'validator-java'=> 'digits: true, range: [150, 1500]',
	),
	'ncsMode'		=> array(
		'cleanOnSubmit'	=> false,
		'db-key'  			=> 'ncs_mode',
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldSelect',
		'getData'				=> true,
		'miscConf'			=> 0,
		'options'				=> array(
			'select'	=> array(
				'on'					=> 'NETWORK_CONFIG_SERVER_OPTION_ON',
				'detectonly'	=> 'NETWORK_CONFIG_SERVER_OPTION_OD',
				'off'					=> 'NETWORK_CONFIG_SERVER_OPTION_OFF',
			),
		),
		'title'   			=> 'NETWORK_CONFIG_SERVER_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'select',
		'validator-java'=> null,
	),
	// VLAN
	'vlanEnable'	=> array(
		'cleanOnSubmit'	=> false,
		'db-key' 				=> 'vlan-enable',
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldCheckbox',
		'getData'				=> true,
		'miscConf'			=> 0,
		'options'				=> null,
		'title'   			=> 'NETWORK_VLAN_ENABLE_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'bool',
		'validator-java'=> null,
	),
	'vlanId'			=> array(
		'cleanOnSubmit'	=> false,
		'db-key'  			=> 'vlan-id',
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldText',
		'getData'				=> true,
		'miscConf'			=> 0,
		'options'				=> array(
			'int-range' => array(
				'max'	=> 4094,
				'min'	=> 1,
			),
		),
		'title'   			=> 'NETWORK_VLAN_ID_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'int-range',
		'validator-java'=> 'digits: true, required: true, range:[1, 4094]'
	),
	'vlanPrio'		=> array(
		'cleanOnSubmit'	=> false,
		'db-key' 				=> 'vlan-prio',
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldSelect',
		'getData'				=> true,
		'miscConf'			=> 0,
		'options'				=> array(
			'select'	=> array(
				'000'	=> '0',
				'001'	=> '1',
				'010'	=> '2',
				'011'	=> '3',
				'100'	=> '4',
				'101'	=> '5',
				'110'	=> '6',
				'111'	=> '7',
			),
		),
		'title'   			=> 'NETWORK_VLAN_PRIORITY_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'select',
		'validator-java'=> null,
	),
	// ROUTE
	'routing' => array(
		'cleanOnSubmit' => false,
		'db-key'				=> 'routing',
		'default'				=> '',
		'disabled'			=> false,
		'display'				=> null,
		'getData'				=> true,
		'miscConf'			=> 0,
		'options'				=> null,
		'title'					=> '',
		'tooltip'				=> '',
		'validator'			=> null,
		'validator-java'=> null,
	),
	'routeGateway'	=> array(
		'class' 				=> array(
			'label' => 'col-sm-4 control-label',
		),
		'cleanOnSubmit'	=> false,
		'db-key' 				=> null,
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldText',
		'getData'				=> false,
		'miscConf'			=> null,
		'options'				=> null,
		'title'   			=> 'NETWORK_ROUTE_GATEWAY_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'ip4',
		'validator-java'=> 'verifyIP: true, required: true',
	),
	'routeNet'		=> array(
		'class' 				=> array(
			'label' => 'col-sm-4 control-label',
		),
		'cleanOnSubmit'	=> false,
		'db-key' 				=> null,
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldText',
		'getData'				=> false,
		'miscConf'			=> null,
		'options'				=> null,
		'title'   			=> 'NETWORK_ROUTE_TARGET_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'ip4',
		'validator-java'=> 'verifyIP: true, required: true',
	),
	'routeNetmask'	=> array(
		'cleanOnSubmit'	=> false,
		'db-key' 				=> null,
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldText',
		'getData'				=> false,
		'miscConf'			=> null,
		'options'				=> array(
			'int-range'	=> array(
				'max' => 32,
				'min'	=> 0,
			),
		),
		'title'   			=> 'NETWORK_ROUTE_NETMASK_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'int-range',
		'validator-java'=> 'digits: true, range:[0,32]',
	),
	// HTTPS
	'errorCert'		=> array(
		'cleanOnSubmit'	=> false,
		'db-key'   			=> 'errorCert',
		'default' 			=> '0',
		'disabled'			=> false,
		'display' 			=> 'fieldCheckbox',
		'getData'				=> false,
		'miscConf'			=> null,
		'options'				=> null,
		'title'   			=> 'ERROR_HTTPS_REMOVE_CERTIFICATE_MESSAGE_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'bool',
		'validator-java'=> null,
	),
	'httpsOnly'		=> array(
		'cleanOnSubmit'	=> false,
		'db-key'   			=> 'httpsOnly',
		'default' 			=> '0',
		'disabled'			=> false,
		'display' 			=> 'fieldCheckbox',
		'getData'				=> true,
		'miscConf'			=> '',
		'options'				=> null,
		'title'   			=> 'HTTPS_ONLY_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'bool',
		'validator-java'=> null,
	),
	'uploadFile'	=> array(
		'cleanOnSubmit'	=> false,
		'db-key'  			=> 'uploadfile',
		'default' 			=> '',
		'disabled'			=> false,
		'display' 			=> 'fieldUpload',
		'getData'				=> false,
		'miscConf'			=> null,
		'options'				=> null,
		'title'   			=> 'HTTPS_UPLOAD_CERTIFICATE_DIS',
		'tooltip' 			=> '',
		'validator'			=> 'bool',
		'validator-java'=> null,
	),
	// NETWORK TROUBLESHOOTING
	'nwts_getPubIP'	=> array(
		'cleanOnSubmit'	=> false,
		'default' 			=> '0',
		'db-key' 				=> 'nwts_getPubIP',
		'disabled'			=> false,
		'display' 			=> 'fieldCheckbox',
		'getData'				=> false,
		'miscConf'			=> null,
		'options'				=> null,
		'title'   			=> 'NWTS_PUBIP_DIS',
		'tooltip' 			=> 'NWTS_PUBIP_TT',
		'validator'			=> 'bool',
		'validator-java'=> null,
	),
	'nwts_health'		=> array(
		'cleanOnSubmit'	=> false,
		'default' 			=> '1',
		'db-key' 				=> 'nwts_health',
		'disabled'			=> true,
		'display' 			=> 'fieldCheckbox',
		'getData'				=> false,
		'miscConf'			=> null,
		'options'				=> null,
		'title'   			=> 'NWTS_HEALTH_DIS',
		'tooltip' 			=> 'NWTS_HEALTH_TT',
		'validator'			=> 'bool',
		'validator-java'=> null,
	),
	'nwts_hostName'	=> array(
		'cleanOnSubmit'	=> false,
		'default' 			=> 'www.beronet.com',
		'db-key'   			=> 'nwts_hostName',
		'disabled'			=> false,
		'display' 			=> 'fieldText',
		'getData'				=> false,
		'miscConf'			=> null,
		'options'				=> null,
		'title'   			=> 'NWTS_HOSTNAME_DIS',
		'tooltip' 			=> 'NWTS_HOSTNAME_TT',
		'validator'			=> 'hostname',
		'validator-java'=> 'checkHostname: true, required: true',
	),
	'nwts_pingHost'	=> array(
		'cleanOnSubmit'	=> false,
		'default' 			=> '1',
		'db-key'   			=> 'nwts_pingHost',
		'display' 			=> 'fieldCheckbox',
		'getData'				=> false,
		'miscConf'			=> null,
		'options'				=> null,
		'title'   			=> 'NWTS_PINGHOST_DIS',
		'tooltip' 			=> 'NWTS_PINGHOST_TT',
		'validator'			=> 'bool',
		'validator-java'=> null,
	),
	'nwts_resName'	=> array(
		'cleanOnSubmit'	=> false,
		'default' 			=> '1',
		'db-key' 				=> 'nwts_resName',
		'disabled'			=> false,
		'display' 			=> 'fieldCheckbox',
		'getData'				=> false,
		'miscConf'			=> null,
		'options'				=> null,
		'title'   			=> 'NWTS_RESNAME_DIS',
		'tooltip' 			=> 'NWTS_RESNAME_TT',
		'validator'			=> 'bool',
		'validator-java'=> null,
	),
);

return $parameters;
?>
