<?php

/**
 * Implementiert das Einstellen der Provisionierungsparameter
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once("/usr/www/include/SQLite2ToSQLite3.php");

class Provisioning {
	
	private 	$m_attr;

	private		$post_attr,
			$post_checked = 0;

	private		$isRequestRejected = 0,
			$reasonRejected = array();

	function __construct($m, $get = array(), $post = array(), $session = array()) {
		$this->m_attr = $m;
	}

	/**
	 * Funktion display erzeugt den Inhalt von der HTML-Seite
	 * @return string HTML Seite
	 */
	function display() {
		$name = "PROVISIONING_TITLE_DIS";
		include('./includes/header.php');

		ob_start();
		?>
		<script  type="text/javascript">
		    function show_provopts(ch) {
		        if (!ch) {
		            $('#prov_mode').hide();
		            $('#prov_url').hide();
		            $('#poll_int').hide();
		        } else {
		            $('#prov_mode').show();
		            $('#prov_url').show();
		            $('#poll_int').show();
		        }
		    }
		</script>
		<form name="provisioning" id="provisioning" class="form-horizontal" action="modules/Provisioning/provisioning_submit.php" method="POST">
			<?php echo $this->dynamic_table() ?>
			<input type="hidden" name="m" value="<?php echo $this->m_attr ?>">
			<input type="hidden" name="a" value="save">
		</form>
		<script type="text/javascript">
		    show_provopts(document.getElementById("prov_man").checked);
		    $("#provisioning").validate({
			rules: {
				provisioning_url: {
					checkUrl: true
				}
			}
		   });
		</script>
		<?php
		$ret .= ob_get_clean();

		return $ret;
	}

	/**
	 * Generiert das HTML Formular und speichert die Einstellungen
	 * @return string HTML Formular
	 */

	function dynamic_table() {
		require_once('./includes/lang.php');
		include('/usr/fallback/beroConf.php');

		$bc = new beroConf('root');

		$table = '';
		if ($this->isRequestRejected) {
			$table .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

		$selmode = $bc->get('root', 'provisioning_mode');
		ob_start();
		?>
		<p class="text-center lead">
			<?php echo PROVISIONING_TABLE_HEADER_DIS ?>
		</p>
		<div class='form-group'>
			<label for='provisioning_manual' class='col-sm-6 control-label'><?php echo PROVISIONING_MANUAL_DIS ?></label>
			<div class='col-sm-4 form-checkbox'>
				<input type="checkbox" name="provisioning_manual" id="prov_man"  
					   onclick="show_provopts($('#prov_man').prop('checked'));" value="1" 
					   <?php echo (($bc->get('root', 'provisioning_manual') == 1) ? ' checked' : '') ?>>
			</div>
		</div>
		<div class='form-group' id="prov_mode">
			<label for='provisioning_mode' class='col-sm-6 control-label'><?php echo PROVISIONING_MODE_DIS ?></label>
			<div class='col-sm-4'>
				<select name="provisioning_mode" class="form-control input-sm">
					<?php foreach (array('off', 'once', 'always') as $mode): ?>
						<option value="<?php echo $mode ?>" <?php echo (($mode == $selmode) ? ' selected' : '') ?>><?php echo $mode ?></option>
					<?php endforeach; ?>
				</select>
			</div>
		</div>
		<div class='form-group' id="prov_url">
			<label for='provisioning_url' class='col-sm-6 control-label'><?php echo PROVISIONING_URL_DIS ?></label>
			<div class='col-sm-4'>
				<input type="text" class="form-control input-sm" name="provisioning_url" value="<?php echo $bc->get('root', 'provisioning_url') ?>">
			</div>
		</div>
		<div class='form-group' id="poll_int">
			<label for='polling_interval' class='col-sm-6 control-label'><?php echo PROVISIONING_POLLING_INTERVAL_DIS ?></label>
			<div class='col-sm-4'>
				<input type="text" class="form-control input-sm" name="polling_interval" digits="true" value="<?php echo $bc->get('root', 'polling_interval') ?>" min="0">
			</div>
		</div>

		<br>
		<div class="text-center">
			<input type="hidden" name="action" value="save">
			<input type="submit" name="submit" class="btn btn-default" value="<?php echo BUTTON_SAVE ?>">
		</div>
		<?php
		if (strlen(($provConfigMd5 = $bc->get('root', 'provisioning_config_md5'))) == 0) {
			$table .= ob_get_clean();
			return $table;
		}
		?>
		<br>
		<br>
		<p class="text-center lead"><?php echo PROVISIONINGMD5_TABLE_HEADER_DIS ?></p>
		<form name="provMd5" action="" method="POST">
			<div class="text-center">
				<p><?php echo $bc->get('root', 'provisioning_config_md5'); ?></p>
				<input type="submit" name="deleteMd5" class="btn btn-default" value="Delete">
			</div>
		</form>

		<?php
		$table .= ob_get_clean();

		return($table);
	}

}
?>
