<?php

# check if session is valid
$newTarget = '/app/berogui/index.php?m=RebootReset';
include('/usr/local/www/berogui/includes/session.php');
unset($newTarget);

/**
 * @file
 * Factory Reset, Datenbank löschen und neu erzeugen
 */
chdir('../..');

include('./includes/variables.php');
include_once("/usr/www/include/SQLite2ToSQLite3.php");
include('./misc/database.php');
include('/usr/fallback/beroConf.php');

require_once('./modules/PstnHardware/PstnHardware.php');
require_once('/usr/local/www/berogui/includes/Helper/Helper.php');

/* ######## Functions ####### */
function fillSettingsByEntry($entry) {
	$settings = array();
	foreach ($entry as $key => $val) {
		if (!is_numeric($key)) {
			$settings[$key] = $val;
		}
	}
	return $settings;
}

function insertFieldByTable($ba, $table, $settings) {
	foreach ($settings as $fields) {
		unset($fields['id']);
		$sql = "INSERT INTO $table ('". implode("','", array_keys($fields)) ."') VALUES ('". implode("','", array_map(sqlite_escape_string, $fields)) ."');";
		$ba->insert_($sql);
	}
}

function get_config_to_sip_configuration ($scenario, $extern, $port_type) {
	// scenario == 2 == PBX
	if ($scenario != 2) {
		return '';
	}
	// extern PSTN
	if ($extern == 0) {
		return 'sip_ppi_user_setting=${new_source},from_sip_src_setting=ppi_user'; 
	}
	// intern BRI
	if (strcmp($port_type, 'BRI') == 0) {
		$config = 'sip_from_user_setting=${account_username}';
		if ($_SESSION['pbx'] == "3CX") {
			$config .= ',from_sip_src_setting=from_display';
		}
		return $config;
	}
	// intern FXS
	return '';	
}

function get_config_to_pstn_configuration ($scenario) {
	if ($scenario == 3) {
		return 'isdn_oad_setting=${new_source_auto},isdn_dad_setting=${new_destination_auto}';
	}
	return '';
}

function get_config_to_dialplan_configuration ($scenario) {
	if ($scenario == 2) {
		return 'sip_from_user_setting=${account_username}';
	}
	return '';
}

function load_wizard_config($filename = '/tmp/wizard-voip.conf') {
	$wizard_cfg = array();
	// load the file
	$file_loaded = parse_ini_file($filename, true);

	// general configuration
	$list_general = array('Scenario', 'acl', 'cloud', 'prefix');
	foreach ($list_general as $parameter) {
		$wizard_cfg['General'][$parameter] = isset($file_loaded[$parameter]) ? $file_loaded[$parameter] : 0;
		unset($file_loaded[$parameter]);		
	}

	foreach (array_keys($file_loaded) as $key) { // NB: the 'Port 0' is located to Extern PSTN modules
		if (preg_match('/Pstn-Extern-([a-z]{3})/', $key, $matches)) {
			$wizard_cfg['Pstn'][strtoupper($matches[1])][0] = $file_loaded[$key];
			$wizard_cfg['Pstn'][strtoupper($matches[1])][0]['config'] = get_config_to_pstn_configuration($wizard_cfg['General']['Scenario']);
		}
		else if (preg_match('/Pstn-Intern-([a-z]{3})-([0-9]*)/', $key, $matches)) {
			$wizard_cfg['Pstn'][strtoupper($matches[1])][$matches[2]] = $file_loaded[$key];
			$wizard_cfg['Pstn'][strtoupper($matches[1])][$matches[2]]['config'] = get_config_to_pstn_configuration($wizard_cfg['General']['Scenario']);
		}
		else if (preg_match('/Dialplan-Extern-([a-z]{3})/', $key, $matches)) {
			$wizard_cfg['Dialplan'][strtoupper($matches[1])][0] = $file_loaded[$key];
			$wizard_cfg['Dialplan'][strtoupper($matches[1])][0]['config'] = get_config_to_dialplan_configuration($wizard_cfg['General']['Scenario']);
		}
		else if (preg_match('/Dialplan-Intern-([a-z]{3})-([0-9]*)/', $key, $matches)) {
			$wizard_cfg['Dialplan'][strtoupper($matches[1])][$matches[2]] = $file_loaded[$key];
			$wizard_cfg['Dialplan'][strtoupper($matches[1])][$matches[2]]['config'] = get_config_to_dialplan_configuration($wizard_cfg['General']['Scenario']);
		}
		else {
			$wizard_cfg[$key] = $file_loaded[$key];
		}
	}

	return $wizard_cfg;
}

function set_sip_profile_gateway_scenario ($ba, $scenario, $sip_cfg, $pstn_cfg) {
	$port_type = key($pstn_cfg);

	$name 	   = sqlite_escape_string($sip_cfg['name']);
	$server    = sqlite_escape_string($sip_cfg['server']);
	$user      = sqlite_escape_string(isset($sip_cfg['user'])     ? $sip_cfg['user']   : '');
	$secret    = sqlite_escape_string(isset($sip_cfg['secret'])   ? $sip_cfg['secret'] : '');
	$register  = sqlite_escape_string(isset($sip_cfg['register']) ? 1 		   : 0 );
	$transport = sqlite_escape_string(strtolower($sip_cfg['transport']));
	$config    = get_config_to_sip_configuration($scenario, 0, $port_type);

	if ($scenario == 3) {
		$config .= (strlen($config) == 0 ? '' : ',') . 'sip_national_code='. $pstn_cfg[$port_type][0]['city'] .",sip_international_code=". $pstn_cfg[$port_type][0]['country'];
	}

	$config = sqlite_escape_string($config);

	$sql_str = "(name, sip_transport, sip_registrar, sip_domain, sip_proxy, user, secret, register, config) VALUES ('$name', '$transport', '$server', '$server', '$server', '$user', '$secret', '$register', '$config')";

	$ba->insert_("INSERT INTO sip $sql_str");	
}

function set_sip_profile_gateway_pbx_scenario ($ba, $scenario, $pbx_settings, $pstn_settings) {
	$pbx_server   = $pbx_settings['server'];
	$pbx_port     = (isset($pbx_settings['port']) ? ":". $pbx_settings['port'] : '');

	$server = sqlite_escape_string($pbx_server . $pbx_port);

	$matchtype = 'touser';
	foreach ($pstn_settings as $port_type => $array_ports) {
		foreach (array_keys($array_ports) as $port) {
			$pstn_cfg = $pstn_settings[$port_type][$port];

			$register = sqlite_escape_string('1');
			if (isset($_SESSION['pbx'])) {
				$name = sqlite_escape_string($_SESSION['pbx']."-".$pstn_cfg['group']);
			}
			else {
				$name = sqlite_escape_string("SIP-".$pstn_cfg['group']);
			}
			$user     = sqlite_escape_string(isset($pstn_cfg['user'])     ? $pstn_cfg['user']   : '');
			$secret   = sqlite_escape_string(isset($pstn_cfg['secret'])   ? $pstn_cfg['secret'] : '');
			$config   = sqlite_escape_string(get_config_to_sip_configuration($scenario, $port, $port_type));

			$sql_str = '';			

			// Extern
			if ($port == 0) {
				$sql_str = "(name, sip_registrar, sip_proxy, sip_domain, user, secret, register, config) VALUES ('$name', '$server', '$server', '$server', '$user', '$secret', '$register', '$config')";	

			}
			// Intern
			else {
				if (strcmp($port_type, 'BRI') == 0) {
					$sql_str = "(name, sip_registrar, sip_proxy, sip_domain, user, secret, register, matchtype, config) VALUES ('$name', '$server', '$server', '$server', '$user', '$secret', '$register', '$matchtype', '$config')";	
				}
				else {
					$sql_str = "(name, sip_registrar, sip_proxy, sip_domain, user, secret, register, matchtype) VALUES ('$name', '$server', '$server', '$server', '$user', '$secret', '$register', '$matchtype')";	
				}
			}

			$ba->insert_("INSERT INTO sip $sql_str");
		}
	}
}

function get_isdn_hardware_configuration ($type, $port, $extern_ports, $scenario) {
	// when no one string comparison is made in the return, the choice has been made by the user during the Easy Wizard Configuration
	switch ($scenario) {
		case '1': // Gateway
			return 'TE';
		case '2': // PBX
			return (in_array($port, $extern_ports) ? 'TE' : 'NT'); 
		case '3': // Provider
			return (strcmp($type, 'BRI') == 0 ? 'NT' : 'TE');; // or the return is the same for BRI and PRI
	}
}

function get_isdn_protocol_configuration ($type, $scenario) {
	switch ($scenario) {
		case '1': // Gateway
			return 'PTP';
		case '2': // PBX
			return (strcmp($type, 'BRI') == 0 ? 'PMP' : 'PTP');
		case '3': // Provider
			return 'PTP';
	}
}

function set_pstn_hardware ($ba, $scenario, $pstn_settings) {
	foreach ($pstn_settings as $port_type => $parameters) {
		$keep_parameters = $parameters;	
		
		// port == 0 => Intern
		$list_extern = array();
		if (isset($keep_parameters[0])) {
			$list_extern = explode('-', $keep_parameters[0]['ports']);
			foreach ($list_extern as $port) {
				$keep_parameters[$port] = $keep_parameters[0];
			}
			unset($keep_parameters[0]);
		}

		foreach (array_keys($keep_parameters) as $port) {
			$ptp	  = '';
			$tones 	  = '';
			$sql_str  = '';
			$pstn_cfg = $keep_parameters[$port];

			$group = sqlite_escape_string($pstn_cfg['group']);

			switch ($port_type) {
				case 'BRI':
				case 'PRI':
					$type = 'isdn';
					
					$ntte    = sqlite_escape_string(strtolower(isset($pstn_cfg['ntte']) ? $pstn_cfg['ntte'] : get_isdn_hardware_configuration($type, $port, $list_extern, $scenario)));
					$ptp	 = sqlite_escape_string(strcmp('PTP', isset($pstn_cfg['ptp']) ? $pstn_cfg['ptp'] : get_isdn_protocol_configuration($port_type, $scenario)) == 0 ? 1 : 0);

					$ba->update("UPDATE $type SET ntteHW='$ntte', ntteSW='$ntte', ptp='$ptp'  WHERE port='". sqlite_escape_string($port) ."'");	

					$tones   = sqlite_escape_string("[". $pstn_cfg['tones'] ."]");
					$country = sqlite_escape_string(isset($pstn_cfg['country']) ? $pstn_cfg['country'] : '');
					$city    = sqlite_escape_string(isset($pstn_cfg['city'])    ? $pstn_cfg['city']	   : '');
					$local   = sqlite_escape_string(isset($pstn_cfg['local'])   ? $pstn_cfg['local']   : '');	
					$config  = sqlite_escape_string(strlen($pstn_cfg['config']) == 0 ? '' : $pstn_cfg['config']);

					$sql_str = ", tones='$tones', country_code='$country', city_code='$city', local_area_code='$local', config='$config'";
					break;
				case 'FXO':
				case 'FXS':
					$type  = 'analog';
					$tones = ", tones='". sqlite_escape_string("[". $pstn_cfg['tones'] ."]") . "'";

					$sql_str = $tones;
					break;
				case 'GSM':
				case 'LTE':
					$type = strtolower($port_type);
					break;
				default:
					// TODO: stop the factory reset if error
					return;
			}

			if (isset($pstn_cfg['t1e1'])) {
				$ba->update("UPDATE cas SET protocol='". sqlite_escape_string(strtolower($pstn_cfg['t1e1'])) ."', termination='$ntte' WHERE port_type='hdlc'");
			}

			$ba->update("UPDATE $type SET gr='$group'$sql_str WHERE port='". sqlite_escape_string($port) ."'");
		}
	}
}

function set_dialplan_rules($ba, $dialplan_rules) {
	$posId = 0;
	$activ = sqlite_escape_string('1');

	foreach ($dialplan_rules as $port_type => $port_type_parameters) {
		foreach ($port_type_parameters as $port => $parameters) {
			// init input variable
			$fromDirection  = sqlite_escape_string($parameters['fromDirection']);
			$toDirection	= sqlite_escape_string($parameters['toDirection']);
			$dest		= sqlite_escape_string('('. $parameters['dest'] .')');
			$newDest	= sqlite_escape_string("\\". $parameters['newDest']);
			$src		= sqlite_escape_string('('. $parameters['src'] .')');
			$newSrc		= sqlite_escape_string("\\". $parameters['newSrc']);
			$config		= sqlite_escape_string(isset($parameters['config']) ? $parameters['config'] : '');

			// SIP => PSTN
			$sip_ref = ($port == 0 ? 'd:' : 'a:');	// port == 0 => extern .... port != 0 => intern
			$fromId  = $sip_ref . $parameters['fromId'];
			$toId	 = "g:". $parameters['toId'];

			$posIdsql = sqlite_escape_string($posId);
			$sql_str  = "(fromDirection, toDirection, fromId, toId, dest, newDest, src, newSrc, posId, activ) VALUES ('$fromDirection', '$toDirection', '$fromId', '$toId', '$dest', '$newDest', '$src', '$newSrc', '$posIdsql', '$activ')";
	
			$ba->insert_("INSERT INTO dialplan $sql_str");
		
			$posId++;

			// PSTN => SIP
			$fromId  = "g:". $parameters['toId'];
			$toId	 = "p:". $parameters['fromId'];			

			$posIdsql = sqlite_escape_string($posId);
			if (strlen($config) == 0) {
				$sql_str = "(fromDirection, toDirection, fromId, toId, dest, newDest, src, newSrc, posId, activ) VALUES ('$toDirection', '$fromDirection', '$fromId', '$toId', '$dest', '$newDest', '$src', '$newSrc', '$posIdsql', '$activ')";
			}
			else {
	        	       $sql_str=  "(fromDirection, toDirection, fromId, toId, dest, newDest, src, newSrc, posId, activ, config)"
					. " VALUES "
					. "('$toDirection', '$fromDirection', '$fromId', '$toId', '$dest', '$newDest', '$src', '$newSrc', '$posIdsql', '$activ', '$config')";
			}

			$ba->insert_("INSERT INTO dialplan $sql_str");

			$posId++;
		}	
	}
}

function update_lan_or_wan_network ($bc, $network_cfg, $which_settings, $root) {
	// dhcp
	$dhcp = (isset($network_cfg[$which_settings['0']['name']]) ? $network_cfg[$which_settings['0']['name']] : 0); 
	$bc->set($root, $which_settings['0']['id'], sqlite_escape_string($dhcp));

	if ($dhcp == 0) {
		// static
		for ($i = 1; $i < count($which_settings); $i++) {
			$i_str = (string)$i;
			if (isset($network_cfg[$which_settings[$i_str]['name']])) {
				$bc->set($root, $which_settings[$i_str]['id'], sqlite_escape_string($network_cfg[$which_settings[$i_str]['name']]));
			}
		}
	}
}

function update_network_configuration ($bc, $network_cfg, $root = 'root') {
	// delete old network settings
	$old_settings = array('lan-ipaddr', 'lan-netmask', 'lan-gateway','lan-nameserver', 'lan-mtu', 'lan-dhcp', 'wan-dhcp','wan-ipaddr', 'wan-netmask', 'wan-gateway', 'bonding-mode','bonding-miimon', 'bonding-updelay', 'bonding-downdelay');

	foreach ($old_settings as $old_setting) {
		$bc->delete($root, $field);
	}

	// get id new settings
	require_once('./modules/Wizard/network_wizard_popup.php');
	$network_wizard = new NetworkWizard();

	$new_settings = $network_wizard->get_network_settings();

	// set lan or lan-wan mode
	$bc->set($root, $new_settings['mode']['id'], sqlite_escape_string($network_cfg[$new_settings['mode']['name']]));

	// set lan network 
	update_lan_or_wan_network($bc, $network_cfg, $new_settings['lan'], $root);

	// set wan network
	if (strcmp($network_cfg[$new_settings['mode']['name']], 'lan-wan') == 0) {
		// remove lan gateway (correspond to the key '3' in the lan array)
		$bc->delete($root, $new_settings['lan']['3']['id']);

		update_lan_or_wan_network($bc, $network_cfg, $new_settings['wan'], $root);
	}

	// set dns configuration
	$nameserver = '';
	if (isset($network_cfg[$new_settings['dns']['0']['name']])) {
		$nameserver = $network_cfg[$new_settings['dns']['0']['name']] . (isset($network_cfg[$new_settings['dns']['1']['name']]) ? ";" . $network_cfg[$new_settings['dns']['1']['name']] : '');
		$bc->set($root, $new_settings['dns']['0']['id'], sqlite_escape_string($nameserver));
	}

	if (isset($network_cfg[$new_settings['dns']['2']['name']])) {
		$bc->set($root, $new_settings['dns']['2']['id'], sqlite_escape_string($network_cfg[$new_settings['dns']['2']['name']]));
	}
}

###############################

$exec_script = 1;
$invalid = array();

// checking GET request
$list_get = array('wizard' => 'bool', 'val' => 'bool');

$_GET = Helper::sanitizeGet($_GET, $list_get, $exec_script, $invalid);

// checking POST request
unset($_POST['popup'], $_POST['v']);

$list_post = array(	
	// id
	'id_upd' => 'id',
	// bool
	'keep_acl_set' => 'bool', 'keep_cloud_set' => 'bool', 'keep_prefix_set' => 'bool', 'keep_sip_set' => 'bool', 'keep_set' => 'bool', 'keep_app_set' => 'bool', 'keep_hw_set' => 'bool',
	// select
	'type' => 'select'
  );

$list_post_options = array('type' => array('cas', 'cashw'));

foreach ($_POST as $key => $value)  {
	if (preg_match('/^t1e1([0-9]+)$/', $key, $match)) {
		$list_post[$match[0]] = 'bool';
		$list_post["interface_type{$match[1]}"] = 'select';
		$list_post_options["interface_type{$match[1]}"] = array('cas', 'hdlc');
	}
}

$_POST = Helper::sanitizePost($_POST, $list_post, $exec_script, $invalid, $list_post_options); 

// executing script
if (!$exec_script) {
        echo "<script>window.location='../../index.php?m=RebootReset&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
	exit(1);
}

// init factory reset mode
$ba = new beroAri();

$wizard_factory_reset = false;
$normal_factory_reset = true ;

$keep_acl    = isset($_POST['keep_acl_set']);
$keep_cloud  = isset($_POST['keep_cloud_set']);
$keep_prefix = isset($_POST['keep_prefix_set']);

// init wizard factory reset
$wizard_cfg = array();
if (isset($_GET['wizard']) && $_GET['wizard']) {
	$normal_factory_reset = false;
	$wizard_factory_reset = true ; 

	$wizard_cfg = load_wizard_config();

	$keep_acl    = $wizard_cfg['General']['acl'];	
	$keep_cloud  = $wizard_cfg['General']['cloud'];
	$keep_prefix = $wizard_cfg['General']['prefix'];
}

// init normal factory reset
$sipSettings = array();
$save_sipstack = array();
if ($normal_factory_reset) {
	// keep sip-settings
	if (isset($_POST['keep_sip_set'])){
		$q = $ba->select('SELECT * FROM sip;');
		while ($entry = sqlite_fetch_array($q, SQLITE_ASSOC)){
			$sipSettings[] = fillSettingsByEntry($entry);
		}

		// keep sip stacks
		$list_interface = array('lan', 'wan', 'vpn');

		$list_keyval = array(
        		'sip_transport'         , 'ssl_version' , 'tos_rtp'     , 'tos_sip'     ,
        		'rtp_port_selection'    , 'rtpports'    , 'stack_active', 'sip_bindport',
		);

		foreach ($list_interface as $iface) {
        		foreach ($list_keyval as $keyval) {
                		$param = $keyval ."_". $iface;
                		$save_sipstack[$param] = $ba->get($param);
        		}
		}
	}
}

//keep ACL Settings 
$aclSettings = array();
if ($keep_acl) {
	$q = $ba->select('SELECT * FROM acl;');
	while ($entry = sqlite_fetch_array($q, SQLITE_ASSOC)) {
		$aclSettings[] = fillSettingsByEntry($entry);
	}
}

// keep cloud-settings
$cloudSettings['cloudAddress'] = $ba->get('cloudAddress');
if ($keep_cloud) {
	$nameArray = array('proxyEnabled', 'proxyAddress', 'proxyPort', 'proxyType', 'proxyUser', 'proxySecret', 'cloud_show_status');
	foreach ($nameArray as $name) {
		$cloudSettings[$name] = $ba->get($name);
	}
}

// keep prefix-settings
$prefixSettings = array();
if ($keep_prefix) {
	$nameArray = array('national_code', 'international_code');
	foreach ($nameArray as $name) {
		$prefixSettings[$name] = $ba->get($name);
	}
}

// delete database ari.db
$ba = null;
unset($ba);
exec('/bin/rm /usr/conf/ari.db');

//Create new db
$ba = new beroAri();
if ($ba -> is_error()) {
	echo '<script>alert("'. $ba->error() .'");</script>';
}

// reset rootdb
$bc = new beroConf('root');
$bc->exec_sql("DELETE FROM root WHERE key NOT IN ('root-version', 'lan-mtu', 'lan-iface', 'lan-ipaddr', 'lan-netmask', 'lan-gateway', 'lan-dhcp', 'lan-mode', "
	. "'lan-ports', 'msp-iface', 'msp-ipaddr', 'app-image', 'app-status', 'ntphost', 'cloud_enable', 'cloud_key','redirect_cfg', 'lan-nameserver', 'vlan-enable', 'vlan-id', "
	. "'vlan-prio', 'wan-dhcp', 'wan-ipaddr', 'wan-netmask', 'wan-gateway', 'bonding-mode', 'bonding-miimon', 'bonding-updelay', 'bonding-downdelay', 'gateway-mode', 'nameserver-mode');");

if (!$keep_cloud) {
	//deregister from the cloud when keep_cloud is not checked
	require_once('/usr/local/php/include/berocloud/SbcApi.php');
	$cloud = new SbcApi($bc, $ba, array('addr' => $cloudSettings['cloudAddress']));
	$res = $cloud->send('deregister');
	$bc->exec_sql("DELETE FROM root WHERE key IN ('cloud_enable', 'cloud_key', 'redirect_cfg');");
	$bc->set('root', 'redirect_cfg', '1');
}
// wizard factory reset
if ($wizard_factory_reset) {
	// SIP profile(s)
	if ($wizard_cfg['General']['Scenario'] == 2) {
		set_sip_profile_gateway_pbx_scenario($ba, $wizard_cfg['General']['Scenario'], $wizard_cfg['Pbx'], $wizard_cfg['Pstn']);
	}
	else {
		set_sip_profile_gateway_scenario($ba, $wizard_cfg['General']['Scenario'], $wizard_cfg['Sip'], $wizard_cfg['Pstn']);
	}

	// PSTN configuration
	set_pstn_hardware($ba, $wizard_cfg['General']['Scenario'], $wizard_cfg['Pstn']);

	// Dialplan Rules
	set_dialplan_rules($ba, $wizard_cfg['Dialplan']);

	// Update network settings
	if (isset($wizard_cfg['Network'])) {
		update_network_configuration($bc, $wizard_cfg['Network']);
	}

	// set a default ntphost (if none is set, but configuration is static)
	if ($bc->get('root', 'lan-dhcp') != '1') {
		//if no gui-ntphost is set, set default
		$gui_ntp = $bc->get ('root', 'gui-ntphost');
		if (strlen ($gui_ntp)) {
			$bc->set('root', 'ntphost', $gui_ntp);
		}
		else {
			$bc->set('root', 'ntphost', 'pool.ntp.org');
		}
	}

	$bc->set('root', 'msp-iface', 'eth1');
	$bc->set('root', 'msp-ipaddr', 'auto');
	$bc->set('root', 'app-status', 'running');
	$bc->set('root', 'userapp-enabled', '1');
}

// normal factroy reset
else if ($normal_factory_reset) {
	//keep network settings
	if (!isset($_POST['keep_set'])) {
		$delArray = array('lan-ipaddr', 'lan-netmask', 'lan-gateway', 'lan-nameserver', 'ntphost', 'vlan-enable', 'vlan-id', 
			'vlan-prio', 'lan-mode', 'wan-dhcp', 'wan-ipaddr', 'wan-netmask', 'wan-gateway', 'bonding-mode', 'bonding-miimon', 
			'bonding-updelay', 'bonding-downdelay', 'gateway-mode', 'nameserver-mode');
		foreach ($delArray as $delItem) {
			$bc->delete('root', $delItem);
		}
		unset($delArray);

		$bc->set('root', 'lan-iface', 'eth0');
		$bc->set('root', 'lan-dhcp', '1');
		$bc->set('root', 'lan-mtu', '1500');
		$bc->set('root', 'beroAvahi-enabled', '1');
	}

	// set a default ntphost (if none is set, but configuration is static)
	if ($bc->get('root', 'lan-dhcp') != '1') {
		//if no gui-ntphost is set, set default
		$gui_ntp = $bc->get ('root', 'gui-ntphost');
		if (strlen ($gui_ntp)) {
			$bc->set ('root', 'ntphost', $gui_ntp);
		}
		else {
			$bc->set ('root', 'ntphost', 'pool.ntp.org');
		}
	}
	//restore apps
	if (!isset($_POST['keep_app_set'])){
	
		exec('/bin/mount -o remount,rw /home/admin/');

		if ($handle = @opendir('/home/admin/apps/')) {
			while (false !== ($file = readdir($handle))) {
				if (($file == '.') || ($file == '..')) {
					continue;
				}
				exec('/bin/rm -rf /home/admin/apps/' . $file);
				exec('/bin/rm -rf /home/admin/www/' . $file);
			}
			closedir($handle);
		}

		exec('/bin/rm -rf /usr/conf/userapp');
		exec('sync');
		exec('/bin/mount -o remount,ro /home/admin/');
	}

	$bc->set('root', 'msp-iface', 'eth1');
	$bc->set('root', 'msp-ipaddr', 'auto');
	$bc->set('root', 'app-status', 'running');
	$bc->set('root', 'userapp-enabled', '1');

	// sip restore settings
	insertFieldByTable($ba, 'sip', $sipSettings);

	// restore sip stacks
	foreach ($save_sipstack as $param => $value) {
		$ba->set($param, sqlite_escape_string($value));
	}

	// if E1/T1 module is plugged, we activate the module depending the choice made before to make the factory-reset
	if (isset($_POST['keep_hw_set'])) {
	        if (!($_POST['id_upd']))
	        {
			// TODO: the default_array is not enough generic ... can we have interface_type$i with $i > 4 ?

	                // we come directly from RebootReset.php page (modal has not been be shown)
	                // setting default value
	                $default_array = array( 'id_upd' => array ('0', '1'), 'type' => array('cashw', 'cas'), 
	                                        'interface_type1' => '0', 'interface_type2' => '0', 'interface_type3' => '0', 'interface_type4' => '0',
	                                        't1e11' => 'e1', 't1e12' => 'e1', 't1e13' => 'e1', 't1e14' => 'e1');	

	                $_POST = array_merge($_POST, $default_array);
	        }
	
		require_once('/usr/local/www/berogui/includes/Helper/HelperPstn.php');
		$helperPstn = new HelperPstn();
		$helperPstn->saveHardwareConfiguration($ba, $_POST);	
	
		// really useful ??
	        $ba->set('activate', '3');
	}
}

// restore ACL-settings
if ($keep_acl) {
	$ba->delete('DELETE FROM acl;');
	foreach ($aclSettings as $fields) {
		$sql = "INSERT INTO 'acl' ('". implode("','", array_keys($fields)) ."') VALUES ('". implode("','", array_map(sqlite_escape_string, $fields)) ."');";
		$ba->insert_($sql);
	}
}

// restore cloud-settings
if ($keep_cloud) {
	foreach ($cloudSettings as $key => $value) {
		$ba->set($key, sqlite_escape_string($value));
	}
}

// restore prefix-settings
if ($keep_prefix) {
	foreach ($prefixSettings as $key => $value) {
		$ba->set($key, sqlite_escape_string($value));
	}
}

// doesn't this belong into 'create_files.php'??
// reset api-password
@unlink('/usr/conf/apiusers.conf');
require_once('/usr/local/php/include/apiusers.Class.php');
$apiusers=new apiusers('admin');
$apiusers->createFile();

// reset password for user admin and deactivate account
exec('/usr/local/sbin/pwchange.sh admin admin');
exec('/bin/mount -oremount,rw /; /usr/bin/passwd -l admin; sync; /bin/mount -oremount,ro /');

echo '<script>window.location.href="../../includes/create_files.php"</script>';
?>
