<?php

/**
 * Implementiert einige Sicherheitseinstellungen wie Passwort ändern, etc.
 * @author Florian Kraatz <fk@beronet.com>
 * @author Sílvia Mariné <smg@beronet.com>
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');
include_once('/usr/local/www/berogui/includes/Helper/Helper.php');

class Security {

	private 	$_bc,
			$_ba;

	private		$m_attr;

	private		$submitResponse = -1;

	private		$isRequestRejected = 0,
			$reasonRejected = array();

	function __construct($m, $get = array(), $post = array(), $session = array()) {
		// loading class
		$this->_bc = new beroConf('root');
		$this->_ba = new beroAri();
		
		// set main GET variable
		$this->m_attr = $m;

		// get response from submit
		if (isset($get['response'])) {
			$this->submitResponse = Helper::sanitizeGet($get['response'], 'int');
			unset($get['response']);
		}
		// get error from response
		else if (isset($get['error'])) {
			$this->isRequestRejected = 1;
			$this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
			unset($get['error'], $get['request'], $get['checkor'], $get['key']);
		}
	}



	function display() {
		$name = "SECURITY_TITLE_DIS";
		include('./includes/header.php');

		if ($this->_ba->get('gui_mode') == 'simple') {
			$simple_class = 'simple';
		}

		if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}
		else {
			switch ($this->submitResponse) {
				case 0:
					$ret .= "<div class='text-center'>". SECURITY_SUCCES_MESSAGE_DIS . "</div>\n";
					$ret .= '<script>$("#security_mess").hide();</script>';
					break;
				case 1:
					$ret .= "<div class='text-center' style='color:red;'>". SECURITY_EMP_PASS_ERROR_DIS ."</div>\n";
					break;
				case 2:
					$ret .= "<div class='text-center' style='color:red;'>". SECURITY_OLD_PASS_ERROR_DIS ."</div>\n";
					break;
				case 3:
					$ret .= "<div class='text-center' style='color:red;'>". SECURITY_CONFIRM_ERROR_DIS . "</div>\n";
					break;
				default:
					$ret .= '';
			}
		}

		$ret .= $this->_displayTabs($this->m_attr, $simple_class);

		return $ret;
	}

	private function _displayTabs($m, $class) {
		$html_str = 	  "\n<script>\n"
				. "\t$(function() {\n"
				. "\t\t$('#tabs').tabs({active:0})\n"
				. "\t});\n"
				. "\t</script>\n"
				. "\t<div id='tabs' class=''>\n"
				. "\t\t<ul>\n"
				. "\t\t\t<li><a href='#tabs-1'>". SECURITY_PASSWORD_TABLE_HEADER_DIS ."</a></li>\n"
				. ($class == 'simple' || $this->_bc->get('root', 'is-sbc-vm') == 1 ? '' : "\t\t\t<li><a href='#tabs-2'>". SECURITY_SETTINGS_TABLE_HEADER_DIS ."</a></li>\n")
				. "\t\t</ul>\n"
				. $this->_displayTabs_1($m)
				. ($class == 'simple' || $this->_bc->get('root', 'is-sbc-vm') == 1 ? '' : $this->_displayTabs_2($m, $class))
				. "\n\t</div>\n";

		return $html_str;
	}

	private function _displayTabs_1($module) {
		ob_start();
		?>
		<div id='tabs-1'>
			<form name="scrtypsswd" id="scrtypsswd" method="POST" class="form-horizontal" style='margin-top: 15px;' autocomplete="off" action='modules/Security/security_submit.php'>
				<input name="fixChrome" type="password" style="display:none">
				<input type="hidden" name="m" value="<?php echo $module ?>">
				<input type="hidden" name="a" value="save_password">
				<div class="form-group" data-toggle="tooltip" title="<?php echo CHANGE_PWD_OLD_PASS ?>">
					<label for='pass_old' class='col-sm-5 control-label'><?php echo SECURITY_OLD_PASS_DIS ?></label>
					<div class='col-sm-4'>
						<input type="password" name="pass_old" class="form-control input-sm" autocomplete="off">
					</div>
				</div>
				<div class="form-group" data-toggle="tooltip" title="<?php echo CHANGE_PWD_NEW_PASS ?>">
					<label for='pass_new' class='col-sm-5 control-label'><?php echo SECURITY_NEW_PASS_DIS ?></label>
					<div class='col-sm-4'>
						<input type="password" name="pass_new" id='pass_new' class="form-control input-sm" autocomplete="off">
					</div>
				</div>
				<div class="form-group" data-toggle="tooltip" title="<?php echo CHANGE_PWD_CONFIRM_NEW_PASS ?>">
					<label for='pass_con' class='col-sm-5 control-label'><?php echo SECURITY_CONFIRM_PASS_DIS ?></label>
					<div class='col-sm-4'>
						<input type="password" class="form-control input-sm" name="pass_con" autocomplete="off">
					</div>
				</div>
				<div class="text-center">
					<input name="submit" type="submit" class="btn btn-default" value="<?php echo BUTTON_SAVE ?>">
				</div>
			</form>
		</div>
		<script type="text/javascript">
			$('#scrtypsswd').validate({
				rules: {
					pass_con: {
						comparePassword: 'pass_new',
						required: true,
					},
					pass_new: {
						checkPassword: true,
						required: true,
					},
					pass_old: {
						required: true,
					},
				}
			});
		</script>
		<?php
		return ob_get_clean();
	}

	private function _displayTabs_2($module, $simple_class) {
		ob_start();
		?>
		<div id='tabs-2'>
			<form name="scrtysettings" id="scrtysettings" method="POST" class="form-horizontal" style='margin-top: 15px;' autocomplete="off" action='modules/Security/security_submit.php'>
				<input type="hidden" name="m" value="<?php echo $module ?>">
				<input type="hidden" name="a" value="save_settings">
				<div class="form-group <?php echo $simple_class ?>" data-toggle="tooltip" title="<?php echo SECURITY_API_DISABLE ?>">
					<label for='api_disable' class='col-sm-5 control-label'><?php echo SECURITY_DISABLE_API_DIS ?></label>
					<div class='col-sm-4 form-checkbox'>
						<?php echo $this->_show_api_disable() ?>
					</div>
				</div>
				<div class="form-group <?php echo $simple_class ?>" data-toggle="tooltip" title="<?php echo SECURITY_SSH_ADMIN_ENABLE ?>">
					<label for='ssh_admin_enable' class='col-sm-5 control-label'><?php echo SECURITY_ENABLE_SSH_ADMIN_DIS ?></label>
					<div class='col-sm-4 form-checkbox'>
						<?php echo $this->_show_ssh_enable() ?>
					</div>
				</div>
				<div class="form-group <?php echo $simple_class ?>" data-toggle="tooltip" title="<?php echo SECURITY_SAFE_GUARD ?>">
					<label for='safeguard' class='col-sm-5 control-label'><?php echo SECURITY_SAFE_GUARD_DIS ?></label>
					<div class='col-sm-4 form-checkbox'>
						<?php echo $this->_show_safeguard() ?>
					</div>
				</div>
				<div class="text-center">
					<input name="submit" type="submit" class="btn btn-default" value="<?php echo BUTTON_SAVE ?>">
				</div>
			</form>
		</div>
		<?php
		return ob_get_clean();
	}

	private function _show_ssh_enable() {

		$ret = '<input type="checkbox" name="ssh_admin_enable" value="1" ' . (($this->_bc->get('root', 'ssh_admin_enable') == 1) ? 'checked="checked" ' : '') . '>';

		return $ret;
	}

	private function _show_api_disable() {

		$ret = '<input type="checkbox" name="api_disable" value="1" ' . (($this->_bc->get('root', 'api_disable') == '1') ? 'checked="checked" ' : '') . '>';

		return $ret;
	}

	private function _show_safeguard() {

		$ret = '<input type="checkbox" name="safeguard" value="1" ' . (($this->_bc->get('root', 'safeguard') == 1) ? 'checked="checked" ' : '') . '>';

		return $ret;
	}

	private function _show_table($module, $simple_class = null) {
		ob_start();
		?>
		<br>
		<br>
		<p class="text-center lead"><?php echo SECURITY_TABLE_HEADER_DIS ?></p>
			<!-- This is where the old thing was; we'd need to change the following in order to change the message (and change it wherever needed)
			-->


		<?php
		$ret .= ob_get_clean();

		return $ret;
	}

}
?>
