<?php

/**
 * Implementiert die SIP Stacks Einstellungen.
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class SipStack {
	
	private		$m_attr;

	private		$isFileUploaded = 0,
			$fileUploaded = array();

        private         $isRequestRejected = 0,
                        $reasonRejected = array();

	private		$default = array(
				'sip_transport'		=> array('tls', 'udp', 'tcp'),
				'ssl_version'		=> array("tls1.0", "tls1.1", "tls1.2"),
				'rtp_port_selection' 	=> array("standard", "roundrobin"),
				'tls_verification_selection'		=> array("all", "incoming", "outgoing", "none")
			);

	/**
	 * Constructor
	 */
	function __construct($m, $get = array(), $post = array(), $session = array()) {
		// set main index
		$this->m_attr = $m;

		// get upload file
		if (isset($get['upld_file'])) {
			$this->isFileUploaded = 1;
			foreach ($get as $key => $value) {
				unset($matched);
				if (preg_match('/^(lan|wan|vpn)_(ca|ag)_punkt$/', $key, $matched)) {
					$this->fileUploaded[$matched[1]][$matched[2]] = ($value === 'gruen') ? 'gruen' : 'rot';
					unset($get[$matched[0]]);
				}
			}
			unset($get['upld_file']);
		}
                // get error from modal or submit execution
                else if (isset($get['error'])) {
                        $this->isRequestRejected = 1;
                        $this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
                        unset($get['error'], $get['request'], $get['checkor'], $get['key']);
                }
	}


	/**
	 * Generiert den Inhalt von der HTML-Seite
	 * @return string HTML code
	 */
	function display() {
		$m = $this->m_attr;

		// build page content
		$name = "SIP_STACKS_TITLE_DIS";
		include('./includes/header.php');

		$sip_stacks_from = $this->dynamic_table();
		ob_start();

		// TODO: for  the javascript validator, made a loop over array('lan', 'wan', 'vpm')

		?>

		<form name='sip_stacks' id='sip_stacks' class="form-horizontal" action='modules/SipStack/sipstack_submit.php' method='POST' ENCTYPE="multipart/form-data">
			<input type="hidden" name="m" value="<?php echo $m ?>">
			<input type="hidden" name="a" value='save'>
			<br>
			<div id="content">
				<?php echo $sip_stacks_from ?>
				<div class="clearfix"></div>
				<br>
				<div class='text-center'>
					<input name='submit' type='submit' class='btn btn-default' value='<?php echo BUTTON_SAVE ?>'>
				</div>
			</div>
		</form>
		<script>
			$("#sip_stacks").validate({

				rules: {
					sip_bindport_lan: {
						digits: true,
						range: [1025, 65535],
						required: '#stack_active_lan:checked',
					},
					sip_bindport_wan: {
						digits: true,
						range: [1025, 65535],
						required: '#stack_active_wan:checked',
					},
					sip_bindport_vpn: {
						digits: true,
						range: [1025, 65535],
						required: '#stack_active_vpn:checked',
					},
					
					rtpports_lan: {
						rtpFormat: true,
						rtpBindCheck: "sip_bindport_lan",
						rtpCount: true,
					},
					rtpports_wan: {
						rtpFormat: true,
						rtpBindCheck: "sip_bindport_wan",
						rtpCount: true,
					},
					rtpports_vpn: {
						rtpFormat: true,
						rtpBindCheck: "sip_bindport_vpn",
						rtpCount: true,
					},

					tos_rtp_lan: {
						digits: true,
					},
					tos_rtp_wan: {
						digits: true,
					},
					tos_rtp_vpn: {
						digits: true,
					},
					tos_sip_lan: {
						digits: true,
					},
					tos_sip_wan: {
						digits: true,
					},
					tos_sip_vpn: {
						digits: true,
					},
				},
				highlight: function (element) {
					$(element).closest('.form-group').addClass('has-error');
				},
				unhighlight: function (element) {
					$(element).closest('.form-group').removeClass('has-error');
				}
			});
		</script>
		<?php
		$ret .= ob_get_clean();

		return $ret;
	}

// TODO: reworks the function unders. Each times:
//
//	-> the beroAri class is loaded although
//	-> two identical gets request -> useless: one is enough
// 
//	Besides, theses functions are identical. Possible to write a unique function
//
//			function sip_stack_parameter($parameter, $defaultValue) {
// 				return $parameter === '' ? $defaultValue : $parameter;
//			}
//

	/**
	 * @return int Bind port
	 */
	function bind_port($ba, $network_interface) {
		if ($ba->get('sip_bindport_' . $network_interface) != "") {
			return $ba->get("sip_bindport_" . $network_interface);
		} else {
			//Set default
			return 5060;
		}
	}

	/**
	 * @return string RTP Ports
	 */
	function rtpports($ba, $network_interface, $rtp_port) {
		if ($ba->get('rtpports_' . $network_interface) != "") {
			return $ba->get("rtpports_" . $network_interface);
		} else {
			//Set default
			return $rtp_port . "-" . ($rtp_port+=1000);
		}
	}

	/**
	 * @return int Registration refresh intervall
	 */
	function regrefresh($ba, $network_interface) {
		if ($ba->get('regrefresh_' . $network_interface) != "") {
			return $ba->get('regrefresh_' . $network_interface);
		} else {
			//Set default
			return 60;
		}
	}

	/**
	 * @return int Tos SIP value
	 */
	function tos_sip($ba, $network_interface) {
		if ($ba->get('tos_sip_' . $network_interface) != "") {
			return $ba->get('tos_sip_' . $network_interface);
		} else {
			//Set default
			return 160;
		}
	}

	/**
	 * @return int Tos RTP value
	 */
	function tos_rtp($ba, $network_interface) {
		if ($ba->get('tos_rtp_' . $network_interface) != "") {
			return $ba->get('tos_rtp_' . $network_interface);
		} else {
			//Set default
			return 160;
		}
	}

	/**
	 * Generates the dropdown ssl version
	 * @return string
	 */
	function ssl_version($ba, $network_interface) {
		$option = $ba->get("ssl_version_" . $network_interface);
		if (! ($option == "tls1.0" || $option == "tls1.1")) {
			$option = "tls1.2";
		}
		
		$options = $this->default['ssl_version'];
		ob_start();
		?>
		<select name='ssl_version_<?php echo $network_interface; ?>' class='form-control input-sm'>
			<?php
			foreach ($options as $value) {
				$selected = "";
				if ($option == $value) {
					$selected = "selected";
				}
				?>
				<option value='<?php echo $value ?>' <?php echo $selected ?>><?php echo $value ?></option>
			<?php } ?>
		</select>
		<?php
		return ob_get_clean();
	}

	/**
	 * Generates the checkboxes SIP Transport
	 * @return string
	 */
	private function sip_transport($ba, $network_interface) {
		$options = $ba->get("sip_transport_$network_interface");
		$option = explode(":", $options);
		
		if (strlen ($options) == 0) {
			$tcpChecked = "checked";
			$udpChecked = "checked";
		}
		else {
			$flag = 0;
			if (in_array("tls", $option)) {
				$tlsChecked = "checked";
				$flag = 1;
			}
			if (in_array("tcp", $option)) {
				$tcpChecked = "checked";
				$flag = 1;
			}
			if (in_array("udp", $option)) {
				$udpChecked = "checked";
				$flag = 1;
			}
			if (!$flag) {
				$udpChecked = "checked";
			}
		}
		ob_start();
		?>
		<input type='checkbox' name='sip_transport_<?php echo $network_interface; ?>[]' value='tls' id='sipt_tls_<?php echo $network_interface; ?>' 
			   onclick='javascript:tls_<?php echo $network_interface; ?>($(this).prop("checked"));' <?php echo $tlsChecked ?>> tls
		<input type='checkbox' name='sip_transport_<?php echo $network_interface; ?>[]' value='tcp' <?php echo $tcpChecked ?>> tcp
		<input type='checkbox' name='sip_transport_<?php echo $network_interface; ?>[]' value='udp' <?php echo $udpChecked ?>> udp
		<?php
		return ob_get_clean();
	}

	/**
	 * Generates the dropdown menu RTP port selectio
	 * @return string
	 */
	private function rtp_port_selection($ba, $network_interface) {
		$option = $ba->get("rtp_port_selection_$network_interface");
		$options = $this->default['rtp_port_selection'];
		ob_start();
		?>
		<select name="rtp_port_selection_<?php echo $network_interface; ?>" class="form-control" id="rtp_port_selection_<?php echo $network_interface; ?>">
			<?php
			foreach ($options as $value) {
				$selected = "";
				if ($option == $value) {
					$selected = "selected";
				}
				?>
				<option value='<?php echo $value ?>' <?php echo $selected ?>><?php echo $value ?></option>
			<?php } ?>
		</select>
		<?php
		return ob_get_clean();
	}
	
	private function tls_verification_selection($ba, $network_interface) {
		$option = $ba->get("tls_verification_selection_$network_interface");
		$options = $this->default['tls_verification_selection'];
		ob_start();
		?>
		<select name="tls_verification_selection_<?php echo $network_interface; ?>" class="form-control" id="tls_verification_selection_<?php echo $network_interface; ?>">
			<?php
			foreach ($options as $value) {
				$selected = "";
				if ($option == $value) {
					$selected = "selected";
				}
				?>
				<option value='<?php echo $value ?>' <?php echo $selected ?>><?php echo $value ?></option>
			<?php } ?>
		</select>
		<?php
		return ob_get_clean();
	}
	
	/**
	 * Generates the form field for each SIP stack
	 * @param string $network_interface
	 * @return string HTLM Block for each network interface
	 */
	private function generates_block($ba, $network_interface, $rtpport, $is_sbc_vm = false) {
		ob_start();
		?>
		<script type="text/javascript">
			function tls_<?php echo $network_interface; ?>(chk) {
				if (chk != true) {
					$('#tls_verification_selection_<?php echo $network_interface; ?>').hide();
					$('#ssl_version_<?php echo $network_interface; ?>').hide();
					$('#upload_cafile_<?php echo $network_interface; ?>').hide();
					$('#upload_agent_<?php echo $network_interface; ?>').hide();
				} else {
					$('#tls_verification_selection_<?php echo $network_interface; ?>').show();
					$('#ssl_version_<?php echo $network_interface; ?>').show();
					$('#upload_cafile_<?php echo $network_interface; ?>').show();
					$('#upload_agent_<?php echo $network_interface; ?>').show();
				}
			}
		</script>
		<p class="text-center lead" ><?php echo SIP_STACKS_TABLE_HEADER_DIS . " " . strtoupper($network_interface) .($is_sbc_vm && $network_interface == 'lan' ? '/VPN': '') ?> </p>
		<div class='form-group'>
			<label for='stack_active_<?php echo $network_interface; ?>' class='col-sm-5 control-label'><?php echo SIP_STACKS_ACTIVE_DIS ?></label>
			<div class='col-sm-4 form-checkbox'>
				<input type='hidden' name='stack_active_<?php echo $network_interface; ?>' value="0">
				<input type='checkbox' name='stack_active_<?php echo $network_interface; ?>' id='stack_active_<?php echo $network_interface; ?>' value="1" <?php echo $this->active($ba, $network_interface); ?>>
			</div>
		</div>
		<div class='form-group' data-toggle='tooltip' title='<?php echo SIP_STACKS_BINDPORT; ?>'>
			<label for='sip_bindport_<?php echo $network_interface; ?>' class='col-sm-5 control-label'><?php echo SIP_STACKS_BIND_PORT_DIS ?></label>
			<div class='col-sm-4'>
				<input type='text' class='form-control input-sm' name='sip_bindport_<?php echo $network_interface; ?>' id='sip_bindport_<?php echo $network_interface; ?>' 
					   value='<?php echo $this->bind_port($ba, $network_interface) ?>' >
			</div>
		</div>
		<div class='form-group' data-toggle='tooltip' title='<?php echo SIP_STACKS_RTPPORTS; ?>'>
			<label for='rtpports_<?php echo $network_interface; ?>' class='col-sm-5 control-label'><?php echo SIP_STACKS_RTP_PORT_RANGE_DIS ?></label>
			<div class='col-sm-4'>
				<input type='text' class='form-control input-sm' name='rtpports_<?php echo $network_interface; ?>' id='rtpports_<?php echo $network_interface; ?>' 
					   value='<?php echo $this->rtpports($ba, $network_interface, $rtpport) ?>' >
			</div>
		</div>
		<div class='form-group' data-toggle='tooltip' title='<?php echo SIP_STACKS_TOS_RTP; ?>'>
			<label for='tos_rtp_<?php echo $network_interface; ?>' class='col-sm-5 control-label'><?php echo SIP_STACKS_TOS_RTP_DIS ?></label>
			<div class='col-sm-4'>
				<input type='text' class='form-control input-sm' name='tos_rtp_<?php echo $network_interface; ?>' value='<?php echo $this->tos_rtp($ba, $network_interface) ?>' >
			</div>
		</div>
		<div class='form-group' data-toggle='tooltip' title='<?php echo SIP_STACKS_TOS_SIP; ?>'>
			<label for='tos_sip_<?php echo $network_interface; ?>' class='col-sm-5 control-label'><?php echo SIP_STACKS_TOS_SIP_DIS ?></label>
			<div class='col-sm-4'>
				<input type='text' class='form-control input-sm' name='tos_sip_<?php echo $network_interface; ?>' value='<?php echo $this->tos_sip($ba, $network_interface) ?>' >
			</div>
		</div>
		<div class='form-group'>
			<label for='rtp_port_selection_<?php echo $network_interface; ?>' class='col-sm-5 control-label'><?php echo SIP_STACKS_RTP_PORT_SELECTION_DIS ?></label>
			<div class='col-sm-4'>
				<?php echo $this->rtp_port_selection($ba, $network_interface) ?>
			</div>
		</div>
		<div class='form-group'>
			<label for='sip_transport_<?php echo $network_interface; ?>[]' class='col-sm-5 control-label'><?php echo SIP_STACKS_SIP_TRANSPORT_DIS ?></label>
			<div class='col-sm-4 form-checkbox'>
				<?php echo $this->sip_transport($ba, $network_interface) ?>
			</div>
		</div>
		<div class='form-group' id='ssl_version_<?php echo $network_interface; ?>'>
			<label for='ssl_version_<?php echo $network_interface; ?>' class='col-sm-5 control-label'><?php echo SIP_STACKS_SSL_VERSION_DIS ?></label>
			<div class='col-sm-4'>
				<?php echo $this->ssl_version($ba, $network_interface) ?>
			</div>
		</div>
		
		<div class='form-group' id='tls_verification_selection_<?php echo $network_interface; ?>'>
				<label for='tls_verification_selection_<?php echo $network_interface; ?>' class='col-sm-5 control-label'><?php echo SIP_STACKS_TLS_VERIFICATION_DIS ?></label>
			<div class='col-sm-4'>
				<?php echo $this->tls_verification_selection($ba, $network_interface) ?>
			</div>
		</div>
		
		
		
		<?php if (file_exists("/usr/conf/cafile_$network_interface.pem")): ?>
			<div class='form-group'>
				<label class='col-sm-5 control-label'><?php echo SIP_STACKS_UPLOAD_CERTIFICATE_DIS ?> (cafile.pem)</label>
				<div class='col-sm-4'>
					<input type='button' class='btn btn-default' value='<?php echo SIP_STACKS_DOWNLOAD_CERTIFICATE_DIS ?> (cafile_<?php echo $network_interface; ?>.pem)' 
						   onclick="window.location.href = 'misc/files_download.php?option=certificate&file=cafile_<?php echo $network_interface; ?>&network_interface=<?php echo $network_interface; ?>';">&nbsp;&nbsp;
					<input type='button' class='btn btn-default' value='<?php echo SIP_STACKS_DELETE_CERTIFICATE_DIS ?>' 
						   onclick="javascript:if (confirm('<?php echo SIP_STACKS_DELETE_CERTIFICATE_MESS_DIS ?>?') == true)
							window.location.href = 'misc/deletefile.php?m=<?php echo $this->m_attr ?>&option=certificate&file=cafile_<?php echo $network_interface; ?>&network_interface=<?php echo $network_interface; ?>';">
				</div>
			</div>
		<?php endif; ?>
		
		<?php if (file_exists("/usr/conf/agent_$network_interface.pem")): ?>
			<div class='form-group'>
				<label class='col-sm-5 control-label'><?php echo SIP_STACKS_UPLOAD_CERTIFICATE_DIS ?> (agent.pem)</label>
				<div class='col-sm-4'>
					<input type='button' class='btn btn-default' value='<?php echo SIP_STACKS_DOWNLOAD_CERTIFICATE_DIS ?> (agent_<?php echo $network_interface; ?>.pem)' 
						   onclick="window.location.href = 'misc/files_download.php?option=certificate&file=agent_<?php echo $network_interface; ?>&network_interface=<?php echo $network_interface; ?>';">&nbsp;&nbsp;
					<input type='button' class='btn btn-default' value='<?php echo SIP_STACKS_DELETE_CERTIFICATE_DIS ?>' 
						onclick="javascript:if (confirm('<?php echo SIP_STACKS_DELETE_CERTIFICATE_MESS_DIS ?>?') == true)
						window.location.href = 'misc/deletefile.php?m=<?php echo $this->m_attr ?>&option=certificate&file=agent_<?php echo $network_interface; ?>&network_interface=<?php echo $network_interface; ?>';">
				</div>
			</div>
		<?php endif; ?>
		
		<?php if (file_exists("/usr/conf/agent.pem")): ?>
			<div class='form-group'>
				<label class='col-sm-5 control-label'><?php echo SIP_STACKS_UPLOAD_OLD_CERTIFICATE_DIS ?> (agent.pem)</label>
				<div class='col-sm-4'>
					<input type='button' class='btn btn-default' value='<?php echo SIP_STACKS_DOWNLOAD_OLD_CERTIFICATE_DIS ?> (agent.pem)' 
						   onclick="window.location.href = 'misc/files_download.php?option=certificate&file=agent&network_interface=<?php echo $network_interface; ?>';">&nbsp;&nbsp;
					<input type='button' class='btn btn-default' value='<?php echo SIP_STACKS_DELETE_CERTIFICATE_DIS ?>' 
						onclick="javascript:if (confirm('<?php echo SIP_STACKS_DELETE_CERTIFICATE_MESS_DIS ?>?') == true)
						window.location.href = 'misc/deletefile.php?m=<?php echo$this->m_attr ?>&option=certificate&file=agent&network_interface=<?php echo $network_interface; ?>';">
				</div>
			</div>
		<?php endif; ?>
		
		<?php if (file_exists("/usr/conf/cafile.pem")): ?>
			<div class='form-group'>
				<label class='col-sm-5 control-label'><?php echo SIP_STACKS_UPLOAD_OLD_CERTIFICATE_DIS ?> (cafile.pem)</label>
				<div class='col-sm-4'>
					<input type='button' class='btn btn-default' value='<?php echo SIP_STACKS_DOWNLOAD_OLD_CERTIFICATE_DIS ?> (cafile.pem)' 
						   onclick="window.location.href = 'misc/files_download.php?option=certificate&file=cafile&network_interface=<?php echo $network_interface; ?>';">&nbsp;&nbsp;
					<input type='button' class='btn btn-default' value='<?php echo SIP_STACKS_DELETE_CERTIFICATE_DIS ?>' 
						onclick="javascript:if (confirm('<?php echo SIP_STACKS_DELETE_CERTIFICATE_MESS_DIS ?>?') == true)
						window.location.href = 'misc/deletefile.php?m=<?php echo$this->m_attr ?>&option=certificate&file=cafile&network_interface=<?php echo $network_interface; ?>';">
				</div>
			</div>
		<?php endif; ?>
		
		
		<div class='form-group' id='upload_cafile_<?php echo $network_interface; ?>' data-toggle='tooltip' title='<?php echo UPLOAD_CERTIFICATE; ?>'>
			<label for='uploadfile_cafile_<?php echo $network_interface; ?>' class='col-sm-5 control-label'><?php echo SIP_STACKS_UPLOAD_CERTIFICATE_DIS ?> (cafile_<?php echo $network_interface; ?>.pem)</label>
			<div class='col-sm-4 form-checkbox'>
				<input type='file' size='28' name='uploadfile_cafile_<?php echo $network_interface; ?>'>
			</div>
		</div>
		<div class='form-group' id='upload_agent_<?php echo $network_interface; ?>' data-toggle='tooltip' title='<?php echo UPLOAD_CERTIFICATE; ?>'>
			<label for='uploadfile_agent_<?php echo $network_interface; ?>' class='col-sm-5 control-label'><?php echo SIP_STACKS_UPLOAD_CERTIFICATE_DIS ?> (agent_<?php echo $network_interface; ?>.pem)</label>
			<div class='col-sm-4 form-checkbox'>
				<input type='file' size='28' name='uploadfile_agent_<?php echo $network_interface; ?>'>
			</div>
		</div>
		<br>


		<script type='text/javascript'>
			tls_<?php echo $network_interface; ?>($('#sipt_tls_<?php echo $network_interface; ?>').prop('checked'));
		</script>
		<?php
		return ob_get_clean();
	}

	/**
	 * Generates the HTML form
	 * @return string
	 */
	private function dynamic_table() {

		$ba = new beroAri();
		$bc = new beroConf('root');

		require_once("./includes/lang.php");

		if ($this->isFileUploaded) {
			foreach ($this->fileUploaded as $iface => $list) {
				foreach ($list as $type => $status) { 
					$ret .= "<div class='text-center'>"
						. "<img src='./includes/images/punkt_$status.gif'>"
						. "<font color='red'>". (($status === 'rot') ? SIP_STACKS_FILE_SIZE_DIS : SIP_STACKS_UPLOAD_SUCCESS_DIS ) ." ({$type}file_$iface.pem)</font>"
						. "</div>";
				}
			}
		}
		else if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}
		
		$has_lan_wan = 0;
		$has_vpn = 0;
		
		if ($bc->get('root', 'lan-mode') == 'lan-wan') {
			$has_lan_wan = 1;
		}
		if (is_dir('/home/admin/apps/openvpn/')) {
			$has_vpn = 1;
		}
		
		$is_sbc_vm = $bc->get('root', 'is-sbc-vm') == 1;
		$is_vpn_running = $bc->get('root', 'is-vpn-running') == 1;

		$table .= $ret .'<br/>' . "\n" . '<br/>' . "\n" .
		'<script>' . "\n" .
		"\t" . '$(function() {' . "\n" .
		"\t\t" . '$( "#tabs" ).tabs({active:0})' . "\n" .
		"\t" . '});' . "\n" .
		'</script>' . "\n" .
		"\n\n" . '<!-- BEGIN TABS //-->' . "\n\n" .
		'<div id="tabs" class="">' . "\n" .
		"\t".'<ul>' . "\n" .
		"\t\t".'<li><a href="#tabs-1">' . ($is_sbc_vm ? "SIP Stack WAN" : "SIP Stack LAN") .'</a></li>' . "\n";
		
		if ($has_lan_wan) {
			$table .= "\t\t".'<li><a href="#tabs-2">' . ($is_sbc_vm && $is_vpn_running ? "SIP Stack LAN/VPN" : "SIP Stack WAN") . '</a></li>' . "\n";
		}
		if ($has_vpn) {
			$table .= "\t\t".'<li><a href="#tabs-3">' . "SIP Stack VPN" . '</a></li>' . "\n";
		}
		$table .= "\t".'</ul>' . "\n\n";
		
		$table .= "\n\n" . '<!-- BEGIN TAB1 //-->' . "\n\n" . '<div id="tabs-1">' . "\n";
		$rtpport = 6000;
		$table .= $this->generates_block($ba, $is_sbc_vm ? 'wan' : 'lan', $rtpport, $is_sbc_vm);
		$table .= "</div>";
		
		if ($has_lan_wan) {
			$table  .="\n\n" . '<!-- BEGIN TAB2 //-->' . "\n\n" . '<div id="tabs-2">' . "\n";
			$rtpport = 8000;
			$table .= $this->generates_block($ba, $is_sbc_vm && $is_vpn_running ? 'lan' : 'wan', $rtpport, $is_sbc_vm);
			$table .= "</div>";
		}
		if ($has_vpn) {
			$table  .="\n\n" . '<!-- BEGIN TAB3 //-->' . "\n\n" . '<div id="tabs-3">' . "\n";
			$rtpport = 10000;
			$table .= $this->generates_block($ba, 'vpn', $rtpport, $is_sbc_vm);
			$table .= "</div>";
		}
		$table .="\n\n" . '<!-- END TABS //-->' . "\n" . '</div>' . "\n\n";
		
		//Rückgabe: Erzeugte Tabelle mit den änderbaren Feldern von den Einstellungen von isgw.conf
		return $table;
	}

	/**
	 * Return the checked state of each stack_active checkbox 
	 * @param string $network_interface
	 * @return string
	 */
	private function active($ba, $network_interface) {
		$active = (int) $ba->get("stack_active_" . $network_interface);
		if ($active === 1) {
			return "checked";
		}
		return "";
	}

}
?>
