<?PHP
$m = 'TimeConf';
$berogui_path = "/usr/local/www/berogui";

/* [CHECKING SESSION] */
$newTarget = "/app/berogui/index.php?m=$m";
include($berogui_path .'/includes/session.php');
unset($newTarget);

/* [INCLUDE] */
include('/usr/fallback/beroConf.php');
include_once($berogui_path ."/misc/database.php");
include_once($berogui_path ."/includes/isgwtelnet.php");
include_once($berogui_path ."/includes/Helper/Helper.php");

$exec_ajax = 1;
$invalid = array();

/* [CHECKING GET REQUEST] */
unset($_GET);

/* [CHECKING POST REQUEST] */
unset($_POST['action'], $_POST['Apply']);

$timezone_list = Helper::getTimezoneList();

$list_post = array('ntphost' => 'hostname', 'time_manual' => 'gmt', 'time_mode' => array('||', 'select', 'int>0'), 'timezone' => 'select', 'timezone_mode' => 'select');

$list_options = array( 
	'time_mode'	=> array('timezone', 'none', 'manual'),
	'timezone' 	=> array_keys($timezone_list),
	'timezone_mode' => array('winter', 'summer', 'auto'),
);

$_POST = Helper::sanitizePost($_POST, $list_post, $exec_ajax, $invalid, $list_options);

/* [EXECUTING AJAX] */
if (!$exec_ajax) {
        echo "<script>window.location='../../index.php?m=$m&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
        exit(1);
}

$bc = new beroConf('root');
$isgw = new isgwtelnet();
if (($response = $isgw->isgw_login()) == false) {
	echo "<script>window.location='../../index.php?m=$m&isgwerror=1'</script>";
	exit(1);
}

// default values
$data = array(
	'gui-ntphost'	=> '',
	'ntphost'	=> '',
	'time_from_isdn'=> '0',
	'time_mode'	=> sqlite_escape_string($_POST['time_mode']),
	'timezone'	=> '',
	'timezone_mode'	=> '',
);

$showDate = '';
$update_TZ = '';
switch ($_POST['time_mode']) {
	// summer/winter time
	case 'timezone':
		$data['ntphost'] = sqlite_escape_string($_POST['ntphost']);
		$data['gui-ntphost'] = sqlite_escape_string($_POST['ntphost']);

		$data['timezone'] = sqlite_escape_string($_POST['timezone']);
		$data['timezone_mode'] = sqlite_escape_string($_POST['timezone_mode']);

		// Does this part really useful ? What is its purpose ?
		if ($bc->get('root', $_POST['ntphost'])) {
			echo 	'<script>
                   			setTimeout(function () {
                        			location.href = location.href;
                     			}, 500);  // just reloads the page
                      		</script>';
		}

		$timezone = $timezone_list[sqlite_escape_string($_POST['timezone'])];
		switch ($data['timezone_mode']) {
			case 'auto':
				$update_TZ = "{$timezone['std-abbr']}{$timezone['std-offset']}{$timezone['dst-abbr']},{$timezone['rules']}";
				break;
			case 'summer':
				if (preg_match('/^(-|\+)(\d+)$/', $timezone['std-offset'], $gmt_matched)) {
					$gmt_modified = $gmt_matched[1]. (string)($gmt_matched[1] === '-' ? (int)$gmt_matched[2] + 1 : abs((int)$gmt_matched[2] - 1));
					$update_TZ = "GMT$gmt_modified";
				}
				else if (preg_match('/(-|\+)(\d+):(\d+)$/', $timezone['std-offset'], $gmt_matched)) {
					$gmt_modified = $gmt_matched[1]. (string)($gmt_matched[1] === '-' ? (int)$gmt_matched[2] + 1 : abs((int)$gmt_matched[2] - 1));
					$update_TZ = "GMT$gmt_modified:{$gmt_matched[3]}";
				}
				break;
			case 'winter':
				$update_TZ = "{$timezone['std-abbr']}{$timezone['std-offset']}";
				break;
		}

		$showDate = '&showDate=1';
		break;
	// manual/none time
	case 'manual':
		$data['ntphost'] = sqlite_escape_string($_POST['ntphost']);
		$data['gui-ntphost'] = sqlite_escape_string($_POST['ntphost']);

		$data['timezone'] = $_POST['time_manual'];
		if ($_POST['time_manual'] == 'GMT0') {
			$update_TZ = 'GMT0';
		}
		else if (preg_match('/^GMT(-|\+)([:\d]+)$/', $_POST['time_manual'], $gmt_matched)) {
			if ($gmt_matched[1] == '+') {
				$gmt_matched[1] = '-';
			}
			else {
				$gmt_matched[1] = '+';
			}
			if (preg_match('/^(\d+):(\d)$/', $gmt_matched[2], $time_matched)) {
				$gmt_matched[2] = ($time_matched[1] > 12 ? '12' : $time_matched[1]) . ":{$time_matched[2]}";
			}
			else if ((int)substr($gmt_matched[2], 0, 2) > 12 || strlen($gmt_matched[2]) == 5) {
				$gmt_matched[2] = 12;
			}
			$update_TZ = "GMT{$gmt_matched[1]}{$gmt_matched[2]}";
		}
		$showDate = '&showDate=1';
	case 'none':
		break;
	// isdn time. ISDN port given
	default:
		$update_TZ = 'GMT0';
		$data['time_from_isdn'] = sqlite_escape_string($_POST['time_mode']);
		break;
}

system(
	"/bin/mount -o remount,rw /;
	/bin/echo \"$update_TZ\" > /etc/TZ ;
	/bin/mount -o remount,ro /;
	/bin/sync;"
);
exec("/usr/sbin/update-time");

// update beroconf 
foreach ($data as $key => $value) {
	$bc->set("root", $key, $value);
}

// update isgw
$isgw->itpX($data['time_from_isdn']);

Helper::activate(1, true, $m, ACTIVATE);
echo "<script>window.location='../../index.php?m=$m$showDate'</script>";
exit(1);
?>
