<?php
/**
 * Implementiert die Seite, die das Gateway neustartet um eine Firmware zu installieren
 * @author Florian Kraatz <fk@beronet.com>
 * @author Miguel Palmer <mp@beronet.com>
 */

require_once('/usr/local/www/berogui/includes/Helper/HelperHtml.php');

class UpdateTool {

	private	$_m = null,
					$_is_sbc_vm = '0';

	private $_isError = false,
					$_reasonResponse 	= array();

	private $_data 				= array(),
					$_parameters 	= array();

	private	$_tabs = array(
						1 => array(
							'display'	=> '_sbcvmDisplayInfoTab',
							'form'		=> array(
								'action'				=> 'sbcvm-infotab',
								'has-required'	=> false,
								'id'						=> 'id-sbcvm-infotab',
								'style'					=> 'margin-top:15px',
							),
							'key'			=> 'sbcvm-info',
							'title'		=> 'UPDATE_TOOL_SBCVM_INFOTAB_DIS',
						),
						2 => array(
							'display'	=> '_sbcvmDisplaySettingsTab',
							'form'		=> array(
								'action'				=> 'sbcvm-settingstab',
								'has-required'	=> false,
								'id'						=> 'id-sbcvm-settingstab',
								'style'					=> 'margin-top:15px',
							),
							'key'			=> 'sbcvm-settings',
							'title'		=> 'UPDATE_TOOL_SBCVM_SETTINGSTAB_DIS',
						),
					);

	/* [CONSTRUCTOR] */
	function __construct($m, $get = array(), $post = array(), $session = array()) {
		$this->_m = $m;

		$image_dir = "/tmp/images";
		if (!file_exists($image_dir)) {
			system("mkdir -p $image_dir");
		}

		require_once('/usr/fallback/beroConf.php');
		$bc = new beroConf('root'); 
		$this->_is_sbc_vm = ($bc->get('root', 'is-sbc-vm') == 1) ? 1 : 0;
		if ($this->_is_sbc_vm) {
			// set data
			$this->_parameters = require('/usr/local/www/berogui/modules/UpdateTool/updatetool_parameters_sbcvm.php');
			$this->_data = $this->_parameters['load']($bc, array_keys($this->_tabs), $this->_parameters);

			foreach (array_keys($this->_tabs) as $nb) {
				foreach ($this->_parameters["tab-$nb"]['data'] as $key => $param) {
					if ($param['getData']) {
						$data = $bc->get('root', $key);
						$this->_data["tab-$nb"][$key] = strlen($data) == 0 ? $param['default'] : $data;
					}
				}
			}
		}
		else {
			$this->_parameters = require('/usr/local/www/berogui/modules/UpdateTool/updatetool_parameters.php');
		}

		// set error
		if (isset($get['error'])) {
			$this->_isError = true;
			$this->_reasonResponse = $get;
		}
	}

	/* [PUBLIC METHODS] */
	public function display() {
		$title = array(
			0 => 'UPDATE_TOOL_TITLE_DIS',
			1 => 'UPDATE_TOOL_SBCVM_TITLE_DIS',
		);
		$name = $title[$this->_is_sbc_vm];
		include('./includes/header.php');
		$ret .= "\n";

		$display_list = array(
			0 => '_displaySbc',
			1 => '_displaySbcVm',
		);
		$display = $display_list[$this->_is_sbc_vm];
		return $ret.$this->$display("\t");
	}

	/* [PRIVATE METHODS] */
	private function _buttonDownloadLogFile($tab = "") {
		$permlog = $this->_parameters['btns']['permlog'];
		if (!file_exists($permlog['file'])) {
			return '';
		}
		$dir_contents = scandir($permlog['file']);
		$file_count = 0;
		foreach ($dir_contents as $logfile) {
			if (($logfile == '.') || ($logfile == '..')) {
				continue;
			}
			$file_count++;
		}
		if ($file_count == 0) {
			return '';
		}
		$html =	"$tab<form method='POST'>\n"
					. "$tab\t<div class='text-center' style='margin-top:25px;'>\n"
					. "$tab\t\t<input type='button' class='btn btn-default' value='". constant($permlog['title']) ."'"
					.	"onclick='window.location.href=\"modules/UpdateTool/permlog.php\";' onmouseover='Tip(\"". constant($permlog['tooltip']) ."\");' onmouseout='UnTip();'/>\n"
					. "$tab\t</div>\n"
					. "$tab</form>\n";
		return $html;
	}

	private function _displaySbc($tab = "") {
		$msgs = $this->_parameters['msg'];
		$permlog = $this->_parameters['btns']['permlog'];
		$sbc_update = $this->_parameters['btns']['update'];

		//available FW version form FW list
		$html_fw = '';
		if (file_exists($sbc_update['file']) && $get_fw_list = file_get_contents($permlog['file'])) {
			if (preg_match("/Firmware ([0-9.]{1,5});appfs/", $get_fw_list, $fw_matched)) { 
				$html_fw =	"$tab<table class='table table-striped table-bordered' style='width:30% !important; margin:auto; text-align: center;'>\n"
									. "$tab\t<tr><th class='text-center'>". constant($msgs['available']) ."</th></tr>\n"
									. "$tab\t<tr><td>{$fw_matched[1]}</td></tr>\n"
									. "$tab</table>\n";
			}	
		}		
		ob_start();
		?>
		<script>
        	function checkupdate(option) {
          	if (option != "0") {
           		alert('<?php echo constant($msgs['alert']); ?>');
           		return false;
           	}
           	conf = confirm('<?php echo constant($msgs['confirm']); ?>');
						if (conf == false) {
            	return false;
            }
						else{
            	return true;
            }
        	}
    </script>
		<?php
		$html = ob_get_clean();
		$html .= $html_fw
					. "$tab<div class='text-center'>\n"
					. "$tab\t<form method='POST' action='./reboot.php' onsubmit='return checkupdate(\"". Helper::getActivateOption() ."\");'>\n"
					. "$tab\t\t<input type='hidden' name='action' value='reboot'>\n"
					. "$tab\t\t<input type='hidden' name='v' value='Yes'>\n"
					. "$tab\t\t<input type='hidden' name='module' value='fw_update'>\n"
					. "$tab\t\t<input type='submit' class='btn btn-default' name='submit' value='". constant($sbc_update['title']) ."'/>\n"
					. "$tab\t</form>\n"
					. $this->_buttonDownloadLogFile($tab)
					. "$tab</div>\n";

		return ($this->_isError ? $this->_setError($this->_reasonResponse) : '')
					. "<div id='content' style='margin-top:45px;'>\n"
					. $html
					. "</div>\n";
	}

	private function _displaySbcVm($tab = '') {
		$tabs = '';
		$tabs_menu = '';
		foreach ($this->_tabs as $id => $tab) {
			$tabs_menu .= "\t\t<li><a href='#tabs-$id'>". constant($tab['title'])  ."</a></li>\n";

			$function = $tab['display'];
			$tab['form']['uri'] = 'UpdateTool/updatetool_submit.php';
			$tabs .= $this->$function($id, $tab['form'], "\t");
		}

		$msg = ($this->_isError ? $this->_setError($this->_reasonResponse) : '')
					.	"\t\t<div id='ajax-response' class='text-center' style='margin-top: 5px; color: red;'></div>\n";
		return HelperHtml::buildTabs('tabs', $msg, $tabs_menu, $tabs);
	}

	private function _sbcvmDisplayInfoTab($id, $form, $tab = "") {
		$content = array('main-form' => '');
		$parameters = $this->_parameters["tab-$id"]; 
		foreach ($parameters['data'] as $key => $param) {
			$function = $param['display'];
			$content['main-form'] .= HelperHtml::$function($key, $this->_data["tab-$id"][$key], $param, "$tab\t\t");
		}
		foreach ($parameters['btns'] as $btn => $param) {
			$function = $param['display'];
			$content['main-form'] .= HelperHtml::$function($param['key'], $param['value'], $param, "$tab\t\t");
		}
		return HelperHtml::tab($id, $form, $this->_sbcvmJavascriptInfoTab($parameters['msg']), $content, null, $tab);
	}

	private function _sbcvmDisplaySettingsTab($id, $form, $tab = "") {
		$content = array('main-form' => '');
		$parameters = $this->_parameters["tab-$id"]; 
		foreach ($parameters['data'] as $key => $param) {
			$function = $param['display'];
			$content['main-form'] .= HelperHtml::$function($key, $this->_data["tab-$id"][$key], $param, "$tab\t\t");
		}
		foreach ($parameters['btns'] as $btn => $param) {
			$function = $param['display'];
			$content['main-form'] .= HelperHtml::$function($param['key'], $param['title'], null, "$tab\t\t");
		}
		return HelperHtml::tab($id, $form, null, $content, null, $tab);
	}

	private function _sbcvmJavascriptInfoTab($message) {
		ob_start();
		?>
		<script type='text/javascript' language='javascript'>
			window.ajaxLoading = false;
			function checkUpdate() {
				$.ajax({
					cache: false,
					data: { check_update:1 },
					error: function(request, stat, error) {
						checkUpdate();
					},
					success: function(data) {
						if (typeof data.success !== 'undefined') {
							$('#newer_firmware_available').hide();
							$('#newer_firmware_available').html('');
							$('#id_sbcvm-current-package').val(data.current_package);
							$('.form-group.sbcvm-available-package').hide();
							$('#ajax-response').css('color', 'green');
							$('#ajax-response').html('<?php echo constant($message['successful']); ?>');
							document.getElementById("wait_div").style.display = "none";
						}
						else if (typeof data.rebooting !== 'undefined') {
							window.setInterval(session, 1000);
							$("#wait_div").html("<p>"+ data.rebooting +"<img src='./includes/images/waitlogo1.gif'/></p>");
						}
						else {
							checkUpdate();
						}
					},
					timeout: 3000,
					type: 'POST',
					url: './modules/UpdateTool/updatetool_ajax.php',
				});
			}
			function doUpdate() {
				$.ajax({
					cache: false,
					data: {},
					error: function(request, stat, error) {
						checkUpdate();
					},
					success: function(data) {
						// should not happen: the update overwrite the updatetool_ajax.php script leading to a failure
						$('#id_sbcvm-current-package').value(data);
						$('.form-group.sbcvm-available-package').hide();
						$('#ajax-response').css('color', 'green');
						$('#ajax-response').html('<?php echo constant($message['successful']); ?>');
						document.getElementById("wait_div").style.display = "none";
					},
					timeout: 60000,
					type: 'POST',
					url: "./modules/UpdateTool/updatetool_ajax.php",
				});
			}
			function manualUpdate(isActiveCalls, callback) {
				var message;
				if (isActiveCalls == 0) {
					message = '<?php echo constant($message['act-call-confirm1']); ?>';
				}
				else {
					message = '<?php echo constant($message['act-call-confirm2']); ?>';
				}
				$("#dialog-confirm").dialog({
					autoOpen: false,
					modal: true
				});
				$('#dialog-confirm').dialog('option', 'title', '<?php echo constant($message['act-call-title']); ?>');	
				$("#dialogtext").html(message);
				$("#dialog-confirm").dialog("open");
				$("#dialog-confirm").dialog({
					buttons: {
						"Confirm": function () {
							$(this).dialog("close");
							window.ajaxLoading = false;
							document.getElementById("wait_div").style.display = "block";	
							callback();
						},
						"Cancel": function () {
							$(this).dialog("close");
							window.ajaxLoading = false;
							$('#id_sbcvm-update').prop('disabled', false);
						}
					}
				});
			}
			$(document).ready(function() {
				$('#id-sbcvm-infotab').submit(function (evt) {
					$('#ajax-response').html('');
					// manual update -> cancel submit and realize an AJAX request
					evt.preventDefault();
					if (window.ajaxLoading) {
						return;
					}
					else if (<?php echo Helper::getActivateOption(); ?> != 0) {
						$('#ajax-response').css('color', 'red');
						$('#ajax-response').html('<?php echo constant($message['activate']); ?>');
						return;
					}
					$('#id_sbcvm-update').prop('disabled', true);
					window.ajaxLoading = true;
					$.ajax({
						cache: false,
						error: function(request, stat, error) {
							$('#ajax-response').css('color', 'red');
							$('#ajax-response').html(error);
							window.ajaxLoading = false;
							$('#id_sbcvm-update').prop('disabled', false);
						},
						success: function(data) {
							manualUpdate(data, doUpdate);
						},
						timeout: 2000,
						url: "./misc/getTotalCalls.php",
					});
				});
			});
		</script>
		<?php
		return ob_get_clean();
	}

	private function _setError($reason) {
		switch ($reason['error']) {
		case 1:
			return Helper::displayErrorMessage($reason['request'], $reason['checkor'], $reason['key']);
		case 2:
		case 3:
			return "<div id='update-error' class='text-center' style='margin-top: 5px; color: red;'>"
				. constant($this->_parameters['submit']["error-{$reason['error']}"])
				. "</div>\n";
		default:
			return "";
		}
	}
}
?>
