<?php

/* [INTERN FUNCTIONS] */
function _loadData($bc, $tabs, &$parameters = null) {
	$data = [];
	foreach ($tabs as $tab) {
		foreach ($parameters["tab-$tab"]['data'] as $key => $param) {
			if ($param['getData']) {
				$value = $bc->get('root', $key);
				$data["tab-$tab"][$key] = strlen($value) == 0 ? $param['default'] : $value;
			}
		}
	}
	if (($data['tab-2']['sbcvmupdate-onlystable'] == 1 && preg_match('/.*rc.*/', $data['tab-1']['sbcvm-available-package'])) || is_null($data['tab-1']['sbcvm-available-package'])) {
		unset($parameters['tab-1']['data']['sbcvm-available-package']);
		$parameters['tab-1']['btns']['sbcvm-update']['disabled'] = true;
		$parameters['tab-1']['btns']['sbcvm-update']['title'] = 'UPDATE_TOOL_SBCVM_BUTTON_UPDATE_DISABLED';
	}
	return $data;
}

/* [PARAMETERS] */
$parameters = [
	'tab-1'	=> [
		'btns'	=> [
			'sbcvm-update' => [
				'default'		=> null,
				'disabled'	=> false,
				'display'		=> 'buttons',
				'key'				=> 'sbcvm-update',
				'title'			=> '',
				'value'			=> 'UPDATE_TOOL_SBCVM_BUTTON_UPDATE',
			],
		],
		'data'	=> [
			'sbcvm-current-package'	=> [
				'default'				=> null,
				'disabled'			=> true,
				'display'				=> 'fieldText',
				'getData'				=> true,
				'key'						=> 'sbcvm-current-package',
				'options'				=> null,
				'save'					=> false,
				'style'					=> null,
				'title'					=> 'UPDATE_TOOL_SBCVM_CURRENTPACKAGE_DIS',
				'tooltip'				=> 'UPDATE_TOOL_SBCVM_CURRENTPACKAGE_TOOLTIP',
				'validator'			=> null,
				'validator-java'=> null,
			],
			'sbcvm-available-package'	=> [
				'default'				=> null,
				'disabled'			=> true,
				'display'				=> 'fieldText',
				'getData'				=> true,
				'key'						=> 'sbcvm-available-package',
				'options'				=> null,
				'save'					=> false,
				'style'					=> null,
				'title'					=> 'UPDATE_TOOL_SBCVM_AVAILABLEPACKAGE_DIS',
				'tooltip'				=> 'UPDATE_TOOL_SBCVM_AVAILABLEPACKAGE_TOOLTIP',
				'validator'			=> null,
				'validator-java'=> null,
			],
			'sbcvm-changelog'	=> [
				'default'				=> null,
				'disabled'			=> false,
				'display'				=> 'fieldLink',
				'getData'				=> false,
				'key'						=> 'sbcvm-changelog',
				'link'					=> 'https://beronet.atlassian.net/wiki/spaces/PUB/pages/51085429/Changelog+-+beroNet+OS+Gateways', // TODO: use beronetsbc package changelog instead
				'message'				=> 'UPDATE_TOOL_SBCVM_CHANGELOG_MSG',
				'options'				=> null,
				'save'					=> false,
				'style'					=> [
					'div-a'	=> 'margin-top:8px;',
				],
				'title'					=> 'UPDATE_TOOL_SBCVM_CHANGELOG_DIS',
				'tooltip'				=> 'UPDATE_TOOL_SBCVM_CHANGELOG_TOOLTIP',
				'validator'			=> null,
				'validator-java'=> null,
			],
		],
		'msg'		=> [
			'act-call-confirm1' => 'UPDATE_TOOL_SBCVM_CONFIRM_WITHOUTCALLS',
			'act-call-confirm2' => 'UPDATE_TOOL_SBCVM_CONFIRM_WITHCALLS',
			'act-call-title'		=> 'UPDATE_TOOL_SBCVM_CONFIRM_TITLE',
			'activate'					=> 'UPDATE_TOOL_SBCVM_ACTIVATE',
			'successful'				=> 'UPDATE_TOOL_SBCVM_SUCCESSFUL',
		],
	],
	'tab-2'	=> [
		'btns'	=> [
			'sbcvmupdate-save' => [
				'default'	=> null,
				'display'	=> 'buttons',
				'key'			=> 'sbcvmupdate-save',
				'title'		=> 'BUTTON_SAVE',
			],
		],
		'data'	=> [
			'sbcvmupdate-mode' => [
				'default'				=> 'manual',
				'disabled'			=> null,
				'display'				=> 'fieldSelect',
				'getData'				=> true,
				'key'						=> 'sbcvmupdate-mode',
				'options'				=> [
					'select' => [
						'manual'	=> 'UPDATE_TOOL_SBCVM_DATA_MANUAL',
						'daily'		=> 'UPDATE_TOOL_SBCVM_DATA_DAILY',
						'weekly'	=> 'UPDATE_TOOL_SBCVM_DATA_WEEKLY',
						'monthly'	=> 'UPDATE_TOOL_SBCVM_DATA_MONTHLY',
					],
				],
				'save'					=> true,
				'style'					=> null,
				'title'					=> 'UPDATE_TOOL_SBCVM_MODE_DIS',
				'tooltip'				=> 'UPDATE_TOOL_SBCVM_MODE_TOOLTIP',
				'validator' 		=> 'select',
				'validator-java'=> null,
			],
			'sbcvmupdate-shownotif'	=> [
				'default'				=> 1,
				'disabled'			=> null,
				'display'				=> 'fieldCheckbox',
				'getData'				=> true,
				'key'						=> 'sbcvmupdate-shownotif',
				'options'				=> null,
				'save'					=> true,
				'style'					=> null,
				'title'					=> 'UPDATE_TOOL_SBCVM_SHOWNOTIF_DIS',
				'tooltip'				=> 'UPDATE_TOOL_SBCVM_SHOWNOTIF_TOOLTIP',
				'validator'			=> 'bool',
				'validator-java'=> null,
			],
			'sbcvmupdate-reboot' => [
				'default'				=> 1,
				'disabled'			=> null,
				'display'				=> 'fieldCheckbox',
				'getData'				=> true,
				'key'						=> 'sbcvmupdate-reboot',
				'options'				=> null,
				'save'					=> true,
				'style'					=> null,
				'title'					=> 'UPDATE_TOOL_SBCVM_REBOOT_DIS',
				'tooltip'				=> 'UPDATE_TOOL_SBCVM_REBOOT_TOOLTIP',
				'validator'			=> 'bool',
				'validator-java'=> null,
			],
			'sbcvmupdate-onlystable'	=> [
				'default'				=> 1,
				'disabled'			=> null,
				'display'				=> 'fieldCheckbox',
				'getData'				=> true,
				'key'						=> 'sbcvmupdate-onlystable',
				'options'				=> null,
				'save'					=> true,
				'style'					=> null,
				'title'					=> 'UPDATE_TOOL_SBCVM_ONLYSTABLE_DIS',
				'tooltip'				=> 'UPDATE_TOOL_SBCVM_ONLYSTABLE_TOOLTIP',
				'validator'			=> 'bool',
				'validator-java'=> null,
			],
		],
		'msg'		=> [
		],
	],
];

$submit = [
	'error-2'	=> 'UPDATE_TOOL_SBCVM_ERROR_CLEANING',
	'error-3'	=> 'UPDATE_TOOL_SBCVM_ERROR_SAVING_CRON',
];

return array_merge($parameters, [
	'load' 	=> '_loadData',
	'submit'=> $submit,
]);
?>
