<?php
/* [PARAMETERS - CLIENT] */
$client['btns'] = [
	'killClient' => [
		'display' => 'buttons',
		'key'			=> 'killClient',
		'options' => null,
		'title'		=> '',
		'type' 		=> 'submit',
		'value' 	=> 'VPN_BTNS_KILLCLIENT_DIS',
	],
];

$client['data'] = [
	'virtIpaddr' 	=> [
		'default' 			=> null,
		'disabled'			=> true,
		'display'				=> 'fieldText',
		'key' 					=> null,
		'options' 			=> null,
		'title'					=> 'VPN_DATA_VIRTIPADDR_DIS',
		'tooltip'				=> 'VPN_DATA_VIRTIPADDR_TOOLTIP',
		'validator'			=> null,
		'validator-java'=> null,
	],
	'realIpaddr' 	=> [
		'default' 			=> null,
		'disabled'			=> true,
		'display'				=> 'fieldText',
		'key' 					=> null,
		'options' 			=> null,
		'title'					=> 'VPN_DATA_REALIPADDR_DIS',
		'tooltip'				=> 'VPN_DATA_REALIPADDR_TOOLTIP',
		'validator'			=> null,
		'validator-java'=> null,
	],
	'connectedSince'=> [
		'default' 			=> null,
		'disabled'			=> true,
		'display'				=> 'fieldText',
		'key' 					=> null,
		'options' 			=> null,
		'title'					=> 'VPN_DATA_CONNECTEDSINCE_DIS',
		'tooltip'				=> 'VPN_DATA_CONNECTEDSINCE_TOOLTIP',
		'validator'			=> null,
		'validator-java'=> null,
	],
	'lastRef'			=> [
		'default' 			=> null,
		'disabled'			=> true,
		'display'				=> 'fieldText',
		'key' 					=> null,
		'options' 			=> null,
		'title'					=> 'VPN_DATA_LASTREF_DIS',
		'tooltip'				=> 'VPN_DATA_LASTREF_TOOLTIP',
		'validator'			=> 'ip4',
		'validator-java'=> null,
	],
	'bytesRcvd'		=> [
		'default' 			=> null,
		'disabled'			=> true,
		'display'				=> 'fieldText',
		'key' 					=> null,
		'options' 			=> null,
		'title'					=> 'VPN_DATA_BYTESRCVD_DIS',
		'tooltip'				=> 'VPN_DATA_BYTESRCVD_TOOLTIP',
		'validator'			=> null,
		'validator-java'=> null,
	],
	'bytesSent'		=> [
		'default' 			=> null,
		'disabled'			=> true,
		'display'				=> 'fieldText',
		'key' 					=> null,
		'options' 			=> null,
		'title'					=> 'VPN_DATA_BYTESSENT_DIS',
		'tooltip'				=> 'VPN_DATA_BYTESSENT_TOOLTIP',
		'validator'			=> null,
		'validator-java'=> null,
	],
];

$client['msgs'] = [
	'killClient' => 'VPN_CONFIRM_KILLCLIENT_DIS', 
];

/* [PARAMETERS - SERVER] */
$server['btns'] = [
	'actions' => [
		'display'	=> 'buttons',
		'key'			=> 'actions',
		'name'		=> null,
		'options' => [
			'delete'=> [
				'key'		=> 'delete',
				'title'	=> '',
				'type' 	=> 'submit',
				'value' => 'BUTTON_DELETE',
			],
			'save'	=> [
				'key'		=> 'save',
				'title'	=> '',
				'type'	=> 'submit',
				'value'	=> 'BUTTON_SAVE',
			],	
		],
		'title'	=> null,
		'type'	=> null,
		'value'	=> null,
	],
];

$server['data']	= [
	'ipaddr' 	=> [
		'default' 			=> '10.0.0.1',
		'disabled'			=> true,
		'display'				=> 'fieldText',
		'key' 					=> 'ipaddr',
		'options' 			=> null,
		'title'					=> 'VPN_DATA_IPADDR_DIS',
		'tooltip'				=> 'VPN_DATA_IPADDR_TOOLTIP',
		'validator'			=> 'ip4',
		'validator-java'=> null,
	],
	'iprange' 	=> [
		'default' 			=> '10.0.0.0',
		'disabled'			=> false,
		'display'				=> 'fieldText',
		'key' 					=> 'iprange',
		'options' 			=> null,
		'title'					=> 'VPN_DATA_IPRANGE_DIS',
		'tooltip'				=> 'VPN_DATA_IPRANGE_TOOLTIP',
		'validator'			=> 'ip4',
		'validator-java'=> 'required:true, verifyIP: true, verifyIPrange: true',
	],
	'ipnetmask' 	=> [
		'default' 			=> '255.255.255.0',
		'display'				=> 'fieldText',
		'key' 					=> 'ipnetmask',
		'options' 			=> null,
		'title'					=> 'VPN_DATA_IPNETMASK_DIS',
		'tooltip'				=> 'VPN_DATA_IPNETMASK_TOOLTIP',
		'validator'			=> 'ip4',
		'validator-java'=> 'required:true, verifyIP: true, verifyIPrange: true',
	],
	'protocol' 	=> [
		'default' 			=> 'UDP',
		'display'				=> 'fieldSelect',
		'key' 					=> 'protocol',
		'title'					=> 'VPN_DATA_PROTOCOL_DIS',
		'tooltip'				=> 'VPN_DATA_PROTOCOL_TOOLTIP',
		'options' 			=> [
			'select' => [
				'udp' => 'PROTOCOL_UDP',
				'tcp' => 'PROTOCOL_TCP',
			],
		],
		'validator'			=> 'select',
		'validator-java'=> null,
	],
];

$server['msgs'] = [
	'confirmDelete'	=> 'VPN_CONFIRM_DELETE_VPN',
];

/* [EXTERN FUNCTIONS] */
function loadParameters($bc, $parameters) {
	if (!($bc->get('root', 'is-vpn-running') == 1)) {
		unset($parameters['server']['data']['ipaddr'], $parameters['server']['btns']['actions']['options']['delete']);
	}
	return [
		'client' => $parameters['client'],
		'server' => $parameters['server'],
	];
}

/* [EXPORT] */
return [
	// extern functions
	'load'	=> 'loadParameters',
	// parameters
	'client' => $client,
	'server' => $server,
];
