<?php
	/*
	 *		PSTN Class to Wizard Modal
	 *
	 */

class PstnWizard
{
	// main variables
	var $nb_lif	    = 0;
	var $which_scenario = 1;

	var $tones_loaded = array();
	var $file_tones   = '/usr/conf/isgw.tones';

	var $t1e1  = false  ;
	var $types = array();
	var $ports = array();
	var $start = array();
	var $lifs  = array();

	var $list_port_types  = array();
	var $list_start_ports = array();

	var $pri_wizard = 'pri-wizard';
	var $bri_wizard = 'bri-wizard';
	var $gsm_wizard = 'gsm-wizard';
	var $lte_wizard = 'lte-wizard';
	var $fxs_wizard = 'fxs-wizard';
	var $fxo_wizard = 'fxo-wizard';

	var $port_types = array('id' => 'port-types', 'name' => 'port_types', 'title' => WIZARD_PSTN_PORT_TYPE_DIS, 'tooltip' => '', 'type' => 'radio', 'postCheck' => 'select', 'options' => array('bri', 'pri', 'gsm', 'lte', 'fxs', 'fxo'));

	// PRI
	var $pri_group	 = array('id' => 'pri-group'   , 'name' => 'pri_group'	 , 'title' => PSTN_NAME_DIS   	     	 , 'tooltip' => ISDN_GROUP_NAME 	, 'type' => 'text'    , 'postCheck' => 'group-name'	   , 'options' => '');
	var $pri_ports	 = array('id' => 'pri-ports'   , 'name' => 'pri_ports[]' , 'title' => PSTN_PORTS_DIS  	     	 , 'tooltip' => ISDN_PORTS_TABLE	, 'type' => 'checkbox', 'postCheck' => 'int>=0'		   , 'options' => '');
	var $pri_ntte	 = array('id' => 'pri-ntte'    , 'name' => 'pri_ntte'	 , 'title' => HARDWARE_INTERFACE_TYPE_DIS, 'tooltip' => ISDNHW_MODE		, 'type' => 'select'  , 'postCheck' => 'select'		   , 'options' => array('TE', 'NT'));
	var $pri_t1e1	 = array('id' => 'pri-t1e1'    , 'name' => 'pri_t1e1'	 , 'title' => HARDWARE_PROTOCOL_DIS    	 , 'tooltip' => ISDNHW_PTPE1		, 'type' => 'select'  , 'postCheck' => 'select'		   , 'options' => array('T1', 'E1'));
	var $pri_tones	 = array('id' => 'pri-tones'   , 'name' => 'pri_tones'	 , 'title' => PSTN_TONES_DIS  	     	 , 'tooltip' => ISDN_TONES		, 'type' => 'select'  , 'postCheck' => 'tones'		   , 'options' => '');
	var $pri_country = array('id' => 'pri-country' , 'name' => 'pri_country' , 'title' => PSTN_COUNTRY_CODE_DIS   	 , 'tooltip' => WIZARD_COUNTRY_CODE	, 'type' => 'text'    , 'postCheck' => 'international-code', 'options' => '');
	var $pri_city	 = array('id' => 'pri-city'    , 'name' => 'pri_city'	 , 'title' => PSTN_CITY_CODE_DIS      	 , 'tooltip' => WIZARD_CITY_CODE	, 'type' => 'text'    , 'postCheck' => 'int>=0'		   , 'options' => '');
	//var $pri_local = array('id' => 'pri-local'   , 'name' => 'pri_local'	 , 'title' => PSTN_LOCAL_AREA_CODE_DIS	 , 'tooltip' => WIZARD_LOCAL_AREA_CODE	, 'type' => 'text'    , 'postCheck' => ''		   , 'options' => '');
	var $pri_user	 = array('id' => 'pri-user'    , 'name' => 'pri_user'	 , 'title' => SIP_USER_DIS    	     	 , 'tooltip' => TRUNKS_SIP_USER		, 'type' => 'text'    , 'postCheck' => 'special-char'	   , 'options' => '');
	var $pri_secret	 = array('id' => 'pri-secret'  , 'name' => 'pri_secret'	 , 'title' => SIP_SECRET_DIS  	     	 , 'tooltip' => TRUNKS_SIP_SECRET	, 'type' => 'password', 'postCheck' => 'password'	   , 'options' => '');

	// BRI 
	var $bri_group	 = array('id' => 'bri-group'   , 'name' => 'bri_group'	 , 'title' => PSTN_NAME_DIS   	     	 , 'tooltip' => ISDN_GROUP_NAME 	, 'type' => 'text'    , 'postCheck' => 'group-name'	   , 'options' => '');
	var $bri_ports	 = array('id' => 'bri-ports'   , 'name' => 'bri_ports[]' , 'title' => PSTN_PORTS_DIS  	     	 , 'tooltip' => ISDN_PORTS_TABLE	, 'type' => 'checkbox', 'postCheck' => 'int>=0'		   , 'options' => '');
	var $bri_ptp	 = array('id' => 'bri-ptp'     , 'name' => 'bri_ptp'	 , 'title' => HARDWARE_PROTOCOL_DIS   	 , 'tooltip' => ISDNHW_PTP		, 'type' => 'select'  , 'postCheck' => 'select'		   , 'options' => array('PTP', 'PMP'));
	var $bri_tones	 = array('id' => 'bri-tones'   , 'name' => 'bri_tones'	 , 'title' => PSTN_TONES_DIS  	     	 , 'tooltip' => ISDN_TONES		, 'type' => 'select'  , 'postCheck' => 'tones'		   , 'options' => '');
	var $bri_country = array('id' => 'bri-country' , 'name' => 'bri_country' , 'title' => PSTN_COUNTRY_CODE_DIS   	 , 'tooltip' => WIZARD_COUNTRY_CODE	, 'type' => 'text'    , 'postCheck' => 'international-code', 'options' => '');
	var $bri_city	 = array('id' => 'bri-city'    , 'name' => 'bri_city'	 , 'title' => PSTN_CITY_CODE_DIS      	 , 'tooltip' => WIZARD_CITY_CODE	, 'type' => 'text'    , 'postCheck' => 'int>=0'		   , 'options' => '');
	//var $bri_local = array('id' => 'bri-local'   , 'name' => 'bri_local'	 , 'title' => PSTN_LOCAL_AREA_CODE_DIS	 , 'tooltip' => WIZARD_LOCAL_AREA_CODE	, 'type' => 'text'    , 'postCheck' => ''		   , 'options' => '');
	var $bri_user	 = array('id' => 'bri-user'    , 'name' => 'bri_user'	 , 'title' => SIP_USER_DIS    	     	 , 'tooltip' => TRUNKS_SIP_USER		, 'type' => 'text'    , 'postCheck' => 'special-char'	   , 'options' => '');
	var $bri_secret	 = array('id' => 'bri-secret'  , 'name' => 'bri_secret'	 , 'title' => SIP_SECRET_DIS  	     	 , 'tooltip' => TRUNKS_SIP_SECRET	, 'type' => 'password', 'postCheck' => 'password'	   , 'options' => '');

	// GSM
	var $gsm_group	 = array('id' => 'gsm-group'   , 'name' => 'gsm_group'	 , 'title' => PSTN_NAME_DIS   , 'tooltip' => GSM_GROUP_NAME  	, 'type' => 'text'    , 'postCheck' => 'group-name'	, 'options' => '');
	var $gsm_ports	 = array('id' => 'gsm-ports'   , 'name' => 'gsm_ports[]' , 'title' => PSTN_PORTS_DIS  , 'tooltip' => GSM_PORTS_TABLE 	, 'type' => 'checkbox', 'postCheck' => 'int>=0'		, 'options' => '');
	var $gsm_user	 = array('id' => 'gsm-user'    , 'name' => 'gsm_user'	 , 'title' => SIP_USER_DIS    , 'tooltip' => TRUNKS_SIP_USER  	, 'type' => 'text'    , 'postCheck' => 'special-char'	, 'options' => '');
	var $gsm_secret	 = array('id' => 'gsm-secret'  , 'name' => 'gsm_secret'	 , 'title' => SIP_SECRET_DIS  , 'tooltip' => TRUNKS_SIP_SECRET	, 'type' => 'password', 'postCheck' => 'password'	, 'options' => '');

	// LTE 
	var $lte_group	 = array('id' => 'lte-group'   , 'name' => 'lte_group'	 , 'title' => PSTN_NAME_DIS   , 'tooltip' => LTE_GROUP_NAME  	, 'type' => 'text'    , 'postCheck' => 'group-name'	, 'options' => '');
	var $lte_ports	 = array('id' => 'lte-ports'   , 'name' => 'lte_ports[]' , 'title' => PSTN_PORTS_DIS  , 'tooltip' => LTE_PORTS_TABLE 	, 'type' => 'checkbox', 'postCheck' => 'int>=0'		, 'options' => '');
	var $lte_user	 = array('id' => 'lte-user'    , 'name' => 'lte_user'	 , 'title' => SIP_USER_DIS    , 'tooltip' => TRUNKS_SIP_USER  	, 'type' => 'text'    , 'postCheck' => 'special-char'	, 'options' => '');
	var $lte_secret	 = array('id' => 'lte-secret'  , 'name' => 'lte_secret'	 , 'title' => SIP_SECRET_DIS  , 'tooltip' => TRUNKS_SIP_SECRET	, 'type' => 'password', 'postCheck' => 'password'	, 'options' => '');

	// FXS	
	var $fxs_group	 = array('id' => 'fxs-group'   , 'name' => 'fxs_group'	 , 'title' => PSTN_NAME_DIS   , 'tooltip' => ANALOG_GROUP_NAME 	, 'type' => 'text'    , 'postCheck' => 'group-name'	, 'options' => '');
	var $fxs_ports	 = array('id' => 'fxs-ports'   , 'name' => 'fxs_ports[]' , 'title' => PSTN_PORTS_DIS  , 'tooltip' => ANALOG_PORTS_TABLE	, 'type' => 'checkbox', 'postCheck' => 'int>=0'		, 'options' => '');
	var $fxs_tones	 = array('id' => 'fxs-tones'   , 'name' => 'fxs_tones'	 , 'title' => PSTN_TONES_DIS  , 'tooltip' => ANALOG_TONES	, 'type' => 'text'    , 'postCheck' => 'tones'		, 'options' => '');
	var $fxs_user	 = array('id' => 'fxs-user'    , 'name' => 'fxs_user'	 , 'title' => SIP_USER_DIS    , 'tooltip' => TRUNKS_SIP_USER	, 'type' => 'text'    , 'postCheck' => 'special-char'	, 'options' => '');
	var $fxs_secret	 = array('id' => 'fxs-secret'  , 'name' => 'fxs_secret'	 , 'title' => SIP_SECRET_DIS  , 'tooltip' => TRUNKS_SIP_SECRET	, 'type' => 'password', 'postCheck' => 'password'	, 'options' => '');
	var $fxs_csvfile = array('id' => 'fxs-csvfile' , 'name' => 'fxs_csvfile' , 'title' => ''	      , 'tooltip' => ''			, 'type' => 'hidden'  , 'postCheck' => 'accept'		, 'options' => '');

	// FXO
	var $fxo_group	 = array('id' => 'fxo-group'   , 'name' => 'fxo_group'	 , 'title' => PSTN_NAME_DIS   , 'tooltip' => ANALOG_GROUP_NAME 	, 'type' => 'text'    , 'postCheck' => 'group-name'	, 'options' => '');
	var $fxo_ports	 = array('id' => 'fxo-ports'   , 'name' => 'fxo_ports[]' , 'title' => PSTN_PORTS_DIS  , 'tooltip' => ANALOG_PORTS_TABLE	, 'type' => 'checkbox', 'postCheck' => 'int>=0'		, 'options' => '');
	var $fxo_tones	 = array('id' => 'fxo-tones'   , 'name' => 'fxo_tones'	 , 'title' => PSTN_TONES_DIS  , 'tooltip' => ANALOG_TONES	, 'type' => 'text'    , 'postCheck' => 'tones'		, 'options' => '');
	var $fxo_user	 = array('id' => 'fxo-user'    , 'name' => 'fxo_user'	 , 'title' => SIP_USER_DIS    , 'tooltip' => TRUNKS_SIP_USER	, 'type' => 'text'    , 'postCheck' => 'special-char'	, 'options' => '');
	var $fxo_secret	 = array('id' => 'fxo-secret'  , 'name' => 'fxo_secret'	 , 'title' => SIP_SECRET_DIS  , 'tooltip' => TRUNKS_SIP_SECRET	, 'type' => 'password', 'postCheck' => 'password'	, 'options' => '');

	// multiple module managment
	var $nb_port_types   = 'nb_porttypes';
	var $multiple_config = false;

	function __construct($scenario = 1, $init = true)
	{
		if (isset($_SESSION['pbx'])) {
			$this -> which_scenario = 2;			
        } else {
        	$this -> which_scenario = $scenario;                          
        }

		if ($init)
		{
			$this -> _lifs_info();

			// get main port types
			$this -> list_port_types = $this -> types;
			if (in_array('BRIFXS', $this -> list_port_types))
			{
				$this -> list_port_types[] = 'BRI';
				$this -> list_port_types[] = 'FXS';
	
				$key_brifxs = array_search('BRIFXS', $this -> list_port_types);
				unset($this -> list_port_types[$key_brifxs]);
			}
			$this -> list_port_types = array_merge(array_unique($this -> list_port_types));

			// remove unknown from list_port_types
			if (($key_unkn = array_search('unknown', $this -> list_port_types)) !== false)
			{
				unset($this -> list_port_types[$key_unkn]);
			}

			// get start ports list 
			$this -> list_start_ports = $this -> _get_start_ports();	

			// load tones from file
			if (file_exists($this -> file_tones))
			{
                		exec('/bin/cat '. $this -> file_tones .' | /bin/grep "^\[.*\]$" ', $this -> tones_loaded);
			}

			// update multiple config boolean
			$this -> multiple_config = ($this -> which_scenario == 2 && count($this -> list_port_types) > 1);
		}
	}

	// private
/* General Functions */
	function _lifs_info ()
	{
		require_once('./includes/Helper/Helper.php');

		$lif 		= Helper::getLif();
		$this -> nb_lif = Helper::getLifCount();

		for ($i = 0; $i < $this -> nb_lif; $i++) 
		{
			$this -> lifs[$i]  = $lif[$i];
			$this -> ports[$i] = substr($lif[$i], 2, 1);

			switch(substr($lif[$i], 3))
			{
				case "S0":
					$this -> types[$i] = "BRI";
					$this -> start[$i] = "isdn";
					break;
				case "t1e1":
					$this -> t1e1 = true;
				case "E1":
					$this -> types[$i] = "PRI";
					$this -> start[$i] = "isdn";
					break;
				case "S02FXS":
					$this -> types[$i] = "BRIFXS";
					$this -> start[$i] = "isdn/analog";
					break;
				case "FXS":
					$this -> types[$i] = "FXS";
					$this -> start[$i] = "analog";
					break;
				case "FXO":
					$this -> types[$i] = "FXO";
					$this -> start[$i] = "analog";
					break;
				case "GSM":
					$this -> types[$i] = "GSM";
					$this -> start[$i] = "gsm";
					break;
				case "LTE":
					$this -> types[$i] = "LTE";
					$this -> start[$i] = "lte";
					break;
				default:
					$this -> types[$i] = "unknown";
					$this -> start[$i] = "n";
					break;
			}
		}
	}

	function _get_post_list()
	{
		return array(	// GENERAL
				$this->port_types,
				// PRI
				$this->pri_group, $this->pri_ports, $this->pri_ntte, $this->pri_t1e1, $this->pri_tones, $this->pri_country, $this->pri_city,/*this->pri_local',*/ $this->pri_user, $this->pri_secret,
				// BRI 
				$this->bri_group, $this->bri_ports, $this->bri_ptp, $this->bri_tones, $this->bri_country, $this->bri_city,/*this->bri_local',*/ $this->bri_user, $this->bri_secret,
				// GSM
				$this->gsm_group, $this->gsm_ports, $this->gsm_user, $this->gsm_secret,
				// LTE 
				$this->lte_group, $this->lte_ports, $this->lte_user, $this->lte_secret,
				// FXS	
				$this->fxs_group, $this->fxs_ports, $this->fxs_user, $this->fxs_secret, $this->fxs_tones, $this->fxs_csvfile, 
				// FXO
				$this->fxo_group, $this->fxo_ports, $this->fxo_user, $this->fxo_secret, $this->fxo_tones
			    );
	}

	function _get_intern_post_conditions_list($post, $ports, $user, $secret, $tones, $intern = 'intern')
	{
		$intern_conditions = array('post' => array(), 'options' => array());

		$port_name = str_replace('[]', '', $ports['name']);

		foreach ($post as $key => $value)
		{
			if (preg_match("/^{$intern}_{$port_name}_([0-9]+)$/", $key, $match))
			{
				$intern_conditions['post'][$match[0]] = $ports['postCheck'];
				$intern_conditions['options'][$match[0]] = $ports['options'];

				$intern_conditions['post']["{$intern}_{$user['name']}_{$match[1]}"] = $user['postCheck'];
				$intern_conditions['options']["{$intern}_{$user['name']}_{$match[1]}"] = $user['options'];
				
				$intern_conditions['post']["{$intern}_{$secret['name']}_{$match[1]}"] = $secret['postCheck'];
				$intern_conditions['options']["{$intern}_{$secret['name']}_{$match[1]}"] = $secret['options'];

				$intern_conditions['post']["{$intern}_{$tones['name']}_{$match[1]}"] = $tones['postCheck'];
				$intern_conditions['options']["{$intern}_{$tones['name']}_{$match[1]}"] = $tones['options'];
			}
		}

		return $intern_conditions;
	}

	function _get_start_ports ()
	{
		$start_isdn   = 1;
		$start_analog = 1;
		$start_ports  = array();

		for ($j = 0; $j < $this -> nb_lif; $j++)
		{
			foreach (array_keys($this -> list_port_types) as $i)
			{
				if (preg_match("#". $this -> list_port_types[$i] ."#", $this -> types[$j]))
				{
					// update isdn start port
					if (strcmp('isdn', $this -> start[$j]) == 0 || (strcmp('isdn/analog', $this -> start[$j]) == 0 && strcmp('BRI', $this -> list_port_types[$i]) == 0))
					{
						$start_ports[$this -> list_port_types[$i]][$j]['isdn']['start'] = $start_isdn;
						$start_ports[$this -> list_port_types[$i]][$j]['isdn']['ports'] = $this -> ports[$j];
						$start_isdn += $this -> ports[$j];
					}
					// update analog start port
					else if (strcmp('analog', $this -> start[$j]) == 0 || (strcmp('isdn/analog', $this -> start[$j]) == 0 && strcmp('FXS', $this -> list_port_types[$i]) == 0))
					{
						$start_ports[$this -> list_port_types[$i]][$j]['analog']['start'] = $start_analog;
						$start_ports[$this -> list_port_types[$i]][$j]['analog']['ports'] = $this -> ports[$j];
						$start_analog += $this -> ports[$j];
					}
					// set the other start port
					else
					{
						$start_ports[$this -> list_port_types[$i]][$j][$this -> start[$j]]['start'] = 1;
						$start_ports[$this -> list_port_types[$i]][$j][$this -> start[$j]]['ports'] = $this -> ports[$j];
					}
				} 
			}
		} 

		return $start_ports;
	}

        function _tones ($port_type, $name, $id, $tones, $disabled, $extern = '', $tab = "\t\t\t\t\t\t")
	{
                $select = $tab. "<select class=\"form-control input-sm select-$extern$port_type\" name=\"$name\" id=\"$id\"$disabled>\n";

                foreach ($this -> tones_loaded as $value) 
		{
                        if ($tones == "") 
			{
                                if ($value == "[de]") 
				{
                                        $select .= $tab. "\t<option value=\"" . $value . "\" selected>" . $value . "</option>\n";
                                } 
				else if ($value != "[general]") 
				{
                                        $select .= $tab. "\t<option value=\"" . $value . "\">" . $value . "</option>\n";
                                }
                        } 
			else 
			{
                                if ($value == "[$tones]") 
				{
                                        $select .= $tab. "\t<option value=\"" . $value . "\" selected>" . $value . "</option>\n";
                                } 
				else if ($value != "[general]") 
				{
                                        $select .= $tab. "\t<option value=\"" . $value . "\">" . $value . "</option>\n";
                                }
                        }
                }

                $select .= $tab. "\t</select>\n";
                return $select;
        }

	function _get_pstn_id_from_port_type ($port_type)
	{
		switch ($port_type)
		{
			case 'PRI':
				return $this -> pri_wizard;
			case 'BRI':
				return $this -> bri_wizard;
			case 'GSM':
				return $this -> gsm_wizard;
			case 'FXO':
				return $this -> fxo_wizard;
			case 'FXS':
				return $this -> fxs_wizard;
			case 'LTE':
				return $this -> lte_wizard;
			default:
				return 'error';
		}
	}

	function _display_content ($pstn_cfg, $port_type)
	{
		switch ($port_type)
		{
			case 'PRI':
				return $this -> _display_content_pri($pstn_cfg);
			case 'BRI':
				return $this -> _display_content_bri($pstn_cfg);
			case 'GSM':
				return $this -> _display_content_gsm($pstn_cfg);
			case 'LTE':
				return $this -> _display_content_lte($pstn_cfg);
			case 'FXO':
				return $this -> _display_content_fxo($pstn_cfg);
			case 'FXS':
				return $this -> _display_content_fxs($pstn_cfg);
		}
		
		return '';
	}

	function _display_simple_select ($parameter, $options, $port_type, $tab = "\t\t\t\t")
	{
		$options_str = '';
		foreach ($options as $option)
		{
			$options_str .= $tab. "\t\t\t<option size='40' value='{$option['value']}'{$option['selected']}>{$option['value']}</option>\n";
		}

		return	  $tab. "<div class='form-group' data-toggle='tooltip' title='{$parameter['tooltip']}'>\n"
			. $tab. "\t<label class='col-sm-3 control-label' for='{$parameter['id']}-for'>{$parameter['title']}</label>\n"
			. $tab. "\t<div class='col-sm-8'>\n"
			. $tab. "\t\t<select class='form-control input-sm select-$port_type' name='{$parameter['name']}' id='{$parameter['id']}'>\n" 
			. $options_str 
			. $tab. "\t\t</select>\n"
			. $tab. "\t</div>\n"
			. $tab. "</div>\n";
	}

	function _display_simple_field ($port_type, $id, $name, $title, $type, $tooltip, $value, $tab = "\t\t\t\t")
	{
		return 	  $tab. "<div class='form-group' data-toggle='tooltip' title='$tooltip'>\n"
			. $tab. "\t<label for='$name' class='col-sm-3 control-label'>$title</label>\n"
			. $tab. "\t<div class='col-sm-8'>\n"
			. $tab. "\t\t<input type='$type' class='form-control input-sm $port_type' name='$name' id='$id' value='$value'>\n"
			. $tab. "\t</div>\n"
			. $tab. "</div>\n";		
	}

	function _display_tones ($id, $name, $title, $tooltip, $port_type, $tones, $disabled = '', $tab = "\t\t\t\t")
	{
		if (file_exists($this -> file_tones))
		{
			return	  $tab. "<div class='form-group' data-toggle='tooltip' title='$tooltip'>\n"
				. $tab. "\t<label for='$name' class='col-sm-3 control-label'>$title</label>\n"
				. $tab. "\t<div class='col-sm-8'>\n" 
				. $this -> _tones($port_type, $name, $id, $tones, $disabled)
				. $tab. "\t</div>\n"
				. $tab. "</div>\n";
		}

		return '';
	}

	function _display_ports_field ($pstn_cfg, $ports, $port_type, $parameter, $techno, $boolOnchange = false, $tab = "\t\t\t\t")
	{
		$title 	    = '';
		$line_ports = '';
		 
		$header_ports =   $tab. "<div class='form-group' id='{$parameter['id']}-tr'>\n"
				. $tab. "\t<label for='{$parameter['name']}' class='col-sm-3 control-label'>{$parameter['title']}</label>\n"
				. $tab. "\t<div class='col-sm-8'>\n";

		$nb_ports   = 0;
		for ($i = 0; $i < $this -> nb_lif; $i++)
		{
			if (preg_match("#$port_type#", $this -> types[$i]))
			{
				$start_ports = $this -> list_start_ports[$port_type][$i][$techno]['start'];
				$nb_ports    = $this -> list_start_ports[$port_type][$i][$techno]['ports'];

				$line_ports .= 	  $tab. "\t\t<div>\n"
						. $tab. "\t\t\tLi$i ({$this -> lifs[$i]}) : \n"
						. $this -> _display_ports($pstn_cfg, $port_type, $start_ports, $nb_ports, $parameter, $ports, $boolOnchange, $techno) 
						. $tab. "\t\t</div>\n";
			}
		}

		return 	  $header_ports
			. $line_ports
			. $tab. "\t</div>\n"
			. $tab. "</div>\n";
	}

	function _display_ports ($pstn_cfg, $port_type, $start_ports, $nb_ports, $parameter, $array_checked_ports, $boolOnchange, $techno, $tab = "\t\t\t\t\t\t\t") 
	{
		$html_str = '';

		for ($i = $start_ports; $i < ($nb_ports + $start_ports); $i++)
		{
			// update onchange (only for BRI module)
			$onchange = '';
			if ($boolOnchange)
			{
				$onchange = " onchange=\"switch_bri_port('$i', 1);\"";
			}

			// update checked if the port used by an intern port or not used
			$checked  = ' checked';
			if ((count($array_checked_ports) > 0 && !(in_array($i, $array_checked_ports))) && isset($pstn_cfg['intern_'. strtolower($port_type) .'_ports_'. $i]))
			{
				$checked = '';
			}

			$html_str .= $tab. "<input type='{$parameter['type']}' class='$port_type' name='{$parameter['name']}' id='{$parameter['id']}-$i' value='$i'$checked$onchange>Port $i\n";
		}

		return $html_str;
	}

	function _intern_port_line ($port_type, $type_cfg, $ports, $user, $secret, $tones, $start_ports, $nb_ports, $intern = 'intern', $tab = "\t\t\t\t")
	{
		$table = '';

		// boolean variables
		$booleanFileTones = file_exists($this -> file_tones);

		$booleanBri = true;
		if (strcmp($port_type, 'FXS') == 0)
		{
			$booleanBri = false;
		}

		// check if ports used as extern
		$array_ports_extern = (isset($type_cfg[$ports['name']]) ? explode('-', $type_cfg[$ports['name']]) : array());

		for ($i = $start_ports; $i < ($nb_ports + $start_ports); $i++)
		{
			$id_extern_port = $ports['id'] ."-$i";
			
			$checked    = '';
			$disabled   = ' disabled';
			if (isset($type_cfg["{$intern}_". strtolower($port_type) ."_ports_$i"]) && !(in_array("$i", $array_ports_extern)))
			{
				$checked     = ' checked';
				$disabled    = '';
			}

			$user_value   = (isset($type_cfg["{$intern}_{$user['name']}_$i"]) ? $type_cfg["{$intern}_{$user['name']}_$i"] : '');
			$user_tooltip = "data-toggle='tooltip' title='{$user['tooltip']}'";

			$secret_value   = (isset($type_cfg["{$intern}_{$secret['name']}_$i"]) ? $type_cfg["{$intern}_{$secret['name']}_$i"] : '');
			$secret_tooltip = "data-toggle='tooltip' title='{$secret['tooltip']}'";

			$onchange  = ($booleanBri ? " onclick=\"switch_bri_port('$i', 0);\"" : " onclick=\"activate_fxs_port('$i');\"");

			$table .= $tab. "<div class='row'>\n"
				. $tab. "\t<div class='col-sm-3'>\n"
				. $tab. "\t\t<div class='form-group'>\n"
				. $tab. "\t\t\t<label for='$intern-{$ports['id']}-$i' class='col-sm-2 control-label'>$i</label>\n"
				. $tab. "\t\t\t<div class='col-sm-5'>\n"
				. $tab. "\t\t\t\t<input type='{$ports['type']}' class='$intern-$port_type' name='{$intern}_{$ports['name']}_$i' id='$intern-{$ports['id']}-$i' value='$i'$onchange$checked>\n"
				. $tab. "\t\t\t</div>\n"
				. $tab. "\t\t</div>\n"
				. $tab. "\t</div>\n"
				. $tab. "\t<div class='col-sm-3'>\n"
				. $tab. "\t\t<input type='{$user['type']}' class='form-control input-sm $intern-$port_type' $user_tooltip name='{$intern}_{$user['name']}_$i' id='$intern-{$user['id']}-$i' value='$user_value'$disabled>\n"
				. $tab. "\t</div>\n"
				. $tab. "\t<div class='col-sm-3'>\n"
				. $tab. "\t\t<input type='{$secret['type']}' class='form-control input-sm $intern-$port_type' $secret_tooltip name='{$intern}_{$secret['name']}_$i' id='$intern-{$secret['id']}-$i' value='$secret_value'$disabled>\n"
				. $tab. "\t</div>\n";

			if ($booleanFileTones)
			{
				$tones_value = (isset($type_cfg["{$intern}_{$tones['name']}_$i"]) ? $type_cfg["{$intern}_{$tones['name']}_$i"] : '');

				$table .= $tab. "\t<div class='col-sm-3'>\n"
        				. $this -> _tones($port_type, "{$intern}_{$tones['name']}_$i", "$intern-{$tones['id']}-$i", $tones_value, $disabled, "$intern-")
					. $tab. "\t</div>\n";
			}
		
			$table .= $tab. "</div>\n";
		}

		return $table;
	}

/* get required input (jquery validator */
	function _get_port_depends ($ports_id, $ports_name, $port_type)
	{
		ob_start();
?>
							depends: function () {
								var uniquePorts = [];
								
								for (var typeNode of document.getElementsByName('<?php echo $ports_name; ?>').values())
								{
									var port = typeNode.id.slice(-1);
 									if (uniquePorts.indexOf(port) == -1)
									{
										if ($('#<?php echo $ports_id; ?>-' + port).is(':checked'))
										{
											return true;
										}
										uniquePorts.push(port);
									}
								}

								$('.<?php echo $port_type; ?>').prop('value', '');
								$('.<?php echo $port_type; ?>').prop('checked', false);
								$('.form-control.input-sm.<?php echo $port_type; ?>').prop('value', '');

								return false;
							}
<?php
		return ob_get_clean();
	}

	function _get_validator_input_group ($group_name, $port_depends = '', $tab = "\t\t\t\t\t")
	{
		$required = "true,\n";
		if (strlen($port_depends) > 0)
		{
			$required =	  "{\n"
					. $port_depends
					. $tab. "\t},\n";
		}

		return 	  $tab. "'$group_name': {\n"
			. $tab. "\trequired: $required"
			. $tab. "\tcheckDigChar: $required"
			. $tab. "},\n";
	}

	function _get_validator_input_ports ($ports_name, $tab = "\t\t\t\t\t")
	{
	 	return	  $tab. "'$ports_name': {\n"
		  	. $tab. "\tatLeastOnePortWizard: true,\n"
			. $tab. "},\n";
	}

	function _get_validator_input_country ($country_name, $tab = "\t\t\t\t\t")
	{
		$required = '';
		if ($this -> which_scenario == 3)
		{
			$required = $tab. "\trequired: true,\n";
		}

		return 	  $tab. "'$country_name': {\n"
			. $required
			. $tab. "\tcheckPhoneNumber: true,\n"
			. $tab. "},\n";
	}

	function _get_validator_input_city ($city_name, $tab = "\t\t\t\t\t")
	{
		$required = '';
		if ($this -> which_scenario == 3)
		{
			$required = $tab. "\trequired: true,\n";
		}
	
		return	  $tab. "'$city_name': {\n"
			. $required
			. $tab. "\tdigits: true,\n"
			. $tab. "},\n";
	}

	function _get_validator_input_user ($user_type, $tab = "\t\t\t\t\t")
	{
		return 	  $tab. "$user_type: {\n"
			. $tab. "\tspecChar: true,\n"
			. $tab. "},\n";
	}

	function _get_validator_intern_inputs ($port_type, $techno, $name_user, $intern = 'intern')
	{	
		$validator = '';

		// loop to get intern ports 
		for ($i = 0; $i < $this -> nb_lif; $i++)
		{
			if (preg_match("#$port_type#", $this -> types[$i]))
			{
				$start_ports = $this -> list_start_ports[$port_type][$i][$techno]['start'];
				$nb_ports    = $this -> list_start_ports[$port_type][$i][$techno]['ports'];

				for ($i = $start_ports; $i < ($nb_ports + $start_ports); $i++) 
				{
					$validator .= $this -> _get_validator_input_user("{$intern}_{$name_user}_$i");
				}
			}
		}

		return $validator;
	}




/*
	function _get_validator_input_local ($local_name, $tab = "\t\t\t\t\t")
	{
		return	  $tab. "'$local_name': {\n"
			. $tab. "\tdigits: true,\n"
			. $tab. "},\n";
	}
*/
/* display intern html code */
	function _display_intern_table_ports ($port_type, $type_cfg, $ports, $user, $secret, $tones, $techno, $tab = "\t\t\t\t")
	{
		$table =  $tab. "<div class='row'>\n"
			. $tab. "\t<div class='col-sm-3'><strong>". $ports['title']  ."</strong></div>\n"
			. $tab. "\t<div class='col-sm-3'><strong>". $user['title']   ."</strong></div>\n"
			. $tab. "\t<div class='col-sm-3'><strong>". $secret['title'] ."</strong></div>\n"
			. $tab. "\t<div class='col-sm-3'><strong>". $tones['title']  ."</strong></div>\n"
			. $tab. "</div>\n";
	
		// delete [ ] from name variable
		$ports['name'] = preg_replace("/[\[\]]/", '', $ports['name']);

		for ($i = 0; $i < $this -> nb_lif; $i++)
		{
			if (preg_match("#$port_type#", $this -> types[$i]))
			{
				$start_ports = $this -> list_start_ports[$port_type][$i][$techno]['start'];
				$nb_ports    = $this -> list_start_ports[$port_type][$i][$techno]['ports'];

				$table .= $this -> _intern_port_line($port_type, $type_cfg, $ports, $user, $secret, $tones, $start_ports, $nb_ports);
			}
		}

		return $table;
	}

/* PRI */
	function _get_pri_hardware_configuration ($pri_hdw, $pri_cfg, $port_type, $tab = "\t\t\t\t")
	{ 
		$options = array('te' => array( 'value' => 'TE', 'selected' => ' selected'),
				 'nt' => array( 'value' => 'NT', 'selected' => ''	  ));

		if ($this -> which_scenario == 3)
		{
			return $tab. "<input type='hidden' class='form-control input-sm $port_type' id='{$pri_hdw['id']}' name='{$pri_hdw['name']}' value='{$options['te']['value']}'>\n";
		}

		if (isset($pri_cfg[$pri_hdw['name']]) && strcmp($pri_cfg[$pri_hdw['name']], 'NT') == 0)
		{
			$options['te']['selected'] = ''; 
			$options['nt']['selected'] = ' selected'; 
		}

		return $this -> _display_simple_select($pri_hdw, $options, $port_type);
	}

	function _get_pri_protocol_t1e1_configuration ($pri_prtcl, $pri_cfg, $port_type)
	{
		$options = array('t1' => array( 'value' => 'T1', 'selected' => ''	  ),
				 'e1' => array( 'value' => 'E1', 'selected' => ' selected'));

		if (isset($pri_cfg[$pri_prtcl['name']]) && strcmp($pri_cfg[$pri_prtcl['name']], 'T1') == 0)
		{
			$options['t1']['selected'] = ' selected'; 
			$options['e1']['selected'] = ''; 
		}

		return $this -> _display_simple_select($pri_prtcl, $options, $port_type);
	}

	function _display_content_pri ($pri_cfg, $port_type = 'PRI')
	{
		// init viariables
		$name_pri_ports_modified = preg_replace('/\[\]/', '', $this -> pri_ports['name']);

		$group 		= ( isset($pri_cfg[$this -> pri_group['name']])   ? $pri_cfg[$this -> pri_group['name']] 		: '' 	 );
		$array_ports 	= ( isset($pri_cfg[$name_pri_ports_modified])	  ? explode('-', $pri_cfg[$name_pri_ports_modified])	: array());
		$tones		= ( isset($pri_cfg[$this -> pri_tones['name']])	  ? $pri_cfg[$this -> pri_tones['name']]		: ''	 );
		$country 	= ( isset($pri_cfg[$this -> pri_country['name']]) ? $pri_cfg[$this -> pri_country['name']]	 	: ''	 ); 
		$city	 	= ( isset($pri_cfg[$this -> pri_city['name']]) 	  ? $pri_cfg[$this -> pri_city['name']]	 		: '' 	 ); 
		//$local 	= ( isset($pri_cfg[$this -> pri_local['name']])   ? $pri_cfg[$this -> pri_local['name']] 		: '' 	 ); 

		// ports html string
		$ports_str = $this -> _display_ports_field ($pri_cfg, $array_ports , $port_type, $this -> pri_ports, 'isdn');

		// sip html string
		$sip_str = '';
		if ($this -> which_scenario == 2)
		{
			$user 	= ( isset($pri_cfg[$this -> pri_user['name']]) 	 ? $pri_cfg[$this -> pri_user['name']]	: ''); 
			$secret	= ( isset($pri_cfg[$this -> pri_secret['name']]) ? $pri_cfg[$this -> pri_secret['name']]: ''); 

			$sip_str =	  $this -> _display_simple_field($port_type, $this -> pri_user['id']  , $this -> pri_user['name']  , $this -> pri_user['title']  , $this -> pri_user['type']  , $this -> pri_user['tooltip']  , $user  )
					. $this -> _display_simple_field($port_type, $this -> pri_secret['id'], $this -> pri_secret['name'], $this -> pri_secret['title'], $this -> pri_secret['type'], $this -> pri_secret['tooltip'], $secret);
		}

		// Select nt ot te
		$ntte_str = $this -> _get_pri_hardware_configuration($this -> pri_ntte, $pri_cfg, $port_type);

		// Select t1 or e1
		$t1e1_str = (($this -> t1e1) ? $this -> _get_pri_protocol_t1e1_configuration($this -> pri_t1e1, $pri_cfg, $port_type) : '');

		// tones html string
		$tones_str = $this -> _display_tones($this -> pri_tones['id'], $this -> pri_tones['name'], $this -> pri_tones['title'], $this -> pri_tones['tooltip'], $port_type, $tones);

		// return html string
		return 	  $this -> _display_simple_field($port_type, $this -> pri_group['id']  , $this -> pri_group['name']  , $this -> pri_group['title']  , $this -> pri_group['type']  , $this -> pri_group['tooltip']  , $group   	 )
			. $ports_str
			. $sip_str
			. $ntte_str
			. $ptp_str
			. $t1e1_str
			. $tones_str
			. $this -> _display_simple_field($port_type, $this -> pri_country['id'], $this -> pri_country['name'], $this -> pri_country['title'], $this -> pri_country['type'], $this -> pri_country['tooltip'], $country	 )
			. $this -> _display_simple_field($port_type, $this -> pri_city['id']   , $this -> pri_city['name']   , $this -> pri_city['title']   , $this -> pri_city['type']   , $this -> pri_city['tooltip']   , $city	 );
			//. $this -> _display_simple_field($port_type, $this -> pri_local['id']  , $this -> pri_local['name']  , $this -> pri_local['title']  , $this -> pri_local['type']  , $this -> pri_local['tooltip']  , $local	 );
	}

	function _get_validator_pri_inputs ()
	{		
		return 	  $this -> _get_validator_input_group($this -> pri_group['name'])
			. $this -> _get_validator_input_ports($this -> pri_ports['name'])
			. ($this -> which_scenario == 2 ? $this -> _get_validator_input_user($this -> bri_user['name']) : '')
			. $this -> _get_validator_input_country($this -> pri_country['name'])
			. $this -> _get_validator_input_city($this -> pri_city['name']);
			//. $this -> _get_validator_input_local($this -> pri_local['name']);
	}

/* BRI */
	function _javascript_code_switch_bri_port ()
	{
		ob_start();
?>
	function switch_bri_port (port, extern)
	{
                if (extern)
                {
			$('#intern-<?php echo $this -> bri_ports['id']; ?>-' + port).prop('checked', !($('#<?php echo $this -> bri_ports['id']; ?>-' + port).prop('checked')));
                }
		else
		{
			$('#<?php echo $this -> bri_ports['id']; ?>-' + port).prop('checked', !($('#intern-<?php echo $this -> bri_ports['id']; ?>-' + port).prop('checked')));
		}

		var intern_port_checked = $('#intern-<?php echo $this -> bri_ports['id']; ?>-' + port).prop('checked');
                $('#intern-<?php echo $this -> bri_user['id']; ?>-' + port).prop('disabled', !(intern_port_checked));
                $('#intern-<?php echo $this -> bri_secret['id']; ?>-' + port).prop('disabled', !(intern_port_checked));
                $('#intern-<?php echo $this -> bri_tones['id']; ?>-' + port).prop('disabled', !(intern_port_checked));

	}
<?php		
		return ob_get_clean();
	}

	function _get_bri_protocol_configuration ($bri_prtcl, $bri_cfg, $port_type)
	{
		$options = array('ptp' => array( 'value' => 'PTP', 'selected' => ' selected'),
				 'pmp' => array( 'value' => 'PMP', 'selected' => ''	    ));

		if (isset($isdn_cfg[$bri_prtcl['name']]) && strcmp($bri_cfg[$bri_prtcl['name']], 'PMP') == 0)
		{
			$options['ptp']['selected'] = '';
			$options['pmp']['selected'] = ' selected';
		}

		return $this -> _display_simple_select($bri_prtcl, $options, $port_type);
	}

	function _display_content_extern_bri ($bri_cfg, $sip_str, $boolOnchange = false, $port_type = 'BRI')
	{
		// init viariables
		$name_bri_ports_modified = preg_replace('/\[\]/', '', $this -> bri_ports['name']);

		$group 		= ( isset($bri_cfg[$this -> bri_group['name']])   ? $bri_cfg[$this -> bri_group['name']] 		: ''	 );
		$array_ports 	= ( isset($bri_cfg[$name_bri_ports_modified])	  ? explode('-', $bri_cfg[$name_bri_ports_modified])	: array());
		$tones 		= ( isset($bri_cfg[$this -> bri_tones['name']])	  ? $bri_cfg[$this -> bri_tones['name']]		: ''	 );
		$country 	= ( isset($bri_cfg[$this -> bri_country['name']]) ? $bri_cfg[$this -> bri_country['name']]	 	: ''	 ); 
		$city	 	= ( isset($bri_cfg[$this -> bri_city['name']]) 	  ? $bri_cfg[$this -> bri_city['name']]	 		: '' 	 ); 
		//$local 	= ( isset($bri_cfg[$this -> bri_local['name']])   ? $bri_cfg[$this -> bri_local['name']] 		: ''	 );

		// hardware and protocol configuration
		$ptp_str  = $this -> _get_bri_protocol_configuration($this -> bri_ptp , $bri_cfg  , $port_type);

		// ports html string
		$ports_str = $this -> _display_ports_field ($bri_cfg, $array_ports , $port_type, $this -> bri_ports, 'isdn', $boolOnchange);

		// tones html string
		$tones_str = $this -> _display_tones($this -> bri_tones['id'], $this -> bri_tones['name'], $this -> bri_tones['title'], $this -> bri_tones['tooltip'], $port_type, $tones);

		// return html string
		return	  $this -> _display_simple_field($port_type, $this -> bri_group['id']  , $this -> bri_group['name']  , $this -> bri_group['title']  , $this -> bri_group['type']  , $this -> bri_group['tooltip']  , $group	)
			. $ports_str
			. $sip_str
			. $ptp_str
			. $tones_str
			. $this -> _display_simple_field($port_type, $this -> bri_country['id'], $this -> bri_country['name'], $this -> bri_country['title'], $this -> bri_country['type'], $this -> bri_country['tooltip'], $country	)
			. $this -> _display_simple_field($port_type, $this -> bri_city['id']   , $this -> bri_city['name']   , $this -> bri_city['title']   , $this -> bri_city['type']   , $this -> bri_city['tooltip']   , $city	);
			//. $this -> _display_simple_field($port_type, $this -> bri_local['id']  , $this -> bri_local['name']  , $this -> bri_local['title']  , $this -> bri_local['type']  , $this -> bri_local['tooltip']  , $local	);
	}

	function _display_content_bri ($bri_cfg, $port_type = 'BRI', $port_type_lower = 'bri', $tab = "\t\t\t\t")
	{
		$sip_str	= '';
		$title_extern   = '';
		$intern_content = '';
		$boolOnchange   = false;

		if ($this -> which_scenario == 2)
		{
			// update Extern Content
			$boolOnchange = true;  
			$title_extern = $tab. "<p class='text-center h4'>". WIZARD_EXTERN_BRI_DIS ."</p>\n";

			$user   = ( isset($bri_cfg[$this -> bri_user['name']])   ? $bri_cfg[$this -> bri_user['name']]   : '' );
			$secret = ( isset($bri_cfg[$this -> bri_secret['name']]) ? $bri_cfg[$this -> bri_secret['name']] : '' );

			$sip_str =	  $this -> _display_simple_field($port_type, $this -> bri_user['id']  , $this -> bri_user['name']  , $this -> bri_user['title']  , $this -> bri_user['type']  , $this -> bri_user['tooltip']  , $user  )
					. $this -> _display_simple_field($port_type, $this -> bri_secret['id'], $this -> bri_secret['name'], $this -> bri_secret['title'], $this -> bri_secret['type'], $this -> bri_secret['tooltip'], $secret);

			// create Intern Content
			$intern_content =   $tab. "<p class='text-center h4'>". WIZARD_INTERN_BRI_DIS ."</p>\n"
					  . $this -> _display_intern_table_ports($port_type, $bri_cfg, $this -> bri_ports, $this -> bri_user, $this -> bri_secret, $this -> bri_tones, 'isdn');
		}

		return $title_extern . $this -> _display_content_extern_bri($bri_cfg, $sip_str, $boolOnchange) . $intern_content;
	}	

	function _get_validator_bri_inputs ($port_type = 'BRI', $techno = 'isdn') 
	{
		$intern_depends	= '';	
		$user_depends	= '';
		$ports_depends 	= '';
		$ports_required = '';

		if ($this -> which_scenario == 2)
		{
			// extern
			$user_depends  = $this -> _get_validator_input_user($this -> bri_user['name']);
			$ports_depends = $this -> _get_port_depends($this -> bri_ports['id'], $this -> bri_ports['name'], 'BRI');

			// intern
			$inter_depends = $this -> _get_validator_intern_inputs($port_type, $techno, $this -> bri_user['name']);
		}
		else 	
		{
			$ports_required = $this -> _get_validator_input_ports($this -> bri_ports['name']);
		}

		return 	  $this -> _get_validator_input_group($this -> bri_group['name'], $ports_depends)
			. $user_depends
			. $ports_required
			. $this -> _get_validator_input_country($this -> bri_country['name'])
			. $this -> _get_validator_input_city($this -> bri_city['name'])
			//. $this -> _get_validator_input_local($this -> bri_local['name'])
			. $intern_depends; 
	}

/* GSM */
	function _display_content_gsm ($gsm_cfg, $port_type = 'GSM', $tab = "\t\t\t\t")
	{
		// init variables
		$name_gsm_ports_modified = preg_replace('/\[\]/', '', $this -> gsm_ports['name']);

		$group 		= ( isset($gsm_cfg[$this -> gsm_group['name']]) ? $gsm_cfg[$this -> gsm_group['name']] 			: ''	 );
		$array_ports 	= ( isset($gsm_cfg[$name_gsm_ports_modified])   ? explode('-', $gsm_cfg[$name_gsm_ports_modified])	: array());
		$tones		= ( isset($gsm_cfg[$this -> gsm_tones['name']]) ? $gsm_cfg[$this -> gsm_tones['name']]			: ''	 );

		// ports html string
		$ports_str = $this -> _display_ports_field($gsm_cfg, $array_ports , $port_type, $this -> gsm_ports, 'gsm');

		// sip string
		$sip_str = '';
		if ($this -> which_scenario == 2)
		{
			$user		= ( isset($gsm_cfg[$this -> gsm_user['name']])	? $gsm_cfg[$this -> gsm_user['name']]	: ''	 );
			$secret		= ( isset($gsm_cfg[$this -> gsm_secret['name']])? $gsm_cfg[$this -> gsm_secret['name']]	: ''	 );

		 	$sip_str =   $this -> _display_simple_field($port_type, $this -> gsm_user['id']  , $this -> gsm_user['name']  , $this -> gsm_user['title']  , $this -> gsm_user['type']  , $this -> gsm_user['tooltip']  , $user  )
		 		   . $this -> _display_simple_field($port_type, $this -> gsm_secret['id'], $this -> gsm_secret['name'], $this -> gsm_secret['title'], $this -> gsm_secret['type'], $this -> gsm_secret['tooltip'], $secret);
		}

		return 	  $this -> _display_simple_field($port_type, $this -> gsm_group['id'], $this -> gsm_group['name'], $this -> gsm_group['title'], $this -> gsm_group['type'], $this -> gsm_group['tooltip'], $group)
			. $ports_str 
			. $sip_str;
	}

	function _get_validator_gsm_inputs ()
	{		
		return    $this -> _get_validator_input_group($this -> gsm_group['name'])
			. $this -> _get_validator_input_ports($this -> gsm_ports['name'])
			. ($this -> which_scenario == 2 ? $this -> _get_validator_input_user($this -> gsm_user['name']) : '');
	}

/* LTE */
	function _display_content_lte ($lte_cfg, $port_type = 'LTE', $tab = "\t\t\t\t")
	{
		// init variables
		$name_lte_ports_modified = preg_replace('/\[\]/', '', $this -> lte_ports['name']);

		$group 		= ( isset($lte_cfg[$this -> lte_group['name']]) ? $lte_cfg[$this -> lte_group['name']] 			: ''	 );
		$array_ports 	= ( isset($lte_cfg[$name_lte_ports_modified])   ? explode('-', $lte_cfg[$name_lte_ports_modified])	: array());
		$tones		= ( isset($lte_cfg[$this -> lte_tones['name']]) ? $lte_cfg[$this -> lte_tones['name']]			: ''	 );

		// ports html string
		$ports_str = $this -> _display_ports_field($lte_cfg, $array_ports , $port_type, $this -> lte_ports, 'lte');

		// sip string
		$sip_str = '';
		if ($this -> which_scenario == 2)
		{
			$user		= ( isset($lte_cfg[$this -> lte_user['name']])	? $lte_cfg[$this -> lte_user['name']]	: ''	 );
			$secret		= ( isset($lte_cfg[$this -> lte_secret['name']])? $lte_cfg[$this -> lte_secret['name']]	: ''	 );

		 	$sip_str =   $this -> _display_simple_field($port_type, $this -> lte_user['id']  , $this -> lte_user['name']  , $this -> lte_user['title']  , $this -> lte_user['type']  , $this -> lte_user['tooltip']  , $user  )
		 		   . $this -> _display_simple_field($port_type, $this -> lte_secret['id'], $this -> lte_secret['name'], $this -> lte_secret['title'], $this -> lte_secret['type'], $this -> lte_secret['tooltip'], $secret);
		}

		return 	  $this -> _display_simple_field($port_type, $this -> lte_group['id'], $this -> lte_group['name'], $this -> lte_group['title'], $this -> lte_group['type'], $this -> lte_group['tooltip'], $group)
			. $ports_str 
			. $sip_str;
	}

	function _get_validator_lte_inputs ()
	{
		return    $this -> _get_validator_input_group($this -> lte_group['name'])
			. $this -> _get_validator_input_ports($this -> lte_ports['name'])
			. ($this -> which_scenario == 2 ? $this -> _get_validator_input_user($this -> lte_user['name']) : '');
	}

/* FXO */
	function _display_content_fxo ($fxo_cfg, $port_type = 'FXO', $tab = "\t\t\t\t")
	{
		// init variables
		$name_fxo_ports_modified = preg_replace('/\[\]/', '', $this -> fxo_ports['name']);

		$group 		= ( isset($fxo_cfg[$this -> fxo_group['name']]) ? $fxo_cfg[$this -> fxo_group['name']] 			: ''	 );
		$array_ports 	= ( isset($fxo_cfg[$name_fxo_ports_modified])   ? explode('-', $fxo_cfg[$name_fxo_ports_modified])	: array());
		$tones		= ( isset($fxo_cfg[$this -> fxo_tones['name']]) ? $fxo_cfg[$this -> fxo_tones['name']]			: ''	 );

		// ports html string
		$ports_str = $this -> _display_ports_field($fxo_cfg, $array_ports , $port_type, $this -> fxo_ports, 'analog');

		// tones html string
		$tones_str = $this -> _display_tones($this -> fxo_tones['id'], $this -> fxo_tones['name'], $this -> fxo_tones['title'], $this -> fxo_tones['tooltip'], $port_type, $tones);

		// sip string
		$sip_str = '';
		if ($this -> which_scenario == 2)
		{
			$user		= ( isset($fxo_cfg[$this -> fxo_user['name']])	? $fxo_cfg[$this -> fxo_user['name']]	: ''	 );
			$secret		= ( isset($fxo_cfg[$this -> fxo_secret['name']])? $fxo_cfg[$this -> fxo_secret['name']]	: ''	 );

		 	$sip_str =   $this -> _display_simple_field($port_type, $this -> fxo_user['id']  , $this -> fxo_user['name']  , $this -> fxo_user['title']  , $this -> fxo_user['type']  , $this -> fxo_user['tooltip']  , $user  )
		 		   . $this -> _display_simple_field($port_type, $this -> fxo_secret['id'], $this -> fxo_secret['name'], $this -> fxo_secret['title'], $this -> fxo_secret['type'], $this -> fxo_secret['tooltip'], $secret);
		}

		return 	  $this -> _display_simple_field($port_type, $this -> fxo_group['id'], $this -> fxo_group['name'], $this -> fxo_group['title'], $this -> fxo_group['type'], $this -> fxo_group['tooltip'], $group)
			. $ports_str 
			. $sip_str
			. $tones_str;
	}

	function _get_validator_fxo_inputs ()
	{
		return    $this -> _get_validator_input_group($this -> fxo_group['name'])
			. $this -> _get_validator_input_ports($this -> fxo_ports['name'])
			. ($this -> which_scenario == 2 ? $this -> _get_validator_input_user($this -> fxo_user['name']) : '');
	}

/* FXS */
	function _javascript_code_fxs ()
	{
		ob_start();
?>

	function activate_fxs_port (port)
	{
                var port_unchecked = !($('#intern-<?php echo $this -> fxs_ports['id']; ?>-' + port).prop('checked'));

                $('#intern-<?php echo $this -> fxs_user['id']; ?>-' + port).prop('disabled', port_unchecked);
                $('#intern-<?php echo $this -> fxs_secret['id']; ?>-' + port).prop('disabled', port_unchecked);
                $('#intern-<?php echo $this -> fxs_tones['id']; ?>-' + port).prop('disabled', port_unchecked);
	}

	function ajaxFileUploadFXSConfig() 
	{
		session();

		$.ajaxFileUpload(
		{
			url: "modules/Wizard/ajax-pstn-wizard.php",
			secureuri: false,
			fileElementId: "<?php echo $this -> fxs_csvfile['id']; ?>",
			dataType: "json",
			success: function (data, status)
			{
				if (typeof (data.error) != "undefined") {
					if (data.error != "") {
						alert(data.error);
					} else {
						var lines = data.file;
						lines = lines.split(";");
						$("input[name='intern_<?php echo $this -> fxs_ports['name']; ?>']").removeAttr("checked");
						$.each(lines, function (index, line) {
							var prop = line.split(",");
							$("#intern-<?php echo $this -> fxs_ports['id']; ?>-" + prop[0]).prop("checked", "checked");

							$("#intern-<?php echo $this -> fxs_user['id']; ?>-" + prop[0]).prop("value", prop[1]);
                					$('#intern-<?php echo $this -> fxs_user['id']; ?>-' + prop[0]).removeAttr('disabled');

							$("#intern-<?php echo $this -> fxs_secret['id']; ?>-" + prop[0]).prop("value", prop[2]);
                					$('#intern-<?php echo $this -> fxs_secret['id']; ?>-' + prop[0]).removeAttr('disabled');

							$("#intern-<?php echo $this -> fxs_tones['id']; ?>-" + prop[0] + " option[value='" + prop[3] + "']").prop("selected", true);
                					$('#intern-<?php echo $this -> fxs_tones['id']; ?>-' + prop[0]).removeAttr('disabled');
						});
					}
				}
			},
			error: function (data, status, e)
			{
				alert(e);
			}
		});

		return false;
	}
<?php
		return ob_get_clean();
	}

	function _display_content_extern_fxs ($fxs_cfg, $port_type = 'FXS')
	{
		// init variables
		$name_fxs_ports_modified = preg_replace('/\[\]/', '', $this -> fxs_ports['name']);

		$group 		= ( isset($fxs_cfg[$this -> fxs_group['name']]) ? $fxs_cfg[$this -> fxs_group['name']] 			: ''	 );
		$array_ports 	= ( isset($fxs_cfg[$name_fxs_ports_modified])	? explode('-', $fxs_cfg[$name_fxs_ports_modified])	: array());
		$tones	 	= ( isset($fxs_cfg[$this -> fxs_tones['name']])	? $fxs_cfg[$this -> fxs_tones['name']]			: ''	 );

		// ports html string
		$ports_str = $this -> _display_ports_field($fxs_cfg, $array_ports, $port_type, $this -> fxs_ports, 'analog');

		// tones html string
		$tones_str = $this -> _display_tones($this -> fxs_tones['id'], $this -> fxs_tones['name'], $this -> fxs_tones['title'], $this -> fxs_tones['tooltip'], $port_type, $tones);

		// return html string
		return 	  $this -> _display_simple_field($port_type, $this -> fxs_group['id'], $this -> fxs_group['name'], $this -> fxs_group['title'], $this -> fxs_group['type'], $this -> fxs_group['tooltip'], $group)
			. $ports_str 
			. $tones_str;
	}

	function _display_content_fxs ($fxs_cfg, $port_type = 'FXS')
	{
		if ($this -> which_scenario == 2)
		{
			$title_intern = $tab. "<p class='text-center h4' style='margin-top: 25px; margin-bottom: 25px;'>". WIZARD_INTERN_FXS_DIS ."</p>\n";
			$upload_file  =	  $tab. "<div class='form-group' style='text-align: center; margin-bottom; 25px;'>\n"
					. $tab. "\t<label for='{$this -> fxs_csvfile['name']}' class='col-sm-3 control-label'>CSV File</label>\n"
					. $tab. "\t<div class='col-sm-4'>\n"
					. $tab. "\t\t<input type='file' id='{$this -> fxs_csvfile['id']}' name='{$this -> fxs_csvfile['name']}'>\n"
					. $tab. "\t</div>\n"
					. $tab. "\t<div class='col-sm-3'>\n"
					. $tab. "\t\t<input type='button' class='btn btn-default' name='upload' value='Upload' onclick='ajaxFileUploadFXSConfig();'>\n"
					. $tab. "\t</div>\n"
					. $tab. "</div>\n";

			return    $title_intern
				. $upload_file
				. $this -> _display_intern_table_ports($port_type, $fxs_cfg, $this -> fxs_ports, $this -> fxs_user, $this -> fxs_secret, $this -> fxs_tones, 'analog');
		}

		return $this -> _display_content_extern_fxs($fxs_cfg);
	}

	function _get_validator_fxs_inputs ($port_type = 'FXS', $techno = 'analog')
	{
		$required = '';
		if ($this -> which_scenario == 2)
		{
			$required = $this -> _get_validator_intern_inputs($port_type, $techno, $this -> fxs_user['name']);
		}
		else
		{
			$required = 	  $this -> _get_validator_input_group($this -> fxs_group['name'])
					. $this -> _get_validator_input_ports($this -> fxs_ports['name']);
		}

		return $required;
	}

	// public
	function get_content_modal ($pstn_cfg, $previous_used, $tab = "\t\t\t")
	{
		// init variables 
		$port_type_ckd_dsd = '';

		// increase / decrease the hidden variables to follow the multiple port types configuration
		$hidden_str = '';
		if ($this -> multiple_config)
		{
			$hidden_str .=  $tab. "<input type='hidden' name='{$this -> nb_port_types}' value='". (string)count($this -> list_port_types) ."'>\n";
		}

		// display PSTN header
		$pstn_header = 	  $hidden_str 
				. $tab. "<div class='form-group group' id='{$this -> port_types['id']}'>\n"
				. $tab. "\t<label for='{$this -> port_types['name']}' class='col-sm-6 control-label'>{$this -> port_types['title']}</label>\n"
				. $tab. "\t<div class='col-sm-5'>\n";

		// get last port_type configured (PBX scenario)
		$last_port_types_cfgd  = '';
		$array_port_types_cfgd = array();
		if (isset($pstn_cfg[$this -> port_types['name']]))
		{
			$array_port_types_cfgd = (is_string($pstn_cfg[$this -> port_types['name']]) ? explode('-', $pstn_cfg[$this -> port_types['name']]) : $pstn_cfg[$this -> port_types['name']]);

			// going backward
			if ($previous_used)
			{
				$array_port_types_cfgd = array_filter($array_port_types_cfgd);
				$last_port_types_cfgd  = array_pop($array_port_types_cfgd);
			}
		}

		$html_content = '';
		foreach ($this -> list_port_types as $port_type) 
		{
			$div_value 	  = " value='-1'";
			$checked_disabled = '';
			$port_type_lower  = strtolower($port_type);

			if ($this -> multiple_config && in_array($port_type_lower, $array_port_types_cfgd))
			{
				$checked_disabled = ' disabled';
			}
			else if (strcmp($last_port_types_cfgd, $port_type_lower) == 0)
			{
				$div_value 	  = '';	
				$checked_disabled = ' checked';
			}

			if ($this -> which_scenario != 3 || preg_match('#BRI|PRI#', $port_type))
			{ 
				$id   = $this -> port_types['id'];
				$type = $this -> port_types['type'];

				$pstn_header .= $tab. "\t\t<input type='$type' id='$id-$port_type_lower' name='{$this -> port_types['name']}' value='$port_type_lower' onclick=\"show_port('$port_type');\"$checked_disabled>$port_type\n";

				$html_content .=  $tab. "<div id='". $this -> _get_pstn_id_from_port_type($port_type) ."'$div_value>\n"
						. $this -> _display_content($pstn_cfg, $port_type)
						. $tab. "</div>\n"; 
			}
		}

		return	  $pstn_header
			. $tab. "\t</div>\n"
			. $tab. "</div>\n"
			. $html_content;
	}

	function get_general_javascript_code ($form)
	{
		$switch_bri_port     = (($this -> which_scenario == 2 && in_array('BRI', $this -> list_port_types)) ? $this -> _javascript_code_switch_bri_port() : '');

		$ajax_file_upload    = '';
		$fxs_javascript_code = '';
		if ($this -> which_scenario == 2 && in_array('FXS', $this -> list_port_types))
		{
			$ajax_file_upload    = "<script type='text/javascript' language='javascript' src='./includes/js/ajaxfileupload.js'></script>\n";
			$fxs_javascript_code = $this -> _javascript_code_fxs();
		}

		// general javascript code
		ob_start();
?>
<script type="text/javascript">
	$(document).ready(
		function () { 
			$("div[value=-1]").hide();

			$('#<?php echo $form; ?>').validate({
				rules: {
					'<?php echo $this -> port_types['name']; ?>': {
						atLeastOnePort: true,
					},
<?php 
echo 	  (in_array('PRI', $this -> list_port_types) ? $this -> _get_validator_pri_inputs() : '')
	. (in_array('BRI', $this -> list_port_types) ? $this -> _get_validator_bri_inputs() : '')
	. (in_array('GSM', $this -> list_port_types) ? $this -> _get_validator_gsm_inputs() : '')
	. (in_array('LTE', $this -> list_port_types) ? $this -> _get_validator_lte_inputs() : '')
	. (in_array('FXO', $this -> list_port_types) ? $this -> _get_validator_fxo_inputs() : '')
	. (in_array('FXS', $this -> list_port_types) ? $this -> _get_validator_fxs_inputs() : '');
?>
        			},
                		highlight: function (element) {
                    			$(element).closest('.col-sm-3').addClass('has-error');
                    			$(element).closest('.form-group').addClass('has-error');
                		},
                		unhighlight: function (element) {
                    			$(element).closest('.col-sm-3').removeClass('has-error');
                	    		$(element).closest('.form-group').removeClass('has-error');
                		},
                		errorElement: 'span',
                		errorClass: 'help-block',
                		errorPlacement: function (error, element) {
					if (error.prop('id') === '<?php echo $this -> port_types['name']; ?>-error' || error.prop('id').slice(-13) === 'ports[]-error')
					{ 
                        			error.insertBefore(element);
					}
					else
					{
						error.insertAfter(element);
					}
                		}
			});
		}
	);

	function show_port (port_type)
	{
<?php		
		foreach ($this -> list_port_types as $port_type)
		{
			$id = $this -> _get_pstn_id_from_port_type($port_type);

			$array_hide = array_diff($this -> list_port_types, array($port_type));
?>
		if (port_type === '<?php echo $port_type; ?>')
		{
			$('#<?php echo $id; ?>').show();
<?php
			foreach ($array_hide as $hide_port_type)
			{
?>
			$('#<?php echo $this -> _get_pstn_id_from_port_type($hide_port_type); ?>').hide();
<?php
			}
?>
		}
<?php		} ?>
	}

<?php echo   $switch_bri_port
	   . $fxs_javascript_code; ?>
</script>
<?php
		return 	  $ajax_file_upload
			. ob_get_clean()
			. $multiple_config_java;	
	}

	function get_extra_check_form_javascript_code ()
	{
		$extra_code = '';
		if ($this -> which_scenario == 2 and in_array('FXS', $this -> list_port_types))
		{
			ob_start();
?>
			if ($("input[value='fxs']").prop('checked') && !($("input[class='intern-FXS']").prop('checked')))
			{
				return false;
			}

<?php
			$extra_code = ob_get_clean();
		}

		return $extra_code;
	}

        function get_post_conditions_list($scenario, $post, $wizard_cfg, $intern = 'intern')
        {
        	if (isset($_SESSION['pbx'])) {
        		$scenario = 2;
        	}
		// extern
                $conditions = array('post' => array(), 'options' => array());

                foreach ($this -> _get_post_list() as $post_input) 
		{
			$conditions['post'][str_replace('[]', '', $post_input['name'])] = $post_input['postCheck'];
                        $conditions['options'][str_replace('[]', '', $post_input['name'])] = $post_input['options'];
                }

		// intern
		$intern_conditions = array('post' => array(), 'options' => array());

		// check the intern port
		if ($scenario == 2 && preg_match('/^bri$|^fxs$/', $post[$this -> port_types['name']], $match))
		{
			// add intern post
			if ($match[0] == 'fxs')
			{
				$intern_conditions = $this -> _get_intern_post_conditions_list($post, $this -> fxs_ports, $this -> fxs_user, $this -> fxs_secret, $this -> fxs_tones);
			}
			else
			{
				$intern_conditions = $this -> _get_intern_post_conditions_list($post, $this -> bri_ports, $this -> bri_user, $this -> bri_secret, $this -> bri_tones);
			}
		}
		// already checked - set the checkor to accept
		else if ($scenario == 2 && isset($wizard_cfg['Pstn']['port_types'])) 
		{
			foreach (explode('-', $wizard_cfg['Pstn']['port_types']) as $type) 
			{
				if ($type == 'fxs')
				{
					$intern_conditions = $this -> _get_intern_post_conditions_list($post, $this -> fxs_ports, $this -> fxs_user, $this -> fxs_secret, $this -> fxs_tones);
				}
				else
				{
					$intern_conditions = $this -> _get_intern_post_conditions_list($post, $this -> bri_ports, $this -> bri_user, $this -> bri_secret, $this -> bri_tones);
				}
			}
		} 

		$conditions['post'] = array_merge($conditions['post'], $intern_conditions['post']);
		$conditions['options'] = array_merge($conditions['options'], $intern_conditions['options']);

                return $conditions;
        }

	function organize_settings ($pstn_settings)
	{ 
		$settings = array();

		foreach (array_filter($pstn_settings[$this -> port_types['name']]) as $port_type)
		{
			foreach ($pstn_settings as $parameter => $value)
			{
				if (preg_match("/intern_". $port_type ."_[a-z_]*_([0-9]*)/", $parameter, $matches_port))
				{
					$parameter_modified = str_replace('intern_'. $port_type .'_', "", $parameter);
	
					$settings['intern'][$port_type][$matches_port[1]][str_replace("_". $matches_port[1], "", $parameter_modified)] = $value;
				}
				else if (preg_match("/". $port_type ."_[a-z]*/", $parameter))
				{
					$parameter_modified = str_replace($port_type ."_", "", $parameter);
	
					$settings['extern'][$port_type][$parameter_modified] = $value;
				}
			}
		}

		// we add the group name to the Intern ports
		if (isset($settings['intern']))
		{
			foreach ($settings['intern'] as $port_type => $port_parameters)
			{
				foreach (array_keys($port_parameters) as $port)
				{
					$settings['intern'][$port_type][$port]['group'] = "Intern-$port_type-$port";
				}
			}
		}

		return $settings;
	}

	function get_summary_settings($scenario, $pstn_settings, $tab = "\t\t\t")
	{
		// init variable
		$list_key_table = array('group'=> $this -> pri_group['title'], 'ports' => $this -> pri_ports['title'], 'tones' => $this -> pri_tones['title'], 'country'  => $this -> pri_country['title'], 
					'city' => $this -> pri_city['title'] , /*'local' => $this -> pri_local['title'],*/ 'user'  => $this -> pri_user['title'] );

		$title = $tab. "<p class='text-center h4'>". WIZARD_PSTN_SETTINGS_DIS ."</p>\n";
	
		// extern settings
		$extern_settings = '';
		if (isset($pstn_settings['extern']))
		{
			$title_extern_settings  = '';
			if ($scenario == 2 && isset($pstn_settings['intern']))
			{
				$title_extern_settings = $tab. "<p class='text-center h5'>". WIZARD_EXTERN_PSTN_SETTINGS_DIS ."</p>\n";
			}

			foreach ($pstn_settings['extern'] as $port_type => $parameters)
			{
				$th_line = "<th>". WIZARD_PORT_TYPE_DIS ."</th>";
				$td_line = "<td>". strtoupper($port_type) ."</td>";	
				foreach ($list_key_table as $key => $def)
				{
					if (isset($parameters[$key]))
					{
						$th_line .= "<th>$def</th>";
						$td_line .= "<td>{$parameters[$key]}</td>";
					}
				}

				$extern_settings .= 	  $tab. "<table class='table table-striped table-bordered'>\n"
							. $tab. "\t<tr>$th_line</tr>\n"
							. $tab. "\t<tr>$td_line</tr>\n"
							. $tab. "</table>\n";
			}

			$extern_settings = $title_extern_settings . $extern_settings;
		}
		
		// intern settings
		$intern_settings = '';
		if (isset($pstn_settings['intern']))
		{
			$intern_settings = 	  $tab. "<p class='text-center h5'>". WIZARD_INTERN_PSTN_SETTINGS_DIS ."</p>\n"
						. $tab. "<table class='table table-striped table-bordered'>\n"
						. $tab. "\t<tr><th>". WIZARD_PORT_TYPE_DIS ."</th><th>". $list_key_table['ports'] ."</th><th>". $list_key_table['user'] ."</th><th>". $list_key_table['tones'] ."</th></tr>\n";
				
			foreach ($pstn_settings['intern'] as $port_type => $parameters_type)
			{
				foreach ($parameters_type as $port => $parameters)
				{
					$intern_settings .= $tab. "\t<tr><td>". strtoupper($port_type) ."</td><td>$port</td><td>". $parameters['user'] ."</td><td>". $parameters['tones'] ."</td></tr>\n";
				}
			}

			$intern_settings .= $tab. "</table>\n";
		}

		return $title . $extern_settings . $intern_settings;
	}
}
?>
